/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.util.Base64URL;
import de.adorsys.sdjwt.SdJwtUtils;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.Objects;

public abstract class SdJws {
    private final JWSObject signedJwt;
    private final String jwsString;
    private final JsonNode payload;

    public String toJws() {
        if (this.jwsString == null) {
            throw new IllegalStateException("JWS not yet signed");
        }
        return this.jwsString;
    }

    public JsonNode getPayload() {
        return this.payload;
    }

    protected SdJws(JsonNode payload) {
        this.payload = payload;
        this.signedJwt = null;
        this.jwsString = null;
    }

    protected SdJws(String jwsString) {
        try {
            this.jwsString = jwsString;
            this.signedJwt = SdJws.parse(jwsString);
            this.payload = SdJws.readPayload(this.signedJwt);
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    protected SdJws(JsonNode payload, JWSObject signedJwt) {
        this.payload = payload;
        this.signedJwt = signedJwt;
        this.jwsString = signedJwt.serialize();
    }

    protected SdJws(JsonNode payload, JWSSigner signer, String keyId, JWSAlgorithm jwsAlgorithm, String jwsType) {
        this.payload = payload;
        JWSHeader header = new JWSHeader.Builder(jwsAlgorithm).type(new JOSEObjectType(jwsType)).keyID(keyId).build();
        this.signedJwt = new JWSObject(header, new Payload(Base64URL.encode((String)payload.toString())));
        try {
            this.signedJwt.sign(signer);
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
        this.jwsString = this.signedJwt.serialize();
    }

    protected SdJws(Base64URL payloadBase64Url, JWSSigner signer, String keyId, JWSAlgorithm jwsAlgorithm, String jwsType) {
        try {
            this.payload = SdJwtUtils.mapper.readTree(payloadBase64Url.decode());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        JWSHeader header = new JWSHeader.Builder(jwsAlgorithm).type(new JOSEObjectType(jwsType)).keyID(keyId).build();
        this.signedJwt = new JWSObject(header, new Payload(payloadBase64Url));
        try {
            this.signedJwt.sign(signer);
        }
        catch (JOSEException e) {
            throw new RuntimeException(e);
        }
        this.jwsString = this.signedJwt.serialize();
    }

    public void verifySignature(JWSVerifier verifier) throws JOSEException {
        if (!this.signedJwt.verify(verifier)) {
            throw new JOSEException("Invalid JWS signature");
        }
    }

    public void verifyExpClaim() throws JOSEException {
        this.verifyTimeClaim("exp", "jwt has expired");
    }

    public void verifyNotBeforeClaim() throws JOSEException {
        this.verifyTimeClaim("nbf", "jwt not valid yet");
    }

    private void verifyTimeClaim(String claimName, String errorMessage) throws JOSEException {
        JsonNode claim = this.payload.get(claimName);
        if (claim == null || !claim.isNumber()) {
            throw new JOSEException("Missing or invalid '" + claimName + "' claim");
        }
        long claimTime = claim.asLong();
        long currentTime = Instant.now().getEpochSecond();
        if ("exp".equals(claimName) && currentTime >= claimTime || "nbf".equals(claimName) && currentTime < claimTime) {
            throw new JOSEException(errorMessage);
        }
    }

    private static JWSObject parse(String jwsString) throws ParseException {
        return JWSObject.parse((String)Objects.requireNonNull(jwsString, "jwsString must not be null"));
    }

    private static JsonNode readPayload(JWSObject jwsInput) throws ParseException, IOException {
        return (JsonNode)SdJwtUtils.mapper.readValue(jwsInput.getParsedParts()[1].decode(), JsonNode.class);
    }
}

