/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import de.adorsys.sdjwt.DisclosureRedList;
import de.adorsys.sdjwt.SdJwtClaimName;
import de.adorsys.sdjwt.SdJwtSalt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DisclosureSpec {
    private final Map<SdJwtClaimName, DisclosureData> undisclosedClaims;
    private final List<DisclosureData> decoyClaims;
    private final Map<SdJwtClaimName, Map<Integer, DisclosureData>> undisclosedArrayElts;
    private final Map<SdJwtClaimName, Map<Integer, DisclosureData>> decoyArrayElts;

    private DisclosureSpec(Map<SdJwtClaimName, DisclosureData> undisclosedClaims, List<DisclosureData> decoyClaims, Map<SdJwtClaimName, Map<Integer, DisclosureData>> undisclosedArrayElts, Map<SdJwtClaimName, Map<Integer, DisclosureData>> decoyArrayElts) {
        this.undisclosedClaims = undisclosedClaims;
        this.decoyClaims = decoyClaims;
        this.undisclosedArrayElts = undisclosedArrayElts;
        this.decoyArrayElts = decoyArrayElts;
    }

    public Map<Integer, DisclosureData> getUndisclosedArrayElts(SdJwtClaimName arrayClaimName) {
        return this.undisclosedArrayElts.get(arrayClaimName);
    }

    public Map<Integer, DisclosureData> getDecoyArrayElts(SdJwtClaimName arrayClaimName) {
        return this.decoyArrayElts.get(arrayClaimName);
    }

    public Map<SdJwtClaimName, DisclosureData> getUndisclosedClaims() {
        return this.undisclosedClaims;
    }

    public List<DisclosureData> getDecoyClaims() {
        return this.decoyClaims;
    }

    public DisclosureData getUndisclosedClaim(SdJwtClaimName claimName) {
        return this.undisclosedClaims.get(claimName);
    }

    public boolean hasUndisclosedArrayElts(SdJwtClaimName claimName) {
        return this.undisclosedArrayElts.containsKey(claimName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class DisclosureData {
        private final SdJwtSalt salt;

        private DisclosureData() {
            this.salt = null;
        }

        private DisclosureData(String salt) {
            this.salt = salt == null ? null : SdJwtSalt.of(salt);
        }

        public static DisclosureData of(String salt) {
            return salt == null ? new DisclosureData() : new DisclosureData(salt);
        }

        public SdJwtSalt getSalt() {
            return this.salt;
        }
    }

    public static class Builder {
        private final Map<SdJwtClaimName, DisclosureData> undisclosedClaims = new HashMap<SdJwtClaimName, DisclosureData>();
        private final List<DisclosureData> decoyClaims = new ArrayList<DisclosureData>();
        private final Map<SdJwtClaimName, Map<Integer, DisclosureData>> undisclosedArrayElts = new HashMap<SdJwtClaimName, Map<Integer, DisclosureData>>();
        private final Map<SdJwtClaimName, Map<Integer, DisclosureData>> decoyArrayElts = new HashMap<SdJwtClaimName, Map<Integer, DisclosureData>>();
        private DisclosureRedList redListedClaimNames;

        public Builder withUndisclosedClaim(String claimName, String salt) {
            this.undisclosedClaims.put(SdJwtClaimName.of(claimName), DisclosureData.of(salt));
            return this;
        }

        public Builder withUndisclosedClaim(String claimName) {
            return this.withUndisclosedClaim(claimName, null);
        }

        public Builder withDecoyClaim(String salt) {
            this.decoyClaims.add(DisclosureData.of(salt));
            return this;
        }

        public Builder withUndisclosedArrayElt(String claimName, Integer undisclosedEltIndex, String salt) {
            Map indexes = this.undisclosedArrayElts.computeIfAbsent(SdJwtClaimName.of(claimName), k -> new HashMap());
            indexes.put(undisclosedEltIndex, DisclosureData.of(salt));
            return this;
        }

        public Builder withDecoyArrayElt(String claimName, Integer decoyEltIndex, String salt) {
            Map indexes = this.decoyArrayElts.computeIfAbsent(SdJwtClaimName.of(claimName), k -> new HashMap());
            indexes.put(decoyEltIndex, DisclosureData.of(salt));
            return this;
        }

        public Builder withRedListedClaimNames(DisclosureRedList redListedClaimNames) {
            this.redListedClaimNames = redListedClaimNames;
            return this;
        }

        public DisclosureSpec build() {
            this.validateRedList();
            HashMap undisclosedArrayEltMap = new HashMap();
            this.undisclosedArrayElts.forEach((k, v) -> undisclosedArrayEltMap.put(k, Collections.unmodifiableMap(v)));
            HashMap decoyArrayEltMap = new HashMap();
            this.decoyArrayElts.forEach((k, v) -> decoyArrayEltMap.put(k, Collections.unmodifiableMap(v)));
            return new DisclosureSpec(Collections.unmodifiableMap(this.undisclosedClaims), Collections.unmodifiableList(this.decoyClaims), Collections.unmodifiableMap(undisclosedArrayEltMap), Collections.unmodifiableMap(decoyArrayEltMap));
        }

        private void validateRedList() {
            if (this.redListedClaimNames == null) {
                this.redListedClaimNames = DisclosureRedList.defaultList;
            }
            if (this.redListedClaimNames.containsRedListedClaimNames(this.undisclosedClaims.keySet())) {
                throw new IllegalArgumentException("UndisclosedClaims contains red listed claim names");
            }
            if (this.redListedClaimNames.containsRedListedClaimNames(this.undisclosedArrayElts.keySet())) {
                throw new IllegalArgumentException("UndisclosedArrays with red listed claim names");
            }
            if (this.redListedClaimNames.containsRedListedClaimNames(this.decoyArrayElts.keySet())) {
                throw new IllegalArgumentException("decoyArrayElts contains red listed claim names");
            }
        }
    }
}

