/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import de.adorsys.sdjwt.SdJwtSalt;
import de.adorsys.sdjwt.SdJwtUtils;
import java.util.Objects;

public abstract class DecoyEntry {
    private final SdJwtSalt salt;

    protected DecoyEntry(SdJwtSalt salt) {
        this.salt = Objects.requireNonNull(salt, "DecoyEntry always requires a non null salt");
    }

    public SdJwtSalt getSalt() {
        return this.salt;
    }

    public String getDisclosureDigest(String hashAlg) {
        return SdJwtUtils.encodeNoPad(SdJwtUtils.hash(this.salt.toString().getBytes(), hashAlg));
    }
}

