/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import de.adorsys.sdjwt.DecoyEntry;
import de.adorsys.sdjwt.SdJwtSalt;
import de.adorsys.sdjwt.SdJwtUtils;

public class DecoyArrayElement
extends DecoyEntry {
    private final Integer index;

    private DecoyArrayElement(SdJwtSalt salt, Integer index) {
        super(salt);
        this.index = index;
    }

    public JsonNode getVisibleValue(String hashAlg) {
        return SdJwtUtils.mapper.createObjectNode().put("...", this.getDisclosureDigest(hashAlg));
    }

    public Integer getIndex() {
        return this.index;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SdJwtSalt salt;
        private Integer index;

        public Builder withSalt(SdJwtSalt salt) {
            this.salt = salt;
            return this;
        }

        public Builder atIndex(Integer index) {
            this.index = index;
            return this;
        }

        public DecoyArrayElement build() {
            this.salt = this.salt == null ? new SdJwtSalt(SdJwtUtils.randomSalt()) : this.salt;
            return new DecoyArrayElement(this.salt, this.index);
        }
    }
}

