/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.sdjwt;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.adorsys.sdjwt.AbstractSdJwtClaim;
import de.adorsys.sdjwt.DecoyArrayElement;
import de.adorsys.sdjwt.SdJwtArrayElement;
import de.adorsys.sdjwt.SdJwtClaimName;
import de.adorsys.sdjwt.SdJwtSalt;
import de.adorsys.sdjwt.SdJwtUtils;
import de.adorsys.sdjwt.UndisclosedArrayElement;
import de.adorsys.sdjwt.VisibleArrayElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ArrayDisclosure
extends AbstractSdJwtClaim {
    private final List<SdJwtArrayElement> elements;
    private JsonNode visibleClaimValue = null;
    private final List<DecoyArrayElement> decoyElements;

    private ArrayDisclosure(SdJwtClaimName claimName, List<SdJwtArrayElement> elements, List<DecoyArrayElement> decoyElements) {
        super(claimName);
        this.elements = elements;
        this.decoyElements = decoyElements;
    }

    @Override
    public JsonNode getVisibleClaimValue(String hashAlgo) {
        if (this.visibleClaimValue != null) {
            return this.visibleClaimValue;
        }
        ArrayList visibleElts = new ArrayList();
        this.elements.stream().filter(Objects::nonNull).forEach(e -> visibleElts.add(e.getVisibleValue(hashAlgo)));
        this.decoyElements.stream().filter(Objects::nonNull).forEach(e -> {
            if (e.getIndex() < visibleElts.size()) {
                visibleElts.add(e.getIndex(), e.getVisibleValue(hashAlgo));
            } else {
                visibleElts.add(e.getVisibleValue(hashAlgo));
            }
        });
        ArrayNode n = SdJwtUtils.mapper.createArrayNode();
        visibleElts.forEach(arg_0 -> ((ArrayNode)n).add(arg_0));
        this.visibleClaimValue = n;
        return this.visibleClaimValue;
    }

    @Override
    public List<String> getDisclosureStrings() {
        ArrayList<String> disclosureStrings = new ArrayList<String>();
        this.elements.stream().filter(Objects::nonNull).forEach(e -> {
            String disclosureString = e.getDisclosureString();
            if (disclosureString != null) {
                disclosureStrings.add(disclosureString);
            }
        });
        return disclosureStrings;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private SdJwtClaimName claimName;
        private final List<SdJwtArrayElement> elements = new ArrayList<SdJwtArrayElement>();
        private final List<DecoyArrayElement> decoyElements = new ArrayList<DecoyArrayElement>();

        public Builder withClaimName(String claimName) {
            this.claimName = new SdJwtClaimName(claimName);
            return this;
        }

        public Builder withVisibleElement(JsonNode elementValue) {
            this.elements.add(new VisibleArrayElement(elementValue));
            return this;
        }

        public Builder withUndisclosedElement(SdJwtSalt salt, JsonNode elementValue) {
            SdJwtSalt sdJwtSalt = salt == null ? new SdJwtSalt(SdJwtUtils.randomSalt()) : salt;
            this.elements.add(UndisclosedArrayElement.builder().withSalt(sdJwtSalt).withArrayElement(elementValue).build());
            return this;
        }

        public void withDecoyElt(Integer position, SdJwtSalt salt) {
            SdJwtSalt sdJwtSalt = salt == null ? new SdJwtSalt(SdJwtUtils.randomSalt()) : salt;
            DecoyArrayElement decoyElement = DecoyArrayElement.builder().withSalt(sdJwtSalt).atIndex(position).build();
            this.decoyElements.add(decoyElement);
        }

        public ArrayDisclosure build() {
            return new ArrayDisclosure(this.claimName, Collections.unmodifiableList(this.elements), Collections.unmodifiableList(this.decoyElements));
        }
    }
}

