/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AdditionalInformationStructured;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.Balance;
import de.adorsys.psd2.model.PurposeCode;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import de.adorsys.psd2.model.RemittanceInformationUnstructuredArray;
import de.adorsys.psd2.model.ReportExchangeRateList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Transaction details.")
@Validated
public class Transactions {
    @JsonProperty(value="transactionId")
    private String transactionId = null;
    @JsonProperty(value="entryReference")
    private String entryReference = null;
    @JsonProperty(value="endToEndId")
    private String endToEndId = null;
    @JsonProperty(value="mandateId")
    private String mandateId = null;
    @JsonProperty(value="checkId")
    private String checkId = null;
    @JsonProperty(value="creditorId")
    private String creditorId = null;
    @JsonProperty(value="bookingDate")
    private LocalDate bookingDate = null;
    @JsonProperty(value="valueDate")
    private LocalDate valueDate = null;
    @JsonProperty(value="transactionAmount")
    private Amount transactionAmount = null;
    @JsonProperty(value="currencyExchange")
    private ReportExchangeRateList currencyExchange = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="creditorAgent")
    private String creditorAgent = null;
    @JsonProperty(value="ultimateCreditor")
    private String ultimateCreditor = null;
    @JsonProperty(value="debtorName")
    private String debtorName = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="debtorAgent")
    private String debtorAgent = null;
    @JsonProperty(value="ultimateDebtor")
    private String ultimateDebtor = null;
    @JsonProperty(value="remittanceInformationUnstructured")
    private String remittanceInformationUnstructured = null;
    @JsonProperty(value="remittanceInformationUnstructuredArray")
    private RemittanceInformationUnstructuredArray remittanceInformationUnstructuredArray = null;
    @JsonProperty(value="remittanceInformationStructured")
    private String remittanceInformationStructured = null;
    @JsonProperty(value="remittanceInformationStructuredArray")
    private RemittanceInformationStructuredArray remittanceInformationStructuredArray = null;
    @JsonProperty(value="additionalInformation")
    private String additionalInformation = null;
    @JsonProperty(value="additionalInformationStructured")
    private AdditionalInformationStructured additionalInformationStructured = null;
    @JsonProperty(value="purposeCode")
    private PurposeCode purposeCode = null;
    @JsonProperty(value="bankTransactionCode")
    private String bankTransactionCode = null;
    @JsonProperty(value="proprietaryBankTransactionCode")
    private String proprietaryBankTransactionCode = null;
    @JsonProperty(value="balanceAfterTransaction")
    private Balance balanceAfterTransaction = null;
    @JsonProperty(value="_links")
    private Map _links = null;

    public Transactions transactionId(String transactionId) {
        this.transactionId = transactionId;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="transactionId")
    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public Transactions entryReference(String entryReference) {
        this.entryReference = entryReference;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="entryReference")
    public @Size(max=35) String getEntryReference() {
        return this.entryReference;
    }

    public void setEntryReference(String entryReference) {
        this.entryReference = entryReference;
    }

    public Transactions endToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
        return this;
    }

    @ApiModelProperty(value="Unique end to end identity.")
    @Size(max=35)
    @JsonProperty(value="endToEndId")
    public @Size(max=35) String getEndToEndId() {
        return this.endToEndId;
    }

    public void setEndToEndId(String endToEndId) {
        this.endToEndId = endToEndId;
    }

    public Transactions mandateId(String mandateId) {
        this.mandateId = mandateId;
        return this;
    }

    @ApiModelProperty(value="Identification of Mandates, e.g. a SEPA Mandate ID.")
    @Size(max=35)
    @JsonProperty(value="mandateId")
    public @Size(max=35) String getMandateId() {
        return this.mandateId;
    }

    public void setMandateId(String mandateId) {
        this.mandateId = mandateId;
    }

    public Transactions checkId(String checkId) {
        this.checkId = checkId;
        return this;
    }

    @ApiModelProperty(value="Identification of a Cheque.")
    @Size(max=35)
    @JsonProperty(value="checkId")
    public @Size(max=35) String getCheckId() {
        return this.checkId;
    }

    public void setCheckId(String checkId) {
        this.checkId = checkId;
    }

    public Transactions creditorId(String creditorId) {
        this.creditorId = creditorId;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="creditorId")
    public @Size(max=35) String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public Transactions bookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="bookingDate")
    public LocalDate getBookingDate() {
        return this.bookingDate;
    }

    public void setBookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
    }

    public Transactions valueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
        return this;
    }

    @ApiModelProperty(value="The Date at which assets become available to the account owner in case of a credit.")
    @Valid
    @JsonProperty(value="valueDate")
    public LocalDate getValueDate() {
        return this.valueDate;
    }

    public void setValueDate(LocalDate valueDate) {
        this.valueDate = valueDate;
    }

    public Transactions transactionAmount(Amount transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="transactionAmount")
    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Amount transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public Transactions currencyExchange(ReportExchangeRateList currencyExchange) {
        this.currencyExchange = currencyExchange;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="currencyExchange")
    public ReportExchangeRateList getCurrencyExchange() {
        return this.currencyExchange;
    }

    public void setCurrencyExchange(ReportExchangeRateList currencyExchange) {
        this.currencyExchange = currencyExchange;
    }

    public Transactions creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="creditorName")
    public @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public Transactions creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="creditorAccount")
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public Transactions creditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    @JsonProperty(value="creditorAgent")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public Transactions ultimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="ultimateCreditor")
    public @Size(max=70) String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public Transactions debtorName(String debtorName) {
        this.debtorName = debtorName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="debtorName")
    public @Size(max=70) String getDebtorName() {
        return this.debtorName;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public Transactions debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="debtorAccount")
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public Transactions debtorAgent(String debtorAgent) {
        this.debtorAgent = debtorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    @JsonProperty(value="debtorAgent")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getDebtorAgent() {
        return this.debtorAgent;
    }

    public void setDebtorAgent(String debtorAgent) {
        this.debtorAgent = debtorAgent;
    }

    public Transactions ultimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="ultimateDebtor")
    public @Size(max=70) String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public Transactions remittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    @JsonProperty(value="remittanceInformationUnstructured")
    public @Size(max=140) String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public Transactions remittanceInformationUnstructuredArray(RemittanceInformationUnstructuredArray remittanceInformationUnstructuredArray) {
        this.remittanceInformationUnstructuredArray = remittanceInformationUnstructuredArray;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="remittanceInformationUnstructuredArray")
    public RemittanceInformationUnstructuredArray getRemittanceInformationUnstructuredArray() {
        return this.remittanceInformationUnstructuredArray;
    }

    public void setRemittanceInformationUnstructuredArray(RemittanceInformationUnstructuredArray remittanceInformationUnstructuredArray) {
        this.remittanceInformationUnstructuredArray = remittanceInformationUnstructuredArray;
    }

    public Transactions remittanceInformationStructured(String remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    @JsonProperty(value="remittanceInformationStructured")
    public @Size(max=140) String getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public void setRemittanceInformationStructured(String remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public Transactions remittanceInformationStructuredArray(RemittanceInformationStructuredArray remittanceInformationStructuredArray) {
        this.remittanceInformationStructuredArray = remittanceInformationStructuredArray;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="remittanceInformationStructuredArray")
    public RemittanceInformationStructuredArray getRemittanceInformationStructuredArray() {
        return this.remittanceInformationStructuredArray;
    }

    public void setRemittanceInformationStructuredArray(RemittanceInformationStructuredArray remittanceInformationStructuredArray) {
        this.remittanceInformationStructuredArray = remittanceInformationStructuredArray;
    }

    public Transactions additionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=500)
    @JsonProperty(value="additionalInformation")
    public @Size(max=500) String getAdditionalInformation() {
        return this.additionalInformation;
    }

    public void setAdditionalInformation(String additionalInformation) {
        this.additionalInformation = additionalInformation;
    }

    public Transactions additionalInformationStructured(AdditionalInformationStructured additionalInformationStructured) {
        this.additionalInformationStructured = additionalInformationStructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="additionalInformationStructured")
    public AdditionalInformationStructured getAdditionalInformationStructured() {
        return this.additionalInformationStructured;
    }

    public void setAdditionalInformationStructured(AdditionalInformationStructured additionalInformationStructured) {
        this.additionalInformationStructured = additionalInformationStructured;
    }

    public Transactions purposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="purposeCode")
    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public Transactions bankTransactionCode(String bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bankTransactionCode")
    public String getBankTransactionCode() {
        return this.bankTransactionCode;
    }

    public void setBankTransactionCode(String bankTransactionCode) {
        this.bankTransactionCode = bankTransactionCode;
    }

    public Transactions proprietaryBankTransactionCode(String proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="proprietaryBankTransactionCode")
    public @Size(max=35) String getProprietaryBankTransactionCode() {
        return this.proprietaryBankTransactionCode;
    }

    public void setProprietaryBankTransactionCode(String proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
    }

    public Transactions balanceAfterTransaction(Balance balanceAfterTransaction) {
        this.balanceAfterTransaction = balanceAfterTransaction;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="balanceAfterTransaction")
    public Balance getBalanceAfterTransaction() {
        return this.balanceAfterTransaction;
    }

    public void setBalanceAfterTransaction(Balance balanceAfterTransaction) {
        this.balanceAfterTransaction = balanceAfterTransaction;
    }

    public Transactions _links(Map _links) {
        this._links = _links;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="_links")
    public Map getLinks() {
        return this._links;
    }

    public void setLinks(Map _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transactions transactions = (Transactions)o;
        return Objects.equals(this.transactionId, transactions.transactionId) && Objects.equals(this.entryReference, transactions.entryReference) && Objects.equals(this.endToEndId, transactions.endToEndId) && Objects.equals(this.mandateId, transactions.mandateId) && Objects.equals(this.checkId, transactions.checkId) && Objects.equals(this.creditorId, transactions.creditorId) && Objects.equals(this.bookingDate, transactions.bookingDate) && Objects.equals(this.valueDate, transactions.valueDate) && Objects.equals(this.transactionAmount, transactions.transactionAmount) && Objects.equals(this.currencyExchange, transactions.currencyExchange) && Objects.equals(this.creditorName, transactions.creditorName) && Objects.equals(this.creditorAccount, transactions.creditorAccount) && Objects.equals(this.creditorAgent, transactions.creditorAgent) && Objects.equals(this.ultimateCreditor, transactions.ultimateCreditor) && Objects.equals(this.debtorName, transactions.debtorName) && Objects.equals(this.debtorAccount, transactions.debtorAccount) && Objects.equals(this.debtorAgent, transactions.debtorAgent) && Objects.equals(this.ultimateDebtor, transactions.ultimateDebtor) && Objects.equals(this.remittanceInformationUnstructured, transactions.remittanceInformationUnstructured) && Objects.equals(this.remittanceInformationUnstructuredArray, transactions.remittanceInformationUnstructuredArray) && Objects.equals(this.remittanceInformationStructured, transactions.remittanceInformationStructured) && Objects.equals(this.remittanceInformationStructuredArray, transactions.remittanceInformationStructuredArray) && Objects.equals(this.additionalInformation, transactions.additionalInformation) && Objects.equals(this.additionalInformationStructured, transactions.additionalInformationStructured) && Objects.equals((Object)this.purposeCode, (Object)transactions.purposeCode) && Objects.equals(this.bankTransactionCode, transactions.bankTransactionCode) && Objects.equals(this.proprietaryBankTransactionCode, transactions.proprietaryBankTransactionCode) && Objects.equals(this.balanceAfterTransaction, transactions.balanceAfterTransaction) && Objects.equals(this._links, transactions._links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.transactionId, this.entryReference, this.endToEndId, this.mandateId, this.checkId, this.creditorId, this.bookingDate, this.valueDate, this.transactionAmount, this.currencyExchange, this.creditorName, this.creditorAccount, this.creditorAgent, this.ultimateCreditor, this.debtorName, this.debtorAccount, this.debtorAgent, this.ultimateDebtor, this.remittanceInformationUnstructured, this.remittanceInformationUnstructuredArray, this.remittanceInformationStructured, this.remittanceInformationStructuredArray, this.additionalInformation, this.additionalInformationStructured, this.purposeCode, this.bankTransactionCode, this.proprietaryBankTransactionCode, this.balanceAfterTransaction, this._links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Transactions {\n");
        sb.append("    transactionId: ").append(this.toIndentedString(this.transactionId)).append("\n");
        sb.append("    entryReference: ").append(this.toIndentedString(this.entryReference)).append("\n");
        sb.append("    endToEndId: ").append(this.toIndentedString(this.endToEndId)).append("\n");
        sb.append("    mandateId: ").append(this.toIndentedString(this.mandateId)).append("\n");
        sb.append("    checkId: ").append(this.toIndentedString(this.checkId)).append("\n");
        sb.append("    creditorId: ").append(this.toIndentedString(this.creditorId)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    valueDate: ").append(this.toIndentedString(this.valueDate)).append("\n");
        sb.append("    transactionAmount: ").append(this.toIndentedString(this.transactionAmount)).append("\n");
        sb.append("    currencyExchange: ").append(this.toIndentedString(this.currencyExchange)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    ultimateCreditor: ").append(this.toIndentedString(this.ultimateCreditor)).append("\n");
        sb.append("    debtorName: ").append(this.toIndentedString(this.debtorName)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    debtorAgent: ").append(this.toIndentedString(this.debtorAgent)).append("\n");
        sb.append("    ultimateDebtor: ").append(this.toIndentedString(this.ultimateDebtor)).append("\n");
        sb.append("    remittanceInformationUnstructured: ").append(this.toIndentedString(this.remittanceInformationUnstructured)).append("\n");
        sb.append("    remittanceInformationUnstructuredArray: ").append(this.toIndentedString(this.remittanceInformationUnstructuredArray)).append("\n");
        sb.append("    remittanceInformationStructured: ").append(this.toIndentedString(this.remittanceInformationStructured)).append("\n");
        sb.append("    remittanceInformationStructuredArray: ").append(this.toIndentedString(this.remittanceInformationStructuredArray)).append("\n");
        sb.append("    additionalInformation: ").append(this.toIndentedString(this.additionalInformation)).append("\n");
        sb.append("    additionalInformationStructured: ").append(this.toIndentedString(this.additionalInformationStructured)).append("\n");
        sb.append("    purposeCode: ").append(this.toIndentedString((Object)this.purposeCode)).append("\n");
        sb.append("    bankTransactionCode: ").append(this.toIndentedString(this.bankTransactionCode)).append("\n");
        sb.append("    proprietaryBankTransactionCode: ").append(this.toIndentedString(this.proprietaryBankTransactionCode)).append("\n");
        sb.append("    balanceAfterTransaction: ").append(this.toIndentedString(this.balanceAfterTransaction)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

