/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.TransactionList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="JSON based account report. This account report contains transactions resulting from the query parameters.  'information' is used if and only if the bookingStatus entry equals \"information\". Every active standing order related to the dedicated payment account result into one entry.  'booked' shall be contained if bookingStatus parameter is set to \"booked\" or \"both\".  'pending' is not contained if the bookingStatus parameter is set to \"booked\" or \"information\".  'information' Only contained if the bookingStatus is set to \"information\" and if supported by ASPSP. ")
@Validated
public class AccountReport {
    @JsonProperty(value="booked")
    private TransactionList booked = null;
    @JsonProperty(value="pending")
    private TransactionList pending = null;
    @JsonProperty(value="information")
    private TransactionList information = null;
    @JsonProperty(value="_links")
    private Map _links = null;

    public AccountReport booked(TransactionList booked) {
        this.booked = booked;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="booked")
    public TransactionList getBooked() {
        return this.booked;
    }

    public void setBooked(TransactionList booked) {
        this.booked = booked;
    }

    public AccountReport pending(TransactionList pending) {
        this.pending = pending;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="pending")
    public TransactionList getPending() {
        return this.pending;
    }

    public void setPending(TransactionList pending) {
        this.pending = pending;
    }

    public AccountReport information(TransactionList information) {
        this.information = information;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="information")
    public TransactionList getInformation() {
        return this.information;
    }

    public void setInformation(TransactionList information) {
        this.information = information;
    }

    public AccountReport _links(Map _links) {
        this._links = _links;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="_links")
    public Map getLinks() {
        return this._links;
    }

    public void setLinks(Map _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountReport accountReport = (AccountReport)o;
        return Objects.equals(this.booked, accountReport.booked) && Objects.equals(this.pending, accountReport.pending) && Objects.equals(this.information, accountReport.information) && Objects.equals(this._links, accountReport._links);
    }

    public int hashCode() {
        return Objects.hash(this.booked, this.pending, this.information, this._links);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountReport {\n");
        sb.append("    booked: ").append(this.toIndentedString(this.booked)).append("\n");
        sb.append("    pending: ").append(this.toIndentedString(this.pending)).append("\n");
        sb.append("    information: ").append(this.toIndentedString(this.information)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

