/*
 * Copyright 2018-2020 adorsys GmbH & Co KG
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program (3.0.4-SNAPSHOT).
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */
package de.adorsys.psd2.api.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.*;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import java.util.Optional;
import java.util.UUID;
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2020-07-17T11:19:20.952034+03:00[Europe/Kiev]")

@Api(value = "ConfirmationOfFunds", description = "the ConfirmationOfFunds API")
public interface ConfirmationOfFundsApi {

    Logger log = LoggerFactory.getLogger(ConfirmationOfFundsApi.class);

    default Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default Optional<String> getAcceptHeader() {
        return getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value = "Create consent", nickname = "createConsentConfirmationOfFunds", notes = "This method creates a confirmation of funds consent resource at the ASPSP regarding confirmation of funds access to an account specified in this request.  **Side Effects** In difference to the Establish Account Information Consent as defined in [XS2A-IG], there is no side effect by the Establish Confirmation of Funds Consent Request ", response = Object.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")
    }, tags={  })
    @ApiResponses(value = {
        @ApiResponse(code = 201, message = "Created", response = Object.class),
        @ApiResponse(code = 400, message = "Bad Request", response = Error400NGAIS.class),
        @ApiResponse(code = 401, message = "Unauthorized", response = Error401NGAIS.class),
        @ApiResponse(code = 403, message = "Forbidden", response = Error403NGAIS.class),
        @ApiResponse(code = 404, message = "Not found", response = Error404NGAIS.class),
        @ApiResponse(code = 405, message = "Method Not Allowed", response = Error405NGAIS.class),
        @ApiResponse(code = 406, message = "Not Acceptable", response = Error406NGAIS.class),
        @ApiResponse(code = 408, message = "Request Timeout"),
        @ApiResponse(code = 409, message = "Conflict", response = Error409NGAIS.class),
        @ApiResponse(code = 415, message = "Unsupported Media Type"),
        @ApiResponse(code = 429, message = "Too Many Requests", response = Error429NGAIS.class),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 503, message = "Service Unavailable") })
    @RequestMapping(value = "/v2/consents/confirmation-of-funds",
        produces = { "application/json", "application/problem+json" },
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default ResponseEntity<Object> _createConsentConfirmationOfFunds(@ApiParam(value = "ID of the request, unique to the call, as determined by the initiating party." ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "Requestbody for a consent confirmation of funds request. "  )  @Valid @RequestBody(required = false) ConsentsConfirmationOfFunds body,@ApiParam(value = "Is contained if and only if the \"Signature\" element is contained in the header of the request." ) @RequestHeader(value="Digest", required=false) String digest,@ApiParam(value = "A signature of the request by the TPP on application level. This might be mandated by ASPSP. " ) @RequestHeader(value="Signature", required=false) String signature,@ApiParam(value = "The certificate used for signing the request, in base64 encoding. Must be contained if a signature is contained. " ) @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate,@ApiParam(value = "Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. " ) @RequestHeader(value="PSU-ID", required=false) String PSU_ID,@ApiParam(value = "Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. " ) @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType,@ApiParam(value = "Might be mandated in the ASPSP's documentation. Only used in a corporate context. " ) @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID,@ApiParam(value = "Might be mandated in the ASPSP's documentation. Only used in a corporate context. " ) @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType,@ApiParam(value = "If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. " , allowableValues="true, false") @RequestHeader(value="TPP-Redirect-Preferred", required=false) String tpPRedirectPreferred,@ApiParam(value = "URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:** This field might be changed to mandatory in the next version of the specification. " ) @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI,@ApiParam(value = "If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. " ) @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI,@ApiParam(value = "If it equals \"true\", the TPP prefers to start the authorisation process separately, e.g. because of the usage of a signing basket. This preference might be ignored by the ASPSP, if a signing basket is not supported as functionality.  If it equals \"false\" or if the parameter is not used, there is no preference of the TPP. This especially indicates that the TPP assumes a direct authorisation of the transaction in the next step, without using a signing basket. " , allowableValues="true, false") @RequestHeader(value="TPP-Explicit-Authorisation-Preferred", required=false) String tpPExplicitAuthorisationPreferred,@ApiParam(value = "The forwarded IP Address header field consists of the corresponding HTTP request IP Address field between PSU and TPP. It shall be contained if and only if this request was actively initiated by the PSU. " ) @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress,@ApiParam(value = "The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. " ) @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept", required=false) String psUAccept,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage,@ApiParam(value = "The forwarded Agent header field of the HTTP request between PSU and TPP, if available. " ) @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent,@ApiParam(value = "HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE " , allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod,@ApiParam(value = "UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. " ) @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID,@ApiParam(value = "The forwarded Geo Location of the corresponding http request between PSU and TPP if available. " ) @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return createConsentConfirmationOfFunds(xRequestID, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, tpPRedirectPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPExplicitAuthorisationPreferred, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    // Override this method
    default ResponseEntity<Object> createConsentConfirmationOfFunds(UUID xRequestID,ConsentsConfirmationOfFunds body,String digest,String signature,byte[] tpPSignatureCertificate,String PSU_ID,String psUIDType,String psUCorporateID,String psUCorporateIDType,String tpPRedirectPreferred,String tpPRedirectURI,String tpPNokRedirectURI,String tpPExplicitAuthorisationPreferred,String psUIPAddress,String psUIPPort,String psUAccept,String psUAcceptCharset,String psUAcceptEncoding,String psUAcceptLanguage,String psUUserAgent,String psUHttpMethod,UUID psUDeviceID,String psUGeoLocation) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "Delete Consent Content", nickname = "deleteConsentConfirmationOfFunds", notes = "Deletes a given consent. ", authorizations = {
        @Authorization(value = "BearerAuthOAuth")
    }, tags={  })
    @ApiResponses(value = {
        @ApiResponse(code = 204, message = "Deletes a given consent."),
        @ApiResponse(code = 400, message = "Bad Request", response = Error400NGAIS.class),
        @ApiResponse(code = 401, message = "Unauthorized", response = Error401NGAIS.class),
        @ApiResponse(code = 403, message = "Forbidden", response = Error403NGAIS.class),
        @ApiResponse(code = 404, message = "Not found", response = Error404NGAIS.class),
        @ApiResponse(code = 405, message = "Method Not Allowed", response = Error405NGAIS.class),
        @ApiResponse(code = 406, message = "Not Acceptable", response = Error406NGAIS.class),
        @ApiResponse(code = 408, message = "Request Timeout"),
        @ApiResponse(code = 409, message = "Conflict", response = Error409NGAIS.class),
        @ApiResponse(code = 415, message = "Unsupported Media Type"),
        @ApiResponse(code = 429, message = "Too Many Requests", response = Error429NGAIS.class),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 503, message = "Service Unavailable") })
    @RequestMapping(value = "/v2/consents/confirmation-of-funds/{consentId}",
        produces = { "application/json", "application/problem+json" },
        method = RequestMethod.DELETE)
    default ResponseEntity<Void> _deleteConsentConfirmationOfFunds(@ApiParam(value = "ID of the corresponding consent object as returned by an Account Information Consent Request. ",required=true) @PathVariable("consentId") String consentId,@ApiParam(value = "ID of the request, unique to the call, as determined by the initiating party." ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "Is contained if and only if the \"Signature\" element is contained in the header of the request." ) @RequestHeader(value="Digest", required=false) String digest,@ApiParam(value = "A signature of the request by the TPP on application level. This might be mandated by ASPSP. " ) @RequestHeader(value="Signature", required=false) String signature,@ApiParam(value = "The certificate used for signing the request, in base64 encoding. Must be contained if a signature is contained. " ) @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate,@ApiParam(value = "The forwarded IP Address header field consists of the corresponding HTTP request IP Address field between PSU and TPP. It shall be contained if and only if this request was actively initiated by the PSU. " ) @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress,@ApiParam(value = "The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. " ) @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept", required=false) String psUAccept,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage,@ApiParam(value = "The forwarded Agent header field of the HTTP request between PSU and TPP, if available. " ) @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent,@ApiParam(value = "HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE " , allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod,@ApiParam(value = "UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. " ) @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID,@ApiParam(value = "The forwarded Geo Location of the corresponding http request between PSU and TPP if available. " ) @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return deleteConsentConfirmationOfFunds(consentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    // Override this method
    default ResponseEntity<Void> deleteConsentConfirmationOfFunds(String consentId,UUID xRequestID,String digest,String signature,byte[] tpPSignatureCertificate,String psUIPAddress,String psUIPPort,String psUAccept,String psUAcceptCharset,String psUAcceptEncoding,String psUAcceptLanguage,String psUUserAgent,String psUHttpMethod,UUID psUDeviceID,String psUGeoLocation) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "Get consent authorisation sub-resources request", nickname = "getConsentAuthorisation", notes = "Return a list of all authorisation subresources IDs which have been created.  This function returns an array of hyperlinks to all generated authorisation sub-resources. ", response = Authorisations.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")
    }, tags={  })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "OK", response = Authorisations.class),
        @ApiResponse(code = 400, message = "Bad Request", response = Error400NGAIS.class),
        @ApiResponse(code = 401, message = "Unauthorized", response = Error401NGAIS.class),
        @ApiResponse(code = 403, message = "Forbidden", response = Error403NGAIS.class),
        @ApiResponse(code = 404, message = "Not found", response = Error404NGAIS.class),
        @ApiResponse(code = 405, message = "Method Not Allowed", response = Error405NGAIS.class),
        @ApiResponse(code = 406, message = "Not Acceptable", response = Error406NGAIS.class),
        @ApiResponse(code = 408, message = "Request Timeout"),
        @ApiResponse(code = 409, message = "Conflict", response = Error409NGAIS.class),
        @ApiResponse(code = 415, message = "Unsupported Media Type"),
        @ApiResponse(code = 429, message = "Too Many Requests", response = Error429NGAIS.class),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 503, message = "Service Unavailable") })
    @RequestMapping(value = "/v2/consents/confirmation-of-funds/{consentId}/authorisations",
        produces = { "application/json", "application/problem+json" },
        method = RequestMethod.GET)
    default ResponseEntity<Authorisations> _getConsentAuthorisation(@ApiParam(value = "ID of the corresponding consent object as returned by an Account Information Consent Request. ",required=true) @PathVariable("consentId") String consentId,@ApiParam(value = "ID of the request, unique to the call, as determined by the initiating party." ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "Is contained if and only if the \"Signature\" element is contained in the header of the request." ) @RequestHeader(value="Digest", required=false) String digest,@ApiParam(value = "A signature of the request by the TPP on application level. This might be mandated by ASPSP. " ) @RequestHeader(value="Signature", required=false) String signature,@ApiParam(value = "The certificate used for signing the request, in base64 encoding. Must be contained if a signature is contained. " ) @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate,@ApiParam(value = "The forwarded IP Address header field consists of the corresponding HTTP request IP Address field between PSU and TPP. It shall be contained if and only if this request was actively initiated by the PSU. " ) @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress,@ApiParam(value = "The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. " ) @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept", required=false) String psUAccept,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage,@ApiParam(value = "The forwarded Agent header field of the HTTP request between PSU and TPP, if available. " ) @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent,@ApiParam(value = "HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE " , allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod,@ApiParam(value = "UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. " ) @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID,@ApiParam(value = "The forwarded Geo Location of the corresponding http request between PSU and TPP if available. " ) @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return getConsentAuthorisation(consentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    // Override this method
    default ResponseEntity<Authorisations> getConsentAuthorisation(String consentId,UUID xRequestID,String digest,String signature,byte[] tpPSignatureCertificate,String psUIPAddress,String psUIPPort,String psUAccept,String psUAcceptCharset,String psUAcceptEncoding,String psUAcceptLanguage,String psUUserAgent,String psUHttpMethod,UUID psUDeviceID,String psUGeoLocation) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "Get Consent Content", nickname = "getConsentConfirmationOfFunds", notes = "Returns the content of an account information consent object. This is returning the data for the TPP especially in cases, where the consent was directly managed between ASPSP and PSU e.g. in a re-direct SCA Approach. ", response = ConsentConfirmationOfFundsContentResponse.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")
    }, tags={  })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "Get consent status", response = ConsentConfirmationOfFundsContentResponse.class),
        @ApiResponse(code = 400, message = "Bad Request", response = Error400NGAIS.class),
        @ApiResponse(code = 401, message = "Unauthorized", response = Error401NGAIS.class),
        @ApiResponse(code = 403, message = "Forbidden", response = Error403NGAIS.class),
        @ApiResponse(code = 404, message = "Not found", response = Error404NGAIS.class),
        @ApiResponse(code = 405, message = "Method Not Allowed", response = Error405NGAIS.class),
        @ApiResponse(code = 406, message = "Not Acceptable", response = Error406NGAIS.class),
        @ApiResponse(code = 408, message = "Request Timeout"),
        @ApiResponse(code = 409, message = "Conflict", response = Error409NGAIS.class),
        @ApiResponse(code = 415, message = "Unsupported Media Type"),
        @ApiResponse(code = 429, message = "Too Many Requests", response = Error429NGAIS.class),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 503, message = "Service Unavailable") })
    @RequestMapping(value = "/v2/consents/confirmation-of-funds/{consentId}",
        produces = { "application/json", "application/problem+json" },
        method = RequestMethod.GET)
    default ResponseEntity<ConsentConfirmationOfFundsContentResponse> _getConsentConfirmationOfFunds(@ApiParam(value = "ID of the corresponding consent object as returned by an Account Information Consent Request. ",required=true) @PathVariable("consentId") String consentId,@ApiParam(value = "ID of the request, unique to the call, as determined by the initiating party." ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "Is contained if and only if the \"Signature\" element is contained in the header of the request." ) @RequestHeader(value="Digest", required=false) String digest,@ApiParam(value = "A signature of the request by the TPP on application level. This might be mandated by ASPSP. " ) @RequestHeader(value="Signature", required=false) String signature,@ApiParam(value = "The certificate used for signing the request, in base64 encoding. Must be contained if a signature is contained. " ) @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate,@ApiParam(value = "The forwarded IP Address header field consists of the corresponding HTTP request IP Address field between PSU and TPP. It shall be contained if and only if this request was actively initiated by the PSU. " ) @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress,@ApiParam(value = "The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. " ) @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept", required=false) String psUAccept,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage,@ApiParam(value = "The forwarded Agent header field of the HTTP request between PSU and TPP, if available. " ) @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent,@ApiParam(value = "HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE " , allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod,@ApiParam(value = "UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. " ) @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID,@ApiParam(value = "The forwarded Geo Location of the corresponding http request between PSU and TPP if available. " ) @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return getConsentConfirmationOfFunds(consentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    // Override this method
    default ResponseEntity<ConsentConfirmationOfFundsContentResponse> getConsentConfirmationOfFunds(String consentId,UUID xRequestID,String digest,String signature,byte[] tpPSignatureCertificate,String psUIPAddress,String psUIPPort,String psUAccept,String psUAcceptCharset,String psUAcceptEncoding,String psUAcceptLanguage,String psUUserAgent,String psUHttpMethod,UUID psUDeviceID,String psUGeoLocation) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "Get Consent Status", nickname = "getConsentConfirmationOfFundsStatus", notes = "Can check the status of an account information consent resource. ", response = ConsentConfirmationOfFundsStatusResponse.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")
    }, tags={  })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "Get consent status", response = ConsentConfirmationOfFundsStatusResponse.class),
        @ApiResponse(code = 400, message = "Bad Request", response = Error400NGAIS.class),
        @ApiResponse(code = 401, message = "Unauthorized", response = Error401NGAIS.class),
        @ApiResponse(code = 403, message = "Forbidden", response = Error403NGAIS.class),
        @ApiResponse(code = 404, message = "Not found", response = Error404NGAIS.class),
        @ApiResponse(code = 405, message = "Method Not Allowed", response = Error405NGAIS.class),
        @ApiResponse(code = 406, message = "Not Acceptable", response = Error406NGAIS.class),
        @ApiResponse(code = 408, message = "Request Timeout"),
        @ApiResponse(code = 409, message = "Conflict", response = Error409NGAIS.class),
        @ApiResponse(code = 415, message = "Unsupported Media Type"),
        @ApiResponse(code = 429, message = "Too Many Requests", response = Error429NGAIS.class),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 503, message = "Service Unavailable") })
    @RequestMapping(value = "/v2/consents/confirmation-of-funds/{consentId}/status",
        produces = { "application/json", "application/problem+json" },
        method = RequestMethod.GET)
    default ResponseEntity<ConsentConfirmationOfFundsStatusResponse> _getConsentConfirmationOfFundsStatus(@ApiParam(value = "ID of the corresponding consent object as returned by an Account Information Consent Request. ",required=true) @PathVariable("consentId") String consentId,@ApiParam(value = "ID of the request, unique to the call, as determined by the initiating party." ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "Is contained if and only if the \"Signature\" element is contained in the header of the request." ) @RequestHeader(value="Digest", required=false) String digest,@ApiParam(value = "A signature of the request by the TPP on application level. This might be mandated by ASPSP. " ) @RequestHeader(value="Signature", required=false) String signature,@ApiParam(value = "The certificate used for signing the request, in base64 encoding. Must be contained if a signature is contained. " ) @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate,@ApiParam(value = "The forwarded IP Address header field consists of the corresponding HTTP request IP Address field between PSU and TPP. It shall be contained if and only if this request was actively initiated by the PSU. " ) @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress,@ApiParam(value = "The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. " ) @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept", required=false) String psUAccept,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage,@ApiParam(value = "The forwarded Agent header field of the HTTP request between PSU and TPP, if available. " ) @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent,@ApiParam(value = "HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE " , allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod,@ApiParam(value = "UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. " ) @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID,@ApiParam(value = "The forwarded Geo Location of the corresponding http request between PSU and TPP if available. " ) @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return getConsentConfirmationOfFundsStatus(consentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    // Override this method
    default ResponseEntity<ConsentConfirmationOfFundsStatusResponse> getConsentConfirmationOfFundsStatus(String consentId,UUID xRequestID,String digest,String signature,byte[] tpPSignatureCertificate,String psUIPAddress,String psUIPPort,String psUAccept,String psUAcceptCharset,String psUAcceptEncoding,String psUAcceptLanguage,String psUUserAgent,String psUHttpMethod,UUID psUDeviceID,String psUGeoLocation) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "Read the SCA status of the consent authorisation", nickname = "getConsentScaStatus", notes = "This method returns the SCA status of a consent initiation's authorisation sub-resource. ", response = ScaStatusResponse.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")
    }, tags={  })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "OK", response = ScaStatusResponse.class),
        @ApiResponse(code = 400, message = "Bad Request", response = Error400NGAIS.class),
        @ApiResponse(code = 401, message = "Unauthorized", response = Error401NGAIS.class),
        @ApiResponse(code = 403, message = "Forbidden", response = Error403NGAIS.class),
        @ApiResponse(code = 404, message = "Not found", response = Error404NGAIS.class),
        @ApiResponse(code = 405, message = "Method Not Allowed", response = Error405NGAIS.class),
        @ApiResponse(code = 406, message = "Not Acceptable", response = Error406NGAIS.class),
        @ApiResponse(code = 408, message = "Request Timeout"),
        @ApiResponse(code = 409, message = "Conflict", response = Error409NGAIS.class),
        @ApiResponse(code = 415, message = "Unsupported Media Type"),
        @ApiResponse(code = 429, message = "Too Many Requests", response = Error429NGAIS.class),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 503, message = "Service Unavailable") })
    @RequestMapping(value = "/v2/consents/confirmation-of-funds/{consentId}/authorisations/{authorisationId}",
        produces = { "application/json", "application/problem+json" },
        method = RequestMethod.GET)
    default ResponseEntity<ScaStatusResponse> _getConsentScaStatus(@ApiParam(value = "ID of the corresponding consent object as returned by an Account Information Consent Request. ",required=true) @PathVariable("consentId") String consentId,@ApiParam(value = "Resource identification of the related SCA.",required=true) @PathVariable("authorisationId") String authorisationId,@ApiParam(value = "ID of the request, unique to the call, as determined by the initiating party." ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "Is contained if and only if the \"Signature\" element is contained in the header of the request." ) @RequestHeader(value="Digest", required=false) String digest,@ApiParam(value = "A signature of the request by the TPP on application level. This might be mandated by ASPSP. " ) @RequestHeader(value="Signature", required=false) String signature,@ApiParam(value = "The certificate used for signing the request, in base64 encoding. Must be contained if a signature is contained. " ) @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate,@ApiParam(value = "The forwarded IP Address header field consists of the corresponding HTTP request IP Address field between PSU and TPP. It shall be contained if and only if this request was actively initiated by the PSU. " ) @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress,@ApiParam(value = "The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. " ) @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept", required=false) String psUAccept,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage,@ApiParam(value = "The forwarded Agent header field of the HTTP request between PSU and TPP, if available. " ) @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent,@ApiParam(value = "HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE " , allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod,@ApiParam(value = "UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. " ) @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID,@ApiParam(value = "The forwarded Geo Location of the corresponding http request between PSU and TPP if available. " ) @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return getConsentScaStatus(consentId, authorisationId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    // Override this method
    default ResponseEntity<ScaStatusResponse> getConsentScaStatus(String consentId,String authorisationId,UUID xRequestID,String digest,String signature,byte[] tpPSignatureCertificate,String psUIPAddress,String psUIPPort,String psUAccept,String psUAcceptCharset,String psUAcceptEncoding,String psUAcceptLanguage,String psUUserAgent,String psUHttpMethod,UUID psUDeviceID,String psUGeoLocation) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "Start the authorisation process for a consent", nickname = "startConsentAuthorisation", notes = "Create an authorisation sub-resource and start the authorisation process of a consent. The message might in addition transmit authentication and authorisation related data.  his method is iterated n times for a n times SCA authorisation in a corporate context, each creating an own authorisation sub-endpoint for the corresponding PSU authorising the consent.  The ASPSP might make the usage of this access method unnecessary, since the related authorisation resource will be automatically created by the ASPSP after the submission of the consent data with the first POST consents call.  The start authorisation process is a process which is needed for creating a new authorisation or cancellation sub-resource.  This applies in the following scenarios:    * The ASPSP has indicated with an 'startAuthorisation' hyperlink in the preceding Payment     initiation response that an explicit start of the authorisation process is needed by the TPP.     The 'startAuthorisation' hyperlink can transport more information about data which needs to be     uploaded by using the extended forms:     * 'startAuthorisationWithPsuIdentfication',     * 'startAuthorisationWithPsuAuthentication'     * 'startAuthorisationWithEncryptedPsuAuthentication'     * 'startAuthorisationWithAuthentciationMethodSelection'   * The related payment initiation cannot yet be executed since a multilevel SCA is mandated.   * The ASPSP has indicated with an 'startAuthorisation' hyperlink in the preceding     payment cancellation response that an explicit start of the authorisation process is needed by the TPP.     The 'startAuthorisation' hyperlink can transport more information about data which needs to be uploaded     by using the extended forms as indicated above.   * The related payment cancellation request cannot be applied yet since a multilevel SCA is mandate for     executing the cancellation.   * The signing basket needs to be authorised yet. ", response = StartScaprocessResponse.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")
    }, tags={  })
    @ApiResponses(value = {
        @ApiResponse(code = 201, message = "Created", response = StartScaprocessResponse.class),
        @ApiResponse(code = 400, message = "Bad Request", response = Error400NGAIS.class),
        @ApiResponse(code = 401, message = "Unauthorized", response = Error401NGAIS.class),
        @ApiResponse(code = 403, message = "Forbidden", response = Error403NGAIS.class),
        @ApiResponse(code = 404, message = "Not found", response = Error404NGAIS.class),
        @ApiResponse(code = 405, message = "Method Not Allowed", response = Error405NGAIS.class),
        @ApiResponse(code = 406, message = "Not Acceptable", response = Error406NGAIS.class),
        @ApiResponse(code = 408, message = "Request Timeout"),
        @ApiResponse(code = 409, message = "Conflict", response = Error409NGAIS.class),
        @ApiResponse(code = 415, message = "Unsupported Media Type"),
        @ApiResponse(code = 429, message = "Too Many Requests", response = Error429NGAIS.class),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 503, message = "Service Unavailable") })
    @RequestMapping(value = "/v2/consents/confirmation-of-funds/{consentId}/authorisations",
        produces = { "application/json", "application/problem+json" },
        consumes = { "application/json" },
        method = RequestMethod.POST)
    default ResponseEntity<StartScaprocessResponse> _startConsentAuthorisation(@ApiParam(value = "ID of the request, unique to the call, as determined by the initiating party." ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "ID of the corresponding consent object as returned by an Account Information Consent Request. ",required=true) @PathVariable("consentId") String consentId,@ApiParam(value = ""  )  @Valid @RequestBody(required = false) Object body,@ApiParam(value = "Is contained if and only if the \"Signature\" element is contained in the header of the request." ) @RequestHeader(value="Digest", required=false) String digest,@ApiParam(value = "A signature of the request by the TPP on application level. This might be mandated by ASPSP. " ) @RequestHeader(value="Signature", required=false) String signature,@ApiParam(value = "The certificate used for signing the request, in base64 encoding. Must be contained if a signature is contained. " ) @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate,@ApiParam(value = "Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. " ) @RequestHeader(value="PSU-ID", required=false) String PSU_ID,@ApiParam(value = "Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. " ) @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType,@ApiParam(value = "Might be mandated in the ASPSP's documentation. Only used in a corporate context. " ) @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID,@ApiParam(value = "Might be mandated in the ASPSP's documentation. Only used in a corporate context. " ) @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType,@ApiParam(value = "If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. " , allowableValues="true, false") @RequestHeader(value="TPP-Redirect-Preferred", required=false) String tpPRedirectPreferred,@ApiParam(value = "URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:** This field might be changed to mandatory in the next version of the specification. " ) @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI,@ApiParam(value = "If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. " ) @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI,@ApiParam(value = "URI for the Endpoint of the TPP-API to which the status of the payment initiation should be sent. This header field may by ignored by the ASPSP.  For security reasons, it shall be ensured that the TPP-Notification-URI as introduced above is secured by the TPP eIDAS QWAC used for identification of the TPP. The following applies:  URIs which are provided by TPPs in TPP-Notification-URI shall comply with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate. Please note that in case of example-TPP.com as certificate entry TPP- Notification-URI like www.example-TPP.com/xs2a-client/v2/ASPSPidentifcation/mytransaction- id/notifications or notifications.example-TPP.com/xs2a-client/v2/ASPSPidentifcation/mytransaction- id/notifications would be compliant.  Wildcard definitions shall be taken into account for compliance checks by the ASPSP.  ASPSPs may respond with ASPSP-Notification-Support set to false, if the provided URIs do not comply. " ) @RequestHeader(value="TPP-Notification-URI", required=false) String tpPNotificationURI,@ApiParam(value = "The string has the form  status=X1, ..., Xn  where Xi is one of the constants SCA, PROCESS, LAST and where constants are not repeated. The usage of the constants supports the of following semantics:    SCA: A notification on every change of the scaStatus attribute for all related authorisation processes is preferred by the TPP.    PROCESS: A notification on all changes of consentStatus or transactionStatus attributes is preferred by the TPP.   LAST: Only a notification on the last consentStatus or transactionStatus as available in the XS2A interface is preferred by the TPP.  This header field may be ignored, if the ASPSP does not support resource notification services for the related TPP. " ) @RequestHeader(value="TPP-Notification-Content-Preferred", required=false) String tpPNotificationContentPreferred,@ApiParam(value = "The forwarded IP Address header field consists of the corresponding HTTP request IP Address field between PSU and TPP. It shall be contained if and only if this request was actively initiated by the PSU. " ) @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress,@ApiParam(value = "The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. " ) @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept", required=false) String psUAccept,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage,@ApiParam(value = "The forwarded Agent header field of the HTTP request between PSU and TPP, if available. " ) @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent,@ApiParam(value = "HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE " , allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod,@ApiParam(value = "UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. " ) @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID,@ApiParam(value = "The forwarded Geo Location of the corresponding http request between PSU and TPP if available. " ) @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return startConsentAuthorisation(xRequestID, consentId, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, tpPRedirectPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPNotificationURI, tpPNotificationContentPreferred, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    // Override this method
    default ResponseEntity<StartScaprocessResponse> startConsentAuthorisation(UUID xRequestID,String consentId,Object body,String digest,String signature,byte[] tpPSignatureCertificate,String PSU_ID,String psUIDType,String psUCorporateID,String psUCorporateIDType,String tpPRedirectPreferred,String tpPRedirectURI,String tpPNokRedirectURI,String tpPNotificationURI,String tpPNotificationContentPreferred,String psUIPAddress,String psUIPPort,String psUAccept,String psUAcceptCharset,String psUAcceptEncoding,String psUAcceptLanguage,String psUUserAgent,String psUHttpMethod,UUID psUDeviceID,String psUGeoLocation) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }


    @ApiOperation(value = "Update PSU Data for consents", nickname = "updateConsentsPsuData", notes = "This method update PSU data on the consents  resource if needed. It may authorise a consent within the Embedded SCA Approach where needed.  Independently from the SCA Approach it supports e.g. the selection of the authentication method and a non-SCA PSU authentication.  This methods updates PSU data on the cancellation authorisation resource if needed.  There are several possible update PSU data requests in the context of a consent request if needed, which depends on the SCA approach:  * Redirect SCA Approach:   A specific Update PSU data request is applicable for     * the selection of authentication methods, before choosing the actual SCA approach. * Decoupled SCA Approach:   A specific update PSU data request is only applicable for   * adding the PSU identification, if not provided yet in the payment initiation request or the Account Information Consent Request, or if no OAuth2 access token is used, or   * the selection of authentication methods. * Embedded SCA Approach:   The Update PSU data request might be used   * to add credentials as a first factor authentication data of the PSU and   * to select the authentication method and   * transaction authorisation.  The SCA Approach might depend on the chosen SCA method. For that reason, the following possible update PSU data request can apply to all SCA approaches:  * Select an SCA method in case of several SCA methods are available for the customer.  There are the following request types on this access path:   * Update PSU identification   * Update PSU authentication   * Select PSU autorization method     WARNING: This method needs a reduced header,     therefore many optional elements are not present.     Maybe in a later version the access path will change.   * Transaction Authorisation     WARNING: This method needs a reduced header,     therefore many optional elements are not present.     Maybe in a later version the access path will change. ", response = Object.class, authorizations = {
        @Authorization(value = "BearerAuthOAuth")
    }, tags={  })
    @ApiResponses(value = {
        @ApiResponse(code = 200, message = "OK", response = Object.class),
        @ApiResponse(code = 400, message = "Bad Request", response = Error400NGAIS.class),
        @ApiResponse(code = 401, message = "Unauthorized", response = Error401NGAIS.class),
        @ApiResponse(code = 403, message = "Forbidden", response = Error403NGAIS.class),
        @ApiResponse(code = 404, message = "Not found", response = Error404NGAIS.class),
        @ApiResponse(code = 405, message = "Method Not Allowed", response = Error405NGAIS.class),
        @ApiResponse(code = 406, message = "Not Acceptable", response = Error406NGAIS.class),
        @ApiResponse(code = 408, message = "Request Timeout"),
        @ApiResponse(code = 409, message = "Conflict", response = Error409NGAIS.class),
        @ApiResponse(code = 415, message = "Unsupported Media Type"),
        @ApiResponse(code = 429, message = "Too Many Requests", response = Error429NGAIS.class),
        @ApiResponse(code = 500, message = "Internal Server Error"),
        @ApiResponse(code = 503, message = "Service Unavailable") })
    @RequestMapping(value = "/v2/consents/confirmation-of-funds/{consentId}/authorisations/{authorisationId}",
        produces = { "application/json", "application/problem+json" },
        consumes = { "application/json" },
        method = RequestMethod.PUT)
    default ResponseEntity<Object> _updateConsentsPsuData(@ApiParam(value = "ID of the request, unique to the call, as determined by the initiating party." ,required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID,@ApiParam(value = "ID of the corresponding consent object as returned by an Account Information Consent Request. ",required=true) @PathVariable("consentId") String consentId,@ApiParam(value = "Resource identification of the related SCA.",required=true) @PathVariable("authorisationId") String authorisationId,@ApiParam(value = ""  )  @Valid @RequestBody(required = false) Object body,@ApiParam(value = "Is contained if and only if the \"Signature\" element is contained in the header of the request." ) @RequestHeader(value="Digest", required=false) String digest,@ApiParam(value = "A signature of the request by the TPP on application level. This might be mandated by ASPSP. " ) @RequestHeader(value="Signature", required=false) String signature,@ApiParam(value = "The certificate used for signing the request, in base64 encoding. Must be contained if a signature is contained. " ) @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate,@ApiParam(value = "Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. " ) @RequestHeader(value="PSU-ID", required=false) String PSU_ID,@ApiParam(value = "Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. " ) @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType,@ApiParam(value = "Might be mandated in the ASPSP's documentation. Only used in a corporate context. " ) @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID,@ApiParam(value = "Might be mandated in the ASPSP's documentation. Only used in a corporate context. " ) @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType,@ApiParam(value = "The forwarded IP Address header field consists of the corresponding HTTP request IP Address field between PSU and TPP. It shall be contained if and only if this request was actively initiated by the PSU. " ) @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress,@ApiParam(value = "The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. " ) @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept", required=false) String psUAccept,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding,@ApiParam(value = "The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. " ) @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage,@ApiParam(value = "The forwarded Agent header field of the HTTP request between PSU and TPP, if available. " ) @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent,@ApiParam(value = "HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE " , allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod,@ApiParam(value = "UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. " ) @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID,@ApiParam(value = "The forwarded Geo Location of the corresponding http request between PSU and TPP if available. " ) @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return updateConsentsPsuData(xRequestID, consentId, authorisationId, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    // Override this method
    default ResponseEntity<Object> updateConsentsPsuData(UUID xRequestID,String consentId,String authorisationId,Object body,String digest,String signature,byte[] tpPSignatureCertificate,String PSU_ID,String psUIDType,String psUCorporateID,String psUCorporateIDType,String psUIPAddress,String psUIPPort,String psUAccept,String psUAcceptCharset,String psUAcceptEncoding,String psUAcceptLanguage,String psUUserAgent,String psUHttpMethod,UUID psUDeviceID,String psUGeoLocation) {
        if(getObjectMapper().isPresent() && getAcceptHeader().isPresent()) {
        } else {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity<>(HttpStatus.NOT_IMPLEMENTED);
    }

}
