/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.MonthsOfExecution;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Details of underlying standing orders. ")
@Validated
public class StandingOrderDetails {
    @JsonProperty(value="startDate")
    private LocalDate startDate = null;
    @JsonProperty(value="frequency")
    private FrequencyCode frequency = null;
    @JsonProperty(value="endDate")
    private LocalDate endDate = null;
    @JsonProperty(value="executionRule")
    private ExecutionRule executionRule = null;
    @JsonProperty(value="withinAMonthFlag")
    private Boolean withinAMonthFlag = null;
    @JsonProperty(value="monthsOfExecution")
    private MonthsOfExecution monthsOfExecution = null;
    @JsonProperty(value="multiplicator")
    private Integer multiplicator = null;
    @JsonProperty(value="dayOfExecution")
    private DayOfExecution dayOfExecution = null;
    @JsonProperty(value="limitAmount")
    private Amount limitAmount = null;

    public StandingOrderDetails startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public StandingOrderDetails frequency(FrequencyCode frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="frequency")
    public FrequencyCode getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyCode frequency) {
        this.frequency = frequency;
    }

    public StandingOrderDetails endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="endDate")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public StandingOrderDetails executionRule(ExecutionRule executionRule) {
        this.executionRule = executionRule;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="executionRule")
    public ExecutionRule getExecutionRule() {
        return this.executionRule;
    }

    public void setExecutionRule(ExecutionRule executionRule) {
        this.executionRule = executionRule;
    }

    public StandingOrderDetails withinAMonthFlag(Boolean withinAMonthFlag) {
        this.withinAMonthFlag = withinAMonthFlag;
        return this;
    }

    @ApiModelProperty(value="This element is only used in case of frequency equals \"monthly\".  If this element equals false it has no effect. If this element equals true, then the execution rule is overruled if the day of execution would fall into a different month using the execution rule.  Example: executionRule equals \"preceding\", dayOfExecution equals \"02\" and the second of a month is a Sunday.  In this case, the transaction date would be on the last day of the month before.  This would be overruled if withinAMonthFlag equals true and the payment is processed on Monday the third of the Month. Remark: This attribute is rarely supported in the market. ")
    @JsonProperty(value="withinAMonthFlag")
    public Boolean isWithinAMonthFlag() {
        return this.withinAMonthFlag;
    }

    public void setWithinAMonthFlag(Boolean withinAMonthFlag) {
        this.withinAMonthFlag = withinAMonthFlag;
    }

    public StandingOrderDetails monthsOfExecution(MonthsOfExecution monthsOfExecution) {
        this.monthsOfExecution = monthsOfExecution;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="monthsOfExecution")
    public MonthsOfExecution getMonthsOfExecution() {
        return this.monthsOfExecution;
    }

    public void setMonthsOfExecution(MonthsOfExecution monthsOfExecution) {
        this.monthsOfExecution = monthsOfExecution;
    }

    public StandingOrderDetails multiplicator(Integer multiplicator) {
        this.multiplicator = multiplicator;
        return this;
    }

    @ApiModelProperty(value="This is multiplying the given frequency resulting the exact frequency, e.g. Frequency=weekly and multiplicator=3 means every 3 weeks. Remark: This attribute is rarely supported in the market. ")
    @JsonProperty(value="multiplicator")
    public Integer getMultiplicator() {
        return this.multiplicator;
    }

    public void setMultiplicator(Integer multiplicator) {
        this.multiplicator = multiplicator;
    }

    public StandingOrderDetails dayOfExecution(DayOfExecution dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="dayOfExecution")
    public DayOfExecution getDayOfExecution() {
        return this.dayOfExecution;
    }

    public void setDayOfExecution(DayOfExecution dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public StandingOrderDetails limitAmount(Amount limitAmount) {
        this.limitAmount = limitAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="limitAmount")
    public Amount getLimitAmount() {
        return this.limitAmount;
    }

    public void setLimitAmount(Amount limitAmount) {
        this.limitAmount = limitAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StandingOrderDetails standingOrderDetails = (StandingOrderDetails)o;
        return Objects.equals(this.startDate, standingOrderDetails.startDate) && Objects.equals((Object)this.frequency, (Object)standingOrderDetails.frequency) && Objects.equals(this.endDate, standingOrderDetails.endDate) && Objects.equals((Object)this.executionRule, (Object)standingOrderDetails.executionRule) && Objects.equals(this.withinAMonthFlag, standingOrderDetails.withinAMonthFlag) && Objects.equals(this.monthsOfExecution, standingOrderDetails.monthsOfExecution) && Objects.equals(this.multiplicator, standingOrderDetails.multiplicator) && Objects.equals((Object)this.dayOfExecution, (Object)standingOrderDetails.dayOfExecution) && Objects.equals(this.limitAmount, standingOrderDetails.limitAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.startDate, this.frequency, this.endDate, this.executionRule, this.withinAMonthFlag, this.monthsOfExecution, this.multiplicator, this.dayOfExecution, this.limitAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class StandingOrderDetails {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    executionRule: ").append(this.toIndentedString((Object)this.executionRule)).append("\n");
        sb.append("    withinAMonthFlag: ").append(this.toIndentedString(this.withinAMonthFlag)).append("\n");
        sb.append("    monthsOfExecution: ").append(this.toIndentedString(this.monthsOfExecution)).append("\n");
        sb.append("    multiplicator: ").append(this.toIndentedString(this.multiplicator)).append("\n");
        sb.append("    dayOfExecution: ").append(this.toIndentedString((Object)this.dayOfExecution)).append("\n");
        sb.append("    limitAmount: ").append(this.toIndentedString(this.limitAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

