/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.PurposeCode;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Generic Body for a periodic payment initation via JSON.  This generic JSON body can be used to represent valid periodic payment initiations for the following JSON based payment product,  which where defined in the Implementation Guidelines:    * sepa-credit-transfers   * instant-sepa-credit-transfers   * target-2-payments   * cross-border-credit-transfers  For the convenience of the implementer additional which are already predefinded in the Implementation Guidelines  are included (but commented in source code), such that an ASPSP may add them easily.  Take care: Since the format is intended to fit for all payment products  there are additional conditions which are NOT covered by this specification. Please check the Implementation Guidelines for detailes.   The following data element are depending on the actual payment product available (in source code):             <table style=\"width:100%\">  <tr><th>Data Element</th><th>SCT EU Core</th><th>SCT INST EU Core</th><th>Target2 Paym. Core</th><th>Cross Border CT Core</th></tr>  <tr><td>endToEndIdentification</td><td> optional</td> <td>optional</td> <td>optional</td> <td>n.a.</td> </tr>  <tr><td>instructionIdentification</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>debtorName</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>debtorAccount</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> </tr>  <tr><td>debtorId</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>ultimateDebtor</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>instructedAmount</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> </tr>  <tr><td>transactionCurrency</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>exchangeRateInformation</td> <td>n.a.</td> <td>n.a.</td><td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>creditorAccount</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> </tr>  <tr><td>creditorAgent</td> <td>optional</td> <td>optional</td> <td>optional</td> <td>conditional </td> </tr>  <tr><td>creditorAgentName</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>creditorName</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> </tr>  <tr><td>creditorId</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>creditorAddress</td>optional</td> <td>optional</td> <td>optional</td> <td>conditional </td> </tr>  <tr><td>creditorNameAndAddress</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>ultimateCreditor</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>purposeCode</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>chargeBearer</td> <td>n.a.</td> <td>n.a.</td> <td>optional</td> <td>conditional </td> </tr>  <tr><td>remittanceInformationUnstructured</td> <td>optional</td> <td>optional</td> <td> optional</td> <td>optional</td> </tr>  <tr><td>remittanceInformationUnstructuredArray</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>remittanceInformationStructured</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>remittanceInformationStructuredArray</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>requestedExecutionDate</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>requestedExecutionTime</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>startDate</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> </tr>  <tr><td>executionRule</td> <td>optional</td> <td>optional</td> <td>optional</td> <td>optional</td> </tr>  <tr><td>endDate</td> <td>optional</td> <td>optional</td> <td>optional</td> <td>optional</td> </tr>  <tr><td>frequency</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> </tr>  <tr><td>dayOfExecution</td> <td>conditional</td> <td>conditional</td> <td>conditional</td> <td>conditional</td> </tr>     </td></tr>   </table>    IMPORTANT: In this API definition the following holds:   *  All data elements mentioned above are defined, but some of them are commented,      i.e. they are only visible in the source code and can be used by uncommenting them.   * Data elements which are mandatory in the table above for all payment products      are set to be mandatory in this specification.   * Data elements which are indicated in the table above as n.a. for all payment products are commented in the source code.   * Data elements which are indicated to be option, conditional or mandatory for at least one payment product      in the table above are set to be optional in the s specification except the case where all are definde to be mandatory.    * Data element which are inticated to be n.a. can be used by the ASPS if needed.      In this case uncomment tthe the relatetd lines in the source code.   * If one uses this data types for some payment products he has to ensure that the used data type is      valid according to the underlying payment product, e.g. by some appropriate validations. ")
@Validated
public class PeriodicPaymentInitiationJson {
    @JsonProperty(value="endToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="instructionIdentification")
    private String instructionIdentification = null;
    @JsonProperty(value="debtorName")
    private String debtorName = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="ultimateDebtor")
    private String ultimateDebtor = null;
    @JsonProperty(value="instructedAmount")
    private Amount instructedAmount = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="creditorAgent")
    private String creditorAgent = null;
    @JsonProperty(value="creditorId")
    private String creditorId = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAddress")
    private Address creditorAddress = null;
    @JsonProperty(value="ultimateCreditor")
    private String ultimateCreditor = null;
    @JsonProperty(value="purposeCode")
    private PurposeCode purposeCode = null;
    @JsonProperty(value="remittanceInformationUnstructured")
    private String remittanceInformationUnstructured = null;
    @JsonProperty(value="remittanceInformationStructured")
    private String remittanceInformationStructured = null;
    @JsonProperty(value="remittanceInformationStructuredArray")
    private RemittanceInformationStructuredArray remittanceInformationStructuredArray = null;
    @JsonProperty(value="startDate")
    private LocalDate startDate = null;
    @JsonProperty(value="endDate")
    private LocalDate endDate = null;
    @JsonProperty(value="executionRule")
    private ExecutionRule executionRule = null;
    @JsonProperty(value="frequency")
    private FrequencyCode frequency = null;
    @JsonProperty(value="dayOfExecution")
    private DayOfExecution dayOfExecution = null;

    public PeriodicPaymentInitiationJson endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="endToEndIdentification")
    public @Size(max=35) String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public PeriodicPaymentInitiationJson instructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="instructionIdentification")
    public @Size(max=35) String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public PeriodicPaymentInitiationJson debtorName(String debtorName) {
        this.debtorName = debtorName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="debtorName")
    public @Size(max=70) String getDebtorName() {
        return this.debtorName;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public PeriodicPaymentInitiationJson debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="debtorAccount")
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public PeriodicPaymentInitiationJson ultimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="ultimateDebtor")
    public @Size(max=70) String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public PeriodicPaymentInitiationJson instructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="instructedAmount")
    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public PeriodicPaymentInitiationJson creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="creditorAccount")
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public PeriodicPaymentInitiationJson creditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    @JsonProperty(value="creditorAgent")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public PeriodicPaymentInitiationJson creditorId(String creditorId) {
        this.creditorId = creditorId;
        return this;
    }

    @ApiModelProperty(value="Identification of Creditors, e.g. a SEPA Creditor ID.")
    @Size(max=35)
    @JsonProperty(value="creditorId")
    public @Size(max=35) String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public PeriodicPaymentInitiationJson creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Size(max=70)
    @JsonProperty(value="creditorName")
    public @NotNull @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public PeriodicPaymentInitiationJson creditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="creditorAddress")
    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public PeriodicPaymentInitiationJson ultimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="ultimateCreditor")
    public @Size(max=70) String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public PeriodicPaymentInitiationJson purposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="purposeCode")
    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public PeriodicPaymentInitiationJson remittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    @JsonProperty(value="remittanceInformationUnstructured")
    public @Size(max=140) String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public PeriodicPaymentInitiationJson remittanceInformationStructured(String remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    @JsonProperty(value="remittanceInformationStructured")
    public @Size(max=140) String getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public void setRemittanceInformationStructured(String remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public PeriodicPaymentInitiationJson remittanceInformationStructuredArray(RemittanceInformationStructuredArray remittanceInformationStructuredArray) {
        this.remittanceInformationStructuredArray = remittanceInformationStructuredArray;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="remittanceInformationStructuredArray")
    public RemittanceInformationStructuredArray getRemittanceInformationStructuredArray() {
        return this.remittanceInformationStructuredArray;
    }

    public void setRemittanceInformationStructuredArray(RemittanceInformationStructuredArray remittanceInformationStructuredArray) {
        this.remittanceInformationStructuredArray = remittanceInformationStructuredArray;
    }

    public PeriodicPaymentInitiationJson startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public PeriodicPaymentInitiationJson endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="endDate")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public PeriodicPaymentInitiationJson executionRule(ExecutionRule executionRule) {
        this.executionRule = executionRule;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="executionRule")
    public ExecutionRule getExecutionRule() {
        return this.executionRule;
    }

    public void setExecutionRule(ExecutionRule executionRule) {
        this.executionRule = executionRule;
    }

    public PeriodicPaymentInitiationJson frequency(FrequencyCode frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="frequency")
    public FrequencyCode getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyCode frequency) {
        this.frequency = frequency;
    }

    public PeriodicPaymentInitiationJson dayOfExecution(DayOfExecution dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="dayOfExecution")
    public DayOfExecution getDayOfExecution() {
        return this.dayOfExecution;
    }

    public void setDayOfExecution(DayOfExecution dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeriodicPaymentInitiationJson periodicPaymentInitiationJson = (PeriodicPaymentInitiationJson)o;
        return Objects.equals(this.endToEndIdentification, periodicPaymentInitiationJson.endToEndIdentification) && Objects.equals(this.instructionIdentification, periodicPaymentInitiationJson.instructionIdentification) && Objects.equals(this.debtorName, periodicPaymentInitiationJson.debtorName) && Objects.equals(this.debtorAccount, periodicPaymentInitiationJson.debtorAccount) && Objects.equals(this.ultimateDebtor, periodicPaymentInitiationJson.ultimateDebtor) && Objects.equals(this.instructedAmount, periodicPaymentInitiationJson.instructedAmount) && Objects.equals(this.creditorAccount, periodicPaymentInitiationJson.creditorAccount) && Objects.equals(this.creditorAgent, periodicPaymentInitiationJson.creditorAgent) && Objects.equals(this.creditorId, periodicPaymentInitiationJson.creditorId) && Objects.equals(this.creditorName, periodicPaymentInitiationJson.creditorName) && Objects.equals(this.creditorAddress, periodicPaymentInitiationJson.creditorAddress) && Objects.equals(this.ultimateCreditor, periodicPaymentInitiationJson.ultimateCreditor) && Objects.equals((Object)this.purposeCode, (Object)periodicPaymentInitiationJson.purposeCode) && Objects.equals(this.remittanceInformationUnstructured, periodicPaymentInitiationJson.remittanceInformationUnstructured) && Objects.equals(this.remittanceInformationStructured, periodicPaymentInitiationJson.remittanceInformationStructured) && Objects.equals(this.remittanceInformationStructuredArray, periodicPaymentInitiationJson.remittanceInformationStructuredArray) && Objects.equals(this.startDate, periodicPaymentInitiationJson.startDate) && Objects.equals(this.endDate, periodicPaymentInitiationJson.endDate) && Objects.equals((Object)this.executionRule, (Object)periodicPaymentInitiationJson.executionRule) && Objects.equals((Object)this.frequency, (Object)periodicPaymentInitiationJson.frequency) && Objects.equals((Object)this.dayOfExecution, (Object)periodicPaymentInitiationJson.dayOfExecution);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endToEndIdentification, this.instructionIdentification, this.debtorName, this.debtorAccount, this.ultimateDebtor, this.instructedAmount, this.creditorAccount, this.creditorAgent, this.creditorId, this.creditorName, this.creditorAddress, this.ultimateCreditor, this.purposeCode, this.remittanceInformationUnstructured, this.remittanceInformationStructured, this.remittanceInformationStructuredArray, this.startDate, this.endDate, this.executionRule, this.frequency, this.dayOfExecution});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PeriodicPaymentInitiationJson {\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    instructionIdentification: ").append(this.toIndentedString(this.instructionIdentification)).append("\n");
        sb.append("    debtorName: ").append(this.toIndentedString(this.debtorName)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    ultimateDebtor: ").append(this.toIndentedString(this.ultimateDebtor)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorId: ").append(this.toIndentedString(this.creditorId)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAddress: ").append(this.toIndentedString(this.creditorAddress)).append("\n");
        sb.append("    ultimateCreditor: ").append(this.toIndentedString(this.ultimateCreditor)).append("\n");
        sb.append("    purposeCode: ").append(this.toIndentedString((Object)this.purposeCode)).append("\n");
        sb.append("    remittanceInformationUnstructured: ").append(this.toIndentedString(this.remittanceInformationUnstructured)).append("\n");
        sb.append("    remittanceInformationStructured: ").append(this.toIndentedString(this.remittanceInformationStructured)).append("\n");
        sb.append("    remittanceInformationStructuredArray: ").append(this.toIndentedString(this.remittanceInformationStructuredArray)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    executionRule: ").append(this.toIndentedString((Object)this.executionRule)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    dayOfExecution: ").append(this.toIndentedString((Object)this.dayOfExecution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

