/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.HrefType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A list of hyperlinks to be recognised by the TPP.  Type of links admitted in this response (which might be extended by single ASPSPs as indicated in its XS2A  documentation):   * 'scaRedirect':      In case of an SCA Redirect Approach, the ASPSP is transmitting the link to which to redirect the      PSU browser.   * 'scaOAuth':      In case of an OAuth2 based Redirect Approach, the ASPSP is transmitting the link where the configuration      of the OAuth2 Server is defined.      The configuration follows the OAuth 2.0 Authorisation Server Metadata specification.  * 'confirmation':    Might be added by the ASPSP if either the \"scaRedirect\" or \"scaOAuth\" hyperlink is returned    in the same response message.    This hyperlink defines the URL to the resource which needs to be updated with      * a confirmation code as retrieved after the plain redirect authentication process with the ASPSP authentication server or     * an access token as retrieved by submitting an authorization code after the integrated OAuth based authentication process with the ASPSP authentication server.   * 'startAuthorisation':      In case, where an explicit start of the transaction authorisation is needed,      but no more data needs to be updated (no authentication method to be selected,      no PSU identification nor PSU authentication data to be uploaded).   * 'startAuthorisationWithPsuIdentification':      The link to the authorisation end-point, where the authorisation sub-resource has to be generated      while uploading the PSU identification data.   * 'startAuthorisationWithPsuAuthentication':     The link to the authorisation end-point, where the authorisation sub-resource has to be generated      while uploading the PSU authentication data.   * 'startAuthorisationWithEncryptedPsuAuthentication':     Same as startAuthorisactionWithPsuAuthentication where the authentication data need to be encrypted on      application layer in uploading.   * 'startAuthorisationWithAuthenticationMethodSelection':     The link to the authorisation end-point, where the authorisation sub-resource has to be generated      while selecting the authentication method. This link is contained under exactly the same conditions      as the data element 'scaMethods'    * 'startAuthorisationWithTransactionAuthorisation':     The link to the authorisation end-point, where the authorisation sub-resource has to be generated      while authorising the transaction e.g. by uploading an OTP received by SMS.   * 'self':      The link to the Establish Account Information Consent resource created by this request.      This link can be used to retrieve the resource data.    * 'status':      The link to retrieve the status of the account information consent.   * 'scaStatus': The link to retrieve the scaStatus of the corresponding authorisation sub-resource.      This link is only contained, if an authorisation sub-resource has been already created. ")
@Validated
public class LinksConsents
extends HashMap<String, HrefType> {
    @JsonProperty(value="scaRedirect")
    private HrefType scaRedirect = null;
    @JsonProperty(value="scaOAuth")
    private HrefType scaOAuth = null;
    @JsonProperty(value="confirmation")
    private HrefType confirmation = null;
    @JsonProperty(value="startAuthorisation")
    private HrefType startAuthorisation = null;
    @JsonProperty(value="startAuthorisationWithPsuIdentification")
    private HrefType startAuthorisationWithPsuIdentification = null;
    @JsonProperty(value="startAuthorisationWithPsuAuthentication")
    private HrefType startAuthorisationWithPsuAuthentication = null;
    @JsonProperty(value="startAuthorisationWithEncryptedPsuAuthentication")
    private HrefType startAuthorisationWithEncryptedPsuAuthentication = null;
    @JsonProperty(value="startAuthorisationWithAuthenticationMethodSelection")
    private HrefType startAuthorisationWithAuthenticationMethodSelection = null;
    @JsonProperty(value="startAuthorisationWithTransactionAuthorisation")
    private HrefType startAuthorisationWithTransactionAuthorisation = null;
    @JsonProperty(value="self")
    private HrefType self = null;
    @JsonProperty(value="status")
    private HrefType status = null;
    @JsonProperty(value="scaStatus")
    private HrefType scaStatus = null;

    public LinksConsents scaRedirect(HrefType scaRedirect) {
        this.scaRedirect = scaRedirect;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scaRedirect")
    public HrefType getScaRedirect() {
        return this.scaRedirect;
    }

    public void setScaRedirect(HrefType scaRedirect) {
        this.scaRedirect = scaRedirect;
    }

    public LinksConsents scaOAuth(HrefType scaOAuth) {
        this.scaOAuth = scaOAuth;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scaOAuth")
    public HrefType getScaOAuth() {
        return this.scaOAuth;
    }

    public void setScaOAuth(HrefType scaOAuth) {
        this.scaOAuth = scaOAuth;
    }

    public LinksConsents confirmation(HrefType confirmation) {
        this.confirmation = confirmation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="confirmation")
    public HrefType getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(HrefType confirmation) {
        this.confirmation = confirmation;
    }

    public LinksConsents startAuthorisation(HrefType startAuthorisation) {
        this.startAuthorisation = startAuthorisation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="startAuthorisation")
    public HrefType getStartAuthorisation() {
        return this.startAuthorisation;
    }

    public void setStartAuthorisation(HrefType startAuthorisation) {
        this.startAuthorisation = startAuthorisation;
    }

    public LinksConsents startAuthorisationWithPsuIdentification(HrefType startAuthorisationWithPsuIdentification) {
        this.startAuthorisationWithPsuIdentification = startAuthorisationWithPsuIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="startAuthorisationWithPsuIdentification")
    public HrefType getStartAuthorisationWithPsuIdentification() {
        return this.startAuthorisationWithPsuIdentification;
    }

    public void setStartAuthorisationWithPsuIdentification(HrefType startAuthorisationWithPsuIdentification) {
        this.startAuthorisationWithPsuIdentification = startAuthorisationWithPsuIdentification;
    }

    public LinksConsents startAuthorisationWithPsuAuthentication(HrefType startAuthorisationWithPsuAuthentication) {
        this.startAuthorisationWithPsuAuthentication = startAuthorisationWithPsuAuthentication;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="startAuthorisationWithPsuAuthentication")
    public HrefType getStartAuthorisationWithPsuAuthentication() {
        return this.startAuthorisationWithPsuAuthentication;
    }

    public void setStartAuthorisationWithPsuAuthentication(HrefType startAuthorisationWithPsuAuthentication) {
        this.startAuthorisationWithPsuAuthentication = startAuthorisationWithPsuAuthentication;
    }

    public LinksConsents startAuthorisationWithEncryptedPsuAuthentication(HrefType startAuthorisationWithEncryptedPsuAuthentication) {
        this.startAuthorisationWithEncryptedPsuAuthentication = startAuthorisationWithEncryptedPsuAuthentication;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="startAuthorisationWithEncryptedPsuAuthentication")
    public HrefType getStartAuthorisationWithEncryptedPsuAuthentication() {
        return this.startAuthorisationWithEncryptedPsuAuthentication;
    }

    public void setStartAuthorisationWithEncryptedPsuAuthentication(HrefType startAuthorisationWithEncryptedPsuAuthentication) {
        this.startAuthorisationWithEncryptedPsuAuthentication = startAuthorisationWithEncryptedPsuAuthentication;
    }

    public LinksConsents startAuthorisationWithAuthenticationMethodSelection(HrefType startAuthorisationWithAuthenticationMethodSelection) {
        this.startAuthorisationWithAuthenticationMethodSelection = startAuthorisationWithAuthenticationMethodSelection;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="startAuthorisationWithAuthenticationMethodSelection")
    public HrefType getStartAuthorisationWithAuthenticationMethodSelection() {
        return this.startAuthorisationWithAuthenticationMethodSelection;
    }

    public void setStartAuthorisationWithAuthenticationMethodSelection(HrefType startAuthorisationWithAuthenticationMethodSelection) {
        this.startAuthorisationWithAuthenticationMethodSelection = startAuthorisationWithAuthenticationMethodSelection;
    }

    public LinksConsents startAuthorisationWithTransactionAuthorisation(HrefType startAuthorisationWithTransactionAuthorisation) {
        this.startAuthorisationWithTransactionAuthorisation = startAuthorisationWithTransactionAuthorisation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="startAuthorisationWithTransactionAuthorisation")
    public HrefType getStartAuthorisationWithTransactionAuthorisation() {
        return this.startAuthorisationWithTransactionAuthorisation;
    }

    public void setStartAuthorisationWithTransactionAuthorisation(HrefType startAuthorisationWithTransactionAuthorisation) {
        this.startAuthorisationWithTransactionAuthorisation = startAuthorisationWithTransactionAuthorisation;
    }

    public LinksConsents self(HrefType self) {
        this.self = self;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="self")
    public HrefType getSelf() {
        return this.self;
    }

    public void setSelf(HrefType self) {
        this.self = self;
    }

    public LinksConsents status(HrefType status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="status")
    public HrefType getStatus() {
        return this.status;
    }

    public void setStatus(HrefType status) {
        this.status = status;
    }

    public LinksConsents scaStatus(HrefType scaStatus) {
        this.scaStatus = scaStatus;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scaStatus")
    public HrefType getScaStatus() {
        return this.scaStatus;
    }

    public void setScaStatus(HrefType scaStatus) {
        this.scaStatus = scaStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinksConsents _linksConsents = (LinksConsents)o;
        return Objects.equals(this.scaRedirect, _linksConsents.scaRedirect) && Objects.equals(this.scaOAuth, _linksConsents.scaOAuth) && Objects.equals(this.confirmation, _linksConsents.confirmation) && Objects.equals(this.startAuthorisation, _linksConsents.startAuthorisation) && Objects.equals(this.startAuthorisationWithPsuIdentification, _linksConsents.startAuthorisationWithPsuIdentification) && Objects.equals(this.startAuthorisationWithPsuAuthentication, _linksConsents.startAuthorisationWithPsuAuthentication) && Objects.equals(this.startAuthorisationWithEncryptedPsuAuthentication, _linksConsents.startAuthorisationWithEncryptedPsuAuthentication) && Objects.equals(this.startAuthorisationWithAuthenticationMethodSelection, _linksConsents.startAuthorisationWithAuthenticationMethodSelection) && Objects.equals(this.startAuthorisationWithTransactionAuthorisation, _linksConsents.startAuthorisationWithTransactionAuthorisation) && Objects.equals(this.self, _linksConsents.self) && Objects.equals(this.status, _linksConsents.status) && Objects.equals(this.scaStatus, _linksConsents.scaStatus) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.scaRedirect, this.scaOAuth, this.confirmation, this.startAuthorisation, this.startAuthorisationWithPsuIdentification, this.startAuthorisationWithPsuAuthentication, this.startAuthorisationWithEncryptedPsuAuthentication, this.startAuthorisationWithAuthenticationMethodSelection, this.startAuthorisationWithTransactionAuthorisation, this.self, this.status, this.scaStatus, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinksConsents {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    scaRedirect: ").append(this.toIndentedString(this.scaRedirect)).append("\n");
        sb.append("    scaOAuth: ").append(this.toIndentedString(this.scaOAuth)).append("\n");
        sb.append("    confirmation: ").append(this.toIndentedString(this.confirmation)).append("\n");
        sb.append("    startAuthorisation: ").append(this.toIndentedString(this.startAuthorisation)).append("\n");
        sb.append("    startAuthorisationWithPsuIdentification: ").append(this.toIndentedString(this.startAuthorisationWithPsuIdentification)).append("\n");
        sb.append("    startAuthorisationWithPsuAuthentication: ").append(this.toIndentedString(this.startAuthorisationWithPsuAuthentication)).append("\n");
        sb.append("    startAuthorisationWithEncryptedPsuAuthentication: ").append(this.toIndentedString(this.startAuthorisationWithEncryptedPsuAuthentication)).append("\n");
        sb.append("    startAuthorisationWithAuthenticationMethodSelection: ").append(this.toIndentedString(this.startAuthorisationWithAuthenticationMethodSelection)).append("\n");
        sb.append("    startAuthorisationWithTransactionAuthorisation: ").append(this.toIndentedString(this.startAuthorisationWithTransactionAuthorisation)).append("\n");
        sb.append("    self: ").append(this.toIndentedString(this.self)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    scaStatus: ").append(this.toIndentedString(this.scaStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

