/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.api.v2;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.ConsentConfirmationOfFundsContentResponse;
import de.adorsys.psd2.model.ConsentConfirmationOfFundsStatusResponse;
import de.adorsys.psd2.model.ConsentsConfirmationOfFunds;
import de.adorsys.psd2.model.Error400NGAIS;
import de.adorsys.psd2.model.Error401NGAIS;
import de.adorsys.psd2.model.Error403NGAIS;
import de.adorsys.psd2.model.Error404NGAIS;
import de.adorsys.psd2.model.Error405NGAIS;
import de.adorsys.psd2.model.Error406NGAIS;
import de.adorsys.psd2.model.Error409NGAIS;
import de.adorsys.psd2.model.Error429NGAIS;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="ConfirmationOfFunds", description="the ConfirmationOfFunds API")
public interface ConfirmationOfFundsApi {
    public static final Logger log = LoggerFactory.getLogger(ConfirmationOfFundsApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Create consent", nickname="createConsentConfirmationOfFunds", notes="This method creates a confirmation of funds consent resource at the ASPSP regarding confirmation of funds access  to an account specified in this request.  **Side Effects** In difference to the Establish Account Information Consent as defined in [XS2A-IG], there is no side effect by the  Establish Confirmation of Funds Consent Request ", response=Object.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=Object.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGAIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGAIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGAIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGAIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGAIS.class), @ApiResponse(code=406, message="Not Acceptable", response=Error406NGAIS.class), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGAIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests", response=Error429NGAIS.class), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v2/consents/confirmation-of-funds"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<Object> _createConsentConfirmationOfFunds(@ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Requestbody for a consent confirmation of funds request. ") @Valid @RequestBody(required=false) ConsentsConfirmationOfFunds body, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface. Might be mandated in the ASPSP's documentation. Is not contained if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ", allowableValues="true, false") @RequestHeader(value="TPP-Redirect-Preferred", required=false) String tpPRedirectPreferred, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="If it equals \"true\", the TPP prefers to start the authorisation process separately,  e.g. because of the usage of a signing basket.  This preference might be ignored by the ASPSP, if a signing basket is not supported as functionality.  If it equals \"false\" or if the parameter is not used, there is no preference of the TPP.  This especially indicates that the TPP assumes a direct authorisation of the transaction in the next step,  without using a signing basket. ", allowableValues="true, false") @RequestHeader(value="TPP-Explicit-Authorisation-Preferred", required=false) String tpPExplicitAuthorisationPreferred, @ApiParam(value="The forwarded IP Address header field consists of the corresponding HTTP request  IP Address field between PSU and TPP.  It shall be contained if and only if this request was actively initiated by the PSU. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.createConsentConfirmationOfFunds(xRequestID, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, tpPRedirectPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPExplicitAuthorisationPreferred, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Object> createConsentConfirmationOfFunds(UUID xRequestID, ConsentsConfirmationOfFunds body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPExplicitAuthorisationPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Delete Consent Content", nickname="deleteConsentConfirmationOfFunds", notes="Deletes a given consent. ", authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=204, message="Deletes a given consent."), @ApiResponse(code=400, message="Bad Request", response=Error400NGAIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGAIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGAIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGAIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGAIS.class), @ApiResponse(code=406, message="Not Acceptable", response=Error406NGAIS.class), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGAIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests", response=Error429NGAIS.class), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v2/consents/confirmation-of-funds/{consentId}"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Void> _deleteConsentConfirmationOfFunds(@ApiParam(value="ID of the corresponding consent object as returned by an Account Information Consent Request. ", required=true) @PathVariable(value="consentId") String consentId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding HTTP request  IP Address field between PSU and TPP.  It shall be contained if and only if this request was actively initiated by the PSU. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.deleteConsentConfirmationOfFunds(consentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Void> deleteConsentConfirmationOfFunds(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Get Consent Content", nickname="getConsentConfirmationOfFunds", notes="Returns the content of an account information consent object.  This is returning the data for the TPP especially in cases, where the consent was directly managed between  ASPSP and PSU e.g. in a re-direct SCA Approach. ", response=ConsentConfirmationOfFundsContentResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Get consent status", response=ConsentConfirmationOfFundsContentResponse.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGAIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGAIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGAIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGAIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGAIS.class), @ApiResponse(code=406, message="Not Acceptable", response=Error406NGAIS.class), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGAIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests", response=Error429NGAIS.class), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v2/consents/confirmation-of-funds/{consentId}"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<ConsentConfirmationOfFundsContentResponse> _getConsentConfirmationOfFunds(@ApiParam(value="ID of the corresponding consent object as returned by an Account Information Consent Request. ", required=true) @PathVariable(value="consentId") String consentId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding HTTP request  IP Address field between PSU and TPP.  It shall be contained if and only if this request was actively initiated by the PSU. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getConsentConfirmationOfFunds(consentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<ConsentConfirmationOfFundsContentResponse> getConsentConfirmationOfFunds(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Get Consent Status", nickname="getConsentConfirmationOfFundsStatus", notes="Can check the status of an account information consent resource. ", response=ConsentConfirmationOfFundsStatusResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="Get consent status", response=ConsentConfirmationOfFundsStatusResponse.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGAIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGAIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGAIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGAIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGAIS.class), @ApiResponse(code=406, message="Not Acceptable", response=Error406NGAIS.class), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGAIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests", response=Error429NGAIS.class), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v2/consents/confirmation-of-funds/{consentId}/status"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<ConsentConfirmationOfFundsStatusResponse> _getConsentConfirmationOfFundsStatus(@ApiParam(value="ID of the corresponding consent object as returned by an Account Information Consent Request. ", required=true) @PathVariable(value="consentId") String consentId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding HTTP request  IP Address field between PSU and TPP.  It shall be contained if and only if this request was actively initiated by the PSU. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getConsentConfirmationOfFundsStatus(consentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<ConsentConfirmationOfFundsStatusResponse> getConsentConfirmationOfFundsStatus(String consentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default ConfirmationOfFundsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

