/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Address;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Requested trusted beneficiaries services for a consent. ")
@Validated
public class TrustedBeneficiaries {
    @JsonProperty(value="trustedBeneficiaryId")
    private String trustedBeneficiaryId = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="creditorAgent")
    private String creditorAgent = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAlias")
    private String creditorAlias = null;
    @JsonProperty(value="creditorId")
    private String creditorId = null;
    @JsonProperty(value="creditorAddress")
    private Address creditorAddress = null;

    public TrustedBeneficiaries trustedBeneficiaryId(String trustedBeneficiaryId) {
        this.trustedBeneficiaryId = trustedBeneficiaryId;
        return this;
    }

    @ApiModelProperty(required=true, value="Resource identification of the list entry.")
    @NotNull
    @JsonProperty(value="trustedBeneficiaryId")
    public String getTrustedBeneficiaryId() {
        return this.trustedBeneficiaryId;
    }

    public void setTrustedBeneficiaryId(String trustedBeneficiaryId) {
        this.trustedBeneficiaryId = trustedBeneficiaryId;
    }

    public TrustedBeneficiaries debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="debtorAccount")
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public TrustedBeneficiaries creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="creditorAccount")
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public TrustedBeneficiaries creditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="It is mandated where the information is mandated for related credit transfers.")
    @JsonProperty(value="creditorAgent")
    public String getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public TrustedBeneficiaries creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the creditor as provided by the PSU.")
    @NotNull
    @Size(max=70)
    @JsonProperty(value="creditorName")
    public @NotNull @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public TrustedBeneficiaries creditorAlias(String creditorAlias) {
        this.creditorAlias = creditorAlias;
        return this;
    }

    @ApiModelProperty(value="An alias for the creditor as defined by the PSU as an alias when displaying the list of trusted beneficiaries in online channels of the ASPSP.")
    @Size(max=70)
    @JsonProperty(value="creditorAlias")
    public @Size(max=70) String getCreditorAlias() {
        return this.creditorAlias;
    }

    public void setCreditorAlias(String creditorAlias) {
        this.creditorAlias = creditorAlias;
    }

    public TrustedBeneficiaries creditorId(String creditorId) {
        this.creditorId = creditorId;
        return this;
    }

    @ApiModelProperty(value="Identification of Creditors.")
    @Size(max=35)
    @JsonProperty(value="creditorId")
    public @Size(max=35) String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public TrustedBeneficiaries creditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="creditorAddress")
    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustedBeneficiaries trustedBeneficiaries = (TrustedBeneficiaries)o;
        return Objects.equals(this.trustedBeneficiaryId, trustedBeneficiaries.trustedBeneficiaryId) && Objects.equals(this.debtorAccount, trustedBeneficiaries.debtorAccount) && Objects.equals(this.creditorAccount, trustedBeneficiaries.creditorAccount) && Objects.equals(this.creditorAgent, trustedBeneficiaries.creditorAgent) && Objects.equals(this.creditorName, trustedBeneficiaries.creditorName) && Objects.equals(this.creditorAlias, trustedBeneficiaries.creditorAlias) && Objects.equals(this.creditorId, trustedBeneficiaries.creditorId) && Objects.equals(this.creditorAddress, trustedBeneficiaries.creditorAddress);
    }

    public int hashCode() {
        return Objects.hash(this.trustedBeneficiaryId, this.debtorAccount, this.creditorAccount, this.creditorAgent, this.creditorName, this.creditorAlias, this.creditorId, this.creditorAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustedBeneficiaries {\n");
        sb.append("    trustedBeneficiaryId: ").append(this.toIndentedString(this.trustedBeneficiaryId)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAlias: ").append(this.toIndentedString(this.creditorAlias)).append("\n");
        sb.append("    creditorId: ").append(this.toIndentedString(this.creditorId)).append("\n");
        sb.append("    creditorAddress: ").append(this.toIndentedString(this.creditorAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

