/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.PurposeCode;
import de.adorsys.psd2.model.RemittanceInformationStructured;
import de.adorsys.psd2.model.TransactionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Generic JSON response body consistion of the corresponding periodic payment initation JSON body together with an optional transaction status field. ")
@Validated
public class PeriodicPaymentInitiationWithStatusResponse {
    @JsonProperty(value="endToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="instructionIdentification")
    private String instructionIdentification = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="ultimateDebtor")
    private String ultimateDebtor = null;
    @JsonProperty(value="instructedAmount")
    private Amount instructedAmount = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="creditorAgent")
    private String creditorAgent = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAddress")
    private Address creditorAddress = null;
    @JsonProperty(value="ultimateCreditor")
    private String ultimateCreditor = null;
    @JsonProperty(value="purposeCode")
    private PurposeCode purposeCode = null;
    @JsonProperty(value="remittanceInformationUnstructured")
    private String remittanceInformationUnstructured = null;
    @JsonProperty(value="remittanceInformationStructured")
    private RemittanceInformationStructured remittanceInformationStructured = null;
    @JsonProperty(value="startDate")
    private LocalDate startDate = null;
    @JsonProperty(value="endDate")
    private LocalDate endDate = null;
    @JsonProperty(value="executionRule")
    private ExecutionRule executionRule = null;
    @JsonProperty(value="frequency")
    private FrequencyCode frequency = null;
    @JsonProperty(value="dayOfExecution")
    private DayOfExecution dayOfExecution = null;
    @JsonProperty(value="transactionStatus")
    private TransactionStatus transactionStatus = null;

    public PeriodicPaymentInitiationWithStatusResponse endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="endToEndIdentification")
    public @Size(max=35) String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public PeriodicPaymentInitiationWithStatusResponse instructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="instructionIdentification")
    public @Size(max=35) String getInstructionIdentification() {
        return this.instructionIdentification;
    }

    public void setInstructionIdentification(String instructionIdentification) {
        this.instructionIdentification = instructionIdentification;
    }

    public PeriodicPaymentInitiationWithStatusResponse debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="debtorAccount")
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public PeriodicPaymentInitiationWithStatusResponse ultimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="ultimateDebtor")
    public @Size(max=70) String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public PeriodicPaymentInitiationWithStatusResponse instructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="instructedAmount")
    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public PeriodicPaymentInitiationWithStatusResponse creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="creditorAccount")
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public PeriodicPaymentInitiationWithStatusResponse creditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    @JsonProperty(value="creditorAgent")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public PeriodicPaymentInitiationWithStatusResponse creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Size(max=70)
    @JsonProperty(value="creditorName")
    public @NotNull @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public PeriodicPaymentInitiationWithStatusResponse creditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="creditorAddress")
    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public PeriodicPaymentInitiationWithStatusResponse ultimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="ultimateCreditor")
    public @Size(max=70) String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public PeriodicPaymentInitiationWithStatusResponse purposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="purposeCode")
    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public PeriodicPaymentInitiationWithStatusResponse remittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    @JsonProperty(value="remittanceInformationUnstructured")
    public @Size(max=140) String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public PeriodicPaymentInitiationWithStatusResponse remittanceInformationStructured(RemittanceInformationStructured remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="remittanceInformationStructured")
    public RemittanceInformationStructured getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public void setRemittanceInformationStructured(RemittanceInformationStructured remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public PeriodicPaymentInitiationWithStatusResponse startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="startDate")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public PeriodicPaymentInitiationWithStatusResponse endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="endDate")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public PeriodicPaymentInitiationWithStatusResponse executionRule(ExecutionRule executionRule) {
        this.executionRule = executionRule;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="executionRule")
    public ExecutionRule getExecutionRule() {
        return this.executionRule;
    }

    public void setExecutionRule(ExecutionRule executionRule) {
        this.executionRule = executionRule;
    }

    public PeriodicPaymentInitiationWithStatusResponse frequency(FrequencyCode frequency) {
        this.frequency = frequency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="frequency")
    public FrequencyCode getFrequency() {
        return this.frequency;
    }

    public void setFrequency(FrequencyCode frequency) {
        this.frequency = frequency;
    }

    public PeriodicPaymentInitiationWithStatusResponse dayOfExecution(DayOfExecution dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=2)
    @JsonProperty(value="dayOfExecution")
    public @Valid @Size(max=2) DayOfExecution getDayOfExecution() {
        return this.dayOfExecution;
    }

    public void setDayOfExecution(DayOfExecution dayOfExecution) {
        this.dayOfExecution = dayOfExecution;
    }

    public PeriodicPaymentInitiationWithStatusResponse transactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="transactionStatus")
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeriodicPaymentInitiationWithStatusResponse periodicPaymentInitiationWithStatusResponse = (PeriodicPaymentInitiationWithStatusResponse)o;
        return Objects.equals(this.endToEndIdentification, periodicPaymentInitiationWithStatusResponse.endToEndIdentification) && Objects.equals(this.instructionIdentification, periodicPaymentInitiationWithStatusResponse.instructionIdentification) && Objects.equals(this.debtorAccount, periodicPaymentInitiationWithStatusResponse.debtorAccount) && Objects.equals(this.ultimateDebtor, periodicPaymentInitiationWithStatusResponse.ultimateDebtor) && Objects.equals(this.instructedAmount, periodicPaymentInitiationWithStatusResponse.instructedAmount) && Objects.equals(this.creditorAccount, periodicPaymentInitiationWithStatusResponse.creditorAccount) && Objects.equals(this.creditorAgent, periodicPaymentInitiationWithStatusResponse.creditorAgent) && Objects.equals(this.creditorName, periodicPaymentInitiationWithStatusResponse.creditorName) && Objects.equals(this.creditorAddress, periodicPaymentInitiationWithStatusResponse.creditorAddress) && Objects.equals(this.ultimateCreditor, periodicPaymentInitiationWithStatusResponse.ultimateCreditor) && Objects.equals((Object)this.purposeCode, (Object)periodicPaymentInitiationWithStatusResponse.purposeCode) && Objects.equals(this.remittanceInformationUnstructured, periodicPaymentInitiationWithStatusResponse.remittanceInformationUnstructured) && Objects.equals(this.remittanceInformationStructured, periodicPaymentInitiationWithStatusResponse.remittanceInformationStructured) && Objects.equals(this.startDate, periodicPaymentInitiationWithStatusResponse.startDate) && Objects.equals(this.endDate, periodicPaymentInitiationWithStatusResponse.endDate) && Objects.equals((Object)this.executionRule, (Object)periodicPaymentInitiationWithStatusResponse.executionRule) && Objects.equals((Object)this.frequency, (Object)periodicPaymentInitiationWithStatusResponse.frequency) && Objects.equals((Object)this.dayOfExecution, (Object)periodicPaymentInitiationWithStatusResponse.dayOfExecution) && Objects.equals((Object)this.transactionStatus, (Object)periodicPaymentInitiationWithStatusResponse.transactionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endToEndIdentification, this.instructionIdentification, this.debtorAccount, this.ultimateDebtor, this.instructedAmount, this.creditorAccount, this.creditorAgent, this.creditorName, this.creditorAddress, this.ultimateCreditor, this.purposeCode, this.remittanceInformationUnstructured, this.remittanceInformationStructured, this.startDate, this.endDate, this.executionRule, this.frequency, this.dayOfExecution, this.transactionStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PeriodicPaymentInitiationWithStatusResponse {\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    instructionIdentification: ").append(this.toIndentedString(this.instructionIdentification)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    ultimateDebtor: ").append(this.toIndentedString(this.ultimateDebtor)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAddress: ").append(this.toIndentedString(this.creditorAddress)).append("\n");
        sb.append("    ultimateCreditor: ").append(this.toIndentedString(this.ultimateCreditor)).append("\n");
        sb.append("    purposeCode: ").append(this.toIndentedString((Object)this.purposeCode)).append("\n");
        sb.append("    remittanceInformationUnstructured: ").append(this.toIndentedString(this.remittanceInformationUnstructured)).append("\n");
        sb.append("    remittanceInformationStructured: ").append(this.toIndentedString(this.remittanceInformationStructured)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    executionRule: ").append(this.toIndentedString((Object)this.executionRule)).append("\n");
        sb.append("    frequency: ").append(this.toIndentedString((Object)this.frequency)).append("\n");
        sb.append("    dayOfExecution: ").append(this.toIndentedString((Object)this.dayOfExecution)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString((Object)this.transactionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

