/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Optional if supported by API provider.  Is asking for additional information as added within this structured object. The usage of this data element requires at least one of the entries \"accounts\",  \"transactions\" or \"balances\" also to be contained in the object.  If detailed accounts are referenced, it is required in addition that any account addressed within  the additionalInformation attribute is also addressed by at least one of the attributes \"accounts\",  \"transactions\" or \"balances\". ")
@Validated
public class AdditionalInformationAccess {
    @JsonProperty(value="ownerName")
    @Valid
    private List<AccountReference> ownerName = null;

    public AdditionalInformationAccess ownerName(List<AccountReference> ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    public AdditionalInformationAccess addOwnerNameItem(AccountReference ownerNameItem) {
        if (this.ownerName == null) {
            this.ownerName = new ArrayList<AccountReference>();
        }
        this.ownerName.add(ownerNameItem);
        return this;
    }

    @ApiModelProperty(value="Is asking for account owner name of the accounts referenced within.  If the array is empty in the request, the TPP is asking for the account  owner name of all accessible accounts.  This may be restricted in a PSU/ASPSP authorization dialogue.  If the array is empty, also the arrays for accounts, balances or transactions shall be empty, if used. The ASPSP will indicate in the consent resource after a successful authorisation,  whether the ownerName consent can be accepted by providing the accounts on which the ownerName will  be delivered. This array can be empty. ")
    @Valid
    @JsonProperty(value="ownerName")
    public List<AccountReference> getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(List<AccountReference> ownerName) {
        this.ownerName = ownerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdditionalInformationAccess additionalInformationAccess = (AdditionalInformationAccess)o;
        return Objects.equals(this.ownerName, additionalInformationAccess.ownerName);
    }

    public int hashCode() {
        return Objects.hash(this.ownerName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdditionalInformationAccess {\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

