/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.HrefType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A list of hyperlinks to be recognised by the TPP. The actual hyperlinks used in  the response depend on the dynamical decisions of the ASPSP when processing the request.  **Remark:** All links can be relative or full links, to be decided by the ASPSP.   **Remark:** This method can be applied before or after PSU identification.  This leads to many possible hyperlink responses. Type of links admitted in this response, (further links might be added for ASPSP defined  extensions):  - 'scaRedirect':    In case of an SCA Redirect Approach, the ASPSP is transmitting the link to which to    redirect the PSU browser. - 'scaOAuth':    In case of a SCA OAuth2 Approach, the ASPSP is transmitting the URI where the    configuration of the Authorisation Server can be retrieved.    The configuration follows the OAuth 2.0 Authorisation Server Metadata specification. - 'updatePsuIdentification':    The link to the authorisation or cancellation authorisation sub-resource,    where PSU identification data needs to be uploaded. - 'updatePsuAuthentication':   The link to the authorisation or cancellation authorisation sub-resource,    where PSU authentication data needs to be uploaded.   - 'updateEncryptedPsuAuthentication':   The link to the authorisation or cancellation authorisation sub-resource,    where PSU authentication encrypted data needs to be uploaded. - 'updateAdditionalPsuAuthentication':     The link to the payment initiation or account information resource,      which needs to be updated by an additional PSU password.  - 'updateAdditionalEncryptedPsuAuthentication':      The link to the payment initiation or account information resource,      which needs to be updated by an additional encrypted PSU password.  - 'authoriseTransaction':   The link to the authorisation or cancellation authorisation sub-resource,    where the authorisation data has to be uploaded, e.g. the TOP received by SMS.  - 'scaStatus':    The link to retrieve the scaStatus of the corresponding authorisation sub-resource. ")
@Validated
public class LinksSelectPsuAuthenticationMethod
extends HashMap<String, HrefType> {
    @JsonProperty(value="scaRedirect")
    private HrefType scaRedirect = null;
    @JsonProperty(value="scaOAuth")
    private HrefType scaOAuth = null;
    @JsonProperty(value="updatePsuIdentification")
    private HrefType updatePsuIdentification = null;
    @JsonProperty(value="updatePsuAuthentication")
    private HrefType updatePsuAuthentication = null;
    @JsonProperty(value="updateAdditionalPsuAuthentication")
    private HrefType updateAdditionalPsuAuthentication = null;
    @JsonProperty(value="updateAdditionalEncryptedPsuAuthentication")
    private HrefType updateAdditionalEncryptedPsuAuthentication = null;
    @JsonProperty(value="authoriseTransaction")
    private HrefType authoriseTransaction = null;
    @JsonProperty(value="scaStatus")
    private HrefType scaStatus = null;

    public LinksSelectPsuAuthenticationMethod scaRedirect(HrefType scaRedirect) {
        this.scaRedirect = scaRedirect;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scaRedirect")
    public HrefType getScaRedirect() {
        return this.scaRedirect;
    }

    public void setScaRedirect(HrefType scaRedirect) {
        this.scaRedirect = scaRedirect;
    }

    public LinksSelectPsuAuthenticationMethod scaOAuth(HrefType scaOAuth) {
        this.scaOAuth = scaOAuth;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scaOAuth")
    public HrefType getScaOAuth() {
        return this.scaOAuth;
    }

    public void setScaOAuth(HrefType scaOAuth) {
        this.scaOAuth = scaOAuth;
    }

    public LinksSelectPsuAuthenticationMethod updatePsuIdentification(HrefType updatePsuIdentification) {
        this.updatePsuIdentification = updatePsuIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="updatePsuIdentification")
    public HrefType getUpdatePsuIdentification() {
        return this.updatePsuIdentification;
    }

    public void setUpdatePsuIdentification(HrefType updatePsuIdentification) {
        this.updatePsuIdentification = updatePsuIdentification;
    }

    public LinksSelectPsuAuthenticationMethod updatePsuAuthentication(HrefType updatePsuAuthentication) {
        this.updatePsuAuthentication = updatePsuAuthentication;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="updatePsuAuthentication")
    public HrefType getUpdatePsuAuthentication() {
        return this.updatePsuAuthentication;
    }

    public void setUpdatePsuAuthentication(HrefType updatePsuAuthentication) {
        this.updatePsuAuthentication = updatePsuAuthentication;
    }

    public LinksSelectPsuAuthenticationMethod updateAdditionalPsuAuthentication(HrefType updateAdditionalPsuAuthentication) {
        this.updateAdditionalPsuAuthentication = updateAdditionalPsuAuthentication;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="updateAdditionalPsuAuthentication")
    public HrefType getUpdateAdditionalPsuAuthentication() {
        return this.updateAdditionalPsuAuthentication;
    }

    public void setUpdateAdditionalPsuAuthentication(HrefType updateAdditionalPsuAuthentication) {
        this.updateAdditionalPsuAuthentication = updateAdditionalPsuAuthentication;
    }

    public LinksSelectPsuAuthenticationMethod updateAdditionalEncryptedPsuAuthentication(HrefType updateAdditionalEncryptedPsuAuthentication) {
        this.updateAdditionalEncryptedPsuAuthentication = updateAdditionalEncryptedPsuAuthentication;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="updateAdditionalEncryptedPsuAuthentication")
    public HrefType getUpdateAdditionalEncryptedPsuAuthentication() {
        return this.updateAdditionalEncryptedPsuAuthentication;
    }

    public void setUpdateAdditionalEncryptedPsuAuthentication(HrefType updateAdditionalEncryptedPsuAuthentication) {
        this.updateAdditionalEncryptedPsuAuthentication = updateAdditionalEncryptedPsuAuthentication;
    }

    public LinksSelectPsuAuthenticationMethod authoriseTransaction(HrefType authoriseTransaction) {
        this.authoriseTransaction = authoriseTransaction;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="authoriseTransaction")
    public HrefType getAuthoriseTransaction() {
        return this.authoriseTransaction;
    }

    public void setAuthoriseTransaction(HrefType authoriseTransaction) {
        this.authoriseTransaction = authoriseTransaction;
    }

    public LinksSelectPsuAuthenticationMethod scaStatus(HrefType scaStatus) {
        this.scaStatus = scaStatus;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scaStatus")
    public HrefType getScaStatus() {
        return this.scaStatus;
    }

    public void setScaStatus(HrefType scaStatus) {
        this.scaStatus = scaStatus;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinksSelectPsuAuthenticationMethod _linksSelectPsuAuthenticationMethod = (LinksSelectPsuAuthenticationMethod)o;
        return Objects.equals(this.scaRedirect, _linksSelectPsuAuthenticationMethod.scaRedirect) && Objects.equals(this.scaOAuth, _linksSelectPsuAuthenticationMethod.scaOAuth) && Objects.equals(this.updatePsuIdentification, _linksSelectPsuAuthenticationMethod.updatePsuIdentification) && Objects.equals(this.updatePsuAuthentication, _linksSelectPsuAuthenticationMethod.updatePsuAuthentication) && Objects.equals(this.updateAdditionalPsuAuthentication, _linksSelectPsuAuthenticationMethod.updateAdditionalPsuAuthentication) && Objects.equals(this.updateAdditionalEncryptedPsuAuthentication, _linksSelectPsuAuthenticationMethod.updateAdditionalEncryptedPsuAuthentication) && Objects.equals(this.authoriseTransaction, _linksSelectPsuAuthenticationMethod.authoriseTransaction) && Objects.equals(this.scaStatus, _linksSelectPsuAuthenticationMethod.scaStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.scaRedirect, this.scaOAuth, this.updatePsuIdentification, this.updatePsuAuthentication, this.updateAdditionalPsuAuthentication, this.updateAdditionalEncryptedPsuAuthentication, this.authoriseTransaction, this.scaStatus, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinksSelectPsuAuthenticationMethod {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    scaRedirect: ").append(this.toIndentedString(this.scaRedirect)).append("\n");
        sb.append("    scaOAuth: ").append(this.toIndentedString(this.scaOAuth)).append("\n");
        sb.append("    updatePsuIdentification: ").append(this.toIndentedString(this.updatePsuIdentification)).append("\n");
        sb.append("    updatePsuAuthentication: ").append(this.toIndentedString(this.updatePsuAuthentication)).append("\n");
        sb.append("    updateAdditionalPsuAuthentication: ").append(this.toIndentedString(this.updateAdditionalPsuAuthentication)).append("\n");
        sb.append("    updateAdditionalEncryptedPsuAuthentication: ").append(this.toIndentedString(this.updateAdditionalEncryptedPsuAuthentication)).append("\n");
        sb.append("    authoriseTransaction: ").append(this.toIndentedString(this.authoriseTransaction)).append("\n");
        sb.append("    scaStatus: ").append(this.toIndentedString(this.scaStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

