/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.ReportExchangeRateList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Card transaction information.")
@Validated
public class CardTransaction {
    @JsonProperty(value="cardTransactionId")
    private String cardTransactionId = null;
    @JsonProperty(value="terminalId")
    private String terminalId = null;
    @JsonProperty(value="transactionDate")
    private LocalDate transactionDate = null;
    @JsonProperty(value="acceptorTransactionDateTime")
    private OffsetDateTime acceptorTransactionDateTime = null;
    @JsonProperty(value="bookingDate")
    private LocalDate bookingDate = null;
    @JsonProperty(value="transactionAmount")
    private Amount transactionAmount = null;
    @JsonProperty(value="currencyExchange")
    private ReportExchangeRateList currencyExchange = null;
    @JsonProperty(value="originalAmount")
    private Amount originalAmount = null;
    @JsonProperty(value="markupFee")
    private Amount markupFee = null;
    @JsonProperty(value="markupFeePercentage")
    private String markupFeePercentage = null;
    @JsonProperty(value="cardAcceptorId")
    private String cardAcceptorId = null;
    @JsonProperty(value="cardAcceptorAddress")
    private Address cardAcceptorAddress = null;
    @JsonProperty(value="cardAcceptorPhone")
    private String cardAcceptorPhone = null;
    @JsonProperty(value="merchantCategoryCode")
    private String merchantCategoryCode = null;
    @JsonProperty(value="maskedPAN")
    private String maskedPAN = null;
    @JsonProperty(value="transactionDetails")
    private String transactionDetails = null;
    @JsonProperty(value="invoiced")
    private Boolean invoiced = null;
    @JsonProperty(value="proprietaryBankTransactionCode")
    private String proprietaryBankTransactionCode = null;

    public CardTransaction cardTransactionId(String cardTransactionId) {
        this.cardTransactionId = cardTransactionId;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="cardTransactionId")
    public @Size(max=35) String getCardTransactionId() {
        return this.cardTransactionId;
    }

    public void setCardTransactionId(String cardTransactionId) {
        this.cardTransactionId = cardTransactionId;
    }

    public CardTransaction terminalId(String terminalId) {
        this.terminalId = terminalId;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="terminalId")
    public @Size(max=35) String getTerminalId() {
        return this.terminalId;
    }

    public void setTerminalId(String terminalId) {
        this.terminalId = terminalId;
    }

    public CardTransaction transactionDate(LocalDate transactionDate) {
        this.transactionDate = transactionDate;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="transactionDate")
    public LocalDate getTransactionDate() {
        return this.transactionDate;
    }

    public void setTransactionDate(LocalDate transactionDate) {
        this.transactionDate = transactionDate;
    }

    public CardTransaction acceptorTransactionDateTime(OffsetDateTime acceptorTransactionDateTime) {
        this.acceptorTransactionDateTime = acceptorTransactionDateTime;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="acceptorTransactionDateTime")
    public OffsetDateTime getAcceptorTransactionDateTime() {
        return this.acceptorTransactionDateTime;
    }

    public void setAcceptorTransactionDateTime(OffsetDateTime acceptorTransactionDateTime) {
        this.acceptorTransactionDateTime = acceptorTransactionDateTime;
    }

    public CardTransaction bookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="bookingDate")
    public LocalDate getBookingDate() {
        return this.bookingDate;
    }

    public void setBookingDate(LocalDate bookingDate) {
        this.bookingDate = bookingDate;
    }

    public CardTransaction transactionAmount(Amount transactionAmount) {
        this.transactionAmount = transactionAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="transactionAmount")
    public Amount getTransactionAmount() {
        return this.transactionAmount;
    }

    public void setTransactionAmount(Amount transactionAmount) {
        this.transactionAmount = transactionAmount;
    }

    public CardTransaction currencyExchange(ReportExchangeRateList currencyExchange) {
        this.currencyExchange = currencyExchange;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="currencyExchange")
    public ReportExchangeRateList getCurrencyExchange() {
        return this.currencyExchange;
    }

    public void setCurrencyExchange(ReportExchangeRateList currencyExchange) {
        this.currencyExchange = currencyExchange;
    }

    public CardTransaction originalAmount(Amount originalAmount) {
        this.originalAmount = originalAmount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="originalAmount")
    public Amount getOriginalAmount() {
        return this.originalAmount;
    }

    public void setOriginalAmount(Amount originalAmount) {
        this.originalAmount = originalAmount;
    }

    public CardTransaction markupFee(Amount markupFee) {
        this.markupFee = markupFee;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="markupFee")
    public Amount getMarkupFee() {
        return this.markupFee;
    }

    public void setMarkupFee(Amount markupFee) {
        this.markupFee = markupFee;
    }

    public CardTransaction markupFeePercentage(String markupFeePercentage) {
        this.markupFeePercentage = markupFeePercentage;
        return this;
    }

    @ApiModelProperty(example="0.3", value="")
    @JsonProperty(value="markupFeePercentage")
    public String getMarkupFeePercentage() {
        return this.markupFeePercentage;
    }

    public void setMarkupFeePercentage(String markupFeePercentage) {
        this.markupFeePercentage = markupFeePercentage;
    }

    public CardTransaction cardAcceptorId(String cardAcceptorId) {
        this.cardAcceptorId = cardAcceptorId;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="cardAcceptorId")
    public @Size(max=35) String getCardAcceptorId() {
        return this.cardAcceptorId;
    }

    public void setCardAcceptorId(String cardAcceptorId) {
        this.cardAcceptorId = cardAcceptorId;
    }

    public CardTransaction cardAcceptorAddress(Address cardAcceptorAddress) {
        this.cardAcceptorAddress = cardAcceptorAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="cardAcceptorAddress")
    public Address getCardAcceptorAddress() {
        return this.cardAcceptorAddress;
    }

    public void setCardAcceptorAddress(Address cardAcceptorAddress) {
        this.cardAcceptorAddress = cardAcceptorAddress;
    }

    public CardTransaction cardAcceptorPhone(String cardAcceptorPhone) {
        this.cardAcceptorPhone = cardAcceptorPhone;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="\\+[0-9]{1,3}-[0-9()\\+\\-]{1,30}")
    @JsonProperty(value="cardAcceptorPhone")
    public @Pattern(regexp="\\+[0-9]{1,3}-[0-9()\\+\\-]{1,30}") String getCardAcceptorPhone() {
        return this.cardAcceptorPhone;
    }

    public void setCardAcceptorPhone(String cardAcceptorPhone) {
        this.cardAcceptorPhone = cardAcceptorPhone;
    }

    public CardTransaction merchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(min=4, max=4)
    @JsonProperty(value="merchantCategoryCode")
    public @Size(min=4, max=4) String getMerchantCategoryCode() {
        return this.merchantCategoryCode;
    }

    public void setMerchantCategoryCode(String merchantCategoryCode) {
        this.merchantCategoryCode = merchantCategoryCode;
    }

    public CardTransaction maskedPAN(String maskedPAN) {
        this.maskedPAN = maskedPAN;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="maskedPAN")
    public @Size(max=35) String getMaskedPAN() {
        return this.maskedPAN;
    }

    public void setMaskedPAN(String maskedPAN) {
        this.maskedPAN = maskedPAN;
    }

    public CardTransaction transactionDetails(String transactionDetails) {
        this.transactionDetails = transactionDetails;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    @JsonProperty(value="transactionDetails")
    public @Size(max=140) String getTransactionDetails() {
        return this.transactionDetails;
    }

    public void setTransactionDetails(String transactionDetails) {
        this.transactionDetails = transactionDetails;
    }

    public CardTransaction invoiced(Boolean invoiced) {
        this.invoiced = invoiced;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="invoiced")
    public Boolean isInvoiced() {
        return this.invoiced;
    }

    public void setInvoiced(Boolean invoiced) {
        this.invoiced = invoiced;
    }

    public CardTransaction proprietaryBankTransactionCode(String proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="proprietaryBankTransactionCode")
    public @Size(max=35) String getProprietaryBankTransactionCode() {
        return this.proprietaryBankTransactionCode;
    }

    public void setProprietaryBankTransactionCode(String proprietaryBankTransactionCode) {
        this.proprietaryBankTransactionCode = proprietaryBankTransactionCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardTransaction cardTransaction = (CardTransaction)o;
        return Objects.equals(this.cardTransactionId, cardTransaction.cardTransactionId) && Objects.equals(this.terminalId, cardTransaction.terminalId) && Objects.equals(this.transactionDate, cardTransaction.transactionDate) && Objects.equals(this.acceptorTransactionDateTime, cardTransaction.acceptorTransactionDateTime) && Objects.equals(this.bookingDate, cardTransaction.bookingDate) && Objects.equals(this.transactionAmount, cardTransaction.transactionAmount) && Objects.equals(this.currencyExchange, cardTransaction.currencyExchange) && Objects.equals(this.originalAmount, cardTransaction.originalAmount) && Objects.equals(this.markupFee, cardTransaction.markupFee) && Objects.equals(this.markupFeePercentage, cardTransaction.markupFeePercentage) && Objects.equals(this.cardAcceptorId, cardTransaction.cardAcceptorId) && Objects.equals(this.cardAcceptorAddress, cardTransaction.cardAcceptorAddress) && Objects.equals(this.cardAcceptorPhone, cardTransaction.cardAcceptorPhone) && Objects.equals(this.merchantCategoryCode, cardTransaction.merchantCategoryCode) && Objects.equals(this.maskedPAN, cardTransaction.maskedPAN) && Objects.equals(this.transactionDetails, cardTransaction.transactionDetails) && Objects.equals(this.invoiced, cardTransaction.invoiced) && Objects.equals(this.proprietaryBankTransactionCode, cardTransaction.proprietaryBankTransactionCode);
    }

    public int hashCode() {
        return Objects.hash(this.cardTransactionId, this.terminalId, this.transactionDate, this.acceptorTransactionDateTime, this.bookingDate, this.transactionAmount, this.currencyExchange, this.originalAmount, this.markupFee, this.markupFeePercentage, this.cardAcceptorId, this.cardAcceptorAddress, this.cardAcceptorPhone, this.merchantCategoryCode, this.maskedPAN, this.transactionDetails, this.invoiced, this.proprietaryBankTransactionCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardTransaction {\n");
        sb.append("    cardTransactionId: ").append(this.toIndentedString(this.cardTransactionId)).append("\n");
        sb.append("    terminalId: ").append(this.toIndentedString(this.terminalId)).append("\n");
        sb.append("    transactionDate: ").append(this.toIndentedString(this.transactionDate)).append("\n");
        sb.append("    acceptorTransactionDateTime: ").append(this.toIndentedString(this.acceptorTransactionDateTime)).append("\n");
        sb.append("    bookingDate: ").append(this.toIndentedString(this.bookingDate)).append("\n");
        sb.append("    transactionAmount: ").append(this.toIndentedString(this.transactionAmount)).append("\n");
        sb.append("    currencyExchange: ").append(this.toIndentedString(this.currencyExchange)).append("\n");
        sb.append("    originalAmount: ").append(this.toIndentedString(this.originalAmount)).append("\n");
        sb.append("    markupFee: ").append(this.toIndentedString(this.markupFee)).append("\n");
        sb.append("    markupFeePercentage: ").append(this.toIndentedString(this.markupFeePercentage)).append("\n");
        sb.append("    cardAcceptorId: ").append(this.toIndentedString(this.cardAcceptorId)).append("\n");
        sb.append("    cardAcceptorAddress: ").append(this.toIndentedString(this.cardAcceptorAddress)).append("\n");
        sb.append("    cardAcceptorPhone: ").append(this.toIndentedString(this.cardAcceptorPhone)).append("\n");
        sb.append("    merchantCategoryCode: ").append(this.toIndentedString(this.merchantCategoryCode)).append("\n");
        sb.append("    maskedPAN: ").append(this.toIndentedString(this.maskedPAN)).append("\n");
        sb.append("    transactionDetails: ").append(this.toIndentedString(this.transactionDetails)).append("\n");
        sb.append("    invoiced: ").append(this.toIndentedString(this.invoiced)).append("\n");
        sb.append("    proprietaryBankTransactionCode: ").append(this.toIndentedString(this.proprietaryBankTransactionCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

