/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.BalanceType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A single balance element. ")
@Validated
public class Balance {
    @JsonProperty(value="balanceAmount")
    private Amount balanceAmount = null;
    @JsonProperty(value="balanceType")
    private BalanceType balanceType = null;
    @JsonProperty(value="creditLimitIncluded")
    private Boolean creditLimitIncluded = null;
    @JsonProperty(value="lastChangeDateTime")
    private OffsetDateTime lastChangeDateTime = null;
    @JsonProperty(value="referenceDate")
    private LocalDate referenceDate = null;
    @JsonProperty(value="lastCommittedTransaction")
    private String lastCommittedTransaction = null;

    public Balance balanceAmount(Amount balanceAmount) {
        this.balanceAmount = balanceAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="balanceAmount")
    public Amount getBalanceAmount() {
        return this.balanceAmount;
    }

    public void setBalanceAmount(Amount balanceAmount) {
        this.balanceAmount = balanceAmount;
    }

    public Balance balanceType(BalanceType balanceType) {
        this.balanceType = balanceType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="balanceType")
    public BalanceType getBalanceType() {
        return this.balanceType;
    }

    public void setBalanceType(BalanceType balanceType) {
        this.balanceType = balanceType;
    }

    public Balance creditLimitIncluded(Boolean creditLimitIncluded) {
        this.creditLimitIncluded = creditLimitIncluded;
        return this;
    }

    @ApiModelProperty(value="A flag indicating if the credit limit of the corresponding account is included in the calculation of the balance, where applicable. ")
    @JsonProperty(value="creditLimitIncluded")
    public Boolean isCreditLimitIncluded() {
        return this.creditLimitIncluded;
    }

    public void setCreditLimitIncluded(Boolean creditLimitIncluded) {
        this.creditLimitIncluded = creditLimitIncluded;
    }

    public Balance lastChangeDateTime(OffsetDateTime lastChangeDateTime) {
        this.lastChangeDateTime = lastChangeDateTime;
        return this;
    }

    @ApiModelProperty(value="This data element might be used to indicate e.g. with the expected or booked balance that no action is known on the account, which is not yet booked. ")
    @Valid
    @JsonProperty(value="lastChangeDateTime")
    public OffsetDateTime getLastChangeDateTime() {
        return this.lastChangeDateTime;
    }

    public void setLastChangeDateTime(OffsetDateTime lastChangeDateTime) {
        this.lastChangeDateTime = lastChangeDateTime;
    }

    public Balance referenceDate(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
        return this;
    }

    @ApiModelProperty(value="Reference date of the balance.")
    @Valid
    @JsonProperty(value="referenceDate")
    public LocalDate getReferenceDate() {
        return this.referenceDate;
    }

    public void setReferenceDate(LocalDate referenceDate) {
        this.referenceDate = referenceDate;
    }

    public Balance lastCommittedTransaction(String lastCommittedTransaction) {
        this.lastCommittedTransaction = lastCommittedTransaction;
        return this;
    }

    @ApiModelProperty(value="\"entryReference\" of the last commited transaction to support the TPP in identifying whether all PSU transactions are already known. ")
    @Size(max=35)
    @JsonProperty(value="lastCommittedTransaction")
    public @Size(max=35) String getLastCommittedTransaction() {
        return this.lastCommittedTransaction;
    }

    public void setLastCommittedTransaction(String lastCommittedTransaction) {
        this.lastCommittedTransaction = lastCommittedTransaction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Balance balance = (Balance)o;
        return Objects.equals(this.balanceAmount, balance.balanceAmount) && Objects.equals((Object)this.balanceType, (Object)balance.balanceType) && Objects.equals(this.creditLimitIncluded, balance.creditLimitIncluded) && Objects.equals(this.lastChangeDateTime, balance.lastChangeDateTime) && Objects.equals(this.referenceDate, balance.referenceDate) && Objects.equals(this.lastCommittedTransaction, balance.lastCommittedTransaction);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.balanceAmount, this.balanceType, this.creditLimitIncluded, this.lastChangeDateTime, this.referenceDate, this.lastCommittedTransaction});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Balance {\n");
        sb.append("    balanceAmount: ").append(this.toIndentedString(this.balanceAmount)).append("\n");
        sb.append("    balanceType: ").append(this.toIndentedString((Object)this.balanceType)).append("\n");
        sb.append("    creditLimitIncluded: ").append(this.toIndentedString(this.creditLimitIncluded)).append("\n");
        sb.append("    lastChangeDateTime: ").append(this.toIndentedString(this.lastChangeDateTime)).append("\n");
        sb.append("    referenceDate: ").append(this.toIndentedString(this.referenceDate)).append("\n");
        sb.append("    lastCommittedTransaction: ").append(this.toIndentedString(this.lastCommittedTransaction)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

