/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import de.adorsys.psd2.model.AccountStatus;
import de.adorsys.psd2.model.BalanceList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="The ASPSP shall give at least one of the account reference identifiers:   - iban   - bban   - pan   - maskedPan   - msisdn If the account is a multicurrency account currency code in \"currency\" is set to \"XXX\". ")
@Validated
public class AccountDetails {
    @JsonProperty(value="resourceId")
    private String resourceId = null;
    @JsonProperty(value="iban")
    private String iban = null;
    @JsonProperty(value="bban")
    private String bban = null;
    @JsonProperty(value="msisdn")
    private String msisdn = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="displayName")
    private String displayName = null;
    @JsonProperty(value="product")
    private String product = null;
    @JsonProperty(value="cashAccountType")
    private String cashAccountType = null;
    @JsonProperty(value="status")
    private AccountStatus status = null;
    @JsonProperty(value="bic")
    private String bic = null;
    @JsonProperty(value="linkedAccounts")
    private String linkedAccounts = null;
    @JsonProperty(value="usage")
    private UsageEnum usage = null;
    @JsonProperty(value="details")
    private String details = null;
    @JsonProperty(value="balances")
    private BalanceList balances = null;
    @JsonProperty(value="_links")
    private Map _links = null;
    @JsonProperty(value="ownerName")
    private String ownerName = null;

    public AccountDetails resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @ApiModelProperty(value="This shall be filled, if addressable resource are created by the ASPSP on the /accounts or /card-accounts endpoint.")
    @JsonProperty(value="resourceId")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public AccountDetails iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{2,2}[0-9]{2,2}[a-zA-Z0-9]{1,30}")
    @JsonProperty(value="iban")
    public @Pattern(regexp="[A-Z]{2,2}[0-9]{2,2}[a-zA-Z0-9]{1,30}") String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public AccountDetails bban(String bban) {
        this.bban = bban;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[a-zA-Z0-9]{1,30}")
    @JsonProperty(value="bban")
    public @Pattern(regexp="[a-zA-Z0-9]{1,30}") String getBban() {
        return this.bban;
    }

    public void setBban(String bban) {
        this.bban = bban;
    }

    public AccountDetails msisdn(String msisdn) {
        this.msisdn = msisdn;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="msisdn")
    public @Size(max=35) String getMsisdn() {
        return this.msisdn;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public AccountDetails currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Pattern(regexp="[A-Z]{3}")
    @JsonProperty(value="currency")
    public @NotNull @Pattern(regexp="[A-Z]{3}") String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public AccountDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the account given by the bank or the PSU in online-banking.")
    @Size(max=35)
    @JsonProperty(value="name")
    public @Size(max=35) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AccountDetails displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="Name of the account as defined by the PSU within online channels.")
    @Size(max=70)
    @JsonProperty(value="displayName")
    public @Size(max=70) String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public AccountDetails product(String product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(value="Product name of the bank for this account, proprietary definition.")
    @Size(max=35)
    @JsonProperty(value="product")
    public @Size(max=35) String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public AccountDetails cashAccountType(String cashAccountType) {
        this.cashAccountType = cashAccountType;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="cashAccountType")
    public String getCashAccountType() {
        return this.cashAccountType;
    }

    public void setCashAccountType(String cashAccountType) {
        this.cashAccountType = cashAccountType;
    }

    public AccountDetails status(AccountStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="status")
    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public AccountDetails bic(String bic) {
        this.bic = bic;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    @JsonProperty(value="bic")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getBic() {
        return this.bic;
    }

    public void setBic(String bic) {
        this.bic = bic;
    }

    public AccountDetails linkedAccounts(String linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
        return this;
    }

    @ApiModelProperty(value="Case of a set of pending card transactions, the APSP will provide the relevant cash account the card is set up on.")
    @Size(max=70)
    @JsonProperty(value="linkedAccounts")
    public @Size(max=70) String getLinkedAccounts() {
        return this.linkedAccounts;
    }

    public void setLinkedAccounts(String linkedAccounts) {
        this.linkedAccounts = linkedAccounts;
    }

    public AccountDetails usage(UsageEnum usage) {
        this.usage = usage;
        return this;
    }

    @ApiModelProperty(value="Specifies the usage of the account:   * PRIV: private personal account   * ORGA: professional account ")
    @Size(max=4)
    @JsonProperty(value="usage")
    public @Size(max=4) UsageEnum getUsage() {
        return this.usage;
    }

    public void setUsage(UsageEnum usage) {
        this.usage = usage;
    }

    public AccountDetails details(String details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(value="Specifications that might be provided by the ASPSP:   - characteristics of the account   - characteristics of the relevant card ")
    @Size(max=500)
    @JsonProperty(value="details")
    public @Size(max=500) String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public AccountDetails balances(BalanceList balances) {
        this.balances = balances;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="balances")
    public BalanceList getBalances() {
        return this.balances;
    }

    public void setBalances(BalanceList balances) {
        this.balances = balances;
    }

    public AccountDetails _links(Map _links) {
        this._links = _links;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="_links")
    public Map getLinks() {
        return this._links;
    }

    public void setLinks(Map _links) {
        this._links = _links;
    }

    public AccountDetails ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @ApiModelProperty(value="Name of the legal account owner. If there is more than one owner, then e.g. two names might be noted here.")
    @Size(max=140)
    @JsonProperty(value="ownerName")
    public @Size(max=140) String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountDetails accountDetails = (AccountDetails)o;
        return Objects.equals(this.resourceId, accountDetails.resourceId) && Objects.equals(this.iban, accountDetails.iban) && Objects.equals(this.bban, accountDetails.bban) && Objects.equals(this.msisdn, accountDetails.msisdn) && Objects.equals(this.currency, accountDetails.currency) && Objects.equals(this.name, accountDetails.name) && Objects.equals(this.displayName, accountDetails.displayName) && Objects.equals(this.product, accountDetails.product) && Objects.equals(this.cashAccountType, accountDetails.cashAccountType) && Objects.equals((Object)this.status, (Object)accountDetails.status) && Objects.equals(this.bic, accountDetails.bic) && Objects.equals(this.linkedAccounts, accountDetails.linkedAccounts) && Objects.equals((Object)this.usage, (Object)accountDetails.usage) && Objects.equals(this.details, accountDetails.details) && Objects.equals(this.balances, accountDetails.balances) && Objects.equals(this._links, accountDetails._links) && Objects.equals(this.ownerName, accountDetails.ownerName);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceId, this.iban, this.bban, this.msisdn, this.currency, this.name, this.displayName, this.product, this.cashAccountType, this.status, this.bic, this.linkedAccounts, this.usage, this.details, this.balances, this._links, this.ownerName});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountDetails {\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    bban: ").append(this.toIndentedString(this.bban)).append("\n");
        sb.append("    msisdn: ").append(this.toIndentedString(this.msisdn)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    cashAccountType: ").append(this.toIndentedString(this.cashAccountType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    bic: ").append(this.toIndentedString(this.bic)).append("\n");
        sb.append("    linkedAccounts: ").append(this.toIndentedString(this.linkedAccounts)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString((Object)this.usage)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum UsageEnum {
        PRIV("PRIV"),
        ORGA("ORGA");

        private String value;

        private UsageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UsageEnum fromValue(String text) {
            for (UsageEnum b : UsageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

