/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.Authorisations;
import de.adorsys.psd2.model.Cancellations;
import de.adorsys.psd2.model.Error400NGPIS;
import de.adorsys.psd2.model.Error401NGPIS;
import de.adorsys.psd2.model.Error403NGPIS;
import de.adorsys.psd2.model.Error404NGPIS;
import de.adorsys.psd2.model.Error405NGPIS;
import de.adorsys.psd2.model.Error405NGPISCANC;
import de.adorsys.psd2.model.Error409NGPIS;
import de.adorsys.psd2.model.PaymentInitationRequestResponse201;
import de.adorsys.psd2.model.PaymentInitiationCancelResponse202;
import de.adorsys.psd2.model.PaymentInitiationStatusResponse200Json;
import de.adorsys.psd2.model.PeriodicPaymentInitiationXmlPart2StandingorderTypeJson;
import de.adorsys.psd2.model.ScaStatusResponse;
import de.adorsys.psd2.model.StartCancellationScaProcessResponse;
import de.adorsys.psd2.model.StartScaprocessResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value="v1", description="payment API")
public interface PaymentApi {
    public static final Logger log = LoggerFactory.getLogger(PaymentApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Payment cancellation request", nickname="cancelPayment", notes="This method initiates the cancellation of a payment.  Depending on the payment-service, the payment-product and the ASPSP's implementation,  this TPP call might be sufficient to cancel a payment.  If an authorisation of the payment cancellation is mandated by the ASPSP,  a corresponding hyperlink will be contained in the response message.  Cancels the addressed payment with resource identification paymentId if applicable to the payment-service, payment-product and received in product related timelines (e.g. before end of business day for scheduled payments of the last business day before the scheduled execution day).   The response to this DELETE command will tell the TPP whether the:   * access method was rejected   * access method was successful, or   * access method is generally applicable, but further authorisation processes are needed. ", response=PaymentInitiationCancelResponse202.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=202, message="Received", response=PaymentInitiationCancelResponse202.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPISCANC.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<PaymentInitiationCancelResponse202> _cancelPayment(@ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ") @RequestHeader(value="TPP-Redirect-Preferred", required=false) Boolean tpPRedirectPreferred, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If it equals \"true\", the TPP prefers to start the authorisation process separately,  e.g. because of the usage of a signing basket.  This preference might be ignored by the ASPSP, if a signing basket is not supported as functionality.  If it equals \"false\" or if the parameter is not used, there is no preference of the TPP.  This especially indicates that the TPP assumes a direct authorisation of the transaction in the next step,  without using a signing basket. ") @RequestHeader(value="TPP-Explicit-Authorisation-Preferred", required=false) Boolean tpPExplicitAuthorisationPreferred, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.cancelPayment(paymentService, paymentProduct, paymentId, xRequestID, digest, signature, tpPSignatureCertificate, tpPRedirectPreferred, tpPNokRedirectURI, tpPRedirectURI, tpPExplicitAuthorisationPreferred, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<PaymentInitiationCancelResponse202> cancelPayment(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, Boolean tpPRedirectPreferred, String tpPNokRedirectURI, String tpPRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Read the SCA status of the payment cancellation's authorisation", nickname="getPaymentCancellationScaStatus", notes="This method returns the SCA status of a payment initiation's authorisation sub-resource. ", response=ScaStatusResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ScaStatusResponse.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}/cancellation-authorisations/{cancellationId}"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<ScaStatusResponse> _getPaymentCancellationScaStatus(@ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="Identification for cancellation resource.", required=true) @PathVariable(value="cancellationId") String cancellationId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getPaymentCancellationScaStatus(paymentService, paymentProduct, paymentId, cancellationId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<ScaStatusResponse> getPaymentCancellationScaStatus(String paymentService, String paymentProduct, String paymentId, String cancellationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Get payment information", nickname="getPaymentInformation", notes="Returns the content of a payment object", response=Object.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Object.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}"}, produces={"application/json", "application/xml", "multipart/form-data", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<Object> _getPaymentInformation(@ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getPaymentInformation(paymentService, paymentProduct, paymentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Object> getPaymentInformation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Get payment initiation authorisation sub-resources request", nickname="getPaymentInitiationAuthorisation", notes="Read a list of all authorisation subresources IDs which have been created.  This function returns an array of hyperlinks to all generated authorisation sub-resources. ", response=Authorisations.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Authorisations.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}/authorisations"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<Authorisations> _getPaymentInitiationAuthorisation(@ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getPaymentInitiationAuthorisation(paymentService, paymentProduct, paymentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Authorisations> getPaymentInitiationAuthorisation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Will deliver an array of resource identifications to all generated cancellation authorisation sub-resources", nickname="getPaymentInitiationCancellationAuthorisationInformation", notes="Retrieve a list of all created cancellation authorisation sub-resources. ", response=Cancellations.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Cancellations.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}/cancellation-authorisations"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<Cancellations> _getPaymentInitiationCancellationAuthorisationInformation(@ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getPaymentInitiationCancellationAuthorisationInformation(paymentService, paymentProduct, paymentId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Cancellations> getPaymentInitiationCancellationAuthorisationInformation(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Read the SCA status of the payment authorisation", nickname="getPaymentInitiationScaStatus", notes="This method returns the SCA status of a payment initiation's authorisation sub-resource. ", response=ScaStatusResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ScaStatusResponse.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}/authorisations/{authorisationId}"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<ScaStatusResponse> _getPaymentInitiationScaStatus(@ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="Resource identification of the related SCA.", required=true) @PathVariable(value="authorisationId") String authorisationId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getPaymentInitiationScaStatus(paymentService, paymentProduct, paymentId, authorisationId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<ScaStatusResponse> getPaymentInitiationScaStatus(String paymentService, String paymentProduct, String paymentId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Payment initiation status request", nickname="getPaymentInitiationStatus", notes="Check the transaction status of a payment initiation.", response=PaymentInitiationStatusResponse200Json.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=PaymentInitiationStatusResponse200Json.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}/status"}, produces={"application/json", "application/xml", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<PaymentInitiationStatusResponse200Json> _getPaymentInitiationStatus(@ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ") @RequestHeader(value="TPP-Redirect-Preferred", required=false) Boolean tpPRedirectPreferred, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getPaymentInitiationStatus(paymentService, paymentProduct, paymentId, xRequestID, digest, signature, tpPSignatureCertificate, tpPRedirectPreferred, tpPRedirectURI, tpPNokRedirectURI, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<PaymentInitiationStatusResponse200Json> getPaymentInitiationStatus(String paymentService, String paymentProduct, String paymentId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Payment initiation request", nickname="initiatePayment", notes="This method is used to initiate a payment at the ASPSP.  ## Variants of Payment initiation requests  This method to initiate a payment initiation at the ASPSP can be sent with either a JSON body or an pain.001 body depending on the payment product in the path.  There are the following **payment products**:    - Payment products with payment information in *JSON* format:     - ***sepa-credit-transfers***     - ***instant-sepa-credit-transfers***     - ***target-2-payments***     - ***cross-border-credit-transfers***   - Payment products with payment information in *pain.001* XML format:     - ***pain.001-sepa-credit-transfers***     - ***pain.001-instant-sepa-credit-transfers***     - ***pain.001-target-2-payments***     - ***pain.001-cross-border-credit-transfers***  Furthermore the request body depends on the **payment-service**:   * ***payments***: A single payment initiation request.   * ***bulk-payments***: A collection of several payment initiation requests.      In case of a *pain.001* message there are more than one payments contained in the *pain.001 message.      In case of a *JSON* there are several JSON payment blocks contained in a joining list.   * ***periodic-payments***:      Create a standing order initiation resource for recurrent i.e. periodic payments addressable under {paymentId}       with all data relevant for the corresponding payment product and the execution of the standing order contained in a JSON body.   This is the first step in the API to initiate the related recurring/periodic payment.  ## Single and mulitilevel SCA Processes  The Payment initiation requests are independent from the need of one or multilevel  SCA processing, i.e. independent from the number of authorisations needed for the execution of payments.   But the response messages are specific to either one SCA processing or multilevel SCA processing.   For payment initiation with multilevel SCA, this specification requires an explicit start of the authorisation,  i.e. links directly associated with SCA processing like 'scaRedirect' or 'scaOAuth' cannot be contained in the  response message of a Payment Initation Request for a payment, where multiple authorisations are needed.  Also if any data is needed for the next action, like selecting an SCA method is not supported in the response,  since all starts of the multiple authorisations are fully equal.  In these cases, first an authorisation sub-resource has to be generated following the 'startAuthorisation' link. ", response=PaymentInitationRequestResponse201.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="CREATED", response=PaymentInitationRequestResponse201.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<PaymentInitationRequestResponse201> _initiatePayment(@ApiParam(value="JSON request body for a payment inition request message.  There are the following payment-products supported:   * \"sepa-credit-transfers\" with JSON-Body   * \"instant-sepa-credit-transfers\" with JSON-Body   * \"target-2-payments\" with JSON-Body   * \"cross-border-credit-transfers\" with JSON-Body   * \"pain.001-sepa-credit-transfers\" with XML pain.001.001.03 body for SCT scheme   * \"pain.001-instant-sepa-credit-transfers\" with XML pain.001.001.03 body for SCT INST scheme   * \"pain.001-target-2-payments\" with pain.001 body.      Only country specific schemes are currently available   * \"pain.001-cross-border-credit-transfers\" with pain.001 body.      Only country specific schemes are currently available  There are the following payment-services supported:   * \"payments\"   * \"periodic-payments\"   * \"bulk-paments\"  All optional, conditional and predefined but not yet used fields are defined. ", required=true) @Valid @RequestBody Object body, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. If not available, the TPP shall use the IP Address used by the TPP when submitting this request. ", required=true) @RequestHeader(value="PSU-IP-Address", required=true) String psUIPAddress, @ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="This data element may be contained, if the payment initiation transaction is part of a session, i.e. combined AIS/PIS service. This then contains the consentId of the related AIS consent, which was performed prior to this payment initiation. ") @RequestHeader(value="Consent-ID", required=false) String consentID, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ") @RequestHeader(value="TPP-Redirect-Preferred", required=false) Boolean tpPRedirectPreferred, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="If it equals \"true\", the TPP prefers to start the authorisation process separately,  e.g. because of the usage of a signing basket.  This preference might be ignored by the ASPSP, if a signing basket is not supported as functionality.  If it equals \"false\" or if the parameter is not used, there is no preference of the TPP.  This especially indicates that the TPP assumes a direct authorisation of the transaction in the next step,  without using a signing basket. ") @RequestHeader(value="TPP-Explicit-Authorisation-Preferred", required=false) Boolean tpPExplicitAuthorisationPreferred, @ApiParam(value="If it equals \"true\" then the TPP prefers a rejection of the payment initiation in case the ASPSP is  providing an integrated confirmation of funds request an the result of this is that not sufficient  funds are available.  If it equals \"false\" then the TPP prefers that the ASPSP is dealing with the payment initiation like  in the ASPSPs online channel, potentially waiting for a certain time period for funds to arrive to initiate the payment.  This parameter might be ignored by the ASPSP. ", allowableValues="true, false") @RequestHeader(value="TPP-Rejection-NoFunds-Preferred", required=false) String tpPRejectionNoFundsPreferred, @ApiParam(value="URI for the Endpoint of the TPP-API to which the status of the payment initiation should be sent. This header field may by ignored by the ASPSP.  For security reasons, it shall be ensured that the TPP-Notification-URI as introduced above is secured by the TPP eIDAS QWAC used for identification of the TPP. The following applies:  URIs which are provided by TPPs in TPP-Notification-URI shall comply with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate. Please note that in case of example-TPP.com as certificate entry TPP- Notification-URI like www.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications or notifications.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications would be compliant.  Wildcard definitions shall be taken into account for compliance checks by the ASPSP.  ASPSPs may respond with ASPSP-Notification-Support set to false, if the provided URIs do not comply. ") @RequestHeader(value="TPP-Notification-URI", required=false) String tpPNotificationURI, @ApiParam(value="The string has the form   status=X1, ..., Xn  where Xi is one of the constants SCA, PROCESS, LAST and where constants are not repeated. The usage of the constants supports the of following semantics:    SCA: A notification on every change of the scaStatus attribute for all related authorisation processes is preferred by the TPP.    PROCESS: A notification on all changes of consentStatus or transactionStatus attributes is preferred by the TPP.   LAST: Only a notification on the last consentStatus or transactionStatus as available in the XS2A interface is preferred by the TPP.  This header field may be ignored, if the ASPSP does not support resource notification services for the related TPP. ") @RequestHeader(value="TPP-Notification-Content-Preferred", required=false) String tpPNotificationContentPreferred, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation, @ApiParam(value="This header might be used by TPPs to inform the ASPSP about the brand used by the TPP towards the PSU. This information is meant for logging entries to enhance communication between ASPSP and PSU or ASPSP and TPP. This header might be ignored by the ASPSP.") @RequestHeader(value="TPP-Brand-Logging-Information", required=false) String tpPBrandLoggingInformation) {
        return this.initiatePayment(body, xRequestID, psUIPAddress, paymentService, paymentProduct, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, consentID, tpPRedirectPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPExplicitAuthorisationPreferred, tpPRejectionNoFundsPreferred, tpPNotificationURI, tpPNotificationContentPreferred, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation, tpPBrandLoggingInformation);
    }

    default public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(Object body, UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String tpPRejectionNoFundsPreferred, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation, String tpPBrandLoggingInformation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Payment initiation request", nickname="initiatePayment", notes="This method is used to initiate a payment at the ASPSP.  ## Variants of Payment initiation requests  This method to initiate a payment initiation at the ASPSP can be sent with either a JSON body or an pain.001 body depending on the payment product in the path.  There are the following **payment products**:    - Payment products with payment information in *JSON* format:     - ***sepa-credit-transfers***     - ***instant-sepa-credit-transfers***     - ***target-2-payments***     - ***cross-border-credit-transfers***   - Payment products with payment information in *pain.001* XML format:     - ***pain.001-sepa-credit-transfers***     - ***pain.001-instant-sepa-credit-transfers***     - ***pain.001-target-2-payments***     - ***pain.001-cross-border-credit-transfers***  Furthermore the request body depends on the **payment-service**:   * ***payments***: A single payment initiation request.   * ***bulk-payments***: A collection of several payment initiation requests.      In case of a *pain.001* message there are more than one payments contained in the *pain.001 message.      In case of a *JSON* there are several JSON payment blocks contained in a joining list.   * ***periodic-payments***:      Create a standing order initiation resource for recurrent i.e. periodic payments addressable under {paymentId}       with all data relevant for the corresponding payment product and the execution of the standing order contained in a JSON body.   This is the first step in the API to initiate the related recurring/periodic payment.  ## Single and mulitilevel SCA Processes  The Payment initiation requests are independent from the need of one or multilevel  SCA processing, i.e. independent from the number of authorisations needed for the execution of payments.   But the response messages are specific to either one SCA processing or multilevel SCA processing.   For payment initiation with multilevel SCA, this specification requires an explicit start of the authorisation,  i.e. links directly associated with SCA processing like 'scaRedirect' or 'scaOAuth' cannot be contained in the  response message of a Payment Initation Request for a payment, where multiple authorisations are needed.  Also if any data is needed for the next action, like selecting an SCA method is not supported in the response,  since all starts of the multiple authorisations are fully equal.  In these cases, first an authorisation sub-resource has to be generated following the 'startAuthorisation' link. ", response=PaymentInitationRequestResponse201.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="CREATED", response=PaymentInitationRequestResponse201.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}"}, produces={"application/json", "application/problem+json"}, consumes={"application/xml", "multipart/form-data"}, method={RequestMethod.POST})
    default public ResponseEntity<PaymentInitationRequestResponse201> _initiatePayment(@ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. If not available, the TPP shall use the IP Address used by the TPP when submitting this request. ", required=true) @RequestHeader(value="PSU-IP-Address", required=true) String psUIPAddress, @ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="") @RequestParam(value="xml_sct", required=false) Object xmlSct, @ApiParam(value="") @RequestParam(value="json_standingorderType", required=false) PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonStandingorderType, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="This data element may be contained, if the payment initiation transaction is part of a session, i.e. combined AIS/PIS service. This then contains the consentId of the related AIS consent, which was performed prior to this payment initiation. ") @RequestHeader(value="Consent-ID", required=false) String consentID, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ") @RequestHeader(value="TPP-Redirect-Preferred", required=false) Boolean tpPRedirectPreferred, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="If it equals \"true\", the TPP prefers to start the authorisation process separately,  e.g. because of the usage of a signing basket.  This preference might be ignored by the ASPSP, if a signing basket is not supported as functionality.  If it equals \"false\" or if the parameter is not used, there is no preference of the TPP.  This especially indicates that the TPP assumes a direct authorisation of the transaction in the next step,  without using a signing basket. ") @RequestHeader(value="TPP-Explicit-Authorisation-Preferred", required=false) Boolean tpPExplicitAuthorisationPreferred, @ApiParam(value="If it equals \"true\" then the TPP prefers a rejection of the payment initiation in case the ASPSP is  providing an integrated confirmation of funds request an the result of this is that not sufficient  funds are available.  If it equals \"false\" then the TPP prefers that the ASPSP is dealing with the payment initiation like  in the ASPSPs online channel, potentially waiting for a certain time period for funds to arrive to initiate the payment.  This parameter might be ignored by the ASPSP. ", allowableValues="true, false") @RequestHeader(value="TPP-Rejection-NoFunds-Preferred", required=false) String tpPRejectionNoFundsPreferred, @ApiParam(value="URI for the Endpoint of the TPP-API to which the status of the payment initiation should be sent. This header field may by ignored by the ASPSP.  For security reasons, it shall be ensured that the TPP-Notification-URI as introduced above is secured by the TPP eIDAS QWAC used for identification of the TPP. The following applies:  URIs which are provided by TPPs in TPP-Notification-URI shall comply with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate. Please note that in case of example-TPP.com as certificate entry TPP- Notification-URI like www.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications or notifications.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications would be compliant.  Wildcard definitions shall be taken into account for compliance checks by the ASPSP.  ASPSPs may respond with ASPSP-Notification-Support set to false, if the provided URIs do not comply. ") @RequestHeader(value="TPP-Notification-URI", required=false) String tpPNotificationURI, @ApiParam(value="The string has the form   status=X1, ..., Xn  where Xi is one of the constants SCA, PROCESS, LAST and where constants are not repeated. The usage of the constants supports the of following semantics:    SCA: A notification on every change of the scaStatus attribute for all related authorisation processes is preferred by the TPP.    PROCESS: A notification on all changes of consentStatus or transactionStatus attributes is preferred by the TPP.   LAST: Only a notification on the last consentStatus or transactionStatus as available in the XS2A interface is preferred by the TPP.  This header field may be ignored, if the ASPSP does not support resource notification services for the related TPP. ") @RequestHeader(value="TPP-Notification-Content-Preferred", required=false) String tpPNotificationContentPreferred, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation, @ApiParam(value="This header might be used by TPPs to inform the ASPSP about the brand used by the TPP towards the PSU. This information is meant for logging entries to enhance communication between ASPSP and PSU or ASPSP and TPP. This header might be ignored by the ASPSP.") @RequestHeader(value="TPP-Brand-Logging-Information", required=false) String tpPBrandLoggingInformation) {
        return this.initiatePayment(xRequestID, psUIPAddress, paymentService, paymentProduct, xmlSct, jsonStandingorderType, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, consentID, tpPRedirectPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPExplicitAuthorisationPreferred, tpPRejectionNoFundsPreferred, tpPNotificationURI, tpPNotificationContentPreferred, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation, tpPBrandLoggingInformation);
    }

    default public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, Object xmlSct, PeriodicPaymentInitiationXmlPart2StandingorderTypeJson jsonStandingorderType, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String tpPRejectionNoFundsPreferred, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation, String tpPBrandLoggingInformation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Payment initiation request", nickname="initiatePayment", notes="This method is used to initiate a payment at the ASPSP.  ## Variants of Payment initiation requests  This method to initiate a payment initiation at the ASPSP can be sent with either a JSON body or an pain.001 body depending on the payment product in the path.  There are the following **payment products**:    - Payment products with payment information in *JSON* format:     - ***sepa-credit-transfers***     - ***instant-sepa-credit-transfers***     - ***target-2-payments***     - ***cross-border-credit-transfers***   - Payment products with payment information in *pain.001* XML format:     - ***pain.001-sepa-credit-transfers***     - ***pain.001-instant-sepa-credit-transfers***     - ***pain.001-target-2-payments***     - ***pain.001-cross-border-credit-transfers***  Furthermore the request body depends on the **payment-service**:   * ***payments***: A single payment initiation request.   * ***bulk-payments***: A collection of several payment initiation requests.      In case of a *pain.001* message there are more than one payments contained in the *pain.001 message.      In case of a *JSON* there are several JSON payment blocks contained in a joining list.   * ***periodic-payments***:      Create a standing order initiation resource for recurrent i.e. periodic payments addressable under {paymentId}       with all data relevant for the corresponding payment product and the execution of the standing order contained in a JSON body.   This is the first step in the API to initiate the related recurring/periodic payment.  ## Single and mulitilevel SCA Processes  The Payment initiation requests are independent from the need of one or multilevel  SCA processing, i.e. independent from the number of authorisations needed for the execution of payments.   But the response messages are specific to either one SCA processing or multilevel SCA processing.   For payment initiation with multilevel SCA, this specification requires an explicit start of the authorisation,  i.e. links directly associated with SCA processing like 'scaRedirect' or 'scaOAuth' cannot be contained in the  response message of a Payment Initation Request for a payment, where multiple authorisations are needed.  Also if any data is needed for the next action, like selecting an SCA method is not supported in the response,  since all starts of the multiple authorisations are fully equal.  In these cases, first an authorisation sub-resource has to be generated following the 'startAuthorisation' link. ", response=PaymentInitationRequestResponse201.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="CREATED", response=PaymentInitationRequestResponse201.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}"}, produces={"application/json", "application/problem+json"}, consumes={"text/plain"}, method={RequestMethod.POST})
    default public ResponseEntity<PaymentInitationRequestResponse201> _initiatePayment(@ApiParam(value="JSON request body for a payment inition request message.  There are the following payment-products supported:   * \"sepa-credit-transfers\" with JSON-Body   * \"instant-sepa-credit-transfers\" with JSON-Body   * \"target-2-payments\" with JSON-Body   * \"cross-border-credit-transfers\" with JSON-Body   * \"pain.001-sepa-credit-transfers\" with XML pain.001.001.03 body for SCT scheme   * \"pain.001-instant-sepa-credit-transfers\" with XML pain.001.001.03 body for SCT INST scheme   * \"pain.001-target-2-payments\" with pain.001 body.      Only country specific schemes are currently available   * \"pain.001-cross-border-credit-transfers\" with pain.001 body.      Only country specific schemes are currently available  There are the following payment-services supported:   * \"payments\"   * \"periodic-payments\"   * \"bulk-paments\"  All optional, conditional and predefined but not yet used fields are defined. ", required=true) @Valid @RequestBody String body, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. If not available, the TPP shall use the IP Address used by the TPP when submitting this request. ", required=true) @RequestHeader(value="PSU-IP-Address", required=true) String psUIPAddress, @ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="This data element may be contained, if the payment initiation transaction is part of a session, i.e. combined AIS/PIS service. This then contains the consentId of the related AIS consent, which was performed prior to this payment initiation. ") @RequestHeader(value="Consent-ID", required=false) String consentID, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ") @RequestHeader(value="TPP-Redirect-Preferred", required=false) Boolean tpPRedirectPreferred, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="If it equals \"true\", the TPP prefers to start the authorisation process separately,  e.g. because of the usage of a signing basket.  This preference might be ignored by the ASPSP, if a signing basket is not supported as functionality.  If it equals \"false\" or if the parameter is not used, there is no preference of the TPP.  This especially indicates that the TPP assumes a direct authorisation of the transaction in the next step,  without using a signing basket. ") @RequestHeader(value="TPP-Explicit-Authorisation-Preferred", required=false) Boolean tpPExplicitAuthorisationPreferred, @ApiParam(value="If it equals \"true\" then the TPP prefers a rejection of the payment initiation in case the ASPSP is  providing an integrated confirmation of funds request an the result of this is that not sufficient  funds are available.  If it equals \"false\" then the TPP prefers that the ASPSP is dealing with the payment initiation like  in the ASPSPs online channel, potentially waiting for a certain time period for funds to arrive to initiate the payment.  This parameter might be ignored by the ASPSP. ", allowableValues="true, false") @RequestHeader(value="TPP-Rejection-NoFunds-Preferred", required=false) String tpPRejectionNoFundsPreferred, @ApiParam(value="URI for the Endpoint of the TPP-API to which the status of the payment initiation should be sent. This header field may by ignored by the ASPSP.  For security reasons, it shall be ensured that the TPP-Notification-URI as introduced above is secured by the TPP eIDAS QWAC used for identification of the TPP. The following applies:  URIs which are provided by TPPs in TPP-Notification-URI shall comply with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate. Please note that in case of example-TPP.com as certificate entry TPP- Notification-URI like www.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications or notifications.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications would be compliant.  Wildcard definitions shall be taken into account for compliance checks by the ASPSP.  ASPSPs may respond with ASPSP-Notification-Support set to false, if the provided URIs do not comply. ") @RequestHeader(value="TPP-Notification-URI", required=false) String tpPNotificationURI, @ApiParam(value="The string has the form   status=X1, ..., Xn  where Xi is one of the constants SCA, PROCESS, LAST and where constants are not repeated. The usage of the constants supports the of following semantics:    SCA: A notification on every change of the scaStatus attribute for all related authorisation processes is preferred by the TPP.    PROCESS: A notification on all changes of consentStatus or transactionStatus attributes is preferred by the TPP.   LAST: Only a notification on the last consentStatus or transactionStatus as available in the XS2A interface is preferred by the TPP.  This header field may be ignored, if the ASPSP does not support resource notification services for the related TPP. ") @RequestHeader(value="TPP-Notification-Content-Preferred", required=false) String tpPNotificationContentPreferred, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation, @ApiParam(value="This header might be used by TPPs to inform the ASPSP about the brand used by the TPP towards the PSU. This information is meant for logging entries to enhance communication between ASPSP and PSU or ASPSP and TPP. This header might be ignored by the ASPSP.") @RequestHeader(value="TPP-Brand-Logging-Information", required=false) String tpPBrandLoggingInformation) {
        return this.initiatePayment(body, xRequestID, psUIPAddress, paymentService, paymentProduct, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, consentID, tpPRedirectPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPExplicitAuthorisationPreferred, tpPRejectionNoFundsPreferred, tpPNotificationURI, tpPNotificationContentPreferred, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation, tpPBrandLoggingInformation);
    }

    default public ResponseEntity<PaymentInitationRequestResponse201> initiatePayment(String body, UUID xRequestID, String psUIPAddress, String paymentService, String paymentProduct, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String tpPRejectionNoFundsPreferred, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation, String tpPBrandLoggingInformation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Start the authorisation process for a payment initiation", nickname="startPaymentAuthorisation", notes="Create an authorisation sub-resource and start the authorisation process.  The message might in addition transmit authentication and authorisation related data.   This method is iterated n times for a n times SCA authorisation in a  corporate context, each creating an own authorisation sub-endpoint for  the corresponding PSU authorising the transaction.  The ASPSP might make the usage of this access method unnecessary in case  of only one SCA process needed, since the related authorisation resource  might be automatically created by the ASPSP after the submission of the  payment data with the first POST payments/{payment-product} call.  The start authorisation process is a process which is needed for creating a new authorisation  or cancellation sub-resource.   This applies in the following scenarios:    * The ASPSP has indicated with an 'startAuthorisation' hyperlink in the preceding Payment      initiation response that an explicit start of the authorisation process is needed by the TPP.      The 'startAuthorisation' hyperlink can transport more information about data which needs to be      uploaded by using the extended forms:     * 'startAuthorisationWithPsuIdentfication',      * 'startAuthorisationWithPsuAuthentication'      * 'startAuthorisationWithEncryptedPsuAuthentication'     * 'startAuthorisationWithAuthentciationMethodSelection'    * The related payment initiation cannot yet be executed since a multilevel SCA is mandated.   * The ASPSP has indicated with an 'startAuthorisation' hyperlink in the preceding      Payment cancellation response that an explicit start of the authorisation process is needed by the TPP.      The 'startAuthorisation' hyperlink can transport more information about data which needs to be uploaded      by using the extended forms as indicated above.   * The related payment cancellation request cannot be applied yet since a multilevel SCA is mandate for      executing the cancellation.   * The signing basket needs to be authorised yet. ", response=StartScaprocessResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=StartScaprocessResponse.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}/authorisations"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<StartScaprocessResponse> _startPaymentAuthorisation(@ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="") @Valid @RequestBody(required=false) Object body, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ") @RequestHeader(value="TPP-Redirect-Preferred", required=false) Boolean tpPRedirectPreferred, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="URI for the Endpoint of the TPP-API to which the status of the payment initiation should be sent. This header field may by ignored by the ASPSP.  For security reasons, it shall be ensured that the TPP-Notification-URI as introduced above is secured by the TPP eIDAS QWAC used for identification of the TPP. The following applies:  URIs which are provided by TPPs in TPP-Notification-URI shall comply with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate. Please note that in case of example-TPP.com as certificate entry TPP- Notification-URI like www.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications or notifications.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications would be compliant.  Wildcard definitions shall be taken into account for compliance checks by the ASPSP.  ASPSPs may respond with ASPSP-Notification-Support set to false, if the provided URIs do not comply. ") @RequestHeader(value="TPP-Notification-URI", required=false) String tpPNotificationURI, @ApiParam(value="The string has the form   status=X1, ..., Xn  where Xi is one of the constants SCA, PROCESS, LAST and where constants are not repeated. The usage of the constants supports the of following semantics:    SCA: A notification on every change of the scaStatus attribute for all related authorisation processes is preferred by the TPP.    PROCESS: A notification on all changes of consentStatus or transactionStatus attributes is preferred by the TPP.   LAST: Only a notification on the last consentStatus or transactionStatus as available in the XS2A interface is preferred by the TPP.  This header field may be ignored, if the ASPSP does not support resource notification services for the related TPP. ") @RequestHeader(value="TPP-Notification-Content-Preferred", required=false) String tpPNotificationContentPreferred, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.startPaymentAuthorisation(xRequestID, paymentService, paymentProduct, paymentId, body, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, tpPRedirectPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPNotificationURI, tpPNotificationContentPreferred, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<StartScaprocessResponse> startPaymentAuthorisation(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, Object body, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPNotificationURI, String tpPNotificationContentPreferred, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Start the authorisation process for the cancellation of the addressed payment", nickname="startPaymentInitiationCancellationAuthorisation", notes="Creates an authorisation sub-resource and start the authorisation process of the cancellation of the addressed payment.  The message might in addition transmit authentication and authorisation related data.  This method is iterated n times for a n times SCA authorisation in a  corporate context, each creating an own authorisation sub-endpoint for  the corresponding PSU authorising the cancellation-authorisation.  The ASPSP might make the usage of this access method unnecessary in case  of only one SCA process needed, since the related authorisation resource  might be automatically created by the ASPSP after the submission of the  payment data with the first POST payments/{payment-product} call.  The start authorisation process is a process which is needed for creating a new authorisation  or cancellation sub-resource.   This applies in the following scenarios:    * The ASPSP has indicated with an 'startAuthorisation' hyperlink in the preceding Payment      initiation response that an explicit start of the authorisation process is needed by the TPP.      The 'startAuthorisation' hyperlink can transport more information about data which needs to be      uploaded by using the extended forms:     * 'startAuthorisationWithPsuIdentfication'      * 'startAuthorisationWithPsuAuthentication'      * 'startAuthorisationWithAuthentciationMethodSelection'    * The related payment initiation cannot yet be executed since a multilevel SCA is mandated.   * The ASPSP has indicated with an 'startAuthorisation' hyperlink in the preceding      Payment cancellation response that an explicit start of the authorisation process is needed by the TPP.      The 'startAuthorisation' hyperlink can transport more information about data which needs to be uploaded      by using the extended forms as indicated above.   * The related payment cancellation request cannot be applied yet since a multilevel SCA is mandate for      executing the cancellation.   * The signing basket needs to be authorised yet. ", response=StartCancellationScaProcessResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Created cancellation authorisation", response=StartCancellationScaProcessResponse.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}/cancellation-authorisations"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<StartCancellationScaProcessResponse> _startPaymentInitiationCancellationAuthorisation(@ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="") @Valid @RequestBody(required=false) Object body, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ") @RequestHeader(value="TPP-Redirect-Preferred", required=false) Boolean tpPRedirectPreferred, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="URI for the Endpoint of the TPP-API to which the status of the payment initiation should be sent. This header field may by ignored by the ASPSP.  For security reasons, it shall be ensured that the TPP-Notification-URI as introduced above is secured by the TPP eIDAS QWAC used for identification of the TPP. The following applies:  URIs which are provided by TPPs in TPP-Notification-URI shall comply with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate. Please note that in case of example-TPP.com as certificate entry TPP- Notification-URI like www.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications or notifications.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications would be compliant.  Wildcard definitions shall be taken into account for compliance checks by the ASPSP.  ASPSPs may respond with ASPSP-Notification-Support set to false, if the provided URIs do not comply. ") @RequestHeader(value="TPP-Notification-URI", required=false) String tpPNotificationURI, @ApiParam(value="The string has the form   status=X1, ..., Xn  where Xi is one of the constants SCA, PROCESS, LAST and where constants are not repeated. The usage of the constants supports the of following semantics:    SCA: A notification on every change of the scaStatus attribute for all related authorisation processes is preferred by the TPP.    PROCESS: A notification on all changes of consentStatus or transactionStatus attributes is preferred by the TPP.   LAST: Only a notification on the last consentStatus or transactionStatus as available in the XS2A interface is preferred by the TPP.  This header field may be ignored, if the ASPSP does not support resource notification services for the related TPP. ") @RequestHeader(value="TPP-Notification-Content-Preferred", required=false) String tpPNotificationContentPreferred, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.startPaymentInitiationCancellationAuthorisation(xRequestID, paymentService, paymentProduct, paymentId, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, tpPRedirectPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPNotificationURI, tpPNotificationContentPreferred, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<StartCancellationScaProcessResponse> startPaymentInitiationCancellationAuthorisation(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Update PSU data for payment initiation cancellation", nickname="updatePaymentCancellationPsuData", notes="This method updates PSU data on the cancellation authorisation resource if needed.  It may authorise a cancellation of the payment within the Embedded SCA Approach where needed.  Independently from the SCA Approach it supports e.g. the selection of  the authentication method and a non-SCA PSU authentication.  This methods updates PSU data on the cancellation authorisation resource if needed.   There are several possible Update PSU data requests in the context of a cancellation authorisation within the payment initiation services needed,  which depends on the SCA approach:  * Redirect SCA Approach:   A specific Update PSU data request is applicable for      * the selection of authentication methods, before choosing the actual SCA approach. * Decoupled SCA Approach:   A specific Update PSU data request is only applicable for   * adding the PSU Identification, if not provided yet in the Payment initiation request or the Account Information Consent Request, or if no OAuth2 access token is used, or   * the selection of authentication methods. * Embedded SCA Approach:    The Update PSU Data request might be used    * to add credentials as a first factor authentication data of the PSU and   * to select the authentication method and   * transaction authorisation.  The SCA Approach might depend on the chosen SCA method.  For that reason, the following possible Update PSU data request can apply to all SCA approaches:  * Select an SCA method in case of several SCA methods are available for the customer.  There are the following request types on this access path:   * Update PSU identification   * Update PSU authentication   * Select PSU autorization Method      WARNING: This method need a reduced header,      therefore many optional elements are not present.      Maybe in a later version the access path will change.   * Transaction Authorisation     WARNING: This method need a reduced header,      therefore many optional elements are not present.      Maybe in a later version the access path will change. ", response=Object.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Object.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}/cancellation-authorisations/{cancellationId}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    default public ResponseEntity<Object> _updatePaymentCancellationPsuData(@ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="Identification for cancellation resource.", required=true) @PathVariable(value="cancellationId") String cancellationId, @ApiParam(value="") @Valid @RequestBody(required=false) Object body, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.updatePaymentCancellationPsuData(xRequestID, paymentService, paymentProduct, paymentId, cancellationId, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Object> updatePaymentCancellationPsuData(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, String cancellationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Update PSU data for payment initiation", nickname="updatePaymentPsuData", notes="This methods updates PSU data on the authorisation resource if needed.  It may authorise a payment within the Embedded SCA Approach where needed.  Independently from the SCA Approach it supports e.g. the selection of  the authentication method and a non-SCA PSU authentication.  There are several possible Update PSU data requests in the context of payment initiation services needed, which depends on the SCA approach:  * Redirect SCA Approach:   A specific Update PSU data request is applicable for     * the selection of authentication methods, before choosing the actual SCA approach. * Decoupled SCA Approach:   A specific Update PSU data request is only applicable for   * adding the PSU Identification, if not provided yet in the Payment initiation request or the Account Information Consent Request, or if no OAuth2 access token is used, or   * the selection of authentication methods. * Embedded SCA Approach:    The Update PSU Data request might be used    * to add credentials as a first factor authentication data of the PSU and   * to select the authentication method and   * transaction authorisation.  The SCA Approach might depend on the chosen SCA method.  For that reason, the following possible Update PSU data request can apply to all SCA approaches:  * Select an SCA method in case of several SCA methods are available for the customer.  There are the following request types on this access path:   * Update PSU identification   * Update PSU authentication   * Select PSU autorization Method      WARNING: This method need a reduced header,      therefore many optional elements are not present.      Maybe in a later version the access path will change.   * Transaction Authorisation     WARNING: This method need a reduced header,      therefore many optional elements are not present.      Maybe in a later version the access path will change. ", response=Object.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Object.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGPIS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGPIS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGPIS.class), @ApiResponse(code=404, message="Not found", response=Error404NGPIS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGPIS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGPIS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/{payment-service}/{payment-product}/{paymentId}/authorisations/{authorisationId}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    default public ResponseEntity<Object> _updatePaymentPsuData(@ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Payment service:  Possible values are: * payments * bulk-payments * periodic-payments ", required=true, allowableValues="\"payments\", \"bulk-payments\", \"periodic-payments\"") @PathVariable(value="payment-service") String paymentService, @ApiParam(value="The addressed payment product endpoint, e.g. for SEPA Credit Transfers (SCT). The ASPSP will publish which of the payment products/endpoints will be supported.  The following payment products are supported:   - sepa-credit-transfers   - instant-sepa-credit-transfers   - target-2-payments   - cross-border-credit-transfers   - pain.001-sepa-credit-transfers   - pain.001-instant-sepa-credit-transfers   - pain.001-target-2-payments   - pain.001-cross-border-credit-transfers  **Remark:** For all SEPA Credit Transfer based endpoints which accept XML encoding,  the XML pain.001 schemes provided by EPC are supported by the ASPSP as a minimum for the body content.  Further XML schemes might be supported by some communities.  **Remark:** For cross-border and TARGET-2 payments only community wide pain.001 schemes do exist.  There are plenty of country specificic scheme variants. ", required=true, allowableValues="\"sepa-credit-transfers\", \"instant-sepa-credit-transfers\", \"target-2-payments\", \"cross-border-credit-transfers\", \"pain.001-sepa-credit-transfers\", \"pain.001-instant-sepa-credit-transfers\", \"pain.001-target-2-payments\", \"pain.001-cross-border-credit-transfers\"") @PathVariable(value="payment-product") String paymentProduct, @ApiParam(value="Resource identification of the generated payment initiation resource.", required=true) @PathVariable(value="paymentId") String paymentId, @ApiParam(value="Resource identification of the related SCA.", required=true) @PathVariable(value="authorisationId") String authorisationId, @ApiParam(value="") @Valid @RequestBody(required=false) Object body, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID need to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.updatePaymentPsuData(xRequestID, paymentService, paymentProduct, paymentId, authorisationId, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Object> updatePaymentPsuData(UUID xRequestID, String paymentService, String paymentProduct, String paymentId, String authorisationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default PaymentInitiationServicePisApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

