/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.PurposeCode;
import de.adorsys.psd2.model.RemittanceInformationStructured;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Generic body for a bulk payment initation entry.  The bulk entry type is a type which follows the JSON formats for the supported products for single payments excluding the data elements (if supported):   * debtorAccount   * requestedExecutionDate,   * requestedExecutionTime. These data elements may not be contained in any bulk entry.  This data object can be used to represent valid bulk payment initiations entry for the following JSON based payment product, which where defined in the Implementation Guidelines:    * sepa-credit-transfers   * instant-sepa-credit-transfers   * target-2-payments   * cross-border-credit-transfers  For the convenience of the implementer additional which are already predefinded in the Implementation Guidelines are included (but commented in source code), such that an ASPSP may add them easily.  Take care: Since the format is intended to fit for all payment products there are additional conditions which are NOT covered by this specification. Please check the Implementation Guidelines for detailes.   The following data element are depending on the actual payment product available (in source code):   <table style=\"width:100%\">  <tr><th>Data Element</th><th>SCT EU Core</th><th>SCT INST EU Core</th><th>Target2 Paym. Core</th><th>Cross Border CT Core</th></tr>  <tr><td>endToEndIdentification</td><td> optional</td> <td>optional</td> <td>optional</td> <td>n.a.</td> </tr>  <tr><td>debtorId</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>ultimateDebtor</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>instructedAmount</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> </tr>  <tr><td>transactionCurrency</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>exchangeRateInformation</td> <td>n.a.</td> <td>n.a.</td><td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>creditorAccount</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> </tr>  <tr><td>creditorAgent</td> <td>optional</td> <td>optional</td> <td>optional</td> <td>conditional </td> </tr>  <tr><td>creditorAgentName</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>creditorName</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> <td>mandatory</td> </tr>  <tr><td>creditorId</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>creditorAddress</td>optional</td> <td>optional</td> <td>optional</td> <td>conditional </td> </tr>  <tr><td>creditorNameAndAddress</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>ultimateCreditor</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>purposeCode</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>chargeBearer</td> <td>n.a.</td> <td>n.a.</td> <td>optional</td> <td>conditional </td> </tr>  <tr><td>remittanceInformationUnstructured</td> <td>optional</td> <td>optional</td> <td> optional</td> <td>optional</td> </tr>  <tr><td>remittanceInformationUnstructuredArray</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>  <tr><td>remittanceInformationStructured</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> <td>n.a.</td> </tr>     </td></tr>   </table>  IMPORTANT: In this API definition the following holds:   *  All data elements mentioned above are defined, but some of them are commented,     i.e. they are only visible in the source code and can be used by uncommenting them.   * Data elements which are mandatory in the table above for all payment products     are set to be mandatory in this specification.   * Data elements which are indicated in the table above as n.a. for all payment products are commented in the source code.   * Data elements which are indicated to be option, conditional or mandatory for at least one payment product     in the table above are set to be optional in the s specification except the case where all are definde to be mandatory.   * Data element which are inticated to be n.a. can be used by the ASPS if needed.     In this case uncomment tthe the relatetd lines in the source code.   * If one uses this data types for some payment products he has to ensure that the used data type is     valid according to the underlying payment product, e.g. by some appropriate validations. ")
@Validated
public class PaymentInitiationBulkElementJson {
    @JsonProperty(value="endToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="ultimateDebtor")
    private String ultimateDebtor = null;
    @JsonProperty(value="instructedAmount")
    private Amount instructedAmount = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="creditorAgent")
    private String creditorAgent = null;
    @JsonProperty(value="creditorAgentName")
    private String creditorAgentName = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAddress")
    private Address creditorAddress = null;
    @JsonProperty(value="creditorId")
    private String creditorId = null;
    @JsonProperty(value="ultimateCreditor")
    private String ultimateCreditor = null;
    @JsonProperty(value="purposeCode")
    private PurposeCode purposeCode = null;
    @JsonProperty(value="remittanceInformationUnstructured")
    private String remittanceInformationUnstructured = null;
    @JsonProperty(value="remittanceInformationStructured")
    private RemittanceInformationStructured remittanceInformationStructured = null;

    public PaymentInitiationBulkElementJson endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="endToEndIdentification")
    public @Size(max=35) String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public PaymentInitiationBulkElementJson ultimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="ultimateDebtor")
    public @Size(max=70) String getUltimateDebtor() {
        return this.ultimateDebtor;
    }

    public void setUltimateDebtor(String ultimateDebtor) {
        this.ultimateDebtor = ultimateDebtor;
    }

    public PaymentInitiationBulkElementJson instructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="instructedAmount")
    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public PaymentInitiationBulkElementJson creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="creditorAccount")
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public PaymentInitiationBulkElementJson creditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    @JsonProperty(value="creditorAgent")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public PaymentInitiationBulkElementJson creditorAgentName(String creditorAgentName) {
        this.creditorAgentName = creditorAgentName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="creditorAgentName")
    public @Size(max=70) String getCreditorAgentName() {
        return this.creditorAgentName;
    }

    public void setCreditorAgentName(String creditorAgentName) {
        this.creditorAgentName = creditorAgentName;
    }

    public PaymentInitiationBulkElementJson creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Size(max=70)
    @JsonProperty(value="creditorName")
    public @NotNull @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public PaymentInitiationBulkElementJson creditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="creditorAddress")
    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public PaymentInitiationBulkElementJson creditorId(String creditorId) {
        this.creditorId = creditorId;
        return this;
    }

    @ApiModelProperty(value="Identification of Creditors, e.g. a SEPA Creditor ID.")
    @Size(max=35)
    @JsonProperty(value="creditorId")
    public @Size(max=35) String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public PaymentInitiationBulkElementJson ultimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="ultimateCreditor")
    public @Size(max=70) String getUltimateCreditor() {
        return this.ultimateCreditor;
    }

    public void setUltimateCreditor(String ultimateCreditor) {
        this.ultimateCreditor = ultimateCreditor;
    }

    public PaymentInitiationBulkElementJson purposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="purposeCode")
    public PurposeCode getPurposeCode() {
        return this.purposeCode;
    }

    public void setPurposeCode(PurposeCode purposeCode) {
        this.purposeCode = purposeCode;
    }

    public PaymentInitiationBulkElementJson remittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    @JsonProperty(value="remittanceInformationUnstructured")
    public @Size(max=140) String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public PaymentInitiationBulkElementJson remittanceInformationStructured(RemittanceInformationStructured remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="remittanceInformationStructured")
    public RemittanceInformationStructured getRemittanceInformationStructured() {
        return this.remittanceInformationStructured;
    }

    public void setRemittanceInformationStructured(RemittanceInformationStructured remittanceInformationStructured) {
        this.remittanceInformationStructured = remittanceInformationStructured;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationBulkElementJson paymentInitiationBulkElementJson = (PaymentInitiationBulkElementJson)o;
        return Objects.equals(this.endToEndIdentification, paymentInitiationBulkElementJson.endToEndIdentification) && Objects.equals(this.ultimateDebtor, paymentInitiationBulkElementJson.ultimateDebtor) && Objects.equals(this.instructedAmount, paymentInitiationBulkElementJson.instructedAmount) && Objects.equals(this.creditorAccount, paymentInitiationBulkElementJson.creditorAccount) && Objects.equals(this.creditorAgent, paymentInitiationBulkElementJson.creditorAgent) && Objects.equals(this.creditorAgentName, paymentInitiationBulkElementJson.creditorAgentName) && Objects.equals(this.creditorName, paymentInitiationBulkElementJson.creditorName) && Objects.equals(this.creditorAddress, paymentInitiationBulkElementJson.creditorAddress) && Objects.equals(this.creditorId, paymentInitiationBulkElementJson.creditorId) && Objects.equals(this.ultimateCreditor, paymentInitiationBulkElementJson.ultimateCreditor) && Objects.equals((Object)this.purposeCode, (Object)paymentInitiationBulkElementJson.purposeCode) && Objects.equals(this.remittanceInformationUnstructured, paymentInitiationBulkElementJson.remittanceInformationUnstructured) && Objects.equals(this.remittanceInformationStructured, paymentInitiationBulkElementJson.remittanceInformationStructured);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endToEndIdentification, this.ultimateDebtor, this.instructedAmount, this.creditorAccount, this.creditorAgent, this.creditorAgentName, this.creditorName, this.creditorAddress, this.creditorId, this.ultimateCreditor, this.purposeCode, this.remittanceInformationUnstructured, this.remittanceInformationStructured});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationBulkElementJson {\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    ultimateDebtor: ").append(this.toIndentedString(this.ultimateDebtor)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorAgentName: ").append(this.toIndentedString(this.creditorAgentName)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAddress: ").append(this.toIndentedString(this.creditorAddress)).append("\n");
        sb.append("    creditorId: ").append(this.toIndentedString(this.creditorId)).append("\n");
        sb.append("    ultimateCreditor: ").append(this.toIndentedString(this.ultimateCreditor)).append("\n");
        sb.append("    purposeCode: ").append(this.toIndentedString((Object)this.purposeCode)).append("\n");
        sb.append("    remittanceInformationUnstructured: ").append(this.toIndentedString(this.remittanceInformationUnstructured)).append("\n");
        sb.append("    remittanceInformationStructured: ").append(this.toIndentedString(this.remittanceInformationStructured)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

