/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Authentication Object. ")
@Validated
public class AuthenticationObject {
    @JsonProperty(value="authenticationType")
    private String authenticationType = null;
    @JsonProperty(value="authenticationVersion")
    private String authenticationVersion = null;
    @JsonProperty(value="authenticationMethodId")
    private String authenticationMethodId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="explanation")
    private String explanation = null;

    public AuthenticationObject authenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @JsonProperty(value="authenticationType")
    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
    }

    public AuthenticationObject authenticationVersion(String authenticationVersion) {
        this.authenticationVersion = authenticationVersion;
        return this;
    }

    @ApiModelProperty(value="Depending on the \"authenticationType\". This version can be used by differentiating authentication tools used within performing OTP generation in the same authentication type. This version can be referred to in the ASPSP?s documentation. ")
    @JsonProperty(value="authenticationVersion")
    public String getAuthenticationVersion() {
        return this.authenticationVersion;
    }

    public void setAuthenticationVersion(String authenticationVersion) {
        this.authenticationVersion = authenticationVersion;
    }

    public AuthenticationObject authenticationMethodId(String authenticationMethodId) {
        this.authenticationMethodId = authenticationMethodId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Size(max=35)
    @JsonProperty(value="authenticationMethodId")
    public @NotNull @Size(max=35) String getAuthenticationMethodId() {
        return this.authenticationMethodId;
    }

    public void setAuthenticationMethodId(String authenticationMethodId) {
        this.authenticationMethodId = authenticationMethodId;
    }

    public AuthenticationObject name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="SMS OTP on phone +49160 xxxxx 28", value="This is the name of the authentication method defined by the PSU in the Online Banking frontend of the ASPSP. Alternatively this could be a description provided by the ASPSP like \"SMS OTP on phone +49160 xxxxx 28\". This name shall be used by the TPP when presenting a list of authentication methods to the PSU, if available. ")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public AuthenticationObject explanation(String explanation) {
        this.explanation = explanation;
        return this;
    }

    @ApiModelProperty(example="Detailed information about the SCA method for the PSU.", value="Detailed information about the SCA method for the PSU. ")
    @JsonProperty(value="explanation")
    public String getExplanation() {
        return this.explanation;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationObject authenticationObject = (AuthenticationObject)o;
        return Objects.equals(this.authenticationType, authenticationObject.authenticationType) && Objects.equals(this.authenticationVersion, authenticationObject.authenticationVersion) && Objects.equals(this.authenticationMethodId, authenticationObject.authenticationMethodId) && Objects.equals(this.name, authenticationObject.name) && Objects.equals(this.explanation, authenticationObject.explanation);
    }

    public int hashCode() {
        return Objects.hash(this.authenticationType, this.authenticationVersion, this.authenticationMethodId, this.name, this.explanation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthenticationObject {\n");
        sb.append("    authenticationType: ").append(this.toIndentedString(this.authenticationType)).append("\n");
        sb.append("    authenticationVersion: ").append(this.toIndentedString(this.authenticationVersion)).append("\n");
        sb.append("    authenticationMethodId: ").append(this.toIndentedString(this.authenticationMethodId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    explanation: ").append(this.toIndentedString(this.explanation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

