/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.AdditionalInformationAccess;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Requested access services for a consent. ")
@Validated
public class AccountAccess {
    @JsonProperty(value="accounts")
    @Valid
    private List<AccountReference> accounts = null;
    @JsonProperty(value="balances")
    @Valid
    private List<AccountReference> balances = null;
    @JsonProperty(value="transactions")
    @Valid
    private List<AccountReference> transactions = null;
    @JsonProperty(value="availableAccounts")
    private AvailableAccountsEnum availableAccounts = null;
    @JsonProperty(value="availableAccountsWithBalance")
    private AvailableAccountsWithBalanceEnum availableAccountsWithBalance = null;
    @JsonProperty(value="allPsd2")
    private AllPsd2Enum allPsd2 = null;
    @JsonProperty(value="additionalAccountInformation")
    private AdditionalInformationAccess additionalAccountInformation = null;

    public AccountAccess accounts(List<AccountReference> accounts) {
        this.accounts = accounts;
        return this;
    }

    public AccountAccess addAccountsItem(AccountReference accountsItem) {
        if (this.accounts == null) {
            this.accounts = new ArrayList<AccountReference>();
        }
        this.accounts.add(accountsItem);
        return this;
    }

    @ApiModelProperty(value="Is asking for detailed account information.  If the array is empty, the TPP is asking for an accessible account list. This may be restricted in a PSU/ASPSP authorization dialogue. If the array is empty, also the arrays for balances or transactions shall be empty, if used. ")
    @Valid
    @JsonProperty(value="accounts")
    public List<AccountReference> getAccounts() {
        return this.accounts;
    }

    public void setAccounts(List<AccountReference> accounts) {
        this.accounts = accounts;
    }

    public AccountAccess balances(List<AccountReference> balances) {
        this.balances = balances;
        return this;
    }

    public AccountAccess addBalancesItem(AccountReference balancesItem) {
        if (this.balances == null) {
            this.balances = new ArrayList<AccountReference>();
        }
        this.balances.add(balancesItem);
        return this;
    }

    @ApiModelProperty(value="Is asking for balances of the addressed accounts.  If the array is empty, the TPP is asking for the balances of all accessible account lists. This may be restricted in a PSU/ASPSP authorization dialogue. If the array is empty, also the arrays for accounts or transactions shall be empty, if used. ")
    @Valid
    @JsonProperty(value="balances")
    public List<AccountReference> getBalances() {
        return this.balances;
    }

    public void setBalances(List<AccountReference> balances) {
        this.balances = balances;
    }

    public AccountAccess transactions(List<AccountReference> transactions) {
        this.transactions = transactions;
        return this;
    }

    public AccountAccess addTransactionsItem(AccountReference transactionsItem) {
        if (this.transactions == null) {
            this.transactions = new ArrayList<AccountReference>();
        }
        this.transactions.add(transactionsItem);
        return this;
    }

    @ApiModelProperty(value="Is asking for transactions of the addressed accounts.  If the array is empty, the TPP is asking for the transactions of all accessible account lists. This may be restricted in a PSU/ASPSP authorization dialogue. If the array is empty, also the arrays for accounts or balances shall be empty, if used. ")
    @Valid
    @JsonProperty(value="transactions")
    public List<AccountReference> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<AccountReference> transactions) {
        this.transactions = transactions;
    }

    public AccountAccess availableAccounts(AvailableAccountsEnum availableAccounts) {
        this.availableAccounts = availableAccounts;
        return this;
    }

    @ApiModelProperty(value="Optional if supported by API provider.  Only the value \"allAccounts\" is admitted. ")
    @JsonProperty(value="availableAccounts")
    public AvailableAccountsEnum getAvailableAccounts() {
        return this.availableAccounts;
    }

    public void setAvailableAccounts(AvailableAccountsEnum availableAccounts) {
        this.availableAccounts = availableAccounts;
    }

    public AccountAccess availableAccountsWithBalance(AvailableAccountsWithBalanceEnum availableAccountsWithBalance) {
        this.availableAccountsWithBalance = availableAccountsWithBalance;
        return this;
    }

    @ApiModelProperty(value="Optional if supported by API provider.  Only the value \"allAccounts\" is admitted. ")
    @JsonProperty(value="availableAccountsWithBalance")
    public AvailableAccountsWithBalanceEnum getAvailableAccountsWithBalance() {
        return this.availableAccountsWithBalance;
    }

    public void setAvailableAccountsWithBalance(AvailableAccountsWithBalanceEnum availableAccountsWithBalance) {
        this.availableAccountsWithBalance = availableAccountsWithBalance;
    }

    public AccountAccess allPsd2(AllPsd2Enum allPsd2) {
        this.allPsd2 = allPsd2;
        return this;
    }

    @ApiModelProperty(value="Optional if supported by API provider.  Only the value \"allAccounts\" is admitted. ")
    @JsonProperty(value="allPsd2")
    public AllPsd2Enum getAllPsd2() {
        return this.allPsd2;
    }

    public void setAllPsd2(AllPsd2Enum allPsd2) {
        this.allPsd2 = allPsd2;
    }

    public AccountAccess additionalAccountInformation(AdditionalInformationAccess additionalAccountInformation) {
        this.additionalAccountInformation = additionalAccountInformation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="additionalAccountInformation")
    public AdditionalInformationAccess getAdditionalAccountInformation() {
        return this.additionalAccountInformation;
    }

    public void setAdditionalAccountInformation(AdditionalInformationAccess additionalAccountInformation) {
        this.additionalAccountInformation = additionalAccountInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountAccess accountAccess = (AccountAccess)o;
        return Objects.equals(this.accounts, accountAccess.accounts) && Objects.equals(this.balances, accountAccess.balances) && Objects.equals(this.transactions, accountAccess.transactions) && Objects.equals((Object)this.availableAccounts, (Object)accountAccess.availableAccounts) && Objects.equals((Object)this.availableAccountsWithBalance, (Object)accountAccess.availableAccountsWithBalance) && Objects.equals((Object)this.allPsd2, (Object)accountAccess.allPsd2) && Objects.equals(this.additionalAccountInformation, accountAccess.additionalAccountInformation);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accounts, this.balances, this.transactions, this.availableAccounts, this.availableAccountsWithBalance, this.allPsd2, this.additionalAccountInformation});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountAccess {\n");
        sb.append("    accounts: ").append(this.toIndentedString(this.accounts)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    transactions: ").append(this.toIndentedString(this.transactions)).append("\n");
        sb.append("    availableAccounts: ").append(this.toIndentedString((Object)this.availableAccounts)).append("\n");
        sb.append("    availableAccountsWithBalance: ").append(this.toIndentedString((Object)this.availableAccountsWithBalance)).append("\n");
        sb.append("    allPsd2: ").append(this.toIndentedString((Object)this.allPsd2)).append("\n");
        sb.append("    additionalAccountInformation: ").append(this.toIndentedString(this.additionalAccountInformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AllPsd2Enum {
        ALLACCOUNTS("allAccounts");

        private String value;

        private AllPsd2Enum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AllPsd2Enum fromValue(String text) {
            for (AllPsd2Enum b : AllPsd2Enum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AvailableAccountsWithBalanceEnum {
        ALLACCOUNTS("allAccounts");

        private String value;

        private AvailableAccountsWithBalanceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AvailableAccountsWithBalanceEnum fromValue(String text) {
            for (AvailableAccountsWithBalanceEnum b : AvailableAccountsWithBalanceEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum AvailableAccountsEnum {
        ALLACCOUNTS("allAccounts");

        private String value;

        private AvailableAccountsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AvailableAccountsEnum fromValue(String text) {
            for (AvailableAccountsEnum b : AvailableAccountsEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

