/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.HrefType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Objects;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A list of hyperlinks to be recognised by the TPP. The actual hyperlinks used in the  response depend on the dynamical decisions of the ASPSP when processing the request.  **Remark:** All links can be relative or full links, to be decided by the ASPSP.  Type of links admitted in this response, (further links might be added for ASPSP defined  extensions):  - 'scaRedirect':    In case of an SCA Redirect Approach, the ASPSP is transmitting the link to which to    redirect the PSU browser. - 'scaOAuth':    In case of a SCA OAuth2 Approach, the ASPSP is transmitting the URI where the configuration of the Authorisation Server can be retrieved. The configuration follows the OAuth 2.0 Authorisation Server Metadata specification. - 'updatePsuIdentification':    The link to the authorisation or cancellation authorisation sub-resource,    where PSU identification data needs to be uploaded. - 'startAuthorisationWithPsuAuthentication':   The link to the authorisation or cancellation authorisation sub-resource,    where PSU authentication data needs to be uploaded. - 'startAuthorisationWithEncryptedPsuAuthentication':     Same as startAuthorisactionWithPsuAuthentication where the authentication data need to be encrypted on      application layer in uploading. - 'selectAuthenticationMethod':   The link to the authorisation or cancellation authorisation sub-resource,    where the selected authentication method needs to be uploaded.    This link is contained under exactly the same conditions as the data element 'scaMethods'. - 'authoriseTransaction':   The link to the authorisation or cancellation authorisation sub-resource,    where the authorisation data has to be uploaded, e.g. the TOP received by SMS.  - 'scaStatus':    The link to retrieve the scaStatus of the corresponding authorisation sub-resource.  ")
@Validated
public class LinksStartScaProcess
extends HashMap<String, HrefType> {
    @JsonProperty(value="scaRedirect")
    private HrefType scaRedirect = null;
    @JsonProperty(value="scaOAuth")
    private HrefType scaOAuth = null;
    @JsonProperty(value="updatePsuIdentification")
    private HrefType updatePsuIdentification = null;
    @JsonProperty(value="startAuthorisationWithPsuAuthentication")
    private HrefType startAuthorisationWithPsuAuthentication = null;
    @JsonProperty(value="startAuthorisationWithEncryptedPsuAuthentication")
    private HrefType startAuthorisationWithEncryptedPsuAuthentication = null;
    @JsonProperty(value="selectAuthenticationMethod")
    private HrefType selectAuthenticationMethod = null;
    @JsonProperty(value="authoriseTransaction")
    private HrefType authoriseTransaction = null;
    @JsonProperty(value="scaStatus")
    private HrefType scaStatus = null;
    @JsonProperty(value="confirmation")
    private HrefType confirmation = null;

    public LinksStartScaProcess scaRedirect(HrefType scaRedirect) {
        this.scaRedirect = scaRedirect;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scaRedirect")
    public HrefType getScaRedirect() {
        return this.scaRedirect;
    }

    public void setScaRedirect(HrefType scaRedirect) {
        this.scaRedirect = scaRedirect;
    }

    public LinksStartScaProcess scaOAuth(HrefType scaOAuth) {
        this.scaOAuth = scaOAuth;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scaOAuth")
    public HrefType getScaOAuth() {
        return this.scaOAuth;
    }

    public void setScaOAuth(HrefType scaOAuth) {
        this.scaOAuth = scaOAuth;
    }

    public LinksStartScaProcess updatePsuIdentification(HrefType updatePsuIdentification) {
        this.updatePsuIdentification = updatePsuIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="updatePsuIdentification")
    public HrefType getUpdatePsuIdentification() {
        return this.updatePsuIdentification;
    }

    public void setUpdatePsuIdentification(HrefType updatePsuIdentification) {
        this.updatePsuIdentification = updatePsuIdentification;
    }

    public LinksStartScaProcess startAuthorisationWithPsuAuthentication(HrefType startAuthorisationWithPsuAuthentication) {
        this.startAuthorisationWithPsuAuthentication = startAuthorisationWithPsuAuthentication;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="startAuthorisationWithPsuAuthentication")
    public HrefType getStartAuthorisationWithPsuAuthentication() {
        return this.startAuthorisationWithPsuAuthentication;
    }

    public void setStartAuthorisationWithPsuAuthentication(HrefType startAuthorisationWithPsuAuthentication) {
        this.startAuthorisationWithPsuAuthentication = startAuthorisationWithPsuAuthentication;
    }

    public LinksStartScaProcess startAuthorisationWithEncryptedPsuAuthentication(HrefType startAuthorisationWithEncryptedPsuAuthentication) {
        this.startAuthorisationWithEncryptedPsuAuthentication = startAuthorisationWithEncryptedPsuAuthentication;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="startAuthorisationWithEncryptedPsuAuthentication")
    public HrefType getStartAuthorisationWithEncryptedPsuAuthentication() {
        return this.startAuthorisationWithEncryptedPsuAuthentication;
    }

    public void setStartAuthorisationWithEncryptedPsuAuthentication(HrefType startAuthorisationWithEncryptedPsuAuthentication) {
        this.startAuthorisationWithEncryptedPsuAuthentication = startAuthorisationWithEncryptedPsuAuthentication;
    }

    public LinksStartScaProcess selectAuthenticationMethod(HrefType selectAuthenticationMethod) {
        this.selectAuthenticationMethod = selectAuthenticationMethod;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="selectAuthenticationMethod")
    public HrefType getSelectAuthenticationMethod() {
        return this.selectAuthenticationMethod;
    }

    public void setSelectAuthenticationMethod(HrefType selectAuthenticationMethod) {
        this.selectAuthenticationMethod = selectAuthenticationMethod;
    }

    public LinksStartScaProcess authoriseTransaction(HrefType authoriseTransaction) {
        this.authoriseTransaction = authoriseTransaction;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="authoriseTransaction")
    public HrefType getAuthoriseTransaction() {
        return this.authoriseTransaction;
    }

    public void setAuthoriseTransaction(HrefType authoriseTransaction) {
        this.authoriseTransaction = authoriseTransaction;
    }

    public LinksStartScaProcess scaStatus(HrefType scaStatus) {
        this.scaStatus = scaStatus;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="scaStatus")
    public HrefType getScaStatus() {
        return this.scaStatus;
    }

    public void setScaStatus(HrefType scaStatus) {
        this.scaStatus = scaStatus;
    }

    public LinksStartScaProcess confirmation(HrefType confirmation) {
        this.confirmation = confirmation;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="confirmation")
    public HrefType getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(HrefType confirmation) {
        this.confirmation = confirmation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LinksStartScaProcess _linksStartScaProcess = (LinksStartScaProcess)o;
        return Objects.equals(this.scaRedirect, _linksStartScaProcess.scaRedirect) && Objects.equals(this.scaOAuth, _linksStartScaProcess.scaOAuth) && Objects.equals(this.updatePsuIdentification, _linksStartScaProcess.updatePsuIdentification) && Objects.equals(this.startAuthorisationWithPsuAuthentication, _linksStartScaProcess.startAuthorisationWithPsuAuthentication) && Objects.equals(this.startAuthorisationWithEncryptedPsuAuthentication, _linksStartScaProcess.startAuthorisationWithEncryptedPsuAuthentication) && Objects.equals(this.selectAuthenticationMethod, _linksStartScaProcess.selectAuthenticationMethod) && Objects.equals(this.authoriseTransaction, _linksStartScaProcess.authoriseTransaction) && Objects.equals(this.scaStatus, _linksStartScaProcess.scaStatus) && Objects.equals(this.confirmation, _linksStartScaProcess.confirmation);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.scaRedirect, this.scaOAuth, this.updatePsuIdentification, this.startAuthorisationWithPsuAuthentication, this.startAuthorisationWithEncryptedPsuAuthentication, this.selectAuthenticationMethod, this.authoriseTransaction, this.scaStatus, this.confirmation, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinksStartScaProcess {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    scaRedirect: ").append(this.toIndentedString(this.scaRedirect)).append("\n");
        sb.append("    scaOAuth: ").append(this.toIndentedString(this.scaOAuth)).append("\n");
        sb.append("    updatePsuIdentification: ").append(this.toIndentedString(this.updatePsuIdentification)).append("\n");
        sb.append("    startAuthorisationWithPsuAuthentication: ").append(this.toIndentedString(this.startAuthorisationWithPsuAuthentication)).append("\n");
        sb.append("    startAuthorisationWithEncryptedPsuAuthentication: ").append(this.toIndentedString(this.startAuthorisationWithEncryptedPsuAuthentication)).append("\n");
        sb.append("    selectAuthenticationMethod: ").append(this.toIndentedString(this.selectAuthenticationMethod)).append("\n");
        sb.append("    authoriseTransaction: ").append(this.toIndentedString(this.authoriseTransaction)).append("\n");
        sb.append("    scaStatus: ").append(this.toIndentedString(this.scaStatus)).append("\n");
        sb.append("    confirmation: ").append(this.toIndentedString(this.confirmation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

