/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.TransactionStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Generic JSON response body consistion of the corresponding payment initation JSON body together with an optional transaction status field. ")
@Validated
public class PaymentInitiationWithStatusResponse {
    @JsonProperty(value="endToEndIdentification")
    private String endToEndIdentification = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="instructedAmount")
    private Amount instructedAmount = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="creditorAgent")
    private String creditorAgent = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAddress")
    private Address creditorAddress = null;
    @JsonProperty(value="remittanceInformationUnstructured")
    private String remittanceInformationUnstructured = null;
    @JsonProperty(value="transactionStatus")
    private TransactionStatus transactionStatus = null;

    public PaymentInitiationWithStatusResponse endToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="endToEndIdentification")
    public @Size(max=35) String getEndToEndIdentification() {
        return this.endToEndIdentification;
    }

    public void setEndToEndIdentification(String endToEndIdentification) {
        this.endToEndIdentification = endToEndIdentification;
    }

    public PaymentInitiationWithStatusResponse debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="debtorAccount")
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public PaymentInitiationWithStatusResponse instructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="instructedAmount")
    public Amount getInstructedAmount() {
        return this.instructedAmount;
    }

    public void setInstructedAmount(Amount instructedAmount) {
        this.instructedAmount = instructedAmount;
    }

    public PaymentInitiationWithStatusResponse creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="creditorAccount")
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public PaymentInitiationWithStatusResponse creditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    @JsonProperty(value="creditorAgent")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public PaymentInitiationWithStatusResponse creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Size(max=70)
    @JsonProperty(value="creditorName")
    public @NotNull @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public PaymentInitiationWithStatusResponse creditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="creditorAddress")
    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public PaymentInitiationWithStatusResponse remittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    @JsonProperty(value="remittanceInformationUnstructured")
    public @Size(max=140) String getRemittanceInformationUnstructured() {
        return this.remittanceInformationUnstructured;
    }

    public void setRemittanceInformationUnstructured(String remittanceInformationUnstructured) {
        this.remittanceInformationUnstructured = remittanceInformationUnstructured;
    }

    public PaymentInitiationWithStatusResponse transactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="transactionStatus")
    public TransactionStatus getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(TransactionStatus transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInitiationWithStatusResponse paymentInitiationWithStatusResponse = (PaymentInitiationWithStatusResponse)o;
        return Objects.equals(this.endToEndIdentification, paymentInitiationWithStatusResponse.endToEndIdentification) && Objects.equals(this.debtorAccount, paymentInitiationWithStatusResponse.debtorAccount) && Objects.equals(this.instructedAmount, paymentInitiationWithStatusResponse.instructedAmount) && Objects.equals(this.creditorAccount, paymentInitiationWithStatusResponse.creditorAccount) && Objects.equals(this.creditorAgent, paymentInitiationWithStatusResponse.creditorAgent) && Objects.equals(this.creditorName, paymentInitiationWithStatusResponse.creditorName) && Objects.equals(this.creditorAddress, paymentInitiationWithStatusResponse.creditorAddress) && Objects.equals(this.remittanceInformationUnstructured, paymentInitiationWithStatusResponse.remittanceInformationUnstructured) && Objects.equals((Object)this.transactionStatus, (Object)paymentInitiationWithStatusResponse.transactionStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.endToEndIdentification, this.debtorAccount, this.instructedAmount, this.creditorAccount, this.creditorAgent, this.creditorName, this.creditorAddress, this.remittanceInformationUnstructured, this.transactionStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInitiationWithStatusResponse {\n");
        sb.append("    endToEndIdentification: ").append(this.toIndentedString(this.endToEndIdentification)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    instructedAmount: ").append(this.toIndentedString(this.instructedAmount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAddress: ").append(this.toIndentedString(this.creditorAddress)).append("\n");
        sb.append("    remittanceInformationUnstructured: ").append(this.toIndentedString(this.remittanceInformationUnstructured)).append("\n");
        sb.append("    transactionStatus: ").append(this.toIndentedString((Object)this.transactionStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

