/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Reference to an account by either   * IBAN, of a payment accounts, or   * BBAN, for payment accounts if there is no IBAN, or    * the Primary Account Number (PAN) of a card, can be tokenised by the ASPSP due to PCI DSS requirements, or   * the Primary Account Number (PAN) of a card in a masked form, or   * an alias to access a payment account via a registered mobile phone number (MSISDN). ")
@Validated
public class AccountReference {
    @JsonProperty(value="iban")
    private String iban = null;
    @JsonProperty(value="bban")
    private String bban = null;
    @JsonProperty(value="pan")
    private String pan = null;
    @JsonProperty(value="maskedPan")
    private String maskedPan = null;
    @JsonProperty(value="msisdn")
    private String msisdn = null;
    @JsonProperty(value="currency")
    private String currency = null;

    public AccountReference iban(String iban) {
        this.iban = iban;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{2,2}[0-9]{2,2}[a-zA-Z0-9]{1,30}")
    @JsonProperty(value="iban")
    public @Pattern(regexp="[A-Z]{2,2}[0-9]{2,2}[a-zA-Z0-9]{1,30}") String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public AccountReference bban(String bban) {
        this.bban = bban;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[a-zA-Z0-9]{1,30}")
    @JsonProperty(value="bban")
    public @Pattern(regexp="[a-zA-Z0-9]{1,30}") String getBban() {
        return this.bban;
    }

    public void setBban(String bban) {
        this.bban = bban;
    }

    public AccountReference pan(String pan) {
        this.pan = pan;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="pan")
    public @Size(max=35) String getPan() {
        return this.pan;
    }

    public void setPan(String pan) {
        this.pan = pan;
    }

    public AccountReference maskedPan(String maskedPan) {
        this.maskedPan = maskedPan;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="maskedPan")
    public @Size(max=35) String getMaskedPan() {
        return this.maskedPan;
    }

    public void setMaskedPan(String maskedPan) {
        this.maskedPan = maskedPan;
    }

    public AccountReference msisdn(String msisdn) {
        this.msisdn = msisdn;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="msisdn")
    public @Size(max=35) String getMsisdn() {
        return this.msisdn;
    }

    public void setMsisdn(String msisdn) {
        this.msisdn = msisdn;
    }

    public AccountReference currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{3}")
    @JsonProperty(value="currency")
    public @Pattern(regexp="[A-Z]{3}") String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountReference accountReference = (AccountReference)o;
        return Objects.equals(this.iban, accountReference.iban) && Objects.equals(this.bban, accountReference.bban) && Objects.equals(this.pan, accountReference.pan) && Objects.equals(this.maskedPan, accountReference.maskedPan) && Objects.equals(this.msisdn, accountReference.msisdn) && Objects.equals(this.currency, accountReference.currency);
    }

    public int hashCode() {
        return Objects.hash(this.iban, this.bban, this.pan, this.maskedPan, this.msisdn, this.currency);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountReference {\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    bban: ").append(this.toIndentedString(this.bban)).append("\n");
        sb.append("    pan: ").append(this.toIndentedString(this.pan)).append("\n");
        sb.append("    maskedPan: ").append(this.toIndentedString(this.maskedPan)).append("\n");
        sb.append("    msisdn: ").append(this.toIndentedString(this.msisdn)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

