/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.Error400PISAdditionalErrors;
import de.adorsys.psd2.model.MessageCode400PIS;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Standardised definition of reporting error information according to [RFC7807]  in case of a HTTP error code 400 for PIS. ")
@Validated
public class Error400PIS {
    @JsonProperty(value="type")
    private String type = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="detail")
    private String detail = null;
    @JsonProperty(value="code")
    private MessageCode400PIS code = null;
    @JsonProperty(value="additionalErrors")
    @Valid
    private List<Error400PISAdditionalErrors> additionalErrors = null;
    @JsonProperty(value="_links")
    private Map _links = null;

    public Error400PIS type(String type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="A URI reference [RFC3986] that identifies the problem type.  Remark For Future: These URI will be provided by NextGenPSD2 in future. ")
    @NotNull
    @Size(max=70)
    @JsonProperty(value="type")
    public @NotNull @Size(max=70) String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Error400PIS title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Short human readable description of error type.  Could be in local language.  To be provided by ASPSPs. ")
    @Size(max=70)
    @JsonProperty(value="title")
    public @Size(max=70) String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Error400PIS detail(String detail) {
        this.detail = detail;
        return this;
    }

    @ApiModelProperty(value="Detailed human readable text specific to this instance of the error.  XPath might be used to point to the issue generating the error in addition. Remark for Future: In future, a dedicated field might be introduced for the XPath. ")
    @Size(max=512)
    @JsonProperty(value="detail")
    public @Size(max=512) String getDetail() {
        return this.detail;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public Error400PIS code(MessageCode400PIS code) {
        this.code = code;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="code")
    public MessageCode400PIS getCode() {
        return this.code;
    }

    public void setCode(MessageCode400PIS code) {
        this.code = code;
    }

    public Error400PIS additionalErrors(List<Error400PISAdditionalErrors> additionalErrors) {
        this.additionalErrors = additionalErrors;
        return this;
    }

    public Error400PIS addAdditionalErrorsItem(Error400PISAdditionalErrors additionalErrorsItem) {
        if (this.additionalErrors == null) {
            this.additionalErrors = new ArrayList<Error400PISAdditionalErrors>();
        }
        this.additionalErrors.add(additionalErrorsItem);
        return this;
    }

    @ApiModelProperty(value="Array of Error Information Blocks.  Might be used if more than one error is to be communicated ")
    @Valid
    @JsonProperty(value="additionalErrors")
    public List<Error400PISAdditionalErrors> getAdditionalErrors() {
        return this.additionalErrors;
    }

    public void setAdditionalErrors(List<Error400PISAdditionalErrors> additionalErrors) {
        this.additionalErrors = additionalErrors;
    }

    public Error400PIS _links(Map _links) {
        this._links = _links;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="_links")
    public Map getLinks() {
        return this._links;
    }

    public void setLinks(Map _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error400PIS error400PIS = (Error400PIS)o;
        return Objects.equals(this.type, error400PIS.type) && Objects.equals(this.title, error400PIS.title) && Objects.equals(this.detail, error400PIS.detail) && Objects.equals((Object)this.code, (Object)error400PIS.code) && Objects.equals(this.additionalErrors, error400PIS.additionalErrors) && Objects.equals(this._links, error400PIS._links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.title, this.detail, this.code, this.additionalErrors, this._links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error400PIS {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    code: ").append(this.toIndentedString((Object)this.code)).append("\n");
        sb.append("    additionalErrors: ").append(this.toIndentedString(this.additionalErrors)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

