/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@Validated
public class Address {
    @JsonProperty(value="street")
    private String street = null;
    @JsonProperty(value="buildingNumber")
    private String buildingNumber = null;
    @JsonProperty(value="city")
    private String city = null;
    @JsonProperty(value="postalCode")
    private String postalCode = null;
    @JsonProperty(value="country")
    private String country = null;

    public Address street(String street) {
        this.street = street;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="street")
    public @Size(max=70) String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public Address buildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="buildingNumber")
    public String getBuildingNumber() {
        return this.buildingNumber;
    }

    public void setBuildingNumber(String buildingNumber) {
        this.buildingNumber = buildingNumber;
    }

    public Address city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="city")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public Address postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="postalCode")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public Address country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Pattern(regexp="[A-Z]{2}")
    @JsonProperty(value="country")
    public @NotNull @Pattern(regexp="[A-Z]{2}") String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.street, address.street) && Objects.equals(this.buildingNumber, address.buildingNumber) && Objects.equals(this.city, address.city) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.country, address.country);
    }

    public int hashCode() {
        return Objects.hash(this.street, this.buildingNumber, this.city, this.postalCode, this.country);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Address {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    buildingNumber: ").append(this.toIndentedString(this.buildingNumber)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

