/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Exchange Rate.")
@Validated
public class ReportExchangeRate {
    @JsonProperty(value="sourceCurrency")
    private String sourceCurrency = null;
    @JsonProperty(value="exchangeRate")
    private String exchangeRate = null;
    @JsonProperty(value="unitCurrency")
    private String unitCurrency = null;
    @JsonProperty(value="targetCurrency")
    private String targetCurrency = null;
    @JsonProperty(value="quotationDate")
    private LocalDate quotationDate = null;
    @JsonProperty(value="contractIdentification")
    private String contractIdentification = null;

    public ReportExchangeRate sourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Pattern(regexp="[A-Z]{3}")
    @JsonProperty(value="sourceCurrency")
    public @NotNull @Pattern(regexp="[A-Z]{3}") String getSourceCurrency() {
        return this.sourceCurrency;
    }

    public void setSourceCurrency(String sourceCurrency) {
        this.sourceCurrency = sourceCurrency;
    }

    public ReportExchangeRate exchangeRate(String exchangeRate) {
        this.exchangeRate = exchangeRate;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @JsonProperty(value="exchangeRate")
    public String getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(String exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public ReportExchangeRate unitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Pattern(regexp="[A-Z]{3}")
    @JsonProperty(value="unitCurrency")
    public @NotNull @Pattern(regexp="[A-Z]{3}") String getUnitCurrency() {
        return this.unitCurrency;
    }

    public void setUnitCurrency(String unitCurrency) {
        this.unitCurrency = unitCurrency;
    }

    public ReportExchangeRate targetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Pattern(regexp="[A-Z]{3}")
    @JsonProperty(value="targetCurrency")
    public @NotNull @Pattern(regexp="[A-Z]{3}") String getTargetCurrency() {
        return this.targetCurrency;
    }

    public void setTargetCurrency(String targetCurrency) {
        this.targetCurrency = targetCurrency;
    }

    public ReportExchangeRate quotationDate(LocalDate quotationDate) {
        this.quotationDate = quotationDate;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="quotationDate")
    public LocalDate getQuotationDate() {
        return this.quotationDate;
    }

    public void setQuotationDate(LocalDate quotationDate) {
        this.quotationDate = quotationDate;
    }

    public ReportExchangeRate contractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="contractIdentification")
    public @Size(max=35) String getContractIdentification() {
        return this.contractIdentification;
    }

    public void setContractIdentification(String contractIdentification) {
        this.contractIdentification = contractIdentification;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReportExchangeRate reportExchangeRate = (ReportExchangeRate)o;
        return Objects.equals(this.sourceCurrency, reportExchangeRate.sourceCurrency) && Objects.equals(this.exchangeRate, reportExchangeRate.exchangeRate) && Objects.equals(this.unitCurrency, reportExchangeRate.unitCurrency) && Objects.equals(this.targetCurrency, reportExchangeRate.targetCurrency) && Objects.equals(this.quotationDate, reportExchangeRate.quotationDate) && Objects.equals(this.contractIdentification, reportExchangeRate.contractIdentification);
    }

    public int hashCode() {
        return Objects.hash(this.sourceCurrency, this.exchangeRate, this.unitCurrency, this.targetCurrency, this.quotationDate, this.contractIdentification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReportExchangeRate {\n");
        sb.append("    sourceCurrency: ").append(this.toIndentedString(this.sourceCurrency)).append("\n");
        sb.append("    exchangeRate: ").append(this.toIndentedString(this.exchangeRate)).append("\n");
        sb.append("    unitCurrency: ").append(this.toIndentedString(this.unitCurrency)).append("\n");
        sb.append("    targetCurrency: ").append(this.toIndentedString(this.targetCurrency)).append("\n");
        sb.append("    quotationDate: ").append(this.toIndentedString(this.quotationDate)).append("\n");
        sb.append("    contractIdentification: ").append(this.toIndentedString(this.contractIdentification)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

