/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.PaymentInitiationBulkElementJson;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Generic Body for a bulk payment initation via JSON.  paymentInformationId is contained in code but commented since it is n.a.  and not all ASPSP are able to support this field now. In a later version the field will be mandatory. ")
@Validated
public class BulkPaymentInitiationJson {
    @JsonProperty(value="batchBookingPreferred")
    private Boolean batchBookingPreferred = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="requestedExecutionDate")
    private LocalDate requestedExecutionDate = null;
    @JsonProperty(value="requestedExecutionTime")
    private OffsetDateTime requestedExecutionTime = null;
    @JsonProperty(value="payments")
    @Valid
    private List<PaymentInitiationBulkElementJson> payments = new ArrayList<PaymentInitiationBulkElementJson>();
    @JsonProperty(value="debtorName")
    private String debtorName = null;

    public BulkPaymentInitiationJson batchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="batchBookingPreferred")
    public Boolean getBatchBookingPreferred() {
        return this.batchBookingPreferred;
    }

    public void setBatchBookingPreferred(Boolean batchBookingPreferred) {
        this.batchBookingPreferred = batchBookingPreferred;
    }

    public BulkPaymentInitiationJson debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="debtorAccount")
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public BulkPaymentInitiationJson requestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="requestedExecutionDate")
    public LocalDate getRequestedExecutionDate() {
        return this.requestedExecutionDate;
    }

    public void setRequestedExecutionDate(LocalDate requestedExecutionDate) {
        this.requestedExecutionDate = requestedExecutionDate;
    }

    public BulkPaymentInitiationJson requestedExecutionTime(OffsetDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="requestedExecutionTime")
    public OffsetDateTime getRequestedExecutionTime() {
        return this.requestedExecutionTime;
    }

    public void setRequestedExecutionTime(OffsetDateTime requestedExecutionTime) {
        this.requestedExecutionTime = requestedExecutionTime;
    }

    public BulkPaymentInitiationJson payments(List<PaymentInitiationBulkElementJson> payments) {
        this.payments = payments;
        return this;
    }

    public BulkPaymentInitiationJson addPaymentsItem(PaymentInitiationBulkElementJson paymentsItem) {
        this.payments.add(paymentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of generic JSON bodies payment initations for bulk payments via JSON.  Note: Some fields from single payments do not occcur in a bulk payment element ")
    @NotNull
    @Valid
    @JsonProperty(value="payments")
    public List<PaymentInitiationBulkElementJson> getPayments() {
        return this.payments;
    }

    public void setPayments(List<PaymentInitiationBulkElementJson> payments) {
        this.payments = payments;
    }

    public BulkPaymentInitiationJson debtorName(String debtorName) {
        this.debtorName = debtorName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="debtorName")
    public @Size(max=70) String getDebtorName() {
        return this.debtorName;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BulkPaymentInitiationJson bulkPaymentInitiationJson = (BulkPaymentInitiationJson)o;
        return Objects.equals(this.batchBookingPreferred, bulkPaymentInitiationJson.batchBookingPreferred) && Objects.equals(this.debtorAccount, bulkPaymentInitiationJson.debtorAccount) && Objects.equals(this.requestedExecutionDate, bulkPaymentInitiationJson.requestedExecutionDate) && Objects.equals(this.requestedExecutionTime, bulkPaymentInitiationJson.requestedExecutionTime) && Objects.equals(this.payments, bulkPaymentInitiationJson.payments) && Objects.equals(this.debtorName, bulkPaymentInitiationJson.debtorName);
    }

    public int hashCode() {
        return Objects.hash(this.batchBookingPreferred, this.debtorAccount, this.requestedExecutionDate, this.requestedExecutionTime, this.payments, this.debtorName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BulkPaymentInitiationJson {\n");
        sb.append("    batchBookingPreferred: ").append(this.toIndentedString(this.batchBookingPreferred)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    requestedExecutionDate: ").append(this.toIndentedString(this.requestedExecutionDate)).append("\n");
        sb.append("    requestedExecutionTime: ").append(this.toIndentedString(this.requestedExecutionTime)).append("\n");
        sb.append("    payments: ").append(this.toIndentedString(this.payments)).append("\n");
        sb.append("    debtorName: ").append(this.toIndentedString(this.debtorName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

