/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.api;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.psd2.model.Authorisations;
import de.adorsys.psd2.model.Error400NGSBS;
import de.adorsys.psd2.model.Error401NGSBS;
import de.adorsys.psd2.model.Error403NGSBS;
import de.adorsys.psd2.model.Error404NGSBS;
import de.adorsys.psd2.model.Error405NGSBS;
import de.adorsys.psd2.model.Error409NGSBS;
import de.adorsys.psd2.model.ScaStatusResponse;
import de.adorsys.psd2.model.SigningBasket;
import de.adorsys.psd2.model.SigningBasketResponse200;
import de.adorsys.psd2.model.SigningBasketResponse201;
import de.adorsys.psd2.model.SigningBasketStatusResponse200;
import de.adorsys.psd2.model.StartScaprocessResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value="SigningBasketsServiceSbs", description="the SigningBasketsServiceSbs API")
public interface SigningBasketApi {
    public static final Logger log = LoggerFactory.getLogger(SigningBasketApi.class);

    default public Optional<ObjectMapper> getObjectMapper() {
        return Optional.empty();
    }

    default public Optional<HttpServletRequest> getRequest() {
        return Optional.empty();
    }

    default public Optional<String> getAcceptHeader() {
        return this.getRequest().map(r -> r.getHeader("Accept"));
    }

    @ApiOperation(value="Create a signing basket resource", nickname="createSigningBasket", notes="Create a signing basket resource for authorising several transactions with one SCA method.  The resource identifications of these transactions are contained in the payload of this access method ", response=SigningBasketResponse201.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=SigningBasketResponse201.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGSBS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGSBS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGSBS.class), @ApiResponse(code=404, message="Not found", response=Error404NGSBS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGSBS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGSBS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/signing-baskets"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<SigningBasketResponse201> _createSigningBasket(@ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. If not available, the TPP shall use the IP Address used by the TPP when submitting this request. ", required=true) @RequestHeader(value="PSU-IP-Address", required=true) String psUIPAddress, @ApiParam(value="Request body for a confirmation of an establishing signing basket request. ") @Valid @RequestBody(required=false) SigningBasket body, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="This data element may be contained, if the payment initiation transaction is part of a session, i.e. combined AIS/PIS service. This then contains the consentId of the related AIS consent, which was performed prior to this payment initiation. ") @RequestHeader(value="Consent-ID", required=false) String consentID, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the parameter TPP-Decoupled-Preferred and the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ") @RequestHeader(value="TPP-Redirect-Preferred", required=false) Boolean tpPRedirectPreferred, @ApiParam(value="If it equals \"true\", the TPP prefers a decoupled SCA approach.  If it equals \"false\", the TPP prefers not to use the decoupled approach for SCA. The ASPSP will then choose between the embedded or the redirect SCA approach, depending on the choice of the SCA procedure by the TPP/PSU.  If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the parameter TPP-Redirect-Preferred and the SCA method chosen by the TPP/PSU.  The parameter might be ignored by the ASPSP. If both parameters TPP-Redirect-Preferred and TPP-Decoupled-Preferred are present and true, the request is still not rejected, but it is up to the ASPSP, which approach will actually be used.  **Remark for Future:**  TPP-Redirect-Preferred and TPP-Decoupled-Preferred will be revised in future versions, maybe merged. Currently kept separate for downward compatibility. ") @RequestHeader(value="TPP-Decoupled-Preferred", required=false) Boolean tpPDecoupledPreferred, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="If it equals \"true\", the TPP prefers to start the authorisation process separately,  e.g. because of the usage of a signing basket.  This preference might be ignored by the ASPSP, if a signing basket is not supported as functionality.  If it equals \"false\" or if the parameter is not used, there is no preference of the TPP.  This especially indicates that the TPP assumes a direct authorisation of the transaction in the next step,  without using a signing basket. ") @RequestHeader(value="TPP-Explicit-Authorisation-Preferred", required=false) Boolean tpPExplicitAuthorisationPreferred, @ApiParam(value="URI for the Endpoint of the TPP-API to which the status of the payment initiation should be sent. This header field may by ignored by the ASPSP.  For security reasons, it shall be ensured that the TPP-Notification-URI as introduced above is secured by the TPP eIDAS QWAC used for identification of the TPP. The following applies:  URIs which are provided by TPPs in TPP-Notification-URI shall comply with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate. Please note that in case of example-TPP.com as certificate entry TPP- Notification-URI like www.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications or notifications.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications would be compliant.  Wildcard definitions shall be taken into account for compliance checks by the ASPSP.  ASPSPs may respond with ASPSP-Notification-Support set to false, if the provided URIs do not comply. ") @RequestHeader(value="TPP-Notification-URI", required=false) String tpPNotificationURI, @ApiParam(value="The string has the form   status=X1, ..., Xn  where Xi is one of the constants SCA, PROCESS, LAST and where constants are not repeated. The usage of the constants supports the of following semantics:    SCA: A notification on every change of the scaStatus attribute for all related authorisation processes is preferred by the TPP.    PROCESS: A notification on all changes of consentStatus or transactionStatus attributes is preferred by the TPP.   LAST: Only a notification on the last consentStatus or transactionStatus as available in the XS2A interface is preferred by the TPP.  This header field may be ignored, if the ASPSP does not support resource notification services for the related TPP. ") @RequestHeader(value="TPP-Notification-Content-Preferred", required=false) String tpPNotificationContentPreferred, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID needs to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.createSigningBasket(xRequestID, psUIPAddress, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, consentID, tpPRedirectPreferred, tpPDecoupledPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPExplicitAuthorisationPreferred, tpPNotificationURI, tpPNotificationContentPreferred, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<SigningBasketResponse201> createSigningBasket(UUID xRequestID, String psUIPAddress, SigningBasket body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String consentID, Boolean tpPRedirectPreferred, Boolean tpPDecoupledPreferred, String tpPRedirectURI, String tpPNokRedirectURI, Boolean tpPExplicitAuthorisationPreferred, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SigningBasketsServiceSbsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Delete the signing basket", nickname="deleteSigningBasket", notes="Delete the signing basket structure as long as no (partial) authorisation has yet been applied.  The undlerying transactions are not affected by this deletion.  Remark: The signing basket as such is not deletable after a first (partial) authorisation has been applied.  Nevertheless, single transactions might be cancelled on an individual basis on the XS2A interface. ", authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=204, message="No Content"), @ApiResponse(code=400, message="Bad Request", response=Error400NGSBS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGSBS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGSBS.class), @ApiResponse(code=404, message="Not found", response=Error404NGSBS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGSBS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGSBS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/signing-baskets/{basketId}"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.DELETE})
    default public ResponseEntity<Void> _deleteSigningBasket(@ApiParam(value="This identification of the corresponding signing basket object. ", required=true) @PathVariable(value="basketId") String basketId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID needs to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.deleteSigningBasket(basketId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Void> deleteSigningBasket(String basketId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SigningBasketsServiceSbsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Returns the content of an signing basket object", nickname="getSigningBasket", notes="Returns the content of a signing basket object.", response=SigningBasketResponse200.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SigningBasketResponse200.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGSBS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGSBS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGSBS.class), @ApiResponse(code=404, message="Not found", response=Error404NGSBS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGSBS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGSBS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/signing-baskets/{basketId}"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<SigningBasketResponse200> _getSigningBasket(@ApiParam(value="This identification of the corresponding signing basket object. ", required=true) @PathVariable(value="basketId") String basketId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID needs to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getSigningBasket(basketId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<SigningBasketResponse200> getSigningBasket(String basketId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SigningBasketsServiceSbsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Get signing basket authorisation sub-resources request", nickname="getSigningBasketAuthorisation", notes="Read a list of all authorisation subresources IDs which have been created.  This function returns an array of hyperlinks to all generated authorisation sub-resources. ", response=Authorisations.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Authorisations.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGSBS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGSBS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGSBS.class), @ApiResponse(code=404, message="Not found", response=Error404NGSBS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGSBS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGSBS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/signing-baskets/{basketId}/authorisations"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<Authorisations> _getSigningBasketAuthorisation(@ApiParam(value="This identification of the corresponding signing basket object. ", required=true) @PathVariable(value="basketId") String basketId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID needs to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getSigningBasketAuthorisation(basketId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Authorisations> getSigningBasketAuthorisation(String basketId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SigningBasketsServiceSbsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Read the SCA status of the signing basket authorisation", nickname="getSigningBasketScaStatus", notes="This method returns the SCA status of a signing basket's authorisation sub-resource. ", response=ScaStatusResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=ScaStatusResponse.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGSBS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGSBS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGSBS.class), @ApiResponse(code=404, message="Not found", response=Error404NGSBS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGSBS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGSBS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/signing-baskets/{basketId}/authorisations/{authorisationId}"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<ScaStatusResponse> _getSigningBasketScaStatus(@ApiParam(value="This identification of the corresponding signing basket object. ", required=true) @PathVariable(value="basketId") String basketId, @ApiParam(value="Resource identification of the related SCA.", required=true) @PathVariable(value="authorisationId") String authorisationId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID needs to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getSigningBasketScaStatus(basketId, authorisationId, xRequestID, digest, signature, tpPSignatureCertificate, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<ScaStatusResponse> getSigningBasketScaStatus(String basketId, String authorisationId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SigningBasketsServiceSbsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Read the status of the signing basket", nickname="getSigningBasketStatus", notes="Returns the status of a signing basket object.  ", response=SigningBasketStatusResponse200.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=SigningBasketStatusResponse200.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGSBS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGSBS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGSBS.class), @ApiResponse(code=404, message="Not found", response=Error404NGSBS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGSBS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGSBS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/signing-baskets/{basketId}/status"}, produces={"application/json", "application/problem+json"}, method={RequestMethod.GET})
    default public ResponseEntity<SigningBasketStatusResponse200> _getSigningBasketStatus(@ApiParam(value="This identification of the corresponding signing basket object. ", required=true) @PathVariable(value="basketId") String basketId, @ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID needs to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.getSigningBasketStatus(basketId, xRequestID, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<SigningBasketStatusResponse200> getSigningBasketStatus(String basketId, UUID xRequestID, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SigningBasketsServiceSbsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Start the authorisation process for a signing basket", nickname="startSigningBasketAuthorisation", notes="Create an authorisation sub-resource and start the authorisation process of a signing basket.  The message might in addition transmit authentication and authorisation related data.  This method is iterated n times for a n times SCA authorisation in a  corporate context, each creating an own authorisation sub-endpoint for  the corresponding PSU authorising the signing-baskets.  The ASPSP might make the usage of this access method unnecessary in case  of only one SCA process needed, since the related authorisation resource  might be automatically created by the ASPSP after the submission of the  payment data with the first POST signing basket call.  The start authorisation process is a process which is needed for creating a new authorisation  or cancellation sub-resource.   This applies in the following scenarios:    * The ASPSP has indicated with a 'startAuthorisation' hyperlink in the preceding payment      initiation response that an explicit start of the authorisation process is needed by the TPP.      The 'startAuthorisation' hyperlink can transport more information about data which needs to be      uploaded by using the extended forms:     * 'startAuthorisationWithPsuIdentfication',      * 'startAuthorisationWithPsuAuthentication'      * 'startAuthorisationWithEncryptedPsuAuthentication'     * 'startAuthorisationWithAuthentciationMethodSelection'    * The related payment initiation cannot yet be executed since a multilevel SCA is mandated.   * The ASPSP has indicated with a 'startAuthorisation' hyperlink in the preceding      payment cancellation response that an explicit start of the authorisation process is needed by the TPP.     The 'startAuthorisation' hyperlink can transport more information about data which needs to be uploaded     by using the extended forms as indicated above.   * The related payment cancellation request cannot be applied yet since a multilevel SCA is mandate for      executing the cancellation.   * The signing basket needs to be authorised yet. ", response=StartScaprocessResponse.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=201, message="Created", response=StartScaprocessResponse.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGSBS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGSBS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGSBS.class), @ApiResponse(code=404, message="Not found", response=Error404NGSBS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGSBS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGSBS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/signing-baskets/{basketId}/authorisations"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"}, method={RequestMethod.POST})
    default public ResponseEntity<StartScaprocessResponse> _startSigningBasketAuthorisation(@ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="This identification of the corresponding signing basket object. ", required=true) @PathVariable(value="basketId") String basketId, @ApiParam(value="") @Valid @RequestBody(required=false) Object body, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="If it equals \"true\", the TPP prefers a redirect over an embedded SCA approach. If it equals \"false\", the TPP prefers not to be redirected for SCA. The ASPSP will then choose between the Embedded or the Decoupled SCA approach, depending on the parameter TPP-Decoupled-Preferred and the choice of the SCA procedure by the TPP/PSU. If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the SCA method chosen by the TPP/PSU. ") @RequestHeader(value="TPP-Redirect-Preferred", required=false) Boolean tpPRedirectPreferred, @ApiParam(value="If it equals \"true\", the TPP prefers a decoupled SCA approach.  If it equals \"false\", the TPP prefers not to use the decoupled approach for SCA. The ASPSP will then choose between the embedded or the redirect SCA approach, depending on the choice of the SCA procedure by the TPP/PSU.  If the parameter is not used, the ASPSP will choose the SCA approach to be applied depending on the parameter TPP-Redirect-Preferred and the SCA method chosen by the TPP/PSU.  The parameter might be ignored by the ASPSP. If both parameters TPP-Redirect-Preferred and TPP-Decoupled-Preferred are present and true, the request is still not rejected, but it is up to the ASPSP, which approach will actually be used.  **Remark for Future:**  TPP-Redirect-Preferred and TPP-Decoupled-Preferred will be revised in future versions, maybe merged. Currently kept separate for downward compatibility. ") @RequestHeader(value="TPP-Decoupled-Preferred", required=false) Boolean tpPDecoupledPreferred, @ApiParam(value="URI of the TPP, where the transaction flow shall be redirected to after a Redirect.  Mandated for the Redirect SCA Approach, specifically  when TPP-Redirect-Preferred equals \"true\". It is recommended to always use this header field.  **Remark for Future:**  This field might be changed to mandatory in the next version of the specification. ") @RequestHeader(value="TPP-Redirect-URI", required=false) String tpPRedirectURI, @ApiParam(value="If this URI is contained, the TPP is asking to redirect the transaction flow to this address instead of the TPP-Redirect-URI in case of a negative result of the redirect SCA method. This might be ignored by the ASPSP. ") @RequestHeader(value="TPP-Nok-Redirect-URI", required=false) String tpPNokRedirectURI, @ApiParam(value="URI for the Endpoint of the TPP-API to which the status of the payment initiation should be sent. This header field may by ignored by the ASPSP.  For security reasons, it shall be ensured that the TPP-Notification-URI as introduced above is secured by the TPP eIDAS QWAC used for identification of the TPP. The following applies:  URIs which are provided by TPPs in TPP-Notification-URI shall comply with the domain secured by the eIDAS QWAC certificate of the TPP in the field CN or SubjectAltName of the certificate. Please note that in case of example-TPP.com as certificate entry TPP- Notification-URI like www.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications or notifications.example-TPP.com/xs2a-client/v1/ASPSPidentifcation/mytransaction- id/notifications would be compliant.  Wildcard definitions shall be taken into account for compliance checks by the ASPSP.  ASPSPs may respond with ASPSP-Notification-Support set to false, if the provided URIs do not comply. ") @RequestHeader(value="TPP-Notification-URI", required=false) String tpPNotificationURI, @ApiParam(value="The string has the form   status=X1, ..., Xn  where Xi is one of the constants SCA, PROCESS, LAST and where constants are not repeated. The usage of the constants supports the of following semantics:    SCA: A notification on every change of the scaStatus attribute for all related authorisation processes is preferred by the TPP.    PROCESS: A notification on all changes of consentStatus or transactionStatus attributes is preferred by the TPP.   LAST: Only a notification on the last consentStatus or transactionStatus as available in the XS2A interface is preferred by the TPP.  This header field may be ignored, if the ASPSP does not support resource notification services for the related TPP. ") @RequestHeader(value="TPP-Notification-Content-Preferred", required=false) String tpPNotificationContentPreferred, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID needs to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.startSigningBasketAuthorisation(xRequestID, basketId, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, tpPRedirectPreferred, tpPDecoupledPreferred, tpPRedirectURI, tpPNokRedirectURI, tpPNotificationURI, tpPNotificationContentPreferred, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<StartScaprocessResponse> startSigningBasketAuthorisation(UUID xRequestID, String basketId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, Boolean tpPRedirectPreferred, Boolean tpPDecoupledPreferred, String tpPRedirectURI, String tpPNokRedirectURI, String tpPNotificationURI, String tpPNotificationContentPreferred, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SigningBasketsServiceSbsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }

    @ApiOperation(value="Update PSU data for signing basket", nickname="updateSigningBasketPsuData", notes="This method update PSU data on the signing basket resource if needed.  It may authorise a igning basket within the embedded SCA approach where needed.  Independently from the SCA Approach it supports e.g. the selection of  the authentication method and a non-SCA PSU authentication.  This methods updates PSU data on the cancellation authorisation resource if needed.   There are several possible update PSU data requests in the context of a consent request if needed,  which depends on the SCA approach:  * Redirect SCA Approach:   A specific Update PSU data request is applicable for      * the selection of authentication methods, before choosing the actual SCA approach. * Decoupled SCA Approach:   A specific Update PSU data request is only applicable for   * adding the PSU Identification, if not provided yet in the payment initiation request or the account information consent request, or if no OAuth2 access token is used, or   * the selection of authentication methods. * Embedded SCA Approach:    The update PSU data request might be used    * to add credentials as a first factor authentication data of the PSU and   * to select the authentication method and   * transaction authorisation.  The SCA approach might depend on the chosen SCA method.  For that reason, the following possible update PSU data request can apply to all SCA approaches:  * Select an SCA method in case of several SCA methods are available for the customer.  There are the following request types on this access path:   * Update PSU identification   * Update PSU authentication   * Select PSU autorization Method      WARNING: This method needs a reduced header,      therefore many optional elements are not present.      Maybe in a later version the access path will change.   * Transaction Authorisation     WARNING: This method needs a reduced header,      therefore many optional elements are not present.      Maybe in a later version the access path will change. ", response=Object.class, authorizations={@Authorization(value="BearerAuthOAuth")}, tags={})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", response=Object.class), @ApiResponse(code=400, message="Bad Request", response=Error400NGSBS.class), @ApiResponse(code=401, message="Unauthorized", response=Error401NGSBS.class), @ApiResponse(code=403, message="Forbidden", response=Error403NGSBS.class), @ApiResponse(code=404, message="Not found", response=Error404NGSBS.class), @ApiResponse(code=405, message="Method Not Allowed", response=Error405NGSBS.class), @ApiResponse(code=406, message="Not Acceptable"), @ApiResponse(code=408, message="Request Timeout"), @ApiResponse(code=409, message="Conflict", response=Error409NGSBS.class), @ApiResponse(code=415, message="Unsupported Media Type"), @ApiResponse(code=429, message="Too Many Requests"), @ApiResponse(code=500, message="Internal Server Error"), @ApiResponse(code=503, message="Service Unavailable")})
    @RequestMapping(value={"/v1/signing-baskets/{basketId}/authorisations/{authorisationId}"}, produces={"application/json", "application/problem+json"}, consumes={"application/json"}, method={RequestMethod.PUT})
    default public ResponseEntity<Object> _updateSigningBasketPsuData(@ApiParam(value="ID of the request, unique to the call, as determined by the initiating party.", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @ApiParam(value="This identification of the corresponding signing basket object. ", required=true) @PathVariable(value="basketId") String basketId, @ApiParam(value="Resource identification of the related SCA.", required=true) @PathVariable(value="authorisationId") String authorisationId, @ApiParam(value="") @Valid @RequestBody(required=false) Object body, @ApiParam(value="Is contained if and only if the \"Signature\" element is contained in the header of the request.") @RequestHeader(value="Digest", required=false) String digest, @ApiParam(value="A signature of the request by the TPP on application level. This might be mandated by ASPSP. ") @RequestHeader(value="Signature", required=false) String signature, @ApiParam(value="The certificate used for signing the request, in base64 encoding.  Must be contained if a signature is contained. ") @RequestHeader(value="TPP-Signature-Certificate", required=false) byte[] tpPSignatureCertificate, @ApiParam(value="Client ID of the PSU in the ASPSP client interface.   Might be mandated in the ASPSP's documentation.  It might be contained even if an OAuth2 based authentication was performed in a pre-step or an OAuth2 based SCA was performed in an preceding AIS service in the same session. In this case the ASPSP might check whether PSU-ID and token match,  according to ASPSP documentation. ") @RequestHeader(value="PSU-ID", required=false) String PSU_ID, @ApiParam(value="Type of the PSU-ID, needed in scenarios where PSUs have several PSU-IDs as access possibility.  In this case, the mean and use are then defined in the ASPSP\u2019s documentation. ") @RequestHeader(value="PSU-ID-Type", required=false) String psUIDType, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID", required=false) String psUCorporateID, @ApiParam(value="Might be mandated in the ASPSP's documentation. Only used in a corporate context. ") @RequestHeader(value="PSU-Corporate-ID-Type", required=false) String psUCorporateIDType, @ApiParam(value="The forwarded IP Address header field consists of the corresponding http request IP Address field between PSU and TPP. ") @RequestHeader(value="PSU-IP-Address", required=false) String psUIPAddress, @ApiParam(value="The forwarded IP Port header field consists of the corresponding HTTP request IP Port field between PSU and TPP, if available. ") @RequestHeader(value="PSU-IP-Port", required=false) String psUIPPort, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept", required=false) String psUAccept, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Charset", required=false) String psUAcceptCharset, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Encoding", required=false) String psUAcceptEncoding, @ApiParam(value="The forwarded IP Accept header fields consist of the corresponding HTTP request Accept header fields between PSU and TPP, if available. ") @RequestHeader(value="PSU-Accept-Language", required=false) String psUAcceptLanguage, @ApiParam(value="The forwarded Agent header field of the HTTP request between PSU and TPP, if available. ") @RequestHeader(value="PSU-User-Agent", required=false) String psUUserAgent, @ApiParam(value="HTTP method used at the PSU ? TPP interface, if available. Valid values are: * GET * POST * PUT * PATCH * DELETE ", allowableValues="GET, POST, PUT, PATCH, DELETE") @RequestHeader(value="PSU-Http-Method", required=false) String psUHttpMethod, @ApiParam(value="UUID (Universally Unique Identifier) for a device, which is used by the PSU, if available. UUID identifies either a device or a device dependant application installation. In case of an installation identification this ID needs to be unaltered until removal from device. ") @RequestHeader(value="PSU-Device-ID", required=false) UUID psUDeviceID, @ApiParam(value="The forwarded Geo Location of the corresponding http request between PSU and TPP if available. ") @RequestHeader(value="PSU-Geo-Location", required=false) String psUGeoLocation) {
        return this.updateSigningBasketPsuData(xRequestID, basketId, authorisationId, body, digest, signature, tpPSignatureCertificate, PSU_ID, psUIDType, psUCorporateID, psUCorporateIDType, psUIPAddress, psUIPPort, psUAccept, psUAcceptCharset, psUAcceptEncoding, psUAcceptLanguage, psUUserAgent, psUHttpMethod, psUDeviceID, psUGeoLocation);
    }

    default public ResponseEntity<Object> updateSigningBasketPsuData(UUID xRequestID, String basketId, String authorisationId, Object body, String digest, String signature, byte[] tpPSignatureCertificate, String PSU_ID, String psUIDType, String psUCorporateID, String psUCorporateIDType, String psUIPAddress, String psUIPPort, String psUAccept, String psUAcceptCharset, String psUAcceptEncoding, String psUAcceptLanguage, String psUUserAgent, String psUHttpMethod, UUID psUDeviceID, String psUGeoLocation) {
        if (!this.getObjectMapper().isPresent() || !this.getAcceptHeader().isPresent()) {
            log.warn("ObjectMapper or HttpServletRequest not configured in default SigningBasketsServiceSbsApi interface so no example is generated");
        }
        return new ResponseEntity(HttpStatus.NOT_IMPLEMENTED);
    }
}

