package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import java.util.Objects;

/**
 * Exchange Rate.
 */
@ApiModel(description = "Exchange Rate.")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2021-07-15T10:28:21.780938+03:00[Europe/Kiev]")

public class PaymentExchangeRate   {
  @JsonProperty("unitCurrency")
  private String unitCurrency = null;

  @JsonProperty("exchangeRate")
  private String exchangeRate = null;

  @JsonProperty("contractIdentification")
  private String contractIdentification = null;

  @JsonProperty("rateType")
  private ExchangeRateTypeCode rateType = null;

  public PaymentExchangeRate unitCurrency(String unitCurrency) {
    this.unitCurrency = unitCurrency;
    return this;
  }

  /**
   * Get unitCurrency
   * @return unitCurrency
  **/
  @ApiModelProperty(value = "")

@Pattern(regexp="[A-Z]{3}")

  @JsonProperty("unitCurrency")
  public String getUnitCurrency() {
    return unitCurrency;
  }

  public void setUnitCurrency(String unitCurrency) {
    this.unitCurrency = unitCurrency;
  }

  public PaymentExchangeRate exchangeRate(String exchangeRate) {
    this.exchangeRate = exchangeRate;
    return this;
  }

  /**
   * Get exchangeRate
   * @return exchangeRate
  **/
  @ApiModelProperty(value = "")



  @JsonProperty("exchangeRate")
  public String getExchangeRate() {
    return exchangeRate;
  }

  public void setExchangeRate(String exchangeRate) {
    this.exchangeRate = exchangeRate;
  }

  public PaymentExchangeRate contractIdentification(String contractIdentification) {
    this.contractIdentification = contractIdentification;
    return this;
  }

  /**
   * Get contractIdentification
   * @return contractIdentification
  **/
  @ApiModelProperty(value = "")

@Size(max=35)

  @JsonProperty("contractIdentification")
  public String getContractIdentification() {
    return contractIdentification;
  }

  public void setContractIdentification(String contractIdentification) {
    this.contractIdentification = contractIdentification;
  }

  public PaymentExchangeRate rateType(ExchangeRateTypeCode rateType) {
    this.rateType = rateType;
    return this;
  }

  /**
   * Get rateType
   * @return rateType
  **/
  @ApiModelProperty(value = "")

  @Valid


  @JsonProperty("rateType")
  public ExchangeRateTypeCode getRateType() {
    return rateType;
  }

  public void setRateType(ExchangeRateTypeCode rateType) {
    this.rateType = rateType;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
}    PaymentExchangeRate paymentExchangeRate = (PaymentExchangeRate) o;
    return Objects.equals(this.unitCurrency, paymentExchangeRate.unitCurrency) &&
    Objects.equals(this.exchangeRate, paymentExchangeRate.exchangeRate) &&
    Objects.equals(this.contractIdentification, paymentExchangeRate.contractIdentification) &&
    Objects.equals(this.rateType, paymentExchangeRate.rateType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(unitCurrency, exchangeRate, contractIdentification, rateType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentExchangeRate {\n");

    sb.append("    unitCurrency: ").append(toIndentedString(unitCurrency)).append("\n");
    sb.append("    exchangeRate: ").append(toIndentedString(exchangeRate)).append("\n");
    sb.append("    contractIdentification: ").append(toIndentedString(contractIdentification)).append("\n");
    sb.append("    rateType: ").append(toIndentedString(rateType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

