/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="In cases where the specifically defined criteria (IBAN, BBAN, MSISDN) are not provided to identify an instance of the respective account type (e.g. a savings account), the ASPSP shall include a proprietary ID of the respective account that uniquely identifies the account for this ASPSP.")
@Validated
public class OtherType {
    @JsonProperty(value="identification")
    private String identification = null;
    @JsonProperty(value="schemeNameCode")
    private String schemeNameCode = null;
    @JsonProperty(value="schemeNameProprietary")
    private String schemeNameProprietary = null;
    @JsonProperty(value="issuer")
    private String issuer = null;

    public OtherType identification(String identification) {
        this.identification = identification;
        return this;
    }

    @ApiModelProperty(required=true, value="Proprietary identification of the account.")
    @NotNull
    @Size(max=35)
    @JsonProperty(value="identification")
    public @NotNull @Size(max=35) String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String identification) {
        this.identification = identification;
    }

    public OtherType schemeNameCode(String schemeNameCode) {
        this.schemeNameCode = schemeNameCode;
        return this;
    }

    @ApiModelProperty(value="An entry provided by an external ISO code list.")
    @Size(max=35)
    @JsonProperty(value="schemeNameCode")
    public @Size(max=35) String getSchemeNameCode() {
        return this.schemeNameCode;
    }

    public void setSchemeNameCode(String schemeNameCode) {
        this.schemeNameCode = schemeNameCode;
    }

    public OtherType schemeNameProprietary(String schemeNameProprietary) {
        this.schemeNameProprietary = schemeNameProprietary;
        return this;
    }

    @ApiModelProperty(value="A scheme name defined in a proprietary way.")
    @Size(max=35)
    @JsonProperty(value="schemeNameProprietary")
    public @Size(max=35) String getSchemeNameProprietary() {
        return this.schemeNameProprietary;
    }

    public void setSchemeNameProprietary(String schemeNameProprietary) {
        this.schemeNameProprietary = schemeNameProprietary;
    }

    public OtherType issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @ApiModelProperty(value="Issuer of the identification.")
    @Size(max=35)
    @JsonProperty(value="issuer")
    public @Size(max=35) String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OtherType otherType = (OtherType)o;
        return Objects.equals(this.identification, otherType.identification) && Objects.equals(this.schemeNameCode, otherType.schemeNameCode) && Objects.equals(this.schemeNameProprietary, otherType.schemeNameProprietary) && Objects.equals(this.issuer, otherType.issuer);
    }

    public int hashCode() {
        return Objects.hash(this.identification, this.schemeNameCode, this.schemeNameProprietary, this.issuer);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OtherType {\n");
        sb.append("    identification: ").append(this.toIndentedString(this.identification)).append("\n");
        sb.append("    schemeNameCode: ").append(this.toIndentedString(this.schemeNameCode)).append("\n");
        sb.append("    schemeNameProprietary: ").append(this.toIndentedString(this.schemeNameProprietary)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

