/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Address;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Trusted Beneficiary")
@Validated
public class TrustedBeneficiary {
    @JsonProperty(value="trustedBeneficiaryId")
    private String trustedBeneficiaryId = null;
    @JsonProperty(value="debtorAccount")
    private AccountReference debtorAccount = null;
    @JsonProperty(value="creditorAccount")
    private AccountReference creditorAccount = null;
    @JsonProperty(value="creditorAgent")
    private String creditorAgent = null;
    @JsonProperty(value="creditorName")
    private String creditorName = null;
    @JsonProperty(value="creditorAlias")
    private String creditorAlias = null;
    @JsonProperty(value="creditorId")
    private String creditorId = null;
    @JsonProperty(value="creditorAddress")
    private Address creditorAddress = null;

    public TrustedBeneficiary trustedBeneficiaryId(String trustedBeneficiaryId) {
        this.trustedBeneficiaryId = trustedBeneficiaryId;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Pattern(regexp="[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}")
    @JsonProperty(value="trustedBeneficiaryId")
    public @NotNull @Pattern(regexp="[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}") String getTrustedBeneficiaryId() {
        return this.trustedBeneficiaryId;
    }

    public void setTrustedBeneficiaryId(String trustedBeneficiaryId) {
        this.trustedBeneficiaryId = trustedBeneficiaryId;
    }

    public TrustedBeneficiary debtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="debtorAccount")
    public AccountReference getDebtorAccount() {
        return this.debtorAccount;
    }

    public void setDebtorAccount(AccountReference debtorAccount) {
        this.debtorAccount = debtorAccount;
    }

    public TrustedBeneficiary creditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Valid
    @JsonProperty(value="creditorAccount")
    public AccountReference getCreditorAccount() {
        return this.creditorAccount;
    }

    public void setCreditorAccount(AccountReference creditorAccount) {
        this.creditorAccount = creditorAccount;
    }

    public TrustedBeneficiary creditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
        return this;
    }

    @ApiModelProperty(value="")
    @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}")
    @JsonProperty(value="creditorAgent")
    public @Pattern(regexp="[A-Z]{6,6}[A-Z2-9][A-NP-Z0-9]([A-Z0-9]{3,3}){0,1}") String getCreditorAgent() {
        return this.creditorAgent;
    }

    public void setCreditorAgent(String creditorAgent) {
        this.creditorAgent = creditorAgent;
    }

    public TrustedBeneficiary creditorName(String creditorName) {
        this.creditorName = creditorName;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Size(max=70)
    @JsonProperty(value="creditorName")
    public @NotNull @Size(max=70) String getCreditorName() {
        return this.creditorName;
    }

    public void setCreditorName(String creditorName) {
        this.creditorName = creditorName;
    }

    public TrustedBeneficiary creditorAlias(String creditorAlias) {
        this.creditorAlias = creditorAlias;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="creditorAlias")
    public @Size(max=70) String getCreditorAlias() {
        return this.creditorAlias;
    }

    public void setCreditorAlias(String creditorAlias) {
        this.creditorAlias = creditorAlias;
    }

    public TrustedBeneficiary creditorId(String creditorId) {
        this.creditorId = creditorId;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=35)
    @JsonProperty(value="creditorId")
    public @Size(max=35) String getCreditorId() {
        return this.creditorId;
    }

    public void setCreditorId(String creditorId) {
        this.creditorId = creditorId;
    }

    public TrustedBeneficiary creditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="creditorAddress")
    public Address getCreditorAddress() {
        return this.creditorAddress;
    }

    public void setCreditorAddress(Address creditorAddress) {
        this.creditorAddress = creditorAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrustedBeneficiary trustedBeneficiary = (TrustedBeneficiary)o;
        return Objects.equals(this.trustedBeneficiaryId, trustedBeneficiary.trustedBeneficiaryId) && Objects.equals(this.debtorAccount, trustedBeneficiary.debtorAccount) && Objects.equals(this.creditorAccount, trustedBeneficiary.creditorAccount) && Objects.equals(this.creditorAgent, trustedBeneficiary.creditorAgent) && Objects.equals(this.creditorName, trustedBeneficiary.creditorName) && Objects.equals(this.creditorAlias, trustedBeneficiary.creditorAlias) && Objects.equals(this.creditorId, trustedBeneficiary.creditorId) && Objects.equals(this.creditorAddress, trustedBeneficiary.creditorAddress);
    }

    public int hashCode() {
        return Objects.hash(this.trustedBeneficiaryId, this.debtorAccount, this.creditorAccount, this.creditorAgent, this.creditorName, this.creditorAlias, this.creditorId, this.creditorAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrustedBeneficiary {\n");
        sb.append("    trustedBeneficiaryId: ").append(this.toIndentedString(this.trustedBeneficiaryId)).append("\n");
        sb.append("    debtorAccount: ").append(this.toIndentedString(this.debtorAccount)).append("\n");
        sb.append("    creditorAccount: ").append(this.toIndentedString(this.creditorAccount)).append("\n");
        sb.append("    creditorAgent: ").append(this.toIndentedString(this.creditorAgent)).append("\n");
        sb.append("    creditorName: ").append(this.toIndentedString(this.creditorName)).append("\n");
        sb.append("    creditorAlias: ").append(this.toIndentedString(this.creditorAlias)).append("\n");
        sb.append("    creditorId: ").append(this.toIndentedString(this.creditorId)).append("\n");
        sb.append("    creditorAddress: ").append(this.toIndentedString(this.creditorAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

