/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import de.adorsys.psd2.model.AccountStatus;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.BalanceList;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="Card account details. ")
@Validated
public class CardAccountDetails {
    @JsonProperty(value="resourceId")
    private String resourceId = null;
    @JsonProperty(value="maskedPan")
    private String maskedPan = null;
    @JsonProperty(value="currency")
    private String currency = null;
    @JsonProperty(value="ownerName")
    private String ownerName = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="displayName")
    private String displayName = null;
    @JsonProperty(value="product")
    private String product = null;
    @JsonProperty(value="status")
    private AccountStatus status = null;
    @JsonProperty(value="usage")
    private UsageEnum usage = null;
    @JsonProperty(value="details")
    private String details = null;
    @JsonProperty(value="creditLimit")
    private Amount creditLimit = null;
    @JsonProperty(value="balances")
    private BalanceList balances = null;
    @JsonProperty(value="debitAccounting")
    private Boolean debitAccounting = null;
    @JsonProperty(value="_links")
    private Map _links = null;

    public CardAccountDetails resourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    @ApiModelProperty(value="This is the data element to be used in the path when retrieving data from a dedicated account. This shall be filled, if addressable resource are created by the ASPSP on the /card-accounts endpoint. ")
    @JsonProperty(value="resourceId")
    public String getResourceId() {
        return this.resourceId;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public CardAccountDetails maskedPan(String maskedPan) {
        this.maskedPan = maskedPan;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Size(max=35)
    @JsonProperty(value="maskedPan")
    public @NotNull @Size(max=35) String getMaskedPan() {
        return this.maskedPan;
    }

    public void setMaskedPan(String maskedPan) {
        this.maskedPan = maskedPan;
    }

    public CardAccountDetails currency(String currency) {
        this.currency = currency;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @NotNull
    @Pattern(regexp="[A-Z]{3}")
    @JsonProperty(value="currency")
    public @NotNull @Pattern(regexp="[A-Z]{3}") String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public CardAccountDetails ownerName(String ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=140)
    @JsonProperty(value="ownerName")
    public @Size(max=140) String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public CardAccountDetails name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="Name of the account, as assigned by the ASPSP,  in agreement with the account owner in order to provide an additional means of identification of the account. ")
    @Size(max=70)
    @JsonProperty(value="name")
    public @Size(max=70) String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CardAccountDetails displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @ApiModelProperty(value="")
    @Size(max=70)
    @JsonProperty(value="displayName")
    public @Size(max=70) String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public CardAccountDetails product(String product) {
        this.product = product;
        return this;
    }

    @ApiModelProperty(value="Product Name of the Bank for this account, proprietary definition. ")
    @Size(max=35)
    @JsonProperty(value="product")
    public @Size(max=35) String getProduct() {
        return this.product;
    }

    public void setProduct(String product) {
        this.product = product;
    }

    public CardAccountDetails status(AccountStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="status")
    public AccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(AccountStatus status) {
        this.status = status;
    }

    public CardAccountDetails usage(UsageEnum usage) {
        this.usage = usage;
        return this;
    }

    @ApiModelProperty(value="Specifies the usage of the account:   * PRIV: private personal account   * ORGA: professional account ")
    @Size(max=4)
    @JsonProperty(value="usage")
    public @Size(max=4) UsageEnum getUsage() {
        return this.usage;
    }

    public void setUsage(UsageEnum usage) {
        this.usage = usage;
    }

    public CardAccountDetails details(String details) {
        this.details = details;
        return this;
    }

    @ApiModelProperty(value="Specifications that might be provided by the ASPSP:   - characteristics of the account   - characteristics of the relevant card ")
    @Size(max=500)
    @JsonProperty(value="details")
    public @Size(max=500) String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public CardAccountDetails creditLimit(Amount creditLimit) {
        this.creditLimit = creditLimit;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="creditLimit")
    public Amount getCreditLimit() {
        return this.creditLimit;
    }

    public void setCreditLimit(Amount creditLimit) {
        this.creditLimit = creditLimit;
    }

    public CardAccountDetails balances(BalanceList balances) {
        this.balances = balances;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="balances")
    public BalanceList getBalances() {
        return this.balances;
    }

    public void setBalances(BalanceList balances) {
        this.balances = balances;
    }

    public CardAccountDetails debitAccounting(Boolean debitAccounting) {
        this.debitAccounting = debitAccounting;
        return this;
    }

    @ApiModelProperty(value="If true, the amounts of debits on the reports and balances are quoted positive. If false, the amount of debits on the reports and balances are quoted negative. ")
    @JsonProperty(value="debitAccounting")
    public Boolean isDebitAccounting() {
        return this.debitAccounting;
    }

    public void setDebitAccounting(Boolean debitAccounting) {
        this.debitAccounting = debitAccounting;
    }

    public CardAccountDetails _links(Map _links) {
        this._links = _links;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @JsonProperty(value="_links")
    public Map getLinks() {
        return this._links;
    }

    public void setLinks(Map _links) {
        this._links = _links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CardAccountDetails cardAccountDetails = (CardAccountDetails)o;
        return Objects.equals(this.resourceId, cardAccountDetails.resourceId) && Objects.equals(this.maskedPan, cardAccountDetails.maskedPan) && Objects.equals(this.currency, cardAccountDetails.currency) && Objects.equals(this.ownerName, cardAccountDetails.ownerName) && Objects.equals(this.name, cardAccountDetails.name) && Objects.equals(this.displayName, cardAccountDetails.displayName) && Objects.equals(this.product, cardAccountDetails.product) && Objects.equals((Object)this.status, (Object)cardAccountDetails.status) && Objects.equals((Object)this.usage, (Object)cardAccountDetails.usage) && Objects.equals(this.details, cardAccountDetails.details) && Objects.equals(this.creditLimit, cardAccountDetails.creditLimit) && Objects.equals(this.balances, cardAccountDetails.balances) && Objects.equals(this.debitAccounting, cardAccountDetails.debitAccounting) && Objects.equals(this._links, cardAccountDetails._links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resourceId, this.maskedPan, this.currency, this.ownerName, this.name, this.displayName, this.product, this.status, this.usage, this.details, this.creditLimit, this.balances, this.debitAccounting, this._links});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CardAccountDetails {\n");
        sb.append("    resourceId: ").append(this.toIndentedString(this.resourceId)).append("\n");
        sb.append("    maskedPan: ").append(this.toIndentedString(this.maskedPan)).append("\n");
        sb.append("    currency: ").append(this.toIndentedString(this.currency)).append("\n");
        sb.append("    ownerName: ").append(this.toIndentedString(this.ownerName)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("    product: ").append(this.toIndentedString(this.product)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    usage: ").append(this.toIndentedString((Object)this.usage)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        sb.append("    creditLimit: ").append(this.toIndentedString(this.creditLimit)).append("\n");
        sb.append("    balances: ").append(this.toIndentedString(this.balances)).append("\n");
        sb.append("    debitAccounting: ").append(this.toIndentedString(this.debitAccounting)).append("\n");
        sb.append("    _links: ").append(this.toIndentedString(this._links)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum UsageEnum {
        PRIV("PRIV"),
        ORGA("ORGA");

        private String value;

        private UsageEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static UsageEnum fromValue(String text) {
            for (UsageEnum b : UsageEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

