package de.adorsys.psd2.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.springframework.validation.annotation.Validated;

import java.util.HashMap;
import java.util.Objects;

/**
 * A list of hyperlinks to be recognised by the TPP.  Type of links admitted in this response (which might be
 * extended by single ASPSPs as indicated in its XS2A documentation):   - &#39;scaRedirect&#39;:     In case of an
 * SCA Redirect Approach, the ASPSP is transmitting the link to which to redirect the     PSU browser.   - &#39;
 * scaOAuth&#39;:     In case of an OAuth2 based Redirect Approach, the ASPSP is transmitting the link where the
 * configuration     of the OAuth2 Server is defined.     The configuration follows the OAuth 2.0 Authorisation
 * Server Metadata specification.   - &#39;startAuthorisation&#39;:     In case, where an explicit start of the
 * transaction authorisation is needed,     but no more data needs to be updated (no authentication method to be
 * selected,     no PSU identification nor PSU authentication data to be uploaded).   - &#39;
 * startAuthorisationWithPsuIdentification&#39;:     The link to the authorisation end-point, where the authorisation
 * sub-resource has to be generated     while uploading the PSU identification data.   - &#39;
 * startAuthorisationWithPsuAuthentication&#39;:     The link to the authorisation end-point, where the authorisation
 * sub-resource has to be generated     while uploading the PSU authentication data.   - &#39;
 * startAuthorisationWithAuthenticationMethodSelection&#39;:     The link to the authorisation end-point, where the
 * authorisation sub-resource has to be generated     while selecting the authentication method. This link is
 * contained under exactly the same conditions     as the data element &#39;scaMethods&#39;   - &#39;
 * startAuthorisationWithTransactionAuthorisation&#39;:     The link to the authorisation end-point, where the
 * authorisation sub-resource has to be generated     while authorising the transaction e.g. by uploading an OTP
 * received by SMS.   - &#39;self&#39;:     The link to the Establish Account Information Consent resource created by
 * this request.     This link can be used to retrieve the resource data.   - &#39;status&#39;:     The link to
 * retrieve the status of the account information consent.   - &#39;scaStatus&#39;: The link to retrieve the
 * scaStatus of the corresponding authorisation sub-resource.     This link is only contained, if an authorisation
 * sub-resource has been already created.
 */
@ApiModel(description = "A list of hyperlinks to be recognised by the TPP.  Type of links admitted in this response " +
    "(which might be extended by single ASPSPs as indicated in its XS2A documentation):   - 'scaRedirect':     In " +
    "case of an SCA Redirect Approach, the ASPSP is transmitting the link to which to redirect the     PSU browser.  " +
    " - 'scaOAuth':     In case of an OAuth2 based Redirect Approach, the ASPSP is transmitting the link where the " +
    "configuration     of the OAuth2 Server is defined.     The configuration follows the OAuth 2.0 Authorisation " +
    "Server Metadata specification.   - 'startAuthorisation':     In case, where an explicit start of the transaction" +
    " authorisation is needed,     but no more data needs to be updated (no authentication method to be selected,    " +
    " no PSU identification nor PSU authentication data to be uploaded).   - " +
    "'startAuthorisationWithPsuIdentification':     The link to the authorisation end-point, where the authorisation " +
    "sub-resource has to be generated     while uploading the PSU identification data.   - " +
    "'startAuthorisationWithPsuAuthentication':     The link to the authorisation end-point, where the authorisation " +
    "sub-resource has to be generated     while uploading the PSU authentication data.   - " +
    "'startAuthorisationWithAuthenticationMethodSelection':     The link to the authorisation end-point, where the " +
    "authorisation sub-resource has to be generated     while selecting the authentication method. This link is " +
    "contained under exactly the same conditions     as the data element 'scaMethods'   - " +
    "'startAuthorisationWithTransactionAuthorisation':     The link to the authorisation end-point, where the " +
    "authorisation sub-resource has to be generated     while authorising the transaction e.g. by uploading an OTP " +
    "received by SMS.   - 'self':     The link to the Establish Account Information Consent resource created by this " +
    "request.     This link can be used to retrieve the resource data.   - 'status':     The link to retrieve the " +
    "status of the account information consent.   - 'scaStatus': The link to retrieve the scaStatus of the " +
    "corresponding authorisation sub-resource.     This link is only contained, if an authorisation sub-resource has " +
    "been already created. ")
@Validated
@javax.annotation.Generated(value = "io.swagger.codegen.v3.generators.java.SpringCodegen", date = "2018-10-11T14:55" +
    ":45.627+02:00[Europe/Berlin]")
public class LinksConsents extends HashMap<String, String> {
    @JsonProperty("scaRedirect")
    private String scaRedirect = null;
    @JsonProperty("scaOAuth")
    private String scaOAuth = null;
    @JsonProperty("startAuthorisation")
    private String startAuthorisation = null;
    @JsonProperty("startAuthorisationWithPsuIdentification")
    private String startAuthorisationWithPsuIdentification = null;
    @JsonProperty("startAuthorisationWithPsuAuthentication")
    private String startAuthorisationWithPsuAuthentication = null;
    @JsonProperty("startAuthorisationWithAuthenticationMethodSelection")
    private String startAuthorisationWithAuthenticationMethodSelection = null;
    @JsonProperty("startAuthorisationWithTransactionAuthorisation")
    private String startAuthorisationWithTransactionAuthorisation = null;
    @JsonProperty("self")
    private String self = null;
    @JsonProperty("status")
    private String status = null;
    @JsonProperty("scaStatus")
    private String scaStatus = null;

    public LinksConsents scaRedirect(String scaRedirect) {
        this.scaRedirect = scaRedirect;
        return this;
    }

    /**
     * Get scaRedirect
     *
     * @return scaRedirect
     **/
    @ApiModelProperty(value = "")
    public String getScaRedirect() {
        return scaRedirect;
    }

    public void setScaRedirect(String scaRedirect) {
        this.scaRedirect = scaRedirect;
    }

    public LinksConsents scaOAuth(String scaOAuth) {
        this.scaOAuth = scaOAuth;
        return this;
    }

    /**
     * Get scaOAuth
     *
     * @return scaOAuth
     **/
    @ApiModelProperty(value = "")
    public String getScaOAuth() {
        return scaOAuth;
    }

    public void setScaOAuth(String scaOAuth) {
        this.scaOAuth = scaOAuth;
    }

    public LinksConsents startAuthorisation(String startAuthorisation) {
        this.startAuthorisation = startAuthorisation;
        return this;
    }

    /**
     * Get startAuthorisation
     *
     * @return startAuthorisation
     **/
    @ApiModelProperty(value = "")
    public String getStartAuthorisation() {
        return startAuthorisation;
    }

    public void setStartAuthorisation(String startAuthorisation) {
        this.startAuthorisation = startAuthorisation;
    }

    public LinksConsents startAuthorisationWithPsuIdentification(String startAuthorisationWithPsuIdentification) {
        this.startAuthorisationWithPsuIdentification = startAuthorisationWithPsuIdentification;
        return this;
    }

    /**
     * Get startAuthorisationWithPsuIdentification
     *
     * @return startAuthorisationWithPsuIdentification
     **/
    @ApiModelProperty(value = "")
    public String getStartAuthorisationWithPsuIdentification() {
        return startAuthorisationWithPsuIdentification;
    }

    public void setStartAuthorisationWithPsuIdentification(String startAuthorisationWithPsuIdentification) {
        this.startAuthorisationWithPsuIdentification = startAuthorisationWithPsuIdentification;
    }

    public LinksConsents startAuthorisationWithPsuAuthentication(String startAuthorisationWithPsuAuthentication) {
        this.startAuthorisationWithPsuAuthentication = startAuthorisationWithPsuAuthentication;
        return this;
    }

    /**
     * Get startAuthorisationWithPsuAuthentication
     *
     * @return startAuthorisationWithPsuAuthentication
     **/
    @ApiModelProperty(value = "")
    public String getStartAuthorisationWithPsuAuthentication() {
        return startAuthorisationWithPsuAuthentication;
    }

    public void setStartAuthorisationWithPsuAuthentication(String startAuthorisationWithPsuAuthentication) {
        this.startAuthorisationWithPsuAuthentication = startAuthorisationWithPsuAuthentication;
    }

    public LinksConsents startAuthorisationWithAuthenticationMethodSelection(String startAuthorisationWithAuthenticationMethodSelection) {
        this.startAuthorisationWithAuthenticationMethodSelection = startAuthorisationWithAuthenticationMethodSelection;
        return this;
    }

    /**
     * Get startAuthorisationWithAuthenticationMethodSelection
     *
     * @return startAuthorisationWithAuthenticationMethodSelection
     **/
    @ApiModelProperty(value = "")
    public String getStartAuthorisationWithAuthenticationMethodSelection() {
        return startAuthorisationWithAuthenticationMethodSelection;
    }

    public void setStartAuthorisationWithAuthenticationMethodSelection(String startAuthorisationWithAuthenticationMethodSelection) {
        this.startAuthorisationWithAuthenticationMethodSelection = startAuthorisationWithAuthenticationMethodSelection;
    }

    public LinksConsents startAuthorisationWithTransactionAuthorisation(String startAuthorisationWithTransactionAuthorisation) {
        this.startAuthorisationWithTransactionAuthorisation = startAuthorisationWithTransactionAuthorisation;
        return this;
    }

    /**
     * Get startAuthorisationWithTransactionAuthorisation
     *
     * @return startAuthorisationWithTransactionAuthorisation
     **/
    @ApiModelProperty(value = "")
    public String getStartAuthorisationWithTransactionAuthorisation() {
        return startAuthorisationWithTransactionAuthorisation;
    }

    public void setStartAuthorisationWithTransactionAuthorisation(String startAuthorisationWithTransactionAuthorisation) {
        this.startAuthorisationWithTransactionAuthorisation = startAuthorisationWithTransactionAuthorisation;
    }

    public LinksConsents self(String self) {
        this.self = self;
        return this;
    }

    /**
     * Get self
     *
     * @return self
     **/
    @ApiModelProperty(value = "")
    public String getSelf() {
        return self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public LinksConsents status(String status) {
        this.status = status;
        return this;
    }

    /**
     * Get status
     *
     * @return status
     **/
    @ApiModelProperty(value = "")
    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public LinksConsents scaStatus(String scaStatus) {
        this.scaStatus = scaStatus;
        return this;
    }

    /**
     * Get scaStatus
     *
     * @return scaStatus
     **/
    @ApiModelProperty(value = "")
    public String getScaStatus() {
        return scaStatus;
    }

    public void setScaStatus(String scaStatus) {
        this.scaStatus = scaStatus;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        LinksConsents _linksConsents = (LinksConsents) o;
        return Objects.equals(this.scaRedirect, _linksConsents.scaRedirect) && Objects.equals(this.scaOAuth,
            _linksConsents.scaOAuth) && Objects.equals(this.startAuthorisation, _linksConsents.startAuthorisation) && Objects.equals(this.startAuthorisationWithPsuIdentification, _linksConsents.startAuthorisationWithPsuIdentification) && Objects.equals(this.startAuthorisationWithPsuAuthentication, _linksConsents.startAuthorisationWithPsuAuthentication) && Objects.equals(this.startAuthorisationWithAuthenticationMethodSelection, _linksConsents.startAuthorisationWithAuthenticationMethodSelection) && Objects.equals(this.startAuthorisationWithTransactionAuthorisation, _linksConsents.startAuthorisationWithTransactionAuthorisation) && Objects.equals(this.self, _linksConsents.self) && Objects.equals(this.status, _linksConsents.status) && Objects.equals(this.scaStatus, _linksConsents.scaStatus) && super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(scaRedirect, scaOAuth, startAuthorisation, startAuthorisationWithPsuIdentification,
            startAuthorisationWithPsuAuthentication, startAuthorisationWithAuthenticationMethodSelection,
            startAuthorisationWithTransactionAuthorisation, self, status, scaStatus, super.hashCode());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinksConsents {\n");
        sb.append("    ").append(toIndentedString(super.toString())).append("\n");
        sb.append("    scaRedirect: ").append(toIndentedString(scaRedirect)).append("\n");
        sb.append("    scaOAuth: ").append(toIndentedString(scaOAuth)).append("\n");
        sb.append("    startAuthorisation: ").append(toIndentedString(startAuthorisation)).append("\n");
        sb.append("    startAuthorisationWithPsuIdentification: ").append(toIndentedString(startAuthorisationWithPsuIdentification)).append("\n");
        sb.append("    startAuthorisationWithPsuAuthentication: ").append(toIndentedString(startAuthorisationWithPsuAuthentication)).append("\n");
        sb.append("    startAuthorisationWithAuthenticationMethodSelection: ").append(toIndentedString(startAuthorisationWithAuthenticationMethodSelection)).append("\n");
        sb.append("    startAuthorisationWithTransactionAuthorisation: ").append(toIndentedString(startAuthorisationWithTransactionAuthorisation)).append("\n");
        sb.append("    self: ").append(toIndentedString(self)).append("\n");
        sb.append("    status: ").append(toIndentedString(status)).append("\n");
        sb.append("    scaStatus: ").append(toIndentedString(scaStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(java.lang.Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

