/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.support.mapper.spi;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.payment.support.mapper.Xs2aToPsd2PaymentSupportMapper;
import de.adorsys.psd2.xs2a.service.payment.support.mapper.spi.SpiToXs2aBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.support.mapper.spi.SpiToXs2aPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.support.mapper.spi.SpiToXs2aSinglePaymentMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SpiToXs2aPaymentMapperSupport {
    private static final Logger log = LoggerFactory.getLogger(SpiToXs2aPaymentMapperSupport.class);
    private final SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper;
    private final SpiToXs2aPeriodicPaymentMapper spiToXs2aPeriodicPaymentMapper;
    private final SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper;
    private final Xs2aToPsd2PaymentSupportMapper xs2AToPsd2PaymentSupportMapper;
    private final Xs2aObjectMapper xs2aObjectMapper;

    public SinglePayment mapToSinglePayment(SpiSinglePayment spiSinglePayment) {
        SinglePayment singlePayment = this.spiToXs2aSinglePaymentMapper.mapToXs2aSinglePayment(spiSinglePayment);
        PaymentInitiationJson paymentInitiationJson = this.xs2AToPsd2PaymentSupportMapper.mapToPaymentInitiationJson(singlePayment);
        if (singlePayment != null) {
            singlePayment.setPaymentData(this.convertToBytes(paymentInitiationJson));
        }
        return singlePayment;
    }

    public PeriodicPayment mapToPeriodicPayment(SpiPeriodicPayment spiPeriodicPayment) {
        PeriodicPayment periodicPayment = this.spiToXs2aPeriodicPaymentMapper.mapToXs2aPeriodicPayment(spiPeriodicPayment);
        PeriodicPaymentInitiationJson paymentInitiationJson = this.xs2AToPsd2PaymentSupportMapper.mapToPeriodicPaymentInitiationJson(periodicPayment);
        if (periodicPayment != null) {
            periodicPayment.setPaymentData(this.convertToBytes(paymentInitiationJson));
        }
        return periodicPayment;
    }

    public BulkPayment mapToBulkPayment(SpiBulkPayment spiBulkPayment) {
        BulkPayment bulkPayment = this.spiToXs2aBulkPaymentMapper.mapToXs2aBulkPayment(spiBulkPayment);
        BulkPaymentInitiationJson paymentInitiationJson = this.xs2AToPsd2PaymentSupportMapper.mapToBulkPaymentInitiationJson(bulkPayment);
        if (bulkPayment != null) {
            bulkPayment.setPaymentData(this.convertToBytes(paymentInitiationJson));
        }
        return bulkPayment;
    }

    private byte[] convertToBytes(Object payment) {
        if (payment == null) {
            return new byte[0];
        }
        try {
            return this.xs2aObjectMapper.writeValueAsBytes(payment);
        }
        catch (JsonProcessingException e) {
            log.warn("Couldn't serialise payment to bytes");
            return new byte[0];
        }
    }

    @ConstructorProperties(value={"spiToXs2aSinglePaymentMapper", "spiToXs2aPeriodicPaymentMapper", "spiToXs2aBulkPaymentMapper", "xs2AToPsd2PaymentSupportMapper", "xs2aObjectMapper"})
    public SpiToXs2aPaymentMapperSupport(SpiToXs2aSinglePaymentMapper spiToXs2aSinglePaymentMapper, SpiToXs2aPeriodicPaymentMapper spiToXs2aPeriodicPaymentMapper, SpiToXs2aBulkPaymentMapper spiToXs2aBulkPaymentMapper, Xs2aToPsd2PaymentSupportMapper xs2AToPsd2PaymentSupportMapper, Xs2aObjectMapper xs2aObjectMapper) {
        this.spiToXs2aSinglePaymentMapper = spiToXs2aSinglePaymentMapper;
        this.spiToXs2aPeriodicPaymentMapper = spiToXs2aPeriodicPaymentMapper;
        this.spiToXs2aBulkPaymentMapper = spiToXs2aBulkPaymentMapper;
        this.xs2AToPsd2PaymentSupportMapper = xs2AToPsd2PaymentSupportMapper;
        this.xs2aObjectMapper = xs2aObjectMapper;
    }
}

