/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.support;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.consent.api.pis.proto.PisCommonPaymentResponse;
import de.adorsys.psd2.consent.api.pis.proto.PisPaymentCancellationRequest;
import de.adorsys.psd2.xs2a.config.factory.Prefixes;
import de.adorsys.psd2.xs2a.config.factory.ReadPaymentFactory;
import de.adorsys.psd2.xs2a.config.factory.ReadPaymentStatusFactory;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.PaymentInitiationParameters;
import de.adorsys.psd2.xs2a.service.payment.PaymentServiceResolver;
import de.adorsys.psd2.xs2a.service.payment.cancel.CancelCommonPaymentService;
import de.adorsys.psd2.xs2a.service.payment.cancel.CancelPaymentService;
import de.adorsys.psd2.xs2a.service.payment.create.CreateCommonPaymentService;
import de.adorsys.psd2.xs2a.service.payment.create.CreatePaymentService;
import de.adorsys.psd2.xs2a.service.payment.read.ReadCommonPaymentService;
import de.adorsys.psd2.xs2a.service.payment.read.ReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.status.ReadCommonPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.status.ReadPaymentStatusService;
import de.adorsys.psd2.xs2a.service.payment.support.cancel.CancelCertainPaymentService;
import de.adorsys.psd2.xs2a.service.payment.support.create.CreateBulkPaymentService;
import de.adorsys.psd2.xs2a.service.payment.support.create.CreatePeriodicPaymentService;
import de.adorsys.psd2.xs2a.service.payment.support.create.CreateSinglePaymentService;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PaymentServiceResolverSupport
implements PaymentServiceResolver {
    private static final Logger log = LoggerFactory.getLogger(PaymentServiceResolverSupport.class);
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final CreateCommonPaymentService createCommonPaymentService;
    private final CreateSinglePaymentService createSinglePaymentService;
    private final CreatePeriodicPaymentService createPeriodicPaymentService;
    private final CreateBulkPaymentService createBulkPaymentService;
    private final ReadCommonPaymentService readCommonPaymentService;
    private final ReadPaymentFactory readPaymentFactory;
    private final ReadCommonPaymentStatusService readCommonPaymentStatusService;
    private final ReadPaymentStatusFactory readPaymentStatusFactory;
    private final CancelCommonPaymentService cancelCommonPaymentService;
    private final CancelCertainPaymentService cancelCertainPaymentService;

    public CreatePaymentService getCreatePaymentService(PaymentInitiationParameters paymentInitiationParameters) {
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(paymentInitiationParameters.getPaymentProduct())) {
            return this.createCommonPaymentService;
        }
        if (PaymentType.SINGLE == paymentInitiationParameters.getPaymentType()) {
            return this.createSinglePaymentService;
        }
        if (PaymentType.PERIODIC == paymentInitiationParameters.getPaymentType()) {
            return this.createPeriodicPaymentService;
        }
        return this.createBulkPaymentService;
    }

    public ReadPaymentService getReadPaymentService(CommonPaymentData commonPaymentData) {
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(commonPaymentData.getPaymentProduct())) {
            return this.readCommonPaymentService;
        }
        return (ReadPaymentService)this.readPaymentFactory.getService(commonPaymentData.getPaymentType().getValue());
    }

    public ReadPaymentStatusService getReadPaymentStatusService(PisCommonPaymentResponse pisCommonPaymentResponse) {
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(pisCommonPaymentResponse.getPaymentProduct())) {
            return this.readCommonPaymentStatusService;
        }
        return (ReadPaymentStatusService)this.readPaymentStatusFactory.getService(Prefixes.SERVICE_PREFIX.getValue() + pisCommonPaymentResponse.getPaymentType().getValue());
    }

    public CancelPaymentService getCancelPaymentService(PisPaymentCancellationRequest paymentCancellationRequest) {
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(paymentCancellationRequest.getPaymentProduct())) {
            return this.cancelCommonPaymentService;
        }
        return this.cancelCertainPaymentService;
    }

    @ConstructorProperties(value={"standardPaymentProductsResolver", "createCommonPaymentService", "createSinglePaymentService", "createPeriodicPaymentService", "createBulkPaymentService", "readCommonPaymentService", "readPaymentFactory", "readCommonPaymentStatusService", "readPaymentStatusFactory", "cancelCommonPaymentService", "cancelCertainPaymentService"})
    public PaymentServiceResolverSupport(StandardPaymentProductsResolver standardPaymentProductsResolver, CreateCommonPaymentService createCommonPaymentService, CreateSinglePaymentService createSinglePaymentService, CreatePeriodicPaymentService createPeriodicPaymentService, CreateBulkPaymentService createBulkPaymentService, ReadCommonPaymentService readCommonPaymentService, ReadPaymentFactory readPaymentFactory, ReadCommonPaymentStatusService readCommonPaymentStatusService, ReadPaymentStatusFactory readPaymentStatusFactory, CancelCommonPaymentService cancelCommonPaymentService, CancelCertainPaymentService cancelCertainPaymentService) {
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.createCommonPaymentService = createCommonPaymentService;
        this.createSinglePaymentService = createSinglePaymentService;
        this.createPeriodicPaymentService = createPeriodicPaymentService;
        this.createBulkPaymentService = createBulkPaymentService;
        this.readCommonPaymentService = readCommonPaymentService;
        this.readPaymentFactory = readPaymentFactory;
        this.readCommonPaymentStatusService = readCommonPaymentStatusService;
        this.readPaymentStatusFactory = readPaymentStatusFactory;
        this.cancelCommonPaymentService = cancelCommonPaymentService;
        this.cancelCertainPaymentService = cancelCertainPaymentService;
    }
}

