/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.support.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.PaymentInitiationBulkElementJson;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.model.PurposeCode;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.payment.support.mapper.Xs2aToPsd2PaymentSupportMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class Xs2aToPsd2PaymentSupportMapperImpl
implements Xs2aToPsd2PaymentSupportMapper {
    @Override
    public PaymentInitiationJson mapToPaymentInitiationJson(SinglePayment singlePayment) {
        if (singlePayment == null) {
            return null;
        }
        PaymentInitiationJson paymentInitiationJson = new PaymentInitiationJson();
        paymentInitiationJson.setEndToEndIdentification(singlePayment.getEndToEndIdentification());
        paymentInitiationJson.setInstructionIdentification(singlePayment.getInstructionIdentification());
        paymentInitiationJson.setDebtorName(singlePayment.getDebtorName());
        paymentInitiationJson.setDebtorAccount(this.accountReferenceToAccountReference(singlePayment.getDebtorAccount()));
        paymentInitiationJson.setUltimateDebtor(singlePayment.getUltimateDebtor());
        paymentInitiationJson.setInstructedAmount(this.xs2aAmountToAmount(singlePayment.getInstructedAmount()));
        paymentInitiationJson.setCreditorAccount(this.accountReferenceToAccountReference(singlePayment.getCreditorAccount()));
        paymentInitiationJson.setCreditorAgent(singlePayment.getCreditorAgent());
        paymentInitiationJson.setCreditorName(singlePayment.getCreditorName());
        paymentInitiationJson.setCreditorAddress(this.xs2aAddressToAddress(singlePayment.getCreditorAddress()));
        paymentInitiationJson.setCreditorId(singlePayment.getCreditorId());
        paymentInitiationJson.setUltimateCreditor(singlePayment.getUltimateCreditor());
        paymentInitiationJson.setPurposeCode(this.purposeCodeToPurposeCode(singlePayment.getPurposeCode()));
        paymentInitiationJson.setRemittanceInformationUnstructured(singlePayment.getRemittanceInformationUnstructured());
        paymentInitiationJson.setRemittanceInformationStructured(singlePayment.getRemittanceInformationStructured());
        paymentInitiationJson.setRemittanceInformationStructuredArray(this.stringListToRemittanceInformationStructuredArray(singlePayment.getRemittanceInformationStructuredArray()));
        paymentInitiationJson.setRequestedExecutionDate(singlePayment.getRequestedExecutionDate());
        return paymentInitiationJson;
    }

    @Override
    public PeriodicPaymentInitiationJson mapToPeriodicPaymentInitiationJson(PeriodicPayment xs2aPeriodicPayment) {
        if (xs2aPeriodicPayment == null) {
            return null;
        }
        PeriodicPaymentInitiationJson periodicPaymentInitiationJson = new PeriodicPaymentInitiationJson();
        periodicPaymentInitiationJson.setEndToEndIdentification(xs2aPeriodicPayment.getEndToEndIdentification());
        periodicPaymentInitiationJson.setInstructionIdentification(xs2aPeriodicPayment.getInstructionIdentification());
        periodicPaymentInitiationJson.setDebtorName(xs2aPeriodicPayment.getDebtorName());
        periodicPaymentInitiationJson.setDebtorAccount(this.accountReferenceToAccountReference(xs2aPeriodicPayment.getDebtorAccount()));
        periodicPaymentInitiationJson.setUltimateDebtor(xs2aPeriodicPayment.getUltimateDebtor());
        periodicPaymentInitiationJson.setInstructedAmount(this.xs2aAmountToAmount(xs2aPeriodicPayment.getInstructedAmount()));
        periodicPaymentInitiationJson.setCreditorAccount(this.accountReferenceToAccountReference(xs2aPeriodicPayment.getCreditorAccount()));
        periodicPaymentInitiationJson.setCreditorAgent(xs2aPeriodicPayment.getCreditorAgent());
        periodicPaymentInitiationJson.setCreditorId(xs2aPeriodicPayment.getCreditorId());
        periodicPaymentInitiationJson.setCreditorName(xs2aPeriodicPayment.getCreditorName());
        periodicPaymentInitiationJson.setCreditorAddress(this.xs2aAddressToAddress(xs2aPeriodicPayment.getCreditorAddress()));
        periodicPaymentInitiationJson.setUltimateCreditor(xs2aPeriodicPayment.getUltimateCreditor());
        periodicPaymentInitiationJson.setPurposeCode(this.purposeCodeToPurposeCode(xs2aPeriodicPayment.getPurposeCode()));
        periodicPaymentInitiationJson.setRemittanceInformationUnstructured(xs2aPeriodicPayment.getRemittanceInformationUnstructured());
        periodicPaymentInitiationJson.setRemittanceInformationStructured(xs2aPeriodicPayment.getRemittanceInformationStructured());
        periodicPaymentInitiationJson.setRemittanceInformationStructuredArray(this.stringListToRemittanceInformationStructuredArray(xs2aPeriodicPayment.getRemittanceInformationStructuredArray()));
        periodicPaymentInitiationJson.setStartDate(xs2aPeriodicPayment.getStartDate());
        periodicPaymentInitiationJson.setEndDate(xs2aPeriodicPayment.getEndDate());
        periodicPaymentInitiationJson.setExecutionRule(this.pisExecutionRuleToExecutionRule(xs2aPeriodicPayment.getExecutionRule()));
        periodicPaymentInitiationJson.setFrequency(this.frequencyCodeToFrequencyCode(xs2aPeriodicPayment.getFrequency()));
        periodicPaymentInitiationJson.setDayOfExecution(this.pisDayOfExecutionToDayOfExecution(xs2aPeriodicPayment.getDayOfExecution()));
        return periodicPaymentInitiationJson;
    }

    @Override
    public BulkPaymentInitiationJson mapToBulkPaymentInitiationJson(BulkPayment xs2aBulkPayment) {
        if (xs2aBulkPayment == null) {
            return null;
        }
        BulkPaymentInitiationJson bulkPaymentInitiationJson = new BulkPaymentInitiationJson();
        bulkPaymentInitiationJson.setBatchBookingPreferred(xs2aBulkPayment.getBatchBookingPreferred());
        bulkPaymentInitiationJson.setDebtorAccount(this.accountReferenceToAccountReference(xs2aBulkPayment.getDebtorAccount()));
        bulkPaymentInitiationJson.setRequestedExecutionDate(xs2aBulkPayment.getRequestedExecutionDate());
        bulkPaymentInitiationJson.setRequestedExecutionTime(xs2aBulkPayment.getRequestedExecutionTime());
        bulkPaymentInitiationJson.setPayments(this.singlePaymentListToPaymentInitiationBulkElementJsonList(xs2aBulkPayment.getPayments()));
        return bulkPaymentInitiationJson;
    }

    protected AccountReference accountReferenceToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if (accountReference == null) {
            return null;
        }
        AccountReference accountReference1 = new AccountReference();
        accountReference1.setIban(accountReference.getIban());
        accountReference1.setBban(accountReference.getBban());
        accountReference1.setPan(accountReference.getPan());
        accountReference1.setMaskedPan(accountReference.getMaskedPan());
        accountReference1.setMsisdn(accountReference.getMsisdn());
        if (accountReference.getCurrency() != null) {
            accountReference1.setCurrency(accountReference.getCurrency().getCurrencyCode());
        }
        return accountReference1;
    }

    protected Amount xs2aAmountToAmount(Xs2aAmount xs2aAmount) {
        if (xs2aAmount == null) {
            return null;
        }
        Amount amount = new Amount();
        if (xs2aAmount.getCurrency() != null) {
            amount.setCurrency(xs2aAmount.getCurrency().getCurrencyCode());
        }
        amount.setAmount(xs2aAmount.getAmount());
        return amount;
    }

    protected Address xs2aAddressToAddress(Xs2aAddress xs2aAddress) {
        if (xs2aAddress == null) {
            return null;
        }
        Address address = new Address();
        address.setStreetName(xs2aAddress.getStreetName());
        address.setBuildingNumber(xs2aAddress.getBuildingNumber());
        address.setTownName(xs2aAddress.getTownName());
        address.setPostCode(xs2aAddress.getPostCode());
        address.setCountry(this.mapToCountry(xs2aAddress.getCountry()));
        return address;
    }

    protected PurposeCode purposeCodeToPurposeCode(de.adorsys.psd2.xs2a.core.pis.PurposeCode purposeCode) {
        PurposeCode purposeCode1;
        if (purposeCode == null) {
            return null;
        }
        switch (purposeCode) {
            case BKDF: {
                purposeCode1 = PurposeCode.BKDF;
                break;
            }
            case BKFE: {
                purposeCode1 = PurposeCode.BKFE;
                break;
            }
            case BKFM: {
                purposeCode1 = PurposeCode.BKFM;
                break;
            }
            case BKIP: {
                purposeCode1 = PurposeCode.BKIP;
                break;
            }
            case BKPP: {
                purposeCode1 = PurposeCode.BKPP;
                break;
            }
            case CBLK: {
                purposeCode1 = PurposeCode.CBLK;
                break;
            }
            case CDCB: {
                purposeCode1 = PurposeCode.CDCB;
                break;
            }
            case CDCD: {
                purposeCode1 = PurposeCode.CDCD;
                break;
            }
            case CDCS: {
                purposeCode1 = PurposeCode.CDCS;
                break;
            }
            case CDDP: {
                purposeCode1 = PurposeCode.CDDP;
                break;
            }
            case CDOC: {
                purposeCode1 = PurposeCode.CDOC;
                break;
            }
            case CDQC: {
                purposeCode1 = PurposeCode.CDQC;
                break;
            }
            case ETUP: {
                purposeCode1 = PurposeCode.ETUP;
                break;
            }
            case FCOL: {
                purposeCode1 = PurposeCode.FCOL;
                break;
            }
            case MTUP: {
                purposeCode1 = PurposeCode.MTUP;
                break;
            }
            case ACCT: {
                purposeCode1 = PurposeCode.ACCT;
                break;
            }
            case CASH: {
                purposeCode1 = PurposeCode.CASH;
                break;
            }
            case COLL: {
                purposeCode1 = PurposeCode.COLL;
                break;
            }
            case CSDB: {
                purposeCode1 = PurposeCode.CSDB;
                break;
            }
            case DEPT: {
                purposeCode1 = PurposeCode.DEPT;
                break;
            }
            case INTC: {
                purposeCode1 = PurposeCode.INTC;
                break;
            }
            case LIMA: {
                purposeCode1 = PurposeCode.LIMA;
                break;
            }
            case NETT: {
                purposeCode1 = PurposeCode.NETT;
                break;
            }
            case BFWD: {
                purposeCode1 = PurposeCode.BFWD;
                break;
            }
            case CCIR: {
                purposeCode1 = PurposeCode.CCIR;
                break;
            }
            case CCPC: {
                purposeCode1 = PurposeCode.CCPC;
                break;
            }
            case CCPM: {
                purposeCode1 = PurposeCode.CCPM;
                break;
            }
            case CCSM: {
                purposeCode1 = PurposeCode.CCSM;
                break;
            }
            case CRDS: {
                purposeCode1 = PurposeCode.CRDS;
                break;
            }
            case CRPR: {
                purposeCode1 = PurposeCode.CRPR;
                break;
            }
            case CRSP: {
                purposeCode1 = PurposeCode.CRSP;
                break;
            }
            case CRTL: {
                purposeCode1 = PurposeCode.CRTL;
                break;
            }
            case EQPT: {
                purposeCode1 = PurposeCode.EQPT;
                break;
            }
            case EQUS: {
                purposeCode1 = PurposeCode.EQUS;
                break;
            }
            case EXPT: {
                purposeCode1 = PurposeCode.EXPT;
                break;
            }
            case EXTD: {
                purposeCode1 = PurposeCode.EXTD;
                break;
            }
            case FIXI: {
                purposeCode1 = PurposeCode.FIXI;
                break;
            }
            case FWBC: {
                purposeCode1 = PurposeCode.FWBC;
                break;
            }
            case FWCC: {
                purposeCode1 = PurposeCode.FWCC;
                break;
            }
            case FWSB: {
                purposeCode1 = PurposeCode.FWSB;
                break;
            }
            case FWSC: {
                purposeCode1 = PurposeCode.FWSC;
                break;
            }
            case MARG: {
                purposeCode1 = PurposeCode.MARG;
                break;
            }
            case MBSB: {
                purposeCode1 = PurposeCode.MBSB;
                break;
            }
            case MBSC: {
                purposeCode1 = PurposeCode.MBSC;
                break;
            }
            case MGCC: {
                purposeCode1 = PurposeCode.MGCC;
                break;
            }
            case MGSC: {
                purposeCode1 = PurposeCode.MGSC;
                break;
            }
            case OCCC: {
                purposeCode1 = PurposeCode.OCCC;
                break;
            }
            case OPBC: {
                purposeCode1 = PurposeCode.OPBC;
                break;
            }
            case OPCC: {
                purposeCode1 = PurposeCode.OPCC;
                break;
            }
            case OPSB: {
                purposeCode1 = PurposeCode.OPSB;
                break;
            }
            case OPSC: {
                purposeCode1 = PurposeCode.OPSC;
                break;
            }
            case OPTN: {
                purposeCode1 = PurposeCode.OPTN;
                break;
            }
            case OTCD: {
                purposeCode1 = PurposeCode.OTCD;
                break;
            }
            case REPO: {
                purposeCode1 = PurposeCode.REPO;
                break;
            }
            case RPBC: {
                purposeCode1 = PurposeCode.RPBC;
                break;
            }
            case RPCC: {
                purposeCode1 = PurposeCode.RPCC;
                break;
            }
            case RPSB: {
                purposeCode1 = PurposeCode.RPSB;
                break;
            }
            case RPSC: {
                purposeCode1 = PurposeCode.RPSC;
                break;
            }
            case RVPO: {
                purposeCode1 = PurposeCode.RVPO;
                break;
            }
            case SBSC: {
                purposeCode1 = PurposeCode.SBSC;
                break;
            }
            case SCIE: {
                purposeCode1 = PurposeCode.SCIE;
                break;
            }
            case SCIR: {
                purposeCode1 = PurposeCode.SCIR;
                break;
            }
            case SCRP: {
                purposeCode1 = PurposeCode.SCRP;
                break;
            }
            case SHBC: {
                purposeCode1 = PurposeCode.SHBC;
                break;
            }
            case SHCC: {
                purposeCode1 = PurposeCode.SHCC;
                break;
            }
            case SHSL: {
                purposeCode1 = PurposeCode.SHSL;
                break;
            }
            case SLEB: {
                purposeCode1 = PurposeCode.SLEB;
                break;
            }
            case SLOA: {
                purposeCode1 = PurposeCode.SLOA;
                break;
            }
            case SWBC: {
                purposeCode1 = PurposeCode.SWBC;
                break;
            }
            case SWCC: {
                purposeCode1 = PurposeCode.SWCC;
                break;
            }
            case SWPT: {
                purposeCode1 = PurposeCode.SWPT;
                break;
            }
            case SWSB: {
                purposeCode1 = PurposeCode.SWSB;
                break;
            }
            case SWSC: {
                purposeCode1 = PurposeCode.SWSC;
                break;
            }
            case TBAS: {
                purposeCode1 = PurposeCode.TBAS;
                break;
            }
            case TBBC: {
                purposeCode1 = PurposeCode.TBBC;
                break;
            }
            case TBCC: {
                purposeCode1 = PurposeCode.TBCC;
                break;
            }
            case TRCP: {
                purposeCode1 = PurposeCode.TRCP;
                break;
            }
            case AGRT: {
                purposeCode1 = PurposeCode.AGRT;
                break;
            }
            case AREN: {
                purposeCode1 = PurposeCode.AREN;
                break;
            }
            case BEXP: {
                purposeCode1 = PurposeCode.BEXP;
                break;
            }
            case BOCE: {
                purposeCode1 = PurposeCode.BOCE;
                break;
            }
            case COMC: {
                purposeCode1 = PurposeCode.COMC;
                break;
            }
            case CPYR: {
                purposeCode1 = PurposeCode.CPYR;
                break;
            }
            case GDDS: {
                purposeCode1 = PurposeCode.GDDS;
                break;
            }
            case GDSV: {
                purposeCode1 = PurposeCode.GDSV;
                break;
            }
            case GSCB: {
                purposeCode1 = PurposeCode.GSCB;
                break;
            }
            case LICF: {
                purposeCode1 = PurposeCode.LICF;
                break;
            }
            case MP2B: {
                purposeCode1 = PurposeCode.MP2B;
                break;
            }
            case POPE: {
                purposeCode1 = PurposeCode.POPE;
                break;
            }
            case ROYA: {
                purposeCode1 = PurposeCode.ROYA;
                break;
            }
            case SCVE: {
                purposeCode1 = PurposeCode.SCVE;
                break;
            }
            case SERV: {
                purposeCode1 = PurposeCode.SERV;
                break;
            }
            case SUBS: {
                purposeCode1 = PurposeCode.SUBS;
                break;
            }
            case SUPP: {
                purposeCode1 = PurposeCode.SUPP;
                break;
            }
            case TRAD: {
                purposeCode1 = PurposeCode.TRAD;
                break;
            }
            case CHAR: {
                purposeCode1 = PurposeCode.CHAR;
                break;
            }
            case COMT: {
                purposeCode1 = PurposeCode.COMT;
                break;
            }
            case MP2P: {
                purposeCode1 = PurposeCode.MP2P;
                break;
            }
            case ECPG: {
                purposeCode1 = PurposeCode.ECPG;
                break;
            }
            case ECPR: {
                purposeCode1 = PurposeCode.ECPR;
                break;
            }
            case ECPU: {
                purposeCode1 = PurposeCode.ECPU;
                break;
            }
            case EPAY: {
                purposeCode1 = PurposeCode.EPAY;
                break;
            }
            case CLPR: {
                purposeCode1 = PurposeCode.CLPR;
                break;
            }
            case COMP: {
                purposeCode1 = PurposeCode.COMP;
                break;
            }
            case DBTC: {
                purposeCode1 = PurposeCode.DBTC;
                break;
            }
            case GOVI: {
                purposeCode1 = PurposeCode.GOVI;
                break;
            }
            case HLRP: {
                purposeCode1 = PurposeCode.HLRP;
                break;
            }
            case HLST: {
                purposeCode1 = PurposeCode.HLST;
                break;
            }
            case INPC: {
                purposeCode1 = PurposeCode.INPC;
                break;
            }
            case INPR: {
                purposeCode1 = PurposeCode.INPR;
                break;
            }
            case INSC: {
                purposeCode1 = PurposeCode.INSC;
                break;
            }
            case INSU: {
                purposeCode1 = PurposeCode.INSU;
                break;
            }
            case INTE: {
                purposeCode1 = PurposeCode.INTE;
                break;
            }
            case LBRI: {
                purposeCode1 = PurposeCode.LBRI;
                break;
            }
            case LIFI: {
                purposeCode1 = PurposeCode.LIFI;
                break;
            }
            case LOAN: {
                purposeCode1 = PurposeCode.LOAN;
                break;
            }
            case LOAR: {
                purposeCode1 = PurposeCode.LOAR;
                break;
            }
            case PENO: {
                purposeCode1 = PurposeCode.PENO;
                break;
            }
            case PPTI: {
                purposeCode1 = PurposeCode.PPTI;
                break;
            }
            case RELG: {
                purposeCode1 = PurposeCode.RELG;
                break;
            }
            case RINP: {
                purposeCode1 = PurposeCode.RINP;
                break;
            }
            case TRFD: {
                purposeCode1 = PurposeCode.TRFD;
                break;
            }
            case FORW: {
                purposeCode1 = PurposeCode.FORW;
                break;
            }
            case FXNT: {
                purposeCode1 = PurposeCode.FXNT;
                break;
            }
            case ADMG: {
                purposeCode1 = PurposeCode.ADMG;
                break;
            }
            case ADVA: {
                purposeCode1 = PurposeCode.ADVA;
                break;
            }
            case BCDM: {
                purposeCode1 = PurposeCode.BCDM;
                break;
            }
            case BCFG: {
                purposeCode1 = PurposeCode.BCFG;
                break;
            }
            case BLDM: {
                purposeCode1 = PurposeCode.BLDM;
                break;
            }
            case BNET: {
                purposeCode1 = PurposeCode.BNET;
                break;
            }
            case CBFF: {
                purposeCode1 = PurposeCode.CBFF;
                break;
            }
            case CBFR: {
                purposeCode1 = PurposeCode.CBFR;
                break;
            }
            case CCRD: {
                purposeCode1 = PurposeCode.CCRD;
                break;
            }
            case CDBL: {
                purposeCode1 = PurposeCode.CDBL;
                break;
            }
            case CFEE: {
                purposeCode1 = PurposeCode.CFEE;
                break;
            }
            case CGDD: {
                purposeCode1 = PurposeCode.CGDD;
                break;
            }
            case CORT: {
                purposeCode1 = PurposeCode.CORT;
                break;
            }
            case COST: {
                purposeCode1 = PurposeCode.COST;
                break;
            }
            case CPKC: {
                purposeCode1 = PurposeCode.CPKC;
                break;
            }
            case DCRD: {
                purposeCode1 = PurposeCode.DCRD;
                break;
            }
            case DSMT: {
                purposeCode1 = PurposeCode.DSMT;
                break;
            }
            case DVPM: {
                purposeCode1 = PurposeCode.DVPM;
                break;
            }
            case EDUC: {
                purposeCode1 = PurposeCode.EDUC;
                break;
            }
            case FACT: {
                purposeCode1 = PurposeCode.FACT;
                break;
            }
            case FAND: {
                purposeCode1 = PurposeCode.FAND;
                break;
            }
            case FCPM: {
                purposeCode1 = PurposeCode.FCPM;
                break;
            }
            case FEES: {
                purposeCode1 = PurposeCode.FEES;
                break;
            }
            case GOVT: {
                purposeCode1 = PurposeCode.GOVT;
                break;
            }
            case ICCP: {
                purposeCode1 = PurposeCode.ICCP;
                break;
            }
            case IDCP: {
                purposeCode1 = PurposeCode.IDCP;
                break;
            }
            case IHRP: {
                purposeCode1 = PurposeCode.IHRP;
                break;
            }
            case INSM: {
                purposeCode1 = PurposeCode.INSM;
                break;
            }
            case IVPT: {
                purposeCode1 = PurposeCode.IVPT;
                break;
            }
            case MCDM: {
                purposeCode1 = PurposeCode.MCDM;
                break;
            }
            case MCFG: {
                purposeCode1 = PurposeCode.MCFG;
                break;
            }
            case MSVC: {
                purposeCode1 = PurposeCode.MSVC;
                break;
            }
            case NOWS: {
                purposeCode1 = PurposeCode.NOWS;
                break;
            }
            case OCDM: {
                purposeCode1 = PurposeCode.OCDM;
                break;
            }
            case OCFG: {
                purposeCode1 = PurposeCode.OCFG;
                break;
            }
            case OFEE: {
                purposeCode1 = PurposeCode.OFEE;
                break;
            }
            case OTHR: {
                purposeCode1 = PurposeCode.OTHR;
                break;
            }
            case PADD: {
                purposeCode1 = PurposeCode.PADD;
                break;
            }
            case PTSP: {
                purposeCode1 = PurposeCode.PTSP;
                break;
            }
            case RCKE: {
                purposeCode1 = PurposeCode.RCKE;
                break;
            }
            case RCPT: {
                purposeCode1 = PurposeCode.RCPT;
                break;
            }
            case REBT: {
                purposeCode1 = PurposeCode.REBT;
                break;
            }
            case REFU: {
                purposeCode1 = PurposeCode.REFU;
                break;
            }
            case RENT: {
                purposeCode1 = PurposeCode.RENT;
                break;
            }
            case REOD: {
                purposeCode1 = PurposeCode.REOD;
                break;
            }
            case RIMB: {
                purposeCode1 = PurposeCode.RIMB;
                break;
            }
            case RPNT: {
                purposeCode1 = PurposeCode.RPNT;
                break;
            }
            case RRBN: {
                purposeCode1 = PurposeCode.RRBN;
                break;
            }
            case RVPM: {
                purposeCode1 = PurposeCode.RVPM;
                break;
            }
            case SLPI: {
                purposeCode1 = PurposeCode.SLPI;
                break;
            }
            case SPLT: {
                purposeCode1 = PurposeCode.SPLT;
                break;
            }
            case STDY: {
                purposeCode1 = PurposeCode.STDY;
                break;
            }
            case TBAN: {
                purposeCode1 = PurposeCode.TBAN;
                break;
            }
            case TBIL: {
                purposeCode1 = PurposeCode.TBIL;
                break;
            }
            case TCSC: {
                purposeCode1 = PurposeCode.TCSC;
                break;
            }
            case TELI: {
                purposeCode1 = PurposeCode.TELI;
                break;
            }
            case TMPG: {
                purposeCode1 = PurposeCode.TMPG;
                break;
            }
            case TPRI: {
                purposeCode1 = PurposeCode.TPRI;
                break;
            }
            case TPRP: {
                purposeCode1 = PurposeCode.TPRP;
                break;
            }
            case TRNC: {
                purposeCode1 = PurposeCode.TRNC;
                break;
            }
            case TRVC: {
                purposeCode1 = PurposeCode.TRVC;
                break;
            }
            case WEBI: {
                purposeCode1 = PurposeCode.WEBI;
                break;
            }
            case ANNI: {
                purposeCode1 = PurposeCode.ANNI;
                break;
            }
            case CAFI: {
                purposeCode1 = PurposeCode.CAFI;
                break;
            }
            case CFDI: {
                purposeCode1 = PurposeCode.CFDI;
                break;
            }
            case CMDT: {
                purposeCode1 = PurposeCode.CMDT;
                break;
            }
            case DERI: {
                purposeCode1 = PurposeCode.DERI;
                break;
            }
            case DIVD: {
                purposeCode1 = PurposeCode.DIVD;
                break;
            }
            case FREX: {
                purposeCode1 = PurposeCode.FREX;
                break;
            }
            case HEDG: {
                purposeCode1 = PurposeCode.HEDG;
                break;
            }
            case INVS: {
                purposeCode1 = PurposeCode.INVS;
                break;
            }
            case PRME: {
                purposeCode1 = PurposeCode.PRME;
                break;
            }
            case SAVG: {
                purposeCode1 = PurposeCode.SAVG;
                break;
            }
            case SECU: {
                purposeCode1 = PurposeCode.SECU;
                break;
            }
            case SEPI: {
                purposeCode1 = PurposeCode.SEPI;
                break;
            }
            case TREA: {
                purposeCode1 = PurposeCode.TREA;
                break;
            }
            case UNIT: {
                purposeCode1 = PurposeCode.UNIT;
                break;
            }
            case FNET: {
                purposeCode1 = PurposeCode.FNET;
                break;
            }
            case FUTR: {
                purposeCode1 = PurposeCode.FUTR;
                break;
            }
            case ANTS: {
                purposeCode1 = PurposeCode.ANTS;
                break;
            }
            case CVCF: {
                purposeCode1 = PurposeCode.CVCF;
                break;
            }
            case DMEQ: {
                purposeCode1 = PurposeCode.DMEQ;
                break;
            }
            case DNTS: {
                purposeCode1 = PurposeCode.DNTS;
                break;
            }
            case HLTC: {
                purposeCode1 = PurposeCode.HLTC;
                break;
            }
            case HLTI: {
                purposeCode1 = PurposeCode.HLTI;
                break;
            }
            case HSPC: {
                purposeCode1 = PurposeCode.HSPC;
                break;
            }
            case ICRF: {
                purposeCode1 = PurposeCode.ICRF;
                break;
            }
            case LTCF: {
                purposeCode1 = PurposeCode.LTCF;
                break;
            }
            case MAFC: {
                purposeCode1 = PurposeCode.MAFC;
                break;
            }
            case MARF: {
                purposeCode1 = PurposeCode.MARF;
                break;
            }
            case MDCS: {
                purposeCode1 = PurposeCode.MDCS;
                break;
            }
            case VIEW: {
                purposeCode1 = PurposeCode.VIEW;
                break;
            }
            case CDEP: {
                purposeCode1 = PurposeCode.CDEP;
                break;
            }
            case SWFP: {
                purposeCode1 = PurposeCode.SWFP;
                break;
            }
            case SWPP: {
                purposeCode1 = PurposeCode.SWPP;
                break;
            }
            case SWRS: {
                purposeCode1 = PurposeCode.SWRS;
                break;
            }
            case SWUF: {
                purposeCode1 = PurposeCode.SWUF;
                break;
            }
            case ADCS: {
                purposeCode1 = PurposeCode.ADCS;
                break;
            }
            case AEMP: {
                purposeCode1 = PurposeCode.AEMP;
                break;
            }
            case ALLW: {
                purposeCode1 = PurposeCode.ALLW;
                break;
            }
            case ALMY: {
                purposeCode1 = PurposeCode.ALMY;
                break;
            }
            case BBSC: {
                purposeCode1 = PurposeCode.BBSC;
                break;
            }
            case BECH: {
                purposeCode1 = PurposeCode.BECH;
                break;
            }
            case BENE: {
                purposeCode1 = PurposeCode.BENE;
                break;
            }
            case BONU: {
                purposeCode1 = PurposeCode.BONU;
                break;
            }
            case CCHD: {
                purposeCode1 = PurposeCode.CCHD;
                break;
            }
            case COMM: {
                purposeCode1 = PurposeCode.COMM;
                break;
            }
            case CSLP: {
                purposeCode1 = PurposeCode.CSLP;
                break;
            }
            case GFRP: {
                purposeCode1 = PurposeCode.GFRP;
                break;
            }
            case GVEA: {
                purposeCode1 = PurposeCode.GVEA;
                break;
            }
            case GVEB: {
                purposeCode1 = PurposeCode.GVEB;
                break;
            }
            case GVEC: {
                purposeCode1 = PurposeCode.GVEC;
                break;
            }
            case GVED: {
                purposeCode1 = PurposeCode.GVED;
                break;
            }
            case GWLT: {
                purposeCode1 = PurposeCode.GWLT;
                break;
            }
            case HREC: {
                purposeCode1 = PurposeCode.HREC;
                break;
            }
            case PAYR: {
                purposeCode1 = PurposeCode.PAYR;
                break;
            }
            case PEFC: {
                purposeCode1 = PurposeCode.PEFC;
                break;
            }
            case PENS: {
                purposeCode1 = PurposeCode.PENS;
                break;
            }
            case PRCP: {
                purposeCode1 = PurposeCode.PRCP;
                break;
            }
            case RHBS: {
                purposeCode1 = PurposeCode.RHBS;
                break;
            }
            case SALA: {
                purposeCode1 = PurposeCode.SALA;
                break;
            }
            case SSBE: {
                purposeCode1 = PurposeCode.SSBE;
                break;
            }
            case LBIN: {
                purposeCode1 = PurposeCode.LBIN;
                break;
            }
            case LCOL: {
                purposeCode1 = PurposeCode.LCOL;
                break;
            }
            case LFEE: {
                purposeCode1 = PurposeCode.LFEE;
                break;
            }
            case LMEQ: {
                purposeCode1 = PurposeCode.LMEQ;
                break;
            }
            case LMFI: {
                purposeCode1 = PurposeCode.LMFI;
                break;
            }
            case LMRK: {
                purposeCode1 = PurposeCode.LMRK;
                break;
            }
            case LREB: {
                purposeCode1 = PurposeCode.LREB;
                break;
            }
            case LREV: {
                purposeCode1 = PurposeCode.LREV;
                break;
            }
            case LSFL: {
                purposeCode1 = PurposeCode.LSFL;
                break;
            }
            case ESTX: {
                purposeCode1 = PurposeCode.ESTX;
                break;
            }
            case FWLV: {
                purposeCode1 = PurposeCode.FWLV;
                break;
            }
            case GSTX: {
                purposeCode1 = PurposeCode.GSTX;
                break;
            }
            case HSTX: {
                purposeCode1 = PurposeCode.HSTX;
                break;
            }
            case INTX: {
                purposeCode1 = PurposeCode.INTX;
                break;
            }
            case NITX: {
                purposeCode1 = PurposeCode.NITX;
                break;
            }
            case PTXP: {
                purposeCode1 = PurposeCode.PTXP;
                break;
            }
            case RDTX: {
                purposeCode1 = PurposeCode.RDTX;
                break;
            }
            case TAXS: {
                purposeCode1 = PurposeCode.TAXS;
                break;
            }
            case VATX: {
                purposeCode1 = PurposeCode.VATX;
                break;
            }
            case WHLD: {
                purposeCode1 = PurposeCode.WHLD;
                break;
            }
            case TAXR: {
                purposeCode1 = PurposeCode.TAXR;
                break;
            }
            case B112: {
                purposeCode1 = PurposeCode.B112;
                break;
            }
            case BR12: {
                purposeCode1 = PurposeCode.BR12;
                break;
            }
            case TLRF: {
                purposeCode1 = PurposeCode.TLRF;
                break;
            }
            case TLRR: {
                purposeCode1 = PurposeCode.TLRR;
                break;
            }
            case AIRB: {
                purposeCode1 = PurposeCode.AIRB;
                break;
            }
            case BUSB: {
                purposeCode1 = PurposeCode.BUSB;
                break;
            }
            case FERB: {
                purposeCode1 = PurposeCode.FERB;
                break;
            }
            case RLWY: {
                purposeCode1 = PurposeCode.RLWY;
                break;
            }
            case TRPT: {
                purposeCode1 = PurposeCode.TRPT;
                break;
            }
            case CBTV: {
                purposeCode1 = PurposeCode.CBTV;
                break;
            }
            case ELEC: {
                purposeCode1 = PurposeCode.ELEC;
                break;
            }
            case ENRG: {
                purposeCode1 = PurposeCode.ENRG;
                break;
            }
            case GASB: {
                purposeCode1 = PurposeCode.GASB;
                break;
            }
            case NWCH: {
                purposeCode1 = PurposeCode.NWCH;
                break;
            }
            case NWCM: {
                purposeCode1 = PurposeCode.NWCM;
                break;
            }
            case OTLC: {
                purposeCode1 = PurposeCode.OTLC;
                break;
            }
            case PHON: {
                purposeCode1 = PurposeCode.PHON;
                break;
            }
            case UBIL: {
                purposeCode1 = PurposeCode.UBIL;
                break;
            }
            case WTER: {
                purposeCode1 = PurposeCode.WTER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + purposeCode);
            }
        }
        return purposeCode1;
    }

    protected RemittanceInformationStructuredArray stringListToRemittanceInformationStructuredArray(List<String> list) {
        if (list == null) {
            return null;
        }
        RemittanceInformationStructuredArray remittanceInformationStructuredArray = new RemittanceInformationStructuredArray();
        for (String string : list) {
            remittanceInformationStructuredArray.add((Object)string);
        }
        return remittanceInformationStructuredArray;
    }

    protected ExecutionRule pisExecutionRuleToExecutionRule(PisExecutionRule pisExecutionRule) {
        ExecutionRule executionRule;
        if (pisExecutionRule == null) {
            return null;
        }
        switch (pisExecutionRule) {
            case FOLLOWING: {
                executionRule = ExecutionRule.FOLLOWING;
                break;
            }
            case PRECEDING: {
                executionRule = ExecutionRule.PRECEDING;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + pisExecutionRule);
            }
        }
        return executionRule;
    }

    protected FrequencyCode frequencyCodeToFrequencyCode(de.adorsys.psd2.xs2a.core.pis.FrequencyCode frequencyCode) {
        FrequencyCode frequencyCode1;
        if (frequencyCode == null) {
            return null;
        }
        switch (frequencyCode) {
            case DAILY: {
                frequencyCode1 = FrequencyCode.DAILY;
                break;
            }
            case WEEKLY: {
                frequencyCode1 = FrequencyCode.WEEKLY;
                break;
            }
            case EVERYTWOWEEKS: {
                frequencyCode1 = FrequencyCode.EVERYTWOWEEKS;
                break;
            }
            case MONTHLY: {
                frequencyCode1 = FrequencyCode.MONTHLY;
                break;
            }
            case EVERYTWOMONTHS: {
                frequencyCode1 = FrequencyCode.EVERYTWOMONTHS;
                break;
            }
            case QUARTERLY: {
                frequencyCode1 = FrequencyCode.QUARTERLY;
                break;
            }
            case SEMIANNUAL: {
                frequencyCode1 = FrequencyCode.SEMIANNUAL;
                break;
            }
            case ANNUAL: {
                frequencyCode1 = FrequencyCode.ANNUAL;
                break;
            }
            case MONTHLYVARIABLE: {
                frequencyCode1 = FrequencyCode.MONTHLYVARIABLE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + frequencyCode);
            }
        }
        return frequencyCode1;
    }

    protected DayOfExecution pisDayOfExecutionToDayOfExecution(PisDayOfExecution pisDayOfExecution) {
        DayOfExecution dayOfExecution;
        if (pisDayOfExecution == null) {
            return null;
        }
        switch (pisDayOfExecution) {
            case _1: {
                dayOfExecution = DayOfExecution._1;
                break;
            }
            case _2: {
                dayOfExecution = DayOfExecution._2;
                break;
            }
            case _3: {
                dayOfExecution = DayOfExecution._3;
                break;
            }
            case _4: {
                dayOfExecution = DayOfExecution._4;
                break;
            }
            case _5: {
                dayOfExecution = DayOfExecution._5;
                break;
            }
            case _6: {
                dayOfExecution = DayOfExecution._6;
                break;
            }
            case _7: {
                dayOfExecution = DayOfExecution._7;
                break;
            }
            case _8: {
                dayOfExecution = DayOfExecution._8;
                break;
            }
            case _9: {
                dayOfExecution = DayOfExecution._9;
                break;
            }
            case _10: {
                dayOfExecution = DayOfExecution._10;
                break;
            }
            case _11: {
                dayOfExecution = DayOfExecution._11;
                break;
            }
            case _12: {
                dayOfExecution = DayOfExecution._12;
                break;
            }
            case _13: {
                dayOfExecution = DayOfExecution._13;
                break;
            }
            case _14: {
                dayOfExecution = DayOfExecution._14;
                break;
            }
            case _15: {
                dayOfExecution = DayOfExecution._15;
                break;
            }
            case _16: {
                dayOfExecution = DayOfExecution._16;
                break;
            }
            case _17: {
                dayOfExecution = DayOfExecution._17;
                break;
            }
            case _18: {
                dayOfExecution = DayOfExecution._18;
                break;
            }
            case _19: {
                dayOfExecution = DayOfExecution._19;
                break;
            }
            case _20: {
                dayOfExecution = DayOfExecution._20;
                break;
            }
            case _21: {
                dayOfExecution = DayOfExecution._21;
                break;
            }
            case _22: {
                dayOfExecution = DayOfExecution._22;
                break;
            }
            case _23: {
                dayOfExecution = DayOfExecution._23;
                break;
            }
            case _24: {
                dayOfExecution = DayOfExecution._24;
                break;
            }
            case _25: {
                dayOfExecution = DayOfExecution._25;
                break;
            }
            case _26: {
                dayOfExecution = DayOfExecution._26;
                break;
            }
            case _27: {
                dayOfExecution = DayOfExecution._27;
                break;
            }
            case _28: {
                dayOfExecution = DayOfExecution._28;
                break;
            }
            case _29: {
                dayOfExecution = DayOfExecution._29;
                break;
            }
            case _30: {
                dayOfExecution = DayOfExecution._30;
                break;
            }
            case _31: {
                dayOfExecution = DayOfExecution._31;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + pisDayOfExecution);
            }
        }
        return dayOfExecution;
    }

    protected PaymentInitiationBulkElementJson singlePaymentToPaymentInitiationBulkElementJson(SinglePayment singlePayment) {
        if (singlePayment == null) {
            return null;
        }
        PaymentInitiationBulkElementJson paymentInitiationBulkElementJson = new PaymentInitiationBulkElementJson();
        paymentInitiationBulkElementJson.setEndToEndIdentification(singlePayment.getEndToEndIdentification());
        paymentInitiationBulkElementJson.setInstructionIdentification(singlePayment.getInstructionIdentification());
        paymentInitiationBulkElementJson.setDebtorName(singlePayment.getDebtorName());
        paymentInitiationBulkElementJson.setUltimateDebtor(singlePayment.getUltimateDebtor());
        paymentInitiationBulkElementJson.setInstructedAmount(this.xs2aAmountToAmount(singlePayment.getInstructedAmount()));
        paymentInitiationBulkElementJson.setCreditorAccount(this.accountReferenceToAccountReference(singlePayment.getCreditorAccount()));
        paymentInitiationBulkElementJson.setCreditorAgent(singlePayment.getCreditorAgent());
        paymentInitiationBulkElementJson.setCreditorName(singlePayment.getCreditorName());
        paymentInitiationBulkElementJson.setCreditorAddress(this.xs2aAddressToAddress(singlePayment.getCreditorAddress()));
        paymentInitiationBulkElementJson.setCreditorId(singlePayment.getCreditorId());
        paymentInitiationBulkElementJson.setUltimateCreditor(singlePayment.getUltimateCreditor());
        paymentInitiationBulkElementJson.setPurposeCode(this.purposeCodeToPurposeCode(singlePayment.getPurposeCode()));
        paymentInitiationBulkElementJson.setRemittanceInformationUnstructured(singlePayment.getRemittanceInformationUnstructured());
        paymentInitiationBulkElementJson.setRemittanceInformationStructured(singlePayment.getRemittanceInformationStructured());
        paymentInitiationBulkElementJson.setRemittanceInformationStructuredArray(this.stringListToRemittanceInformationStructuredArray(singlePayment.getRemittanceInformationStructuredArray()));
        return paymentInitiationBulkElementJson;
    }

    protected List<PaymentInitiationBulkElementJson> singlePaymentListToPaymentInitiationBulkElementJsonList(List<SinglePayment> list) {
        if (list == null) {
            return null;
        }
        ArrayList<PaymentInitiationBulkElementJson> list1 = new ArrayList<PaymentInitiationBulkElementJson>(list.size());
        for (SinglePayment singlePayment : list) {
            list1.add(this.singlePaymentToPaymentInitiationBulkElementJson(singlePayment));
        }
        return list1;
    }
}

