/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.support.mapper;

import de.adorsys.psd2.mapper.Xs2aObjectMapper;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.PaymentModelMapper;
import java.beans.ConstructorProperties;
import java.io.IOException;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RawToXs2aPaymentMapper {
    private static final Logger log = LoggerFactory.getLogger(RawToXs2aPaymentMapper.class);
    private final PaymentModelMapper paymentModelMapper;
    private final Xs2aObjectMapper xs2aObjectMapper;

    public SinglePayment mapToSinglePayment(byte[] paymentBody) {
        if (ArrayUtils.isEmpty((byte[])paymentBody)) {
            return null;
        }
        PaymentInitiationJson paymentInitiationJson = this.readBytes(paymentBody, PaymentInitiationJson.class);
        SinglePayment singlePayment = this.paymentModelMapper.mapToXs2aPayment(paymentInitiationJson);
        if (singlePayment != null) {
            singlePayment.setPaymentData(paymentBody);
        }
        return singlePayment;
    }

    public PeriodicPayment mapToPeriodicPayment(byte[] paymentBody) {
        if (ArrayUtils.isEmpty((byte[])paymentBody)) {
            return null;
        }
        PeriodicPaymentInitiationJson paymentInitiationJson = this.readBytes(paymentBody, PeriodicPaymentInitiationJson.class);
        PeriodicPayment periodicPayment = this.paymentModelMapper.mapToXs2aPayment(paymentInitiationJson);
        if (periodicPayment != null) {
            periodicPayment.setPaymentData(paymentBody);
        }
        return periodicPayment;
    }

    public BulkPayment mapToBulkPayment(byte[] paymentBody) {
        if (ArrayUtils.isEmpty((byte[])paymentBody)) {
            return null;
        }
        BulkPaymentInitiationJson paymentInitiationJson = this.readBytes(paymentBody, BulkPaymentInitiationJson.class);
        BulkPayment bulkPayment = this.paymentModelMapper.mapToXs2aPayment(paymentInitiationJson);
        if (bulkPayment != null) {
            bulkPayment.setPaymentData(paymentBody);
        }
        return bulkPayment;
    }

    private <T> T readBytes(byte[] paymentBody, Class<T> clazz) {
        try {
            return (T)this.xs2aObjectMapper.readValue(paymentBody, clazz);
        }
        catch (IOException e) {
            log.warn("Couldn't deserialize payment from bytes");
            return null;
        }
    }

    @ConstructorProperties(value={"paymentModelMapper", "xs2aObjectMapper"})
    public RawToXs2aPaymentMapper(PaymentModelMapper paymentModelMapper, Xs2aObjectMapper xs2aObjectMapper) {
        this.paymentModelMapper = paymentModelMapper;
        this.xs2aObjectMapper = xs2aObjectMapper;
    }
}

