/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.support;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.payment.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiBulkPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiPeriodicPaymentMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.Xs2aToSpiSinglePaymentMapper;
import de.adorsys.psd2.xs2a.service.payment.support.mapper.CmsToXs2aPaymentSupportMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SpiPaymentFactoryImpl
implements SpiPaymentFactory {
    private static final Logger log = LoggerFactory.getLogger(SpiPaymentFactoryImpl.class);
    private final CmsToXs2aPaymentSupportMapper cmsToXs2aPaymentSupportMapper;
    private final Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper;
    private final Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper;
    private final Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper;

    public Optional<? extends SpiPayment> getSpiPayment(CommonPaymentData commonPaymentData) {
        PaymentType paymentType = commonPaymentData.getPaymentType();
        switch (paymentType) {
            case SINGLE: {
                return this.createSpiSinglePayment(commonPaymentData);
            }
            case PERIODIC: {
                return this.createSpiPeriodicPayment(commonPaymentData);
            }
            case BULK: {
                return this.createSpiBulkPayment(commonPaymentData);
            }
        }
        log.info("Unknown payment type: [{}]", (Object)paymentType);
        throw new IllegalArgumentException("Unknown payment type");
    }

    private Optional<SpiSinglePayment> createSpiSinglePayment(CommonPaymentData commonPaymentData) {
        String paymentProduct = commonPaymentData.getPaymentProduct();
        SinglePayment singlePayment = this.cmsToXs2aPaymentSupportMapper.mapToSinglePayment(commonPaymentData);
        if (singlePayment == null) {
            log.warn("Can't map PIS Payment with paymentProduct [{}] to SINGLE payment.", (Object)paymentProduct);
            return Optional.empty();
        }
        return Optional.ofNullable(this.xs2aToSpiSinglePaymentMapper.mapToSpiSinglePayment(singlePayment, paymentProduct));
    }

    private Optional<SpiPeriodicPayment> createSpiPeriodicPayment(CommonPaymentData commonPaymentData) {
        String paymentProduct = commonPaymentData.getPaymentProduct();
        PeriodicPayment periodicPayment = this.cmsToXs2aPaymentSupportMapper.mapToPeriodicPayment(commonPaymentData);
        if (periodicPayment == null) {
            log.warn("Can't map PIS Payment with paymentProduct [{}] to PERIODIC payment.", (Object)paymentProduct);
            return Optional.empty();
        }
        return Optional.ofNullable(this.xs2aToSpiPeriodicPaymentMapper.mapToSpiPeriodicPayment(periodicPayment, paymentProduct));
    }

    private Optional<SpiBulkPayment> createSpiBulkPayment(CommonPaymentData commonPaymentData) {
        String paymentProduct = commonPaymentData.getPaymentProduct();
        BulkPayment bulkPayment = this.cmsToXs2aPaymentSupportMapper.mapToBulkPayment(commonPaymentData);
        if (bulkPayment == null) {
            log.warn("Can't map list of PIS Payments with paymentProduct [{}] to BULK payment.", (Object)paymentProduct);
            return Optional.empty();
        }
        return Optional.ofNullable(this.xs2aToSpiBulkPaymentMapper.mapToSpiBulkPayment(bulkPayment, paymentProduct));
    }

    @ConstructorProperties(value={"cmsToXs2aPaymentSupportMapper", "xs2aToSpiSinglePaymentMapper", "xs2aToSpiPeriodicPaymentMapper", "xs2aToSpiBulkPaymentMapper"})
    public SpiPaymentFactoryImpl(CmsToXs2aPaymentSupportMapper cmsToXs2aPaymentSupportMapper, Xs2aToSpiSinglePaymentMapper xs2aToSpiSinglePaymentMapper, Xs2aToSpiPeriodicPaymentMapper xs2aToSpiPeriodicPaymentMapper, Xs2aToSpiBulkPaymentMapper xs2aToSpiBulkPaymentMapper) {
        this.cmsToXs2aPaymentSupportMapper = cmsToXs2aPaymentSupportMapper;
        this.xs2aToSpiSinglePaymentMapper = xs2aToSpiSinglePaymentMapper;
        this.xs2aToSpiPeriodicPaymentMapper = xs2aToSpiPeriodicPaymentMapper;
        this.xs2aToSpiBulkPaymentMapper = xs2aToSpiBulkPaymentMapper;
    }
}

