package de.adorsys.psd2.xs2a.service.payment.support.mapper.spi;

import de.adorsys.psd2.xs2a.core.pis.Remittance;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPeriodicPayment;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiRemittance;
import de.adorsys.psd2.xs2a.web.mapper.RemittanceMapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-09-24T12:08:13+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class SpiToXs2aPeriodicPaymentMapperImpl implements SpiToXs2aPeriodicPaymentMapper {

    @Autowired
    private SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private SpiToXs2aAddressMapper spiToXs2aAddressMapper;
    @Autowired
    private RemittanceMapper remittanceMapper;

    @Override
    public PeriodicPayment mapToXs2aPeriodicPayment(SpiPeriodicPayment payment) {
        if ( payment == null ) {
            return null;
        }

        PeriodicPayment periodicPayment = new PeriodicPayment();

        periodicPayment.setTransactionStatus( payment.getPaymentStatus() );
        periodicPayment.setPaymentId( payment.getPaymentId() );
        periodicPayment.setPaymentProduct( payment.getPaymentProduct() );
        periodicPayment.setStatusChangeTimestamp( payment.getStatusChangeTimestamp() );
        periodicPayment.setCreditorId( payment.getCreditorId() );
        periodicPayment.setCreationTimestamp( payment.getCreationTimestamp() );
        periodicPayment.setContentType( payment.getContentType() );
        periodicPayment.setInstanceId( payment.getInstanceId() );
        periodicPayment.setEndToEndIdentification( payment.getEndToEndIdentification() );
        periodicPayment.setInstructionIdentification( payment.getInstructionIdentification() );
        periodicPayment.setDebtorAccount( spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( payment.getDebtorAccount() ) );
        periodicPayment.setUltimateDebtor( payment.getUltimateDebtor() );
        periodicPayment.setInstructedAmount( spiToXs2aAmountMapper.mapToXs2aAmount( payment.getInstructedAmount() ) );
        periodicPayment.setCreditorAccount( spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( payment.getCreditorAccount() ) );
        periodicPayment.setCreditorAgent( payment.getCreditorAgent() );
        periodicPayment.setCreditorName( payment.getCreditorName() );
        periodicPayment.setCreditorAddress( spiToXs2aAddressMapper.mapToAddress( payment.getCreditorAddress() ) );
        periodicPayment.setUltimateCreditor( payment.getUltimateCreditor() );
        periodicPayment.setPurposeCode( payment.getPurposeCode() );
        periodicPayment.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        periodicPayment.setRemittanceInformationStructured( remittanceMapper.mapToRemittance( payment.getRemittanceInformationStructured() ) );
        periodicPayment.setRemittanceInformationStructuredArray( spiRemittanceListToRemittanceList( payment.getRemittanceInformationStructuredArray() ) );
        periodicPayment.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        periodicPayment.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        periodicPayment.setDebtorName( payment.getDebtorName() );
        periodicPayment.setStartDate( payment.getStartDate() );
        periodicPayment.setExecutionRule( payment.getExecutionRule() );
        periodicPayment.setEndDate( payment.getEndDate() );
        periodicPayment.setPaymentType( payment.getPaymentType() );
        periodicPayment.setFrequency( payment.getFrequency() );
        periodicPayment.setDayOfExecution( payment.getDayOfExecution() );

        return periodicPayment;
    }

    protected List<Remittance> spiRemittanceListToRemittanceList(List<SpiRemittance> list) {
        if ( list == null ) {
            return null;
        }

        List<Remittance> list1 = new ArrayList<Remittance>( list.size() );
        for ( SpiRemittance spiRemittance : list ) {
            list1.add( remittanceMapper.mapToRemittance( spiRemittance ) );
        }

        return list1;
    }
}
