/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.support.read;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.service.context.SpiContextDataProvider;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiErrorMapper;
import de.adorsys.psd2.xs2a.service.payment.Xs2aUpdatePaymentAfterSpiService;
import de.adorsys.psd2.xs2a.service.payment.read.AbstractReadPaymentService;
import de.adorsys.psd2.xs2a.service.payment.support.SpiPaymentFactory;
import de.adorsys.psd2.xs2a.service.payment.support.mapper.spi.SpiToXs2aPaymentMapperSupport;
import de.adorsys.psd2.xs2a.service.spi.SpiAspspConsentDataProviderFactory;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiBulkPayment;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bulk-payments")
public class ReadBulkPaymentService
extends AbstractReadPaymentService {
    private BulkPaymentSpi bulkPaymentSpi;
    private SpiToXs2aPaymentMapperSupport spiToXs2aPaymentMapperSupport;
    private SpiPaymentFactory spiPaymentFactory;

    @Autowired
    public ReadBulkPaymentService(BulkPaymentSpi bulkPaymentSpi, SpiToXs2aPaymentMapperSupport spiToXs2aPaymentMapperSupport, SpiErrorMapper spiErrorMapper, SpiAspspConsentDataProviderFactory aspspConsentDataProviderFactory, Xs2aUpdatePaymentAfterSpiService updatePaymentStatusAfterSpiService, SpiContextDataProvider spiContextDataProvider, SpiPaymentFactory spiPaymentFactory) {
        super(spiErrorMapper, aspspConsentDataProviderFactory, updatePaymentStatusAfterSpiService, spiContextDataProvider);
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.spiToXs2aPaymentMapperSupport = spiToXs2aPaymentMapperSupport;
        this.spiPaymentFactory = spiPaymentFactory;
    }

    public Optional<SpiBulkPayment> createSpiPayment(CommonPaymentData commonPaymentData) {
        return this.spiPaymentFactory.createSpiBulkPayment(commonPaymentData);
    }

    public SpiResponse<SpiBulkPayment> getSpiPaymentById(SpiContextData spiContextData, String acceptMediaType, Object spiPayment, SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.bulkPaymentSpi.getPaymentById(spiContextData, acceptMediaType, (SpiBulkPayment)spiPayment, aspspConsentDataProvider);
    }

    public CommonPayment getXs2aPayment(SpiResponse spiResponse) {
        SpiBulkPayment spiBulkPayment = (SpiBulkPayment)spiResponse.getPayload();
        return this.spiToXs2aPaymentMapperSupport.mapToBulkPayment(spiBulkPayment);
    }
}

