/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.support.mapper;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.CommonPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.payment.support.mapper.RawToXs2aPaymentMapper;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CmsToXs2aPaymentSupportMapper {
    private final RawToXs2aPaymentMapper rawToXs2aPaymentMapper;

    public SinglePayment mapToSinglePayment(CommonPaymentData commonPayment) {
        if (commonPayment == null) {
            return null;
        }
        byte[] paymentData = commonPayment.getPaymentData();
        SinglePayment originalSinglePayment = this.rawToXs2aPaymentMapper.mapToSinglePayment(paymentData);
        return this.enrichWithCommonProperties(originalSinglePayment, commonPayment);
    }

    public PeriodicPayment mapToPeriodicPayment(CommonPaymentData commonPayment) {
        if (commonPayment == null) {
            return null;
        }
        byte[] paymentData = commonPayment.getPaymentData();
        PeriodicPayment originalPeriodicPayment = this.rawToXs2aPaymentMapper.mapToPeriodicPayment(paymentData);
        return this.enrichWithCommonProperties(originalPeriodicPayment, commonPayment);
    }

    public BulkPayment mapToBulkPayment(CommonPaymentData commonPayment) {
        if (commonPayment == null) {
            return null;
        }
        byte[] paymentData = commonPayment.getPaymentData();
        BulkPayment originalBulkPayment = this.rawToXs2aPaymentMapper.mapToBulkPayment(paymentData);
        BulkPayment bulkPayment = this.enrichWithCommonProperties(originalBulkPayment, commonPayment);
        List payments = bulkPayment.getPayments();
        if (payments != null) {
            bulkPayment.setPayments(this.enrichBulkPaymentParts(commonPayment, payments));
        }
        return bulkPayment;
    }

    private <T extends CommonPayment> T enrichWithCommonProperties(T xs2aCommonPayment, CommonPaymentData commonPaymentData) {
        xs2aCommonPayment.setPaymentId(commonPaymentData.getExternalId());
        xs2aCommonPayment.setPaymentProduct(commonPaymentData.getPaymentProduct());
        xs2aCommonPayment.setTransactionStatus(commonPaymentData.getTransactionStatus());
        xs2aCommonPayment.setStatusChangeTimestamp(commonPaymentData.getStatusChangeTimestamp());
        xs2aCommonPayment.setCreationTimestamp(commonPaymentData.getCreationTimestamp());
        xs2aCommonPayment.setContentType(commonPaymentData.getContentType());
        return xs2aCommonPayment;
    }

    private List<SinglePayment> enrichBulkPaymentParts(CommonPaymentData commonPaymentData, List<SinglePayment> bulkPaymentParts) {
        ArrayList<SinglePayment> enrichedPayments = new ArrayList<SinglePayment>(bulkPaymentParts);
        enrichedPayments.forEach(pmt -> {
            pmt.setPaymentId(commonPaymentData.getExternalId());
            pmt.setTransactionStatus(commonPaymentData.getTransactionStatus());
            pmt.setPsuDataList(commonPaymentData.getPsuData());
            pmt.setStatusChangeTimestamp(commonPaymentData.getStatusChangeTimestamp());
        });
        return enrichedPayments;
    }

    @ConstructorProperties(value={"rawToXs2aPaymentMapper"})
    public CmsToXs2aPaymentSupportMapper(RawToXs2aPaymentMapper rawToXs2aPaymentMapper) {
        this.rawToXs2aPaymentMapper = rawToXs2aPaymentMapper;
    }
}

