/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.support.mapper;

import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.DayOfExecution;
import de.adorsys.psd2.model.OtherType;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.model.RemittanceInformationStructured;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aCountryCode;
import de.adorsys.psd2.xs2a.core.pis.PisDayOfExecution;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import java.util.Currency;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface Xs2aToPsd2PaymentSupportMapper {
    @Mappings(value={@Mapping(target="creditorAgentName", ignore=true), @Mapping(target="creditorAccount", expression="java(mapToAccountReference(singlePayment.getCreditorAccount()))"), @Mapping(target="debtorAccount", expression="java(mapToAccountReference(singlePayment.getDebtorAccount()))")})
    public PaymentInitiationJson mapToPaymentInitiationJson(SinglePayment var1);

    @Mappings(value={@Mapping(target="dayOfExecution", expression="java(mapDayOfExecution(xs2aPeriodicPayment.getDayOfExecution()))"), @Mapping(target="remittanceInformationStructuredArray", expression="java(mapToRemittanceInformationStructuredArray(xs2aPeriodicPayment.getRemittanceInformationStructuredArray()))")})
    public PeriodicPaymentInitiationJson mapToPeriodicPaymentInitiationJson(PeriodicPayment var1);

    public BulkPaymentInitiationJson mapToBulkPaymentInitiationJson(BulkPayment var1);

    default public String mapToCountry(Xs2aCountryCode xs2aCountryCode) {
        return xs2aCountryCode.getCode();
    }

    default public DayOfExecution mapDayOfExecution(PisDayOfExecution dayOfExecution) {
        return dayOfExecution != null ? DayOfExecution.fromValue((Object)dayOfExecution.toString()) : null;
    }

    default public RemittanceInformationStructuredArray mapToRemittanceInformationStructuredArray(List<String> remittanceInformationStructuredArray) {
        if (CollectionUtils.isEmpty(remittanceInformationStructuredArray)) {
            return null;
        }
        List remittanceInfoStructuredList = remittanceInformationStructuredArray.stream().map(s -> new RemittanceInformationStructured().reference(s)).collect(Collectors.toList());
        RemittanceInformationStructuredArray remittanceInfoStructuredArray = new RemittanceInformationStructuredArray();
        remittanceInfoStructuredArray.addAll(remittanceInfoStructuredList);
        return remittanceInfoStructuredArray;
    }

    default public AccountReference mapToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference value) {
        if (value == null) {
            return null;
        }
        AccountReference accountReference = new AccountReference();
        accountReference.setIban(value.getIban());
        accountReference.setBban(value.getBban());
        accountReference.setPan(value.getPan());
        accountReference.setMaskedPan(value.getMaskedPan());
        accountReference.setMsisdn(value.getMsisdn());
        accountReference.setCurrency(this.mapToCurrency(value.getCurrency()));
        accountReference.setOther(this.mapToOtherType(value.getOther()));
        accountReference.cashAccountType(value.getCashAccountType());
        return accountReference;
    }

    default public OtherType mapToOtherType(String other) {
        return other == null ? null : new OtherType().identification(other);
    }

    default public String mapToCurrency(Currency value) {
        return value == null ? null : value.getCurrencyCode();
    }
}

