package de.adorsys.psd2.xs2a.service.payment.support.mapper.spi;

import de.adorsys.psd2.model.ChargeBearer;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAccountReferenceMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAddressMapper;
import de.adorsys.psd2.xs2a.service.mapper.spi_xs2a_mappers.SpiToXs2aAmountMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiSinglePayment;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-09-13T11:33:26+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.12 (Azul Systems, Inc.)"
)
@Component
public class SpiToXs2aSinglePaymentMapperImpl implements SpiToXs2aSinglePaymentMapper {

    @Autowired
    private SpiToXs2aAccountReferenceMapper spiToXs2aAccountReferenceMapper;
    @Autowired
    private SpiToXs2aAmountMapper spiToXs2aAmountMapper;
    @Autowired
    private SpiToXs2aAddressMapper spiToXs2aAddressMapper;

    @Override
    public SinglePayment mapToXs2aSinglePayment(SpiSinglePayment payment) {
        if ( payment == null ) {
            return null;
        }

        SinglePayment singlePayment = new SinglePayment();

        singlePayment.setTransactionStatus( payment.getPaymentStatus() );
        singlePayment.setPaymentId( payment.getPaymentId() );
        singlePayment.setPaymentProduct( payment.getPaymentProduct() );
        singlePayment.setPaymentType( payment.getPaymentType() );
        singlePayment.setStatusChangeTimestamp( payment.getStatusChangeTimestamp() );
        singlePayment.setCreditorId( payment.getCreditorId() );
        singlePayment.setCreationTimestamp( payment.getCreationTimestamp() );
        singlePayment.setContentType( payment.getContentType() );
        singlePayment.setInstanceId( payment.getInstanceId() );
        singlePayment.setEndToEndIdentification( payment.getEndToEndIdentification() );
        singlePayment.setInstructionIdentification( payment.getInstructionIdentification() );
        singlePayment.setDebtorAccount( spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( payment.getDebtorAccount() ) );
        singlePayment.setUltimateDebtor( payment.getUltimateDebtor() );
        singlePayment.setInstructedAmount( spiToXs2aAmountMapper.mapToXs2aAmount( payment.getInstructedAmount() ) );
        singlePayment.setCreditorAccount( spiToXs2aAccountReferenceMapper.mapToXs2aAccountReference( payment.getCreditorAccount() ) );
        singlePayment.setCreditorAgent( payment.getCreditorAgent() );
        singlePayment.setCreditorName( payment.getCreditorName() );
        singlePayment.setCreditorAddress( spiToXs2aAddressMapper.mapToAddress( payment.getCreditorAddress() ) );
        singlePayment.setUltimateCreditor( payment.getUltimateCreditor() );
        singlePayment.setPurposeCode( payment.getPurposeCode() );
        singlePayment.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );
        singlePayment.setRemittanceInformationStructured( payment.getRemittanceInformationStructured() );
        List<String> list = payment.getRemittanceInformationStructuredArray();
        if ( list != null ) {
            singlePayment.setRemittanceInformationStructuredArray( new ArrayList<String>( list ) );
        }
        singlePayment.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        singlePayment.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        singlePayment.setDebtorName( payment.getDebtorName() );
        if ( payment.getChargeBearer() != null ) {
            singlePayment.setChargeBearer( Enum.valueOf( ChargeBearer.class, payment.getChargeBearer() ) );
        }

        return singlePayment;
    }

    @Override
    public List<SinglePayment> mapToXs2aSinglePaymentList(List<SpiSinglePayment> payments) {
        if ( payments == null ) {
            return new ArrayList<SinglePayment>();
        }

        List<SinglePayment> list = new ArrayList<SinglePayment>( payments.size() );
        for ( SpiSinglePayment spiSinglePayment : payments ) {
            list.add( mapToXs2aSinglePayment( spiSinglePayment ) );
        }

        return list;
    }
}
