package de.adorsys.psd2.xs2a.service.payment.support.mapper;

import de.adorsys.psd2.core.payment.model.PurposeCode;
import de.adorsys.psd2.model.AccountReference;
import de.adorsys.psd2.model.Address;
import de.adorsys.psd2.model.Amount;
import de.adorsys.psd2.model.BulkPaymentInitiationJson;
import de.adorsys.psd2.model.ExecutionRule;
import de.adorsys.psd2.model.FrequencyCode;
import de.adorsys.psd2.model.PaymentInitiationBulkElementJson;
import de.adorsys.psd2.model.PaymentInitiationJson;
import de.adorsys.psd2.model.PeriodicPaymentInitiationJson;
import de.adorsys.psd2.model.RemittanceInformationStructuredArray;
import de.adorsys.psd2.xs2a.core.domain.address.Xs2aAddress;
import de.adorsys.psd2.xs2a.core.pis.PisExecutionRule;
import de.adorsys.psd2.xs2a.core.pis.Xs2aAmount;
import de.adorsys.psd2.xs2a.domain.pis.BulkPayment;
import de.adorsys.psd2.xs2a.domain.pis.PeriodicPayment;
import de.adorsys.psd2.xs2a.domain.pis.SinglePayment;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-07-14T11:33:24+0000",
    comments = "version: 1.4.1.Final, compiler: javac, environment: Java 11.0.11 (Azul Systems, Inc.)"
)
@Component
public class Xs2aToPsd2PaymentSupportMapperImpl implements Xs2aToPsd2PaymentSupportMapper {

    @Override
    public PaymentInitiationJson mapToPaymentInitiationJson(SinglePayment singlePayment) {
        if ( singlePayment == null ) {
            return null;
        }

        PaymentInitiationJson paymentInitiationJson = new PaymentInitiationJson();

        paymentInitiationJson.setEndToEndIdentification( singlePayment.getEndToEndIdentification() );
        paymentInitiationJson.setInstructionIdentification( singlePayment.getInstructionIdentification() );
        paymentInitiationJson.setDebtorName( singlePayment.getDebtorName() );
        paymentInitiationJson.setDebtorAccount( accountReferenceToAccountReference( singlePayment.getDebtorAccount() ) );
        paymentInitiationJson.setUltimateDebtor( singlePayment.getUltimateDebtor() );
        paymentInitiationJson.setInstructedAmount( xs2aAmountToAmount( singlePayment.getInstructedAmount() ) );
        paymentInitiationJson.setCreditorAccount( accountReferenceToAccountReference( singlePayment.getCreditorAccount() ) );
        paymentInitiationJson.setCreditorAgent( singlePayment.getCreditorAgent() );
        paymentInitiationJson.setCreditorName( singlePayment.getCreditorName() );
        paymentInitiationJson.setCreditorAddress( xs2aAddressToAddress( singlePayment.getCreditorAddress() ) );
        paymentInitiationJson.setCreditorId( singlePayment.getCreditorId() );
        paymentInitiationJson.setUltimateCreditor( singlePayment.getUltimateCreditor() );
        paymentInitiationJson.setPurposeCode( purposeCodeToPurposeCode( singlePayment.getPurposeCode() ) );
        paymentInitiationJson.setChargeBearer( singlePayment.getChargeBearer() );
        paymentInitiationJson.setRemittanceInformationUnstructured( singlePayment.getRemittanceInformationUnstructured() );
        paymentInitiationJson.setRemittanceInformationStructured( singlePayment.getRemittanceInformationStructured() );
        paymentInitiationJson.setRemittanceInformationStructuredArray( stringListToRemittanceInformationStructuredArray( singlePayment.getRemittanceInformationStructuredArray() ) );
        paymentInitiationJson.setRequestedExecutionDate( singlePayment.getRequestedExecutionDate() );

        return paymentInitiationJson;
    }

    @Override
    public PeriodicPaymentInitiationJson mapToPeriodicPaymentInitiationJson(PeriodicPayment xs2aPeriodicPayment) {
        if ( xs2aPeriodicPayment == null ) {
            return null;
        }

        PeriodicPaymentInitiationJson periodicPaymentInitiationJson = new PeriodicPaymentInitiationJson();

        periodicPaymentInitiationJson.setEndToEndIdentification( xs2aPeriodicPayment.getEndToEndIdentification() );
        periodicPaymentInitiationJson.setInstructionIdentification( xs2aPeriodicPayment.getInstructionIdentification() );
        periodicPaymentInitiationJson.setDebtorName( xs2aPeriodicPayment.getDebtorName() );
        periodicPaymentInitiationJson.setDebtorAccount( accountReferenceToAccountReference( xs2aPeriodicPayment.getDebtorAccount() ) );
        periodicPaymentInitiationJson.setUltimateDebtor( xs2aPeriodicPayment.getUltimateDebtor() );
        periodicPaymentInitiationJson.setInstructedAmount( xs2aAmountToAmount( xs2aPeriodicPayment.getInstructedAmount() ) );
        periodicPaymentInitiationJson.setCreditorAccount( accountReferenceToAccountReference( xs2aPeriodicPayment.getCreditorAccount() ) );
        periodicPaymentInitiationJson.setCreditorAgent( xs2aPeriodicPayment.getCreditorAgent() );
        periodicPaymentInitiationJson.setCreditorId( xs2aPeriodicPayment.getCreditorId() );
        periodicPaymentInitiationJson.setCreditorName( xs2aPeriodicPayment.getCreditorName() );
        periodicPaymentInitiationJson.setCreditorAddress( xs2aAddressToAddress( xs2aPeriodicPayment.getCreditorAddress() ) );
        periodicPaymentInitiationJson.setUltimateCreditor( xs2aPeriodicPayment.getUltimateCreditor() );
        periodicPaymentInitiationJson.setPurposeCode( purposeCodeToPurposeCode( xs2aPeriodicPayment.getPurposeCode() ) );
        periodicPaymentInitiationJson.setRemittanceInformationUnstructured( xs2aPeriodicPayment.getRemittanceInformationUnstructured() );
        periodicPaymentInitiationJson.setRemittanceInformationStructured( xs2aPeriodicPayment.getRemittanceInformationStructured() );
        periodicPaymentInitiationJson.setRemittanceInformationStructuredArray( stringListToRemittanceInformationStructuredArray( xs2aPeriodicPayment.getRemittanceInformationStructuredArray() ) );
        periodicPaymentInitiationJson.setStartDate( xs2aPeriodicPayment.getStartDate() );
        periodicPaymentInitiationJson.setEndDate( xs2aPeriodicPayment.getEndDate() );
        periodicPaymentInitiationJson.setExecutionRule( pisExecutionRuleToExecutionRule( xs2aPeriodicPayment.getExecutionRule() ) );
        periodicPaymentInitiationJson.setFrequency( frequencyCodeToFrequencyCode( xs2aPeriodicPayment.getFrequency() ) );

        periodicPaymentInitiationJson.setDayOfExecution( mapDayOfExecution(xs2aPeriodicPayment.getDayOfExecution()) );

        return periodicPaymentInitiationJson;
    }

    @Override
    public BulkPaymentInitiationJson mapToBulkPaymentInitiationJson(BulkPayment xs2aBulkPayment) {
        if ( xs2aBulkPayment == null ) {
            return null;
        }

        BulkPaymentInitiationJson bulkPaymentInitiationJson = new BulkPaymentInitiationJson();

        bulkPaymentInitiationJson.setBatchBookingPreferred( xs2aBulkPayment.getBatchBookingPreferred() );
        bulkPaymentInitiationJson.setDebtorAccount( accountReferenceToAccountReference( xs2aBulkPayment.getDebtorAccount() ) );
        bulkPaymentInitiationJson.setRequestedExecutionDate( xs2aBulkPayment.getRequestedExecutionDate() );
        bulkPaymentInitiationJson.setRequestedExecutionTime( xs2aBulkPayment.getRequestedExecutionTime() );
        bulkPaymentInitiationJson.setPayments( singlePaymentListToPaymentInitiationBulkElementJsonList( xs2aBulkPayment.getPayments() ) );
        bulkPaymentInitiationJson.setDebtorName( xs2aBulkPayment.getDebtorName() );

        return bulkPaymentInitiationJson;
    }

    protected AccountReference accountReferenceToAccountReference(de.adorsys.psd2.xs2a.core.profile.AccountReference accountReference) {
        if ( accountReference == null ) {
            return null;
        }

        AccountReference accountReference1 = new AccountReference();

        accountReference1.setIban( accountReference.getIban() );
        accountReference1.setBban( accountReference.getBban() );
        accountReference1.setPan( accountReference.getPan() );
        accountReference1.setMaskedPan( accountReference.getMaskedPan() );
        accountReference1.setMsisdn( accountReference.getMsisdn() );
        if ( accountReference.getCurrency() != null ) {
            accountReference1.setCurrency( accountReference.getCurrency().getCurrencyCode() );
        }
        accountReference1.setOtherAccountIdentification( accountReference.getOtherAccountIdentification() );

        return accountReference1;
    }

    protected Amount xs2aAmountToAmount(Xs2aAmount xs2aAmount) {
        if ( xs2aAmount == null ) {
            return null;
        }

        Amount amount = new Amount();

        if ( xs2aAmount.getCurrency() != null ) {
            amount.setCurrency( xs2aAmount.getCurrency().getCurrencyCode() );
        }
        amount.setAmount( xs2aAmount.getAmount() );

        return amount;
    }

    protected Address xs2aAddressToAddress(Xs2aAddress xs2aAddress) {
        if ( xs2aAddress == null ) {
            return null;
        }

        Address address = new Address();

        address.setStreetName( xs2aAddress.getStreetName() );
        address.setBuildingNumber( xs2aAddress.getBuildingNumber() );
        address.setTownName( xs2aAddress.getTownName() );
        address.setPostCode( xs2aAddress.getPostCode() );
        address.setCountry( mapToCountry( xs2aAddress.getCountry() ) );

        return address;
    }

    protected de.adorsys.psd2.model.PurposeCode purposeCodeToPurposeCode(PurposeCode purposeCode) {
        if ( purposeCode == null ) {
            return null;
        }

        de.adorsys.psd2.model.PurposeCode purposeCode1;

        switch ( purposeCode ) {
            case BKDF: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BKDF;
            break;
            case BKFE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BKFE;
            break;
            case BKFM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BKFM;
            break;
            case BKIP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BKIP;
            break;
            case BKPP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BKPP;
            break;
            case CBLK: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CBLK;
            break;
            case CDCB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CDCB;
            break;
            case CDCD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CDCD;
            break;
            case CDCS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CDCS;
            break;
            case CDDP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CDDP;
            break;
            case CDOC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CDOC;
            break;
            case CDQC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CDQC;
            break;
            case ETUP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ETUP;
            break;
            case FCOL: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FCOL;
            break;
            case MTUP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MTUP;
            break;
            case ACCT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ACCT;
            break;
            case CASH: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CASH;
            break;
            case COLL: purposeCode1 = de.adorsys.psd2.model.PurposeCode.COLL;
            break;
            case CSDB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CSDB;
            break;
            case DEPT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.DEPT;
            break;
            case INTC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.INTC;
            break;
            case LIMA: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LIMA;
            break;
            case NETT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.NETT;
            break;
            case BFWD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BFWD;
            break;
            case CCIR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CCIR;
            break;
            case CCPC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CCPC;
            break;
            case CCPM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CCPM;
            break;
            case CCSM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CCSM;
            break;
            case CRDS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CRDS;
            break;
            case CRPR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CRPR;
            break;
            case CRSP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CRSP;
            break;
            case CRTL: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CRTL;
            break;
            case EQPT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.EQPT;
            break;
            case EQUS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.EQUS;
            break;
            case EXPT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.EXPT;
            break;
            case EXTD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.EXTD;
            break;
            case FIXI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FIXI;
            break;
            case FWBC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FWBC;
            break;
            case FWCC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FWCC;
            break;
            case FWSB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FWSB;
            break;
            case FWSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FWSC;
            break;
            case MARG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MARG;
            break;
            case MBSB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MBSB;
            break;
            case MBSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MBSC;
            break;
            case MGCC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MGCC;
            break;
            case MGSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MGSC;
            break;
            case OCCC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OCCC;
            break;
            case OPBC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OPBC;
            break;
            case OPCC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OPCC;
            break;
            case OPSB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OPSB;
            break;
            case OPSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OPSC;
            break;
            case OPTN: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OPTN;
            break;
            case OTCD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OTCD;
            break;
            case REPO: purposeCode1 = de.adorsys.psd2.model.PurposeCode.REPO;
            break;
            case RPBC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RPBC;
            break;
            case RPCC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RPCC;
            break;
            case RPSB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RPSB;
            break;
            case RPSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RPSC;
            break;
            case RVPO: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RVPO;
            break;
            case SBSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SBSC;
            break;
            case SCIE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SCIE;
            break;
            case SCIR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SCIR;
            break;
            case SCRP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SCRP;
            break;
            case SHBC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SHBC;
            break;
            case SHCC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SHCC;
            break;
            case SHSL: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SHSL;
            break;
            case SLEB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SLEB;
            break;
            case SLOA: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SLOA;
            break;
            case SWBC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SWBC;
            break;
            case SWCC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SWCC;
            break;
            case SWPT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SWPT;
            break;
            case SWSB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SWSB;
            break;
            case SWSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SWSC;
            break;
            case TBAS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TBAS;
            break;
            case TBBC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TBBC;
            break;
            case TBCC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TBCC;
            break;
            case TRCP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TRCP;
            break;
            case AGRT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.AGRT;
            break;
            case AREN: purposeCode1 = de.adorsys.psd2.model.PurposeCode.AREN;
            break;
            case BEXP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BEXP;
            break;
            case BOCE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BOCE;
            break;
            case COMC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.COMC;
            break;
            case CPYR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CPYR;
            break;
            case GDDS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GDDS;
            break;
            case GDSV: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GDSV;
            break;
            case GSCB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GSCB;
            break;
            case LICF: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LICF;
            break;
            case MP2B: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MP2B;
            break;
            case POPE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.POPE;
            break;
            case ROYA: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ROYA;
            break;
            case SCVE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SCVE;
            break;
            case SERV: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SERV;
            break;
            case SUBS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SUBS;
            break;
            case SUPP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SUPP;
            break;
            case TRAD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TRAD;
            break;
            case CHAR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CHAR;
            break;
            case COMT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.COMT;
            break;
            case MP2P: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MP2P;
            break;
            case ECPG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ECPG;
            break;
            case ECPR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ECPR;
            break;
            case ECPU: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ECPU;
            break;
            case EPAY: purposeCode1 = de.adorsys.psd2.model.PurposeCode.EPAY;
            break;
            case CLPR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CLPR;
            break;
            case COMP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.COMP;
            break;
            case DBTC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.DBTC;
            break;
            case GOVI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GOVI;
            break;
            case HLRP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.HLRP;
            break;
            case HLST: purposeCode1 = de.adorsys.psd2.model.PurposeCode.HLST;
            break;
            case INPC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.INPC;
            break;
            case INPR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.INPR;
            break;
            case INSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.INSC;
            break;
            case INSU: purposeCode1 = de.adorsys.psd2.model.PurposeCode.INSU;
            break;
            case INTE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.INTE;
            break;
            case LBRI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LBRI;
            break;
            case LIFI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LIFI;
            break;
            case LOAN: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LOAN;
            break;
            case LOAR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LOAR;
            break;
            case PENO: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PENO;
            break;
            case PPTI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PPTI;
            break;
            case RELG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RELG;
            break;
            case RINP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RINP;
            break;
            case TRFD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TRFD;
            break;
            case FORW: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FORW;
            break;
            case FXNT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FXNT;
            break;
            case ADMG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ADMG;
            break;
            case ADVA: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ADVA;
            break;
            case BCDM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BCDM;
            break;
            case BCFG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BCFG;
            break;
            case BLDM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BLDM;
            break;
            case BNET: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BNET;
            break;
            case CBFF: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CBFF;
            break;
            case CBFR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CBFR;
            break;
            case CCRD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CCRD;
            break;
            case CDBL: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CDBL;
            break;
            case CFEE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CFEE;
            break;
            case CGDD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CGDD;
            break;
            case CORT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CORT;
            break;
            case COST: purposeCode1 = de.adorsys.psd2.model.PurposeCode.COST;
            break;
            case CPKC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CPKC;
            break;
            case DCRD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.DCRD;
            break;
            case DSMT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.DSMT;
            break;
            case DVPM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.DVPM;
            break;
            case EDUC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.EDUC;
            break;
            case FACT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FACT;
            break;
            case FAND: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FAND;
            break;
            case FCPM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FCPM;
            break;
            case FEES: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FEES;
            break;
            case GOVT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GOVT;
            break;
            case ICCP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ICCP;
            break;
            case IDCP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.IDCP;
            break;
            case IHRP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.IHRP;
            break;
            case INSM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.INSM;
            break;
            case IVPT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.IVPT;
            break;
            case MCDM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MCDM;
            break;
            case MCFG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MCFG;
            break;
            case MSVC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MSVC;
            break;
            case NOWS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.NOWS;
            break;
            case OCDM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OCDM;
            break;
            case OCFG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OCFG;
            break;
            case OFEE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OFEE;
            break;
            case OTHR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OTHR;
            break;
            case PADD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PADD;
            break;
            case PTSP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PTSP;
            break;
            case RCKE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RCKE;
            break;
            case RCPT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RCPT;
            break;
            case REBT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.REBT;
            break;
            case REFU: purposeCode1 = de.adorsys.psd2.model.PurposeCode.REFU;
            break;
            case RENT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RENT;
            break;
            case REOD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.REOD;
            break;
            case RIMB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RIMB;
            break;
            case RPNT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RPNT;
            break;
            case RRBN: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RRBN;
            break;
            case RVPM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RVPM;
            break;
            case SLPI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SLPI;
            break;
            case SPLT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SPLT;
            break;
            case STDY: purposeCode1 = de.adorsys.psd2.model.PurposeCode.STDY;
            break;
            case TBAN: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TBAN;
            break;
            case TBIL: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TBIL;
            break;
            case TCSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TCSC;
            break;
            case TELI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TELI;
            break;
            case TMPG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TMPG;
            break;
            case TPRI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TPRI;
            break;
            case TPRP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TPRP;
            break;
            case TRNC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TRNC;
            break;
            case TRVC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TRVC;
            break;
            case WEBI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.WEBI;
            break;
            case ANNI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ANNI;
            break;
            case CAFI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CAFI;
            break;
            case CFDI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CFDI;
            break;
            case CMDT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CMDT;
            break;
            case DERI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.DERI;
            break;
            case DIVD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.DIVD;
            break;
            case FREX: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FREX;
            break;
            case HEDG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.HEDG;
            break;
            case INVS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.INVS;
            break;
            case PRME: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PRME;
            break;
            case SAVG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SAVG;
            break;
            case SECU: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SECU;
            break;
            case SEPI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SEPI;
            break;
            case TREA: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TREA;
            break;
            case UNIT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.UNIT;
            break;
            case FNET: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FNET;
            break;
            case FUTR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FUTR;
            break;
            case ANTS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ANTS;
            break;
            case CVCF: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CVCF;
            break;
            case DMEQ: purposeCode1 = de.adorsys.psd2.model.PurposeCode.DMEQ;
            break;
            case DNTS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.DNTS;
            break;
            case HLTC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.HLTC;
            break;
            case HLTI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.HLTI;
            break;
            case HSPC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.HSPC;
            break;
            case ICRF: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ICRF;
            break;
            case LTCF: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LTCF;
            break;
            case MAFC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MAFC;
            break;
            case MARF: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MARF;
            break;
            case MDCS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.MDCS;
            break;
            case VIEW: purposeCode1 = de.adorsys.psd2.model.PurposeCode.VIEW;
            break;
            case CDEP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CDEP;
            break;
            case SWFP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SWFP;
            break;
            case SWPP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SWPP;
            break;
            case SWRS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SWRS;
            break;
            case SWUF: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SWUF;
            break;
            case ADCS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ADCS;
            break;
            case AEMP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.AEMP;
            break;
            case ALLW: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ALLW;
            break;
            case ALMY: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ALMY;
            break;
            case BBSC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BBSC;
            break;
            case BECH: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BECH;
            break;
            case BENE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BENE;
            break;
            case BONU: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BONU;
            break;
            case CCHD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CCHD;
            break;
            case COMM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.COMM;
            break;
            case CSLP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CSLP;
            break;
            case GFRP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GFRP;
            break;
            case GVEA: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GVEA;
            break;
            case GVEB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GVEB;
            break;
            case GVEC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GVEC;
            break;
            case GVED: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GVED;
            break;
            case GWLT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GWLT;
            break;
            case HREC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.HREC;
            break;
            case PAYR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PAYR;
            break;
            case PEFC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PEFC;
            break;
            case PENS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PENS;
            break;
            case PRCP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PRCP;
            break;
            case RHBS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RHBS;
            break;
            case SALA: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SALA;
            break;
            case SSBE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.SSBE;
            break;
            case LBIN: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LBIN;
            break;
            case LCOL: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LCOL;
            break;
            case LFEE: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LFEE;
            break;
            case LMEQ: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LMEQ;
            break;
            case LMFI: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LMFI;
            break;
            case LMRK: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LMRK;
            break;
            case LREB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LREB;
            break;
            case LREV: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LREV;
            break;
            case LSFL: purposeCode1 = de.adorsys.psd2.model.PurposeCode.LSFL;
            break;
            case ESTX: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ESTX;
            break;
            case FWLV: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FWLV;
            break;
            case GSTX: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GSTX;
            break;
            case HSTX: purposeCode1 = de.adorsys.psd2.model.PurposeCode.HSTX;
            break;
            case INTX: purposeCode1 = de.adorsys.psd2.model.PurposeCode.INTX;
            break;
            case NITX: purposeCode1 = de.adorsys.psd2.model.PurposeCode.NITX;
            break;
            case PTXP: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PTXP;
            break;
            case RDTX: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RDTX;
            break;
            case TAXS: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TAXS;
            break;
            case VATX: purposeCode1 = de.adorsys.psd2.model.PurposeCode.VATX;
            break;
            case WHLD: purposeCode1 = de.adorsys.psd2.model.PurposeCode.WHLD;
            break;
            case TAXR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TAXR;
            break;
            case B112: purposeCode1 = de.adorsys.psd2.model.PurposeCode.B112;
            break;
            case BR12: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BR12;
            break;
            case TLRF: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TLRF;
            break;
            case TLRR: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TLRR;
            break;
            case AIRB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.AIRB;
            break;
            case BUSB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.BUSB;
            break;
            case FERB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.FERB;
            break;
            case RLWY: purposeCode1 = de.adorsys.psd2.model.PurposeCode.RLWY;
            break;
            case TRPT: purposeCode1 = de.adorsys.psd2.model.PurposeCode.TRPT;
            break;
            case CBTV: purposeCode1 = de.adorsys.psd2.model.PurposeCode.CBTV;
            break;
            case ELEC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ELEC;
            break;
            case ENRG: purposeCode1 = de.adorsys.psd2.model.PurposeCode.ENRG;
            break;
            case GASB: purposeCode1 = de.adorsys.psd2.model.PurposeCode.GASB;
            break;
            case NWCH: purposeCode1 = de.adorsys.psd2.model.PurposeCode.NWCH;
            break;
            case NWCM: purposeCode1 = de.adorsys.psd2.model.PurposeCode.NWCM;
            break;
            case OTLC: purposeCode1 = de.adorsys.psd2.model.PurposeCode.OTLC;
            break;
            case PHON: purposeCode1 = de.adorsys.psd2.model.PurposeCode.PHON;
            break;
            case UBIL: purposeCode1 = de.adorsys.psd2.model.PurposeCode.UBIL;
            break;
            case WTER: purposeCode1 = de.adorsys.psd2.model.PurposeCode.WTER;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + purposeCode );
        }

        return purposeCode1;
    }

    protected RemittanceInformationStructuredArray stringListToRemittanceInformationStructuredArray(List<String> list) {
        if ( list == null ) {
            return null;
        }

        RemittanceInformationStructuredArray remittanceInformationStructuredArray = new RemittanceInformationStructuredArray();
        for ( String string : list ) {
            remittanceInformationStructuredArray.add( string );
        }

        return remittanceInformationStructuredArray;
    }

    protected ExecutionRule pisExecutionRuleToExecutionRule(PisExecutionRule pisExecutionRule) {
        if ( pisExecutionRule == null ) {
            return null;
        }

        ExecutionRule executionRule;

        switch ( pisExecutionRule ) {
            case FOLLOWING: executionRule = ExecutionRule.FOLLOWING;
            break;
            case PRECEDING: executionRule = ExecutionRule.PRECEDING;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + pisExecutionRule );
        }

        return executionRule;
    }

    protected FrequencyCode frequencyCodeToFrequencyCode(de.adorsys.psd2.xs2a.core.pis.FrequencyCode frequencyCode) {
        if ( frequencyCode == null ) {
            return null;
        }

        FrequencyCode frequencyCode1;

        switch ( frequencyCode ) {
            case DAILY: frequencyCode1 = FrequencyCode.DAILY;
            break;
            case WEEKLY: frequencyCode1 = FrequencyCode.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCode1 = FrequencyCode.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCode1 = FrequencyCode.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCode1 = FrequencyCode.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCode1 = FrequencyCode.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCode1 = FrequencyCode.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCode1 = FrequencyCode.ANNUAL;
            break;
            case MONTHLYVARIABLE: frequencyCode1 = FrequencyCode.MONTHLYVARIABLE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCode );
        }

        return frequencyCode1;
    }

    protected PaymentInitiationBulkElementJson singlePaymentToPaymentInitiationBulkElementJson(SinglePayment singlePayment) {
        if ( singlePayment == null ) {
            return null;
        }

        PaymentInitiationBulkElementJson paymentInitiationBulkElementJson = new PaymentInitiationBulkElementJson();

        paymentInitiationBulkElementJson.setEndToEndIdentification( singlePayment.getEndToEndIdentification() );
        paymentInitiationBulkElementJson.setInstructionIdentification( singlePayment.getInstructionIdentification() );
        paymentInitiationBulkElementJson.setDebtorName( singlePayment.getDebtorName() );
        paymentInitiationBulkElementJson.setUltimateDebtor( singlePayment.getUltimateDebtor() );
        paymentInitiationBulkElementJson.setInstructedAmount( xs2aAmountToAmount( singlePayment.getInstructedAmount() ) );
        paymentInitiationBulkElementJson.setCreditorAccount( accountReferenceToAccountReference( singlePayment.getCreditorAccount() ) );
        paymentInitiationBulkElementJson.setCreditorAgent( singlePayment.getCreditorAgent() );
        paymentInitiationBulkElementJson.setCreditorName( singlePayment.getCreditorName() );
        paymentInitiationBulkElementJson.setCreditorAddress( xs2aAddressToAddress( singlePayment.getCreditorAddress() ) );
        paymentInitiationBulkElementJson.setCreditorId( singlePayment.getCreditorId() );
        paymentInitiationBulkElementJson.setUltimateCreditor( singlePayment.getUltimateCreditor() );
        paymentInitiationBulkElementJson.setPurposeCode( purposeCodeToPurposeCode( singlePayment.getPurposeCode() ) );
        paymentInitiationBulkElementJson.setChargeBearer( singlePayment.getChargeBearer() );
        paymentInitiationBulkElementJson.setRemittanceInformationUnstructured( singlePayment.getRemittanceInformationUnstructured() );
        paymentInitiationBulkElementJson.setRemittanceInformationStructured( singlePayment.getRemittanceInformationStructured() );
        paymentInitiationBulkElementJson.setRemittanceInformationStructuredArray( stringListToRemittanceInformationStructuredArray( singlePayment.getRemittanceInformationStructuredArray() ) );

        return paymentInitiationBulkElementJson;
    }

    protected List<PaymentInitiationBulkElementJson> singlePaymentListToPaymentInitiationBulkElementJsonList(List<SinglePayment> list) {
        if ( list == null ) {
            return null;
        }

        List<PaymentInitiationBulkElementJson> list1 = new ArrayList<PaymentInitiationBulkElementJson>( list.size() );
        for ( SinglePayment singlePayment : list ) {
            list1.add( singlePaymentToPaymentInitiationBulkElementJson( singlePayment ) );
        }

        return list1;
    }
}
