/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.service.payment.support;

import de.adorsys.psd2.xs2a.core.profile.PaymentType;
import de.adorsys.psd2.xs2a.service.authorization.pis.PisCheckAuthorisationConfirmationService;
import de.adorsys.psd2.xs2a.service.payment.support.mapper.spi.SpiPaymentMapper;
import de.adorsys.psd2.xs2a.service.profile.StandardPaymentProductsResolver;
import de.adorsys.psd2.xs2a.spi.domain.SpiAspspConsentDataProvider;
import de.adorsys.psd2.xs2a.spi.domain.SpiContextData;
import de.adorsys.psd2.xs2a.spi.domain.authorisation.SpiCheckConfirmationCodeRequest;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiPaymentInfo;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentConfirmationCodeValidationResponse;
import de.adorsys.psd2.xs2a.spi.domain.payment.response.SpiPaymentInitiationResponse;
import de.adorsys.psd2.xs2a.spi.domain.response.SpiResponse;
import de.adorsys.psd2.xs2a.spi.service.BulkPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.CommonPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.PeriodicPaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SinglePaymentSpi;
import de.adorsys.psd2.xs2a.spi.service.SpiPayment;
import java.beans.ConstructorProperties;
import org.springframework.stereotype.Service;

@Service
public class PisCheckAuthorisationConfirmationServiceSupportImpl
implements PisCheckAuthorisationConfirmationService {
    private final StandardPaymentProductsResolver standardPaymentProductsResolver;
    private final CommonPaymentSpi commonPaymentSpi;
    private final SinglePaymentSpi singlePaymentSpi;
    private final PeriodicPaymentSpi periodicPaymentSpi;
    private final BulkPaymentSpi bulkPaymentSpi;
    private final SpiPaymentMapper spiPaymentMapper;

    public SpiResponse<SpiPaymentConfirmationCodeValidationResponse> checkConfirmationCode(SpiContextData contextData, SpiCheckConfirmationCodeRequest spiCheckConfirmationCodeRequest, SpiPayment payment, SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(payment.getPaymentProduct())) {
            return this.checkConfirmationCode((PaymentSpi)this.commonPaymentSpi, contextData, spiCheckConfirmationCodeRequest, aspspConsentDataProvider);
        }
        PaymentType paymentType = payment.getPaymentType();
        if (PaymentType.SINGLE == paymentType) {
            return this.checkConfirmationCode((PaymentSpi)this.singlePaymentSpi, contextData, spiCheckConfirmationCodeRequest, aspspConsentDataProvider);
        }
        if (PaymentType.PERIODIC == paymentType) {
            return this.checkConfirmationCode((PaymentSpi)this.periodicPaymentSpi, contextData, spiCheckConfirmationCodeRequest, aspspConsentDataProvider);
        }
        return this.checkConfirmationCode((PaymentSpi)this.bulkPaymentSpi, contextData, spiCheckConfirmationCodeRequest, aspspConsentDataProvider);
    }

    public SpiResponse<SpiPaymentConfirmationCodeValidationResponse> notifyConfirmationCodeValidation(SpiContextData contextData, boolean confirmationCodeValidationResult, SpiPayment payment, boolean isCancellation, SpiAspspConsentDataProvider aspspConsentDataProvider) {
        if (this.standardPaymentProductsResolver.isRawPaymentProduct(payment.getPaymentProduct())) {
            return this.notifyConfirmationCodeValidation((PaymentSpi)this.commonPaymentSpi, (SpiPayment)((SpiPaymentInfo)payment), isCancellation, contextData, confirmationCodeValidationResult, aspspConsentDataProvider);
        }
        PaymentType paymentType = payment.getPaymentType();
        if (PaymentType.SINGLE == paymentType) {
            return this.notifyConfirmationCodeValidation((PaymentSpi)this.singlePaymentSpi, (SpiPayment)this.spiPaymentMapper.mapToSpiSinglePayment(payment), isCancellation, contextData, confirmationCodeValidationResult, aspspConsentDataProvider);
        }
        if (PaymentType.PERIODIC == paymentType) {
            return this.notifyConfirmationCodeValidation((PaymentSpi)this.periodicPaymentSpi, (SpiPayment)this.spiPaymentMapper.mapToSpiPeriodicPayment(payment), isCancellation, contextData, confirmationCodeValidationResult, aspspConsentDataProvider);
        }
        return this.notifyConfirmationCodeValidation((PaymentSpi)this.bulkPaymentSpi, (SpiPayment)this.spiPaymentMapper.mapToSpiBulkPayment(payment), isCancellation, contextData, confirmationCodeValidationResult, aspspConsentDataProvider);
    }

    private <T extends SpiPayment> SpiResponse<SpiPaymentConfirmationCodeValidationResponse> notifyConfirmationCodeValidation(PaymentSpi<T, ? extends SpiPaymentInitiationResponse> paymentSpi, T payment, boolean isCancellation, SpiContextData contextData, boolean confirmationCodeValidationResult, SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return paymentSpi.notifyConfirmationCodeValidation(contextData, confirmationCodeValidationResult, payment, isCancellation, aspspConsentDataProvider);
    }

    private <T extends SpiPayment> SpiResponse<SpiPaymentConfirmationCodeValidationResponse> checkConfirmationCode(PaymentSpi<T, ? extends SpiPaymentInitiationResponse> paymentSpi, SpiContextData contextData, SpiCheckConfirmationCodeRequest spiCheckConfirmationCodeRequest, SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return paymentSpi.checkConfirmationCode(contextData, spiCheckConfirmationCodeRequest, aspspConsentDataProvider);
    }

    public boolean checkConfirmationCodeInternally(String authorisationId, String confirmationCode, String scaAuthenticationData, SpiAspspConsentDataProvider aspspConsentDataProvider) {
        return this.commonPaymentSpi.checkConfirmationCodeInternally(authorisationId, confirmationCode, scaAuthenticationData, aspspConsentDataProvider);
    }

    @ConstructorProperties(value={"standardPaymentProductsResolver", "commonPaymentSpi", "singlePaymentSpi", "periodicPaymentSpi", "bulkPaymentSpi", "spiPaymentMapper"})
    public PisCheckAuthorisationConfirmationServiceSupportImpl(StandardPaymentProductsResolver standardPaymentProductsResolver, CommonPaymentSpi commonPaymentSpi, SinglePaymentSpi singlePaymentSpi, PeriodicPaymentSpi periodicPaymentSpi, BulkPaymentSpi bulkPaymentSpi, SpiPaymentMapper spiPaymentMapper) {
        this.standardPaymentProductsResolver = standardPaymentProductsResolver;
        this.commonPaymentSpi = commonPaymentSpi;
        this.singlePaymentSpi = singlePaymentSpi;
        this.periodicPaymentSpi = periodicPaymentSpi;
        this.bulkPaymentSpi = bulkPaymentSpi;
        this.spiPaymentMapper = spiPaymentMapper;
    }
}

