/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.xs2a.payment.common.mapper;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.xs2a.core.psu.AdditionalPsuIdData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.payment.common.mapper.CommonPaymentSupportMapper;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiCommonPayment;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Component;

@Component
public class CommonPaymentSupportMapperImpl
implements CommonPaymentSupportMapper {
    @Override
    public SpiCommonPayment toSpiCommonPayment(CommonPaymentData commonPaymentData) {
        if (commonPaymentData == null) {
            return null;
        }
        SpiCommonPayment spiCommonPayment = new SpiCommonPayment();
        spiCommonPayment.setPaymentId(commonPaymentData.getExternalId());
        spiCommonPayment.setPaymentStatus(commonPaymentData.getTransactionStatus());
        spiCommonPayment.setPaymentType(commonPaymentData.getPaymentType());
        spiCommonPayment.setPaymentProduct(commonPaymentData.getPaymentProduct());
        spiCommonPayment.setStatusChangeTimestamp(commonPaymentData.getStatusChangeTimestamp());
        spiCommonPayment.setContentType(commonPaymentData.getContentType());
        byte[] paymentData = commonPaymentData.getPaymentData();
        if (paymentData != null) {
            spiCommonPayment.setPaymentData(Arrays.copyOf(paymentData, paymentData.length));
        }
        spiCommonPayment.setCreationTimestamp(commonPaymentData.getCreationTimestamp());
        spiCommonPayment.setInstanceId(commonPaymentData.getInstanceId());
        spiCommonPayment.setPsuDataList(this.toSpiPsuDataList(commonPaymentData.getPsuData()));
        return spiCommonPayment;
    }

    @Override
    public SpiPsuData toSpiPsuData(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        SpiPsuData.SpiPsuDataBuilder spiPsuData = SpiPsuData.builder();
        spiPsuData.psuAcceptCharset(this.psuIdDataAdditionalPsuIdDataPsuAcceptCharset(psuIdData));
        spiPsuData.psuGeoLocation(this.psuIdDataAdditionalPsuIdDataPsuGeoLocation(psuIdData));
        spiPsuData.psuAccept(this.psuIdDataAdditionalPsuIdDataPsuAccept(psuIdData));
        spiPsuData.psuHttpMethod(this.psuIdDataAdditionalPsuIdDataPsuHttpMethod(psuIdData));
        spiPsuData.psuIpPort(this.psuIdDataAdditionalPsuIdDataPsuIpPort(psuIdData));
        spiPsuData.psuAcceptEncoding(this.psuIdDataAdditionalPsuIdDataPsuAcceptEncoding(psuIdData));
        spiPsuData.psuDeviceId(this.psuIdDataAdditionalPsuIdDataPsuDeviceId(psuIdData));
        spiPsuData.psuAcceptLanguage(this.psuIdDataAdditionalPsuIdDataPsuAcceptLanguage(psuIdData));
        spiPsuData.psuUserAgent(this.psuIdDataAdditionalPsuIdDataPsuUserAgent(psuIdData));
        spiPsuData.psuId(psuIdData.getPsuId());
        spiPsuData.psuIdType(psuIdData.getPsuIdType());
        spiPsuData.psuCorporateId(psuIdData.getPsuCorporateId());
        spiPsuData.psuCorporateIdType(psuIdData.getPsuCorporateIdType());
        spiPsuData.psuIpAddress(psuIdData.getPsuIpAddress());
        return spiPsuData.build();
    }

    @Override
    public List<SpiPsuData> toSpiPsuDataList(List<PsuIdData> psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        ArrayList<SpiPsuData> list = new ArrayList<SpiPsuData>(psuIdData.size());
        for (PsuIdData psuIdData1 : psuIdData) {
            list.add(this.toSpiPsuData(psuIdData1));
        }
        return list;
    }

    private String psuIdDataAdditionalPsuIdDataPsuAcceptCharset(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if (additionalPsuIdData == null) {
            return null;
        }
        String psuAcceptCharset = additionalPsuIdData.getPsuAcceptCharset();
        if (psuAcceptCharset == null) {
            return null;
        }
        return psuAcceptCharset;
    }

    private String psuIdDataAdditionalPsuIdDataPsuGeoLocation(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if (additionalPsuIdData == null) {
            return null;
        }
        String psuGeoLocation = additionalPsuIdData.getPsuGeoLocation();
        if (psuGeoLocation == null) {
            return null;
        }
        return psuGeoLocation;
    }

    private String psuIdDataAdditionalPsuIdDataPsuAccept(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if (additionalPsuIdData == null) {
            return null;
        }
        String psuAccept = additionalPsuIdData.getPsuAccept();
        if (psuAccept == null) {
            return null;
        }
        return psuAccept;
    }

    private String psuIdDataAdditionalPsuIdDataPsuHttpMethod(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if (additionalPsuIdData == null) {
            return null;
        }
        String psuHttpMethod = additionalPsuIdData.getPsuHttpMethod();
        if (psuHttpMethod == null) {
            return null;
        }
        return psuHttpMethod;
    }

    private String psuIdDataAdditionalPsuIdDataPsuIpPort(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if (additionalPsuIdData == null) {
            return null;
        }
        String psuIpPort = additionalPsuIdData.getPsuIpPort();
        if (psuIpPort == null) {
            return null;
        }
        return psuIpPort;
    }

    private String psuIdDataAdditionalPsuIdDataPsuAcceptEncoding(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if (additionalPsuIdData == null) {
            return null;
        }
        String psuAcceptEncoding = additionalPsuIdData.getPsuAcceptEncoding();
        if (psuAcceptEncoding == null) {
            return null;
        }
        return psuAcceptEncoding;
    }

    private UUID psuIdDataAdditionalPsuIdDataPsuDeviceId(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if (additionalPsuIdData == null) {
            return null;
        }
        UUID psuDeviceId = additionalPsuIdData.getPsuDeviceId();
        if (psuDeviceId == null) {
            return null;
        }
        return psuDeviceId;
    }

    private String psuIdDataAdditionalPsuIdDataPsuAcceptLanguage(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if (additionalPsuIdData == null) {
            return null;
        }
        String psuAcceptLanguage = additionalPsuIdData.getPsuAcceptLanguage();
        if (psuAcceptLanguage == null) {
            return null;
        }
        return psuAcceptLanguage;
    }

    private String psuIdDataAdditionalPsuIdDataPsuUserAgent(PsuIdData psuIdData) {
        if (psuIdData == null) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if (additionalPsuIdData == null) {
            return null;
        }
        String psuUserAgent = additionalPsuIdData.getPsuUserAgent();
        if (psuUserAgent == null) {
            return null;
        }
        return psuUserAgent;
    }
}

