package de.adorsys.psd2.xs2a.payment.common.mapper;

import de.adorsys.psd2.consent.api.pis.CommonPaymentData;
import de.adorsys.psd2.xs2a.core.psu.AdditionalPsuIdData;
import de.adorsys.psd2.xs2a.core.psu.PsuIdData;
import de.adorsys.psd2.xs2a.spi.domain.payment.SpiCommonPayment;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData;
import de.adorsys.psd2.xs2a.spi.domain.psu.SpiPsuData.SpiPsuDataBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.processing.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2021-02-08T09:42:17+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 11.0.2 (Oracle Corporation)"
)
@Component
public class CommonPaymentSupportMapperImpl implements CommonPaymentSupportMapper {

    @Override
    public SpiCommonPayment toSpiCommonPayment(CommonPaymentData commonPaymentData) {
        if ( commonPaymentData == null ) {
            return null;
        }

        SpiCommonPayment spiCommonPayment = new SpiCommonPayment();

        spiCommonPayment.setPaymentId( commonPaymentData.getExternalId() );
        spiCommonPayment.setPaymentStatus( commonPaymentData.getTransactionStatus() );
        spiCommonPayment.setPaymentType( commonPaymentData.getPaymentType() );
        spiCommonPayment.setPaymentProduct( commonPaymentData.getPaymentProduct() );
        spiCommonPayment.setStatusChangeTimestamp( commonPaymentData.getStatusChangeTimestamp() );
        spiCommonPayment.setContentType( commonPaymentData.getContentType() );
        byte[] paymentData = commonPaymentData.getPaymentData();
        if ( paymentData != null ) {
            spiCommonPayment.setPaymentData( Arrays.copyOf( paymentData, paymentData.length ) );
        }
        spiCommonPayment.setCreationTimestamp( commonPaymentData.getCreationTimestamp() );
        spiCommonPayment.setInstanceId( commonPaymentData.getInstanceId() );

        spiCommonPayment.setPsuDataList( toSpiPsuDataList(commonPaymentData.getPsuData()) );

        return spiCommonPayment;
    }

    @Override
    public SpiPsuData toSpiPsuData(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }

        SpiPsuDataBuilder spiPsuData = SpiPsuData.builder();

        spiPsuData.psuAcceptCharset( psuIdDataAdditionalPsuIdDataPsuAcceptCharset( psuIdData ) );
        spiPsuData.psuGeoLocation( psuIdDataAdditionalPsuIdDataPsuGeoLocation( psuIdData ) );
        spiPsuData.psuAccept( psuIdDataAdditionalPsuIdDataPsuAccept( psuIdData ) );
        spiPsuData.psuHttpMethod( psuIdDataAdditionalPsuIdDataPsuHttpMethod( psuIdData ) );
        spiPsuData.psuIpPort( psuIdDataAdditionalPsuIdDataPsuIpPort( psuIdData ) );
        spiPsuData.psuAcceptEncoding( psuIdDataAdditionalPsuIdDataPsuAcceptEncoding( psuIdData ) );
        spiPsuData.psuDeviceId( psuIdDataAdditionalPsuIdDataPsuDeviceId( psuIdData ) );
        spiPsuData.psuAcceptLanguage( psuIdDataAdditionalPsuIdDataPsuAcceptLanguage( psuIdData ) );
        spiPsuData.psuUserAgent( psuIdDataAdditionalPsuIdDataPsuUserAgent( psuIdData ) );
        spiPsuData.psuId( psuIdData.getPsuId() );
        spiPsuData.psuIdType( psuIdData.getPsuIdType() );
        spiPsuData.psuCorporateId( psuIdData.getPsuCorporateId() );
        spiPsuData.psuCorporateIdType( psuIdData.getPsuCorporateIdType() );
        spiPsuData.psuIpAddress( psuIdData.getPsuIpAddress() );

        return spiPsuData.build();
    }

    @Override
    public List<SpiPsuData> toSpiPsuDataList(List<PsuIdData> psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }

        List<SpiPsuData> list = new ArrayList<SpiPsuData>( psuIdData.size() );
        for ( PsuIdData psuIdData1 : psuIdData ) {
            list.add( toSpiPsuData( psuIdData1 ) );
        }

        return list;
    }

    private String psuIdDataAdditionalPsuIdDataPsuAcceptCharset(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if ( additionalPsuIdData == null ) {
            return null;
        }
        String psuAcceptCharset = additionalPsuIdData.getPsuAcceptCharset();
        if ( psuAcceptCharset == null ) {
            return null;
        }
        return psuAcceptCharset;
    }

    private String psuIdDataAdditionalPsuIdDataPsuGeoLocation(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if ( additionalPsuIdData == null ) {
            return null;
        }
        String psuGeoLocation = additionalPsuIdData.getPsuGeoLocation();
        if ( psuGeoLocation == null ) {
            return null;
        }
        return psuGeoLocation;
    }

    private String psuIdDataAdditionalPsuIdDataPsuAccept(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if ( additionalPsuIdData == null ) {
            return null;
        }
        String psuAccept = additionalPsuIdData.getPsuAccept();
        if ( psuAccept == null ) {
            return null;
        }
        return psuAccept;
    }

    private String psuIdDataAdditionalPsuIdDataPsuHttpMethod(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if ( additionalPsuIdData == null ) {
            return null;
        }
        String psuHttpMethod = additionalPsuIdData.getPsuHttpMethod();
        if ( psuHttpMethod == null ) {
            return null;
        }
        return psuHttpMethod;
    }

    private String psuIdDataAdditionalPsuIdDataPsuIpPort(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if ( additionalPsuIdData == null ) {
            return null;
        }
        String psuIpPort = additionalPsuIdData.getPsuIpPort();
        if ( psuIpPort == null ) {
            return null;
        }
        return psuIpPort;
    }

    private String psuIdDataAdditionalPsuIdDataPsuAcceptEncoding(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if ( additionalPsuIdData == null ) {
            return null;
        }
        String psuAcceptEncoding = additionalPsuIdData.getPsuAcceptEncoding();
        if ( psuAcceptEncoding == null ) {
            return null;
        }
        return psuAcceptEncoding;
    }

    private UUID psuIdDataAdditionalPsuIdDataPsuDeviceId(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if ( additionalPsuIdData == null ) {
            return null;
        }
        UUID psuDeviceId = additionalPsuIdData.getPsuDeviceId();
        if ( psuDeviceId == null ) {
            return null;
        }
        return psuDeviceId;
    }

    private String psuIdDataAdditionalPsuIdDataPsuAcceptLanguage(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if ( additionalPsuIdData == null ) {
            return null;
        }
        String psuAcceptLanguage = additionalPsuIdData.getPsuAcceptLanguage();
        if ( psuAcceptLanguage == null ) {
            return null;
        }
        return psuAcceptLanguage;
    }

    private String psuIdDataAdditionalPsuIdDataPsuUserAgent(PsuIdData psuIdData) {
        if ( psuIdData == null ) {
            return null;
        }
        AdditionalPsuIdData additionalPsuIdData = psuIdData.getAdditionalPsuIdData();
        if ( additionalPsuIdData == null ) {
            return null;
        }
        String psuUserAgent = additionalPsuIdData.getPsuUserAgent();
        if ( psuUserAgent == null ) {
            return null;
        }
        return psuUserAgent;
    }
}
